/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.tests.integration.cluster.distribution;

import jakarta.jms.Connection;
import jakarta.jms.Destination;
import jakarta.jms.Message;
import jakarta.jms.MessageConsumer;
import jakarta.jms.MessageProducer;
import jakarta.jms.Queue;
import jakarta.jms.Session;
import jakarta.jms.TemporaryQueue;
import jakarta.jms.TextMessage;
import java.util.HashMap;
import org.apache.activemq.artemis.api.jms.ActiveMQJMSClient;
import org.apache.activemq.artemis.core.config.ClusterConnectionConfiguration;
import org.apache.activemq.artemis.core.postoffice.impl.PostOfficeImpl;
import org.apache.activemq.artemis.core.server.cluster.impl.MessageLoadBalancingType;
import org.apache.activemq.artemis.core.settings.impl.AddressSettings;
import org.apache.activemq.artemis.jms.client.ActiveMQConnectionFactory;
import org.apache.activemq.artemis.tests.integration.cluster.distribution.ClusterTestBase;
import org.apache.activemq.artemis.tests.integration.cluster.distribution.SimpleMessageListener;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class TemporaryJMSQueueClusterTest
extends ClusterTestBase {
    @Test
    public void testDuplicateCacheCleanupForTempQueues() throws Exception {
        this.setupServer(0, this.isFileStorage(), this.isNetty());
        this.setupServer(1, this.isFileStorage(), this.isNetty());
        this.setupClusterConnection("cluster0", "", MessageLoadBalancingType.ON_DEMAND, 1, this.isNetty(), 0, 1);
        ((ClusterConnectionConfiguration)this.servers[0].getConfiguration().getClusterConfigurations().get(0)).setDuplicateDetection(true);
        this.servers[0].getAddressSettingsRepository().addMatch("#", (Object)new AddressSettings().setRedistributionDelay(0L));
        this.setupClusterConnection("cluster1", "", MessageLoadBalancingType.ON_DEMAND, 1, this.isNetty(), 1, 0);
        ((ClusterConnectionConfiguration)this.servers[1].getConfiguration().getClusterConfigurations().get(0)).setDuplicateDetection(true);
        this.servers[1].getAddressSettingsRepository().addMatch("#", (Object)new AddressSettings().setRedistributionDelay(0L));
        this.startServers(0, 1);
        HashMap<String, TextMessage> requestMap = new HashMap<String, TextMessage>();
        ActiveMQConnectionFactory cf = new ActiveMQConnectionFactory("tcp://localhost:61616");
        for (int j = 0; j < 10; ++j) {
            try (Connection connection = cf.createConnection();){
                int i;
                SimpleMessageListener server = new SimpleMessageListener().start();
                Queue requestQueue = ActiveMQJMSClient.createQueue((String)"exampleQueue");
                connection.start();
                Session session = connection.createSession(false, 1);
                MessageProducer producer = session.createProducer((Destination)requestQueue);
                TemporaryQueue replyQueue = session.createTemporaryQueue();
                MessageConsumer replyConsumer = session.createConsumer((Destination)replyQueue);
                int numMessages = 10;
                for (i = 0; i < numMessages; ++i) {
                    TextMessage requestMsg = session.createTextMessage("A request message");
                    requestMsg.setJMSReplyTo((Destination)replyQueue);
                    producer.send((Message)requestMsg);
                    requestMap.put(requestMsg.getJMSMessageID(), requestMsg);
                }
                for (i = 0; i < numMessages; ++i) {
                    TextMessage replyMessageReceived = (TextMessage)replyConsumer.receive();
                    Assertions.assertNotNull(requestMap.get(replyMessageReceived.getJMSCorrelationID()));
                }
                replyConsumer.close();
                replyQueue.delete();
                server.shutdown();
                continue;
            }
        }
        Assertions.assertTrue((((PostOfficeImpl)this.servers[0].getPostOffice()).getDuplicateIDCaches().size() <= 1 ? 1 : 0) != 0);
        Assertions.assertTrue((((PostOfficeImpl)this.servers[1].getPostOffice()).getDuplicateIDCaches().size() <= 1 ? 1 : 0) != 0);
    }

    public boolean isNetty() {
        return true;
    }
}

