/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.tests.integration.cluster.failover;

import java.lang.invoke.MethodHandles;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.activemq.artemis.api.core.ActiveMQException;
import org.apache.activemq.artemis.api.core.Message;
import org.apache.activemq.artemis.api.core.QueueConfiguration;
import org.apache.activemq.artemis.api.core.SimpleString;
import org.apache.activemq.artemis.api.core.TransportConfiguration;
import org.apache.activemq.artemis.api.core.client.ActiveMQClient;
import org.apache.activemq.artemis.api.core.client.ClientConsumer;
import org.apache.activemq.artemis.api.core.client.ClientMessage;
import org.apache.activemq.artemis.api.core.client.ClientProducer;
import org.apache.activemq.artemis.api.core.client.ClientSession;
import org.apache.activemq.artemis.api.core.client.ClientSessionFactory;
import org.apache.activemq.artemis.api.core.client.ServerLocator;
import org.apache.activemq.artemis.api.core.client.SessionFailureListener;
import org.apache.activemq.artemis.api.core.client.TopologyMember;
import org.apache.activemq.artemis.core.client.impl.ClientSessionFactoryInternal;
import org.apache.activemq.artemis.core.client.impl.Topology;
import org.apache.activemq.artemis.core.config.ClusterConnectionConfiguration;
import org.apache.activemq.artemis.core.protocol.core.impl.wireformat.CreateSessionMessage;
import org.apache.activemq.artemis.core.protocol.core.impl.wireformat.SessionSendMessage;
import org.apache.activemq.artemis.core.server.cluster.impl.MessageLoadBalancingType;
import org.apache.activemq.artemis.tests.integration.cluster.failover.FailoverTestBase;
import org.apache.activemq.artemis.tests.util.Wait;
import org.apache.activemq.artemis.utils.network.NetUtil;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeAll;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NetworkFailureFailoverTest
extends FailoverTestBase {
    private static final Logger logger = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    private static final String LIVE_IP = "192.0.2.0";
    private int beforeTime;

    @BeforeAll
    public static void start() {
        NetUtil.skipIfNotSudo();
    }

    @Override
    @BeforeEach
    public void setUp() throws Exception {
        NetUtil.netUp(LIVE_IP);
        super.setUp();
    }

    @Override
    @AfterEach
    public void tearDown() throws Exception {
        try {
            super.tearDown();
        }
        finally {
            NetUtil.cleanup();
        }
    }

    @Override
    protected TransportConfiguration getAcceptorTransportConfiguration(boolean live) {
        return this.getNettyAcceptorTransportConfiguration(live);
    }

    @Override
    protected TransportConfiguration getConnectorTransportConfiguration(boolean live) {
        return this.getNettyConnectorTransportConfiguration(live);
    }

    protected ClientSession createSession(ClientSessionFactory sf1, boolean autoCommitSends, boolean autoCommitAcks, int ackBatchSize) throws Exception {
        return this.addClientSession(sf1.createSession(autoCommitSends, autoCommitAcks, ackBatchSize));
    }

    protected ClientSession createSession(ClientSessionFactory sf1, boolean autoCommitSends, boolean autoCommitAcks) throws Exception {
        return this.addClientSession(sf1.createSession(autoCommitSends, autoCommitAcks));
    }

    protected ClientSession createSession(ClientSessionFactory sf1) throws Exception {
        return this.addClientSession(sf1.createSession());
    }

    protected ClientSession createSession(ClientSessionFactory sf1, boolean xa, boolean autoCommitSends, boolean autoCommitAcks) throws Exception {
        return this.addClientSession(sf1.createSession(xa, autoCommitSends, autoCommitAcks));
    }

    @Override
    protected TransportConfiguration getNettyAcceptorTransportConfiguration(boolean live) {
        HashMap<String, Object> server1Params = new HashMap<String, Object>();
        if (live) {
            server1Params.put("port", 61616);
            server1Params.put("host", LIVE_IP);
        } else {
            server1Params.put("port", 61616);
            server1Params.put("host", "localhost");
        }
        return new TransportConfiguration(NETTY_ACCEPTOR_FACTORY, server1Params);
    }

    @Override
    protected TransportConfiguration getNettyConnectorTransportConfiguration(boolean live) {
        HashMap<String, Object> server1Params = new HashMap<String, Object>();
        if (live) {
            server1Params.put("port", 61616);
            server1Params.put("host", LIVE_IP);
        } else {
            server1Params.put("port", 61616);
            server1Params.put("host", "localhost");
        }
        return new TransportConfiguration(NETTY_CONNECTOR_FACTORY, server1Params);
    }

    @Test
    public void testFailoverAfterNetFailure() throws Exception {
        AtomicInteger sentMessages = new AtomicInteger(0);
        AtomicInteger blockedAt = new AtomicInteger(0);
        Assertions.assertTrue((boolean)NetUtil.checkIP(LIVE_IP));
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("host", LIVE_IP);
        TransportConfiguration tc = NetworkFailureFailoverTest.createTransportConfiguration(true, false, params);
        AtomicInteger countSent = new AtomicInteger(0);
        this.primaryServer.addInterceptor((packet, connection) -> {
            if (packet instanceof SessionSendMessage && countSent.incrementAndGet() == 500) {
                try {
                    NetUtil.netDown(LIVE_IP);
                    logger.debug("Blocking traffic");
                    this.primaryServer.crash(true, false, new ClientSession[0]);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                new Thread(() -> {
                    try {
                        System.err.println("Stopping server");
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                }).start();
            }
            return true;
        });
        ServerLocator locator = this.addServerLocator(ActiveMQClient.createServerLocatorWithHA((TransportConfiguration[])new TransportConfiguration[]{tc}));
        locator.setBlockOnNonDurableSend(false);
        locator.setBlockOnDurableSend(true);
        locator.setBlockOnAcknowledge(false);
        locator.setReconnectAttempts(-1);
        locator.setConfirmationWindowSize(-1);
        locator.setProducerWindowSize(-1);
        locator.setConnectionTTL(1000L);
        locator.setClientFailureCheckPeriod(100L);
        ClientSessionFactoryInternal sfProducer = this.createSessionFactoryAndWaitForTopology(locator, 2);
        sfProducer.addFailureListener(new SessionFailureListener(){

            public void beforeReconnect(ActiveMQException exception) {
            }

            public void connectionFailed(ActiveMQException exception, boolean failedOver, String scaleDownTargetNodeID) {
            }

            public void connectionFailed(ActiveMQException exception, boolean failedOver) {
            }
        });
        ClientSession sessionProducer = this.createSession((ClientSessionFactory)sfProducer, true, true, 0);
        sessionProducer.createQueue(QueueConfiguration.of((SimpleString)FailoverTestBase.ADDRESS));
        ClientProducer producer = sessionProducer.createProducer(FailoverTestBase.ADDRESS);
        int numMessages = 2001;
        CountDownLatch latchReceived = new CountDownLatch(2001);
        ClientSessionFactoryInternal sfConsumer = this.createSessionFactoryAndWaitForTopology(locator, 2);
        ClientSession sessionConsumer = this.createSession((ClientSessionFactory)sfConsumer, true, true, 0);
        ClientConsumer consumer = sessionConsumer.createConsumer(FailoverTestBase.ADDRESS);
        sessionConsumer.start();
        AtomicBoolean running = new AtomicBoolean(true);
        Thread t = new Thread(() -> {
            int received = 0;
            int errors = 0;
            while (running.get() && received < 2001) {
                try {
                    ClientMessage msgReceived = consumer.receive(500L);
                    if (msgReceived != null) {
                        latchReceived.countDown();
                        msgReceived.acknowledge();
                        if (received++ % 100 != 0) continue;
                        logger.debug("Received {}", (Object)received);
                        sessionConsumer.commit();
                        continue;
                    }
                    logger.debug("Null");
                }
                catch (Throwable e) {
                    if (++errors > 10) break;
                    e.printStackTrace();
                }
            }
        });
        t.start();
        sentMessages.set(0);
        while (sentMessages.get() < 2001) {
            while (true) {
                try {
                    if (sentMessages.get() % 100 == 0) {
                        logger.debug("Sent {}", (Object)sentMessages.get());
                    }
                    producer.send((Message)this.createMessage(sessionProducer, sentMessages.get(), true));
                }
                catch (Exception e) {
                    sentMessages.decrementAndGet();
                    new Exception("Exception on ending", e).printStackTrace();
                    continue;
                }
                break;
            }
            sentMessages.incrementAndGet();
        }
        for (int i = 0; i < blockedAt.get(); ++i) {
            latchReceived.countDown();
        }
        Assertions.assertTrue((boolean)latchReceived.await(1L, TimeUnit.MINUTES));
        running.set(false);
        t.join();
    }

    private int countTopologyMembers(Topology topology) {
        int count = 0;
        for (TopologyMember m : topology.getMembers()) {
            ++count;
            if (m.getBackup() == null) continue;
            ++count;
        }
        return count;
    }

    @Test
    public void testNetFailureConsume() throws Exception {
        AtomicInteger sentMessages = new AtomicInteger(0);
        AtomicInteger blockedAt = new AtomicInteger(0);
        Assertions.assertTrue((boolean)NetUtil.checkIP(LIVE_IP));
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("host", LIVE_IP);
        TransportConfiguration tc = NetworkFailureFailoverTest.createTransportConfiguration(true, false, params);
        AtomicInteger countSent = new AtomicInteger(0);
        ServerLocator locator = this.addServerLocator(ActiveMQClient.createServerLocatorWithHA((TransportConfiguration[])new TransportConfiguration[]{tc}));
        locator.setBlockOnNonDurableSend(false);
        locator.setBlockOnDurableSend(false);
        locator.setBlockOnAcknowledge(false);
        locator.setReconnectAttempts(-1);
        locator.setConfirmationWindowSize(-1);
        locator.setProducerWindowSize(-1);
        locator.setClientFailureCheckPeriod(100L);
        locator.setConnectionTTL(1000L);
        ClientSessionFactoryInternal sfProducer = this.createSessionFactoryAndWaitForTopology(locator, 2);
        Wait.assertEquals((int)2, () -> this.countTopologyMembers(locator.getTopology()));
        sfProducer.addFailureListener(new SessionFailureListener(){

            public void beforeReconnect(ActiveMQException exception) {
            }

            public void connectionFailed(ActiveMQException exception, boolean failedOver, String scaleDownTargetNodeID) {
            }

            public void connectionFailed(ActiveMQException exception, boolean failedOver) {
            }
        });
        ClientSession sessionProducer = this.createSession((ClientSessionFactory)sfProducer, true, true, 0);
        sessionProducer.createQueue(QueueConfiguration.of((SimpleString)FailoverTestBase.ADDRESS));
        ClientProducer producer = sessionProducer.createProducer(FailoverTestBase.ADDRESS);
        int numMessages = 2001;
        CountDownLatch latchReceived = new CountDownLatch(2001);
        ClientSessionFactoryInternal sfConsumer = this.createSessionFactoryAndWaitForTopology(locator, 2);
        ClientSession sessionConsumer = this.createSession((ClientSessionFactory)sfConsumer, true, true, 0);
        ClientConsumer consumer = sessionConsumer.createConsumer(FailoverTestBase.ADDRESS);
        sessionConsumer.start();
        AtomicBoolean running = new AtomicBoolean(true);
        Thread t = new Thread(() -> {
            int received = 0;
            int errors = 0;
            while (running.get() && received < 2001) {
                try {
                    ClientMessage msgReceived = consumer.receive(500L);
                    if (msgReceived != null) {
                        latchReceived.countDown();
                        msgReceived.acknowledge();
                        if (++received % 100 != 0) continue;
                        if (received == 300) {
                            logger.debug("Shutting down IP");
                            NetUtil.netDown(LIVE_IP);
                            this.primaryServer.crash(true, false, new ClientSession[0]);
                        }
                        logger.debug("Received {}", (Object)received);
                        sessionConsumer.commit();
                        continue;
                    }
                    logger.debug("Null");
                }
                catch (Throwable e) {
                    if (++errors > 10) break;
                    e.printStackTrace();
                }
            }
        });
        sentMessages.set(0);
        while (sentMessages.get() < 2001) {
            while (true) {
                try {
                    if (sentMessages.get() % 100 == 0) {
                        logger.debug("Sent {}", (Object)sentMessages.get());
                    }
                    producer.send((Message)this.createMessage(sessionProducer, sentMessages.get(), true));
                }
                catch (Exception e) {
                    sentMessages.decrementAndGet();
                    new Exception("Exception on ending", e).printStackTrace();
                    continue;
                }
                break;
            }
            sentMessages.incrementAndGet();
        }
        sessionProducer.close();
        t.start();
        for (int i = 0; i < blockedAt.get(); ++i) {
            latchReceived.countDown();
        }
        Assertions.assertTrue((boolean)latchReceived.await(1L, TimeUnit.MINUTES));
        running.set(false);
        t.join();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testFailoverCreateSessionOnFailure() throws Exception {
        AtomicInteger sentMessages = new AtomicInteger(0);
        AtomicInteger blockedAt = new AtomicInteger(0);
        Assertions.assertTrue((boolean)NetUtil.checkIP(LIVE_IP));
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("host", LIVE_IP);
        TransportConfiguration tc = NetworkFailureFailoverTest.createTransportConfiguration(true, false, params);
        AtomicInteger countSent = new AtomicInteger(0);
        CountDownLatch latchDown = new CountDownLatch(1);
        this.primaryServer.addInterceptor((packet, connection) -> {
            if (packet instanceof CreateSessionMessage && countSent.incrementAndGet() == 50) {
                try {
                    NetUtil.netDown(LIVE_IP);
                    logger.debug("Blocking traffic");
                    blockedAt.set(sentMessages.get());
                    latchDown.countDown();
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
            return true;
        });
        ServerLocator locator = this.addServerLocator(ActiveMQClient.createServerLocatorWithHA((TransportConfiguration[])new TransportConfiguration[]{tc}));
        locator.setBlockOnNonDurableSend(false);
        locator.setBlockOnDurableSend(false);
        locator.setBlockOnAcknowledge(false);
        locator.setReconnectAttempts(-1);
        locator.setConfirmationWindowSize(-1);
        locator.setProducerWindowSize(-1);
        locator.setClientFailureCheckPeriod(100L);
        locator.setConnectionTTL(1000L);
        final ClientSessionFactoryInternal sessionFactory = this.createSessionFactoryAndWaitForTopology(locator, 2);
        final AtomicInteger failed = new AtomicInteger(0);
        sessionFactory.addFailureListener(new SessionFailureListener(){

            public void beforeReconnect(ActiveMQException exception) {
                if (failed.incrementAndGet() == 1) {
                    Thread.currentThread().interrupt();
                }
                new Exception("producer before reconnect", exception).printStackTrace();
            }

            public void connectionFailed(ActiveMQException exception, boolean failedOver) {
            }

            public void connectionFailed(ActiveMQException exception, boolean failedOver, String scaleDownTargetNodeID) {
            }
        });
        int numSessions = 100;
        final CountDownLatch latchCreated = new CountDownLatch(100);
        final AtomicBoolean running = new AtomicBoolean(true);
        Thread t = new Thread("session-creator"){

            @Override
            public void run() {
                int received = 0;
                int errors = 0;
                while (running.get() && received < 100) {
                    try {
                        ClientSession session = sessionFactory.createSession();
                        logger.debug("Creating session, currentLatch = {}", (Object)latchCreated.getCount());
                        session.close();
                        latchCreated.countDown();
                    }
                    catch (Throwable e) {
                        e.printStackTrace();
                        ++errors;
                    }
                }
            }
        };
        t.start();
        Assertions.assertTrue((boolean)latchDown.await(1L, TimeUnit.MINUTES));
        Thread.sleep(1000L);
        logger.debug("Server crashed now!!!");
        this.primaryServer.crash(true, false, new ClientSession[0]);
        try {
            Assertions.assertTrue((boolean)latchCreated.await(5L, TimeUnit.MINUTES));
        }
        finally {
            running.set(false);
            t.join(TimeUnit.SECONDS.toMillis(30L));
        }
    }

    @Test
    public void testInterruptFailingThread() throws Exception {
        final AtomicInteger sentMessages = new AtomicInteger(0);
        AtomicInteger blockedAt = new AtomicInteger(0);
        Assertions.assertTrue((boolean)NetUtil.checkIP(LIVE_IP));
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("host", LIVE_IP);
        TransportConfiguration tc = NetworkFailureFailoverTest.createTransportConfiguration(true, false, params);
        AtomicInteger countSent = new AtomicInteger(0);
        CountDownLatch latchBlocked = new CountDownLatch(1);
        this.primaryServer.addInterceptor((packet, connection) -> {
            if (packet instanceof SessionSendMessage && countSent.incrementAndGet() == 50) {
                try {
                    NetUtil.netDown(LIVE_IP);
                    logger.debug("Blocking traffic");
                    Thread.sleep(3000L);
                    blockedAt.set(sentMessages.get());
                    latchBlocked.countDown();
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
            return true;
        });
        final CountDownLatch failing = new CountDownLatch(1);
        final HashSet setThread = new HashSet();
        ServerLocator locator = this.addServerLocator(ActiveMQClient.createServerLocatorWithHA((TransportConfiguration[])new TransportConfiguration[]{tc}));
        locator.setBlockOnNonDurableSend(false);
        locator.setBlockOnDurableSend(false);
        locator.setBlockOnAcknowledge(false);
        locator.setReconnectAttempts(-1);
        locator.setConfirmationWindowSize(-1);
        locator.setProducerWindowSize(-1);
        locator.setClientFailureCheckPeriod(100L);
        locator.setConnectionTTL(1000L);
        ClientSessionFactoryInternal sfProducer = this.createSessionFactoryAndWaitForTopology(locator, 2);
        sfProducer.addFailureListener(new SessionFailureListener(){

            public void beforeReconnect(ActiveMQException exception) {
                setThread.add(Thread.currentThread());
                failing.countDown();
            }

            public void connectionFailed(ActiveMQException exception, boolean failedOver) {
            }

            public void connectionFailed(ActiveMQException exception, boolean failedOver, String scaleDownTargetNodeID) {
            }
        });
        final ClientSession sessionProducer = this.createSession((ClientSessionFactory)sfProducer, true, true, 0);
        sessionProducer.createQueue(QueueConfiguration.of((SimpleString)FailoverTestBase.ADDRESS));
        final ClientProducer producer = sessionProducer.createProducer(FailoverTestBase.ADDRESS);
        int numMessages = 10000;
        final AtomicBoolean running = new AtomicBoolean(true);
        final CountDownLatch messagesSentlatch = new CountDownLatch(10000);
        Thread t = new Thread("sendingThread"){

            @Override
            public void run() {
                while (sentMessages.get() < 10000 && running.get()) {
                    try {
                        if (sentMessages.get() % 10 == 0) {
                            logger.debug("Sent {}", (Object)sentMessages.get());
                        }
                        producer.send((Message)NetworkFailureFailoverTest.this.createMessage(sessionProducer, sentMessages.get(), true));
                        sentMessages.incrementAndGet();
                        messagesSentlatch.countDown();
                    }
                    catch (Throwable e) {
                        e.printStackTrace();
                    }
                }
            }
        };
        t.start();
        Assertions.assertTrue((boolean)latchBlocked.await(1L, TimeUnit.MINUTES));
        Assertions.assertTrue((boolean)failing.await(1L, TimeUnit.MINUTES));
        for (int i = 0; i < 5; ++i) {
            for (Thread tint : setThread) {
                tint.interrupt();
            }
            Thread.sleep(500L);
        }
        this.primaryServer.crash(true, false, new ClientSession[0]);
        Assertions.assertTrue((boolean)messagesSentlatch.await(3L, TimeUnit.MINUTES));
        running.set(false);
        t.join();
    }

    @Override
    protected ClusterConnectionConfiguration createBasicClusterConfig(String connectorName, String ... connectors) {
        ArrayList<String> connectors0 = new ArrayList<String>();
        for (String c : connectors) {
            connectors0.add(c);
        }
        ClusterConnectionConfiguration clusterConnectionConfiguration = new ClusterConnectionConfiguration().setName("cluster1").setAddress("jms").setConnectorName(connectorName).setRetryInterval(1000L).setDuplicateDetection(false).setMaxHops(1).setClientFailureCheckPeriod(100L).setConnectionTTL(1000L).setConfirmationWindowSize(1).setMessageLoadBalancingType(MessageLoadBalancingType.STRICT).setStaticConnectors(connectors0);
        return clusterConnectionConfiguration;
    }
}

