/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.tests.integration.consumer;

import java.lang.invoke.MethodHandles;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.concurrent.Executor;
import org.apache.activemq.artemis.api.core.ActiveMQException;
import org.apache.activemq.artemis.core.config.impl.ConfigurationImpl;
import org.apache.activemq.artemis.core.paging.PagingManager;
import org.apache.activemq.artemis.core.persistence.OperationContext;
import org.apache.activemq.artemis.core.persistence.StorageManager;
import org.apache.activemq.artemis.core.persistence.impl.nullpm.NullStorageManager;
import org.apache.activemq.artemis.core.postoffice.PostOffice;
import org.apache.activemq.artemis.core.protocol.ServerPacketDecoder;
import org.apache.activemq.artemis.core.protocol.core.impl.PacketDecoder;
import org.apache.activemq.artemis.core.protocol.core.impl.RemotingConnectionImpl;
import org.apache.activemq.artemis.core.remoting.impl.invm.InVMConnection;
import org.apache.activemq.artemis.core.security.SecurityStore;
import org.apache.activemq.artemis.core.server.ActiveMQServer;
import org.apache.activemq.artemis.core.server.ServerSession;
import org.apache.activemq.artemis.core.server.impl.ActiveMQServerImpl;
import org.apache.activemq.artemis.core.server.impl.ServerConsumerImpl;
import org.apache.activemq.artemis.core.server.impl.ServerSessionImpl;
import org.apache.activemq.artemis.core.server.management.ManagementService;
import org.apache.activemq.artemis.core.transaction.ResourceManager;
import org.apache.activemq.artemis.protocol.amqp.broker.AMQPSessionCallback;
import org.apache.activemq.artemis.protocol.amqp.broker.ProtonProtocolManager;
import org.apache.activemq.artemis.protocol.amqp.broker.ProtonProtocolManagerFactory;
import org.apache.activemq.artemis.protocol.amqp.proton.AMQPConnectionContext;
import org.apache.activemq.artemis.protocol.amqp.proton.AMQPSessionContext;
import org.apache.activemq.artemis.protocol.amqp.proton.ProtonServerSenderContext;
import org.apache.activemq.artemis.protocol.amqp.proton.handler.ProtonHandler;
import org.apache.activemq.artemis.spi.core.protocol.RemotingConnection;
import org.apache.activemq.artemis.spi.core.protocol.SessionCallback;
import org.apache.activemq.artemis.spi.core.remoting.BaseConnectionLifeCycleListener;
import org.apache.activemq.artemis.spi.core.remoting.BufferHandler;
import org.apache.activemq.artemis.tests.util.ActiveMQTestBase;
import org.apache.activemq.artemis.utils.ExecutorFactory;
import org.apache.activemq.artemis.utils.RandomUtil;
import org.apache.activemq.artemis.utils.actors.ArtemisExecutor;
import org.apache.qpid.proton.engine.Connection;
import org.apache.qpid.proton.engine.EndpointState;
import org.apache.qpid.proton.engine.Sender;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.mockito.Mockito;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OrphanedConsumerDefenseTest
extends ActiveMQTestBase {
    private static final Logger logger = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());

    @Test
    public void testDefendNPESession() throws Exception {
        ActiveMQServerImpl server = (ActiveMQServerImpl)Mockito.mock(ActiveMQServerImpl.class);
        SessionCallback sessionCallback = (SessionCallback)Mockito.mock(SessionCallback.class);
        ManagementService managementService = (ManagementService)Mockito.mock(ManagementService.class);
        try {
            new ServerConsumerImpl(1L, null, null, null, 1, true, false, (StorageManager)new NullStorageManager(), sessionCallback, true, true, managementService, false, Integer.valueOf(0), (ActiveMQServer)server);
            Assertions.fail((String)"Exception was expected");
        }
        catch (NullPointerException e) {
            logger.debug("Expected exception", (Throwable)e);
        }
    }

    @Test
    public void testDefendDestroyedConnection() throws Exception {
        ActiveMQServerImpl server = (ActiveMQServerImpl)Mockito.mock(ActiveMQServerImpl.class);
        SessionCallback sessionCallback = (SessionCallback)Mockito.mock(SessionCallback.class);
        ManagementService managementService = (ManagementService)Mockito.mock(ManagementService.class);
        NullStorageManager storageManager = new NullStorageManager();
        ArtemisExecutor artemisExecutor = (ArtemisExecutor)Mockito.mock(ArtemisExecutor.class);
        ExecutorFactory executorFactory = (ExecutorFactory)Mockito.mock(ExecutorFactory.class);
        Mockito.when((Object)executorFactory.getExecutor()).thenReturn((Object)artemisExecutor);
        ConfigurationImpl configuration = new ConfigurationImpl();
        ActiveMQServer mockServer = (ActiveMQServer)Mockito.mock(ActiveMQServer.class);
        Mockito.when((Object)mockServer.getExecutorFactory()).thenReturn((Object)executorFactory);
        Mockito.when((Object)mockServer.getConfiguration()).thenReturn((Object)configuration);
        BufferHandler bufferHandler = (BufferHandler)Mockito.mock(BufferHandler.class);
        InVMConnection inVMConnection = new InVMConnection(1, bufferHandler, (BaseConnectionLifeCycleListener)Mockito.mock(BaseConnectionLifeCycleListener.class), artemisExecutor);
        RemotingConnectionImpl remotingConnection = new RemotingConnectionImpl((PacketDecoder)new ServerPacketDecoder((StorageManager)storageManager), (org.apache.activemq.artemis.spi.core.remoting.Connection)inVMConnection, new ArrayList(), new ArrayList(), RandomUtil.randomSimpleString(), (Executor)artemisExecutor);
        remotingConnection.destroy();
        ServerSessionImpl session = new ServerSessionImpl(RandomUtil.randomString(), RandomUtil.randomString(), RandomUtil.randomString(), RandomUtil.randomString(), 1000, true, true, true, true, true, (RemotingConnection)remotingConnection, (StorageManager)storageManager, (PostOffice)Mockito.mock(PostOffice.class), (ResourceManager)Mockito.mock(ResourceManager.class), (SecurityStore)Mockito.mock(SecurityStore.class), (ManagementService)Mockito.mock(ManagementService.class), mockServer, RandomUtil.randomSimpleString(), RandomUtil.randomSimpleString(), (SessionCallback)Mockito.mock(SessionCallback.class), (OperationContext)Mockito.mock(OperationContext.class), (PagingManager)Mockito.mock(PagingManager.class), new HashMap(), "securityDomain", false);
        try {
            new ServerConsumerImpl(1L, (ServerSession)session, null, null, 1, true, false, (StorageManager)new NullStorageManager(), sessionCallback, true, true, managementService, false, Integer.valueOf(0), (ActiveMQServer)server);
            Assertions.fail((String)"Exception was expected");
        }
        catch (ActiveMQException activeMQException) {
            logger.info("Expected exception", (Throwable)activeMQException);
            Assertions.assertTrue((boolean)activeMQException.getMessage().contains("AMQ229250"));
        }
    }

    @Test
    public void testDefendAMQPConsumerNullConnection() throws Exception {
        this.testDefendAMQPConsumer(true);
    }

    @Test
    public void testDefendAMQPConsumer() throws Exception {
        this.testDefendAMQPConsumer(false);
    }

    private void testDefendAMQPConsumer(boolean returnNullConnection) throws Exception {
        ActiveMQServer server = (ActiveMQServer)Mockito.mock(ActiveMQServer.class);
        ProtonProtocolManagerFactory protonProtocolManagerFactory = new ProtonProtocolManagerFactory();
        ProtonProtocolManager protonProtocolManager = new ProtonProtocolManager(protonProtocolManagerFactory, server, new ArrayList(), new ArrayList());
        AMQPConnectionContext connectionContext = (AMQPConnectionContext)Mockito.mock(AMQPConnectionContext.class);
        if (returnNullConnection) {
            Mockito.when((Object)connectionContext.getHandler()).thenReturn(null);
        } else {
            ProtonHandler protonHandler = (ProtonHandler)Mockito.mock(ProtonHandler.class);
            Mockito.when((Object)connectionContext.getHandler()).thenReturn((Object)protonHandler);
            Connection qpidConnection = (Connection)Mockito.mock(Connection.class);
            Mockito.when((Object)qpidConnection.getRemoteState()).thenReturn((Object)EndpointState.CLOSED);
            Mockito.when((Object)protonHandler.getConnection()).thenReturn((Object)qpidConnection);
        }
        Mockito.when((Object)connectionContext.getProtocolManager()).thenReturn((Object)protonProtocolManager);
        Sender sender = (Sender)Mockito.mock(Sender.class);
        AMQPSessionContext sessionContext = (AMQPSessionContext)Mockito.mock(AMQPSessionContext.class);
        AMQPSessionCallback sessionCallback = (AMQPSessionCallback)Mockito.mock(AMQPSessionCallback.class);
        try {
            ProtonServerSenderContext serverSenderContext = new ProtonServerSenderContext(connectionContext, sender, sessionContext, sessionCallback);
            serverSenderContext.initialize();
        }
        catch (ActiveMQException e) {
            Assertions.assertTrue((boolean)e.getMessage().contains("AMQ119027"));
            logger.warn(e.getMessage(), (Throwable)e);
        }
    }
}

