/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.tests.integration.crossprotocol;

import java.net.URI;
import java.util.concurrent.TimeUnit;
import org.apache.activemq.artemis.api.core.QueueConfiguration;
import org.apache.activemq.artemis.api.core.RoutingType;
import org.apache.activemq.artemis.api.core.SimpleString;
import org.apache.activemq.artemis.core.config.Configuration;
import org.apache.activemq.artemis.core.server.ActiveMQServer;
import org.apache.activemq.artemis.core.settings.impl.AddressSettings;
import org.apache.activemq.artemis.tests.integration.stomp.StompTestBase;
import org.apache.activemq.artemis.tests.integration.stomp.util.ClientStompFrame;
import org.apache.activemq.artemis.tests.integration.stomp.util.StompClientConnection;
import org.apache.activemq.artemis.tests.integration.stomp.util.StompClientConnectionFactory;
import org.apache.activemq.artemis.tests.util.ActiveMQTestBase;
import org.apache.activemq.transport.amqp.client.AmqpClient;
import org.apache.activemq.transport.amqp.client.AmqpConnection;
import org.apache.activemq.transport.amqp.client.AmqpMessage;
import org.apache.activemq.transport.amqp.client.AmqpSender;
import org.apache.activemq.transport.amqp.client.AmqpSession;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

public class AMQPToStompTest
extends ActiveMQTestBase {
    private ActiveMQServer server;
    protected String queueName = "amqpToStompTestQueue1";

    @Override
    @BeforeEach
    public void setUp() throws Exception {
        super.setUp();
        this.server = this.createServer(true, true);
        this.server.start();
        this.server.waitForActivation(10L, TimeUnit.SECONDS);
        Configuration serverConfig = this.server.getConfiguration();
        serverConfig.getAddressSettings().put("#", new AddressSettings().setAutoCreateQueues(Boolean.valueOf(false)).setAutoCreateAddresses(Boolean.valueOf(false)).setDeadLetterAddress(SimpleString.of((String)"ActiveMQ.DLQ")));
        serverConfig.setSecurityEnabled(false);
        this.server.createQueue(QueueConfiguration.of((String)this.queueName).setRoutingType(RoutingType.ANYCAST).setDurable(Boolean.valueOf(false)));
    }

    @Override
    @AfterEach
    public void tearDown() throws Exception {
        this.server.stop();
        super.tearDown();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testSendAmqpReceiveStomp() throws Exception {
        AmqpClient client = new AmqpClient(new URI("tcp://127.0.0.1:61616"), null, null);
        try (AmqpConnection amqpconnection = client.connect();){
            AmqpSession session = amqpconnection.createSession();
            AmqpSender sender = session.createSender(this.queueName);
            AmqpMessage message = new AmqpMessage();
            message.setText("mine");
            sender.send(message);
        }
        StompClientConnection conn = StompClientConnectionFactory.createClientConnection(new URI("tcp://127.0.0.1:61616"));
        conn.connect(null, null);
        try {
            StompTestBase.subscribeQueue(conn, null, this.queueName);
            ClientStompFrame frame = conn.receiveFrame();
            Assertions.assertNotNull((Object)frame);
            Assertions.assertNotNull((Object)frame.getBody());
            Assertions.assertTrue((boolean)frame.getBody().contains("mine"));
        }
        finally {
            conn.closeTransport();
        }
    }
}

