/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.tests.integration.jms;

import jakarta.jms.Connection;
import jakarta.jms.Destination;
import jakarta.jms.JMSConsumer;
import jakarta.jms.JMSContext;
import jakarta.jms.JMSProducer;
import jakarta.jms.MessageFormatRuntimeException;
import jakarta.jms.Session;
import jakarta.jms.TextMessage;
import java.util.ArrayList;
import java.util.Random;
import org.apache.activemq.artemis.api.core.QueueConfiguration;
import org.apache.activemq.artemis.api.core.RoutingType;
import org.apache.activemq.artemis.api.core.SimpleString;
import org.apache.activemq.artemis.core.client.impl.ClientSessionImpl;
import org.apache.activemq.artemis.core.server.Queue;
import org.apache.activemq.artemis.core.settings.impl.AddressSettings;
import org.apache.activemq.artemis.jms.client.ActiveMQJMSContext;
import org.apache.activemq.artemis.jms.client.ActiveMQSession;
import org.apache.activemq.artemis.jms.server.config.ConnectionFactoryConfiguration;
import org.apache.activemq.artemis.tests.util.JMSTestBase;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

public class JmsProducerTest
extends JMSTestBase {
    private JMSProducer producer;
    private Random random;
    private JMSContext context;

    @Override
    @BeforeEach
    public void setUp() throws Exception {
        super.setUp();
        this.context = this.createContext();
        this.producer = this.context.createProducer();
        this.random = new Random();
    }

    @Override
    protected void testCaseCfExtraConfig(ConnectionFactoryConfiguration configuration) {
        configuration.setConfirmationWindowSize(0);
        configuration.setPreAcknowledge(false);
        configuration.setBlockOnDurableSend(false);
    }

    @Test
    public void testSetters() {
        long v = this.random.nextLong();
        this.producer.setDeliveryDelay(v);
        Assertions.assertEquals((long)v, (long)this.producer.getDeliveryDelay());
        long l = this.random.nextLong();
        this.producer.setTimeToLive(l);
        Assertions.assertEquals((long)l, (long)this.producer.getTimeToLive());
        String id = "ID: jms2-tests-correlation-id" + this.random.nextLong();
        this.producer.setJMSCorrelationID(id);
        Assertions.assertEquals((Object)id, (Object)this.producer.getJMSCorrelationID());
        try {
            this.producer.setProperty("name1", new ArrayList(2));
            Assertions.fail((String)"didn't get expected MessageFormatRuntimeException");
        }
        catch (MessageFormatRuntimeException messageFormatRuntimeException) {
            // empty catch block
        }
    }

    @Test
    public void testDisMsgID() {
        this.producer.setDisableMessageID(true);
        Assertions.assertTrue((boolean)this.producer.getDisableMessageID());
        this.producer.setDisableMessageID(false);
        Assertions.assertFalse((boolean)this.producer.getDisableMessageID());
    }

    @Test
    public void multipleSendsUsingSetters() throws Exception {
        this.server.createQueue(QueueConfiguration.of((String)"q1").setRoutingType(RoutingType.ANYCAST));
        jakarta.jms.Queue q1 = this.context.createQueue("q1");
        this.context.createProducer().setProperty("prop1", 1).setProperty("prop2", 2).send((Destination)q1, "Text1");
        this.context.createProducer().setProperty("prop1", 3).setProperty("prop2", 4).send((Destination)q1, "Text2");
        for (int i = 0; i < 100; ++i) {
            this.context.createProducer().send((Destination)q1, "Text" + i);
        }
        ActiveMQSession sessionUsed = (ActiveMQSession)((ActiveMQJMSContext)this.context).getUsedSession();
        ClientSessionImpl coreSession = (ClientSessionImpl)sessionUsed.getCoreSession();
        Assertions.assertEquals((int)1, (int)coreSession.cloneProducers().size());
        JMSConsumer consumer = this.context.createConsumer((Destination)q1);
        TextMessage text = (TextMessage)consumer.receive(5000L);
        Assertions.assertNotNull((Object)text);
        Assertions.assertEquals((Object)"Text1", (Object)text.getText());
        Assertions.assertEquals((int)1, (int)text.getIntProperty("prop1"));
        Assertions.assertEquals((int)2, (int)text.getIntProperty("prop2"));
        text = (TextMessage)consumer.receive(5000L);
        Assertions.assertNotNull((Object)text);
        Assertions.assertEquals((Object)"Text2", (Object)text.getText());
        Assertions.assertEquals((int)3, (int)text.getIntProperty("prop1"));
        Assertions.assertEquals((int)4, (int)text.getIntProperty("prop2"));
        for (int i = 0; i < 100; ++i) {
            Assertions.assertEquals((Object)("Text" + i), (Object)consumer.receiveBody(String.class, 1000L));
        }
        consumer.close();
        this.context.close();
    }

    @Test
    public void defaultAutoCreatedQueueConfigTest() throws Exception {
        String queueName = "q1";
        this.server.getAddressSettingsRepository().addMatch("q1", (Object)new AddressSettings().setDefaultMaxConsumers(Integer.valueOf(5)).setDefaultPurgeOnNoConsumers(Boolean.valueOf(true)));
        jakarta.jms.Queue q1 = this.context.createQueue("q1");
        this.context.createProducer().setProperty("prop1", 1).setProperty("prop2", 2).send((Destination)q1, "Text1");
        Queue queue = this.server.locateQueue(SimpleString.of((String)"q1"));
        Assertions.assertEquals((int)5, (int)queue.getMaxConsumers());
        Assertions.assertTrue((boolean)queue.isPurgeOnNoConsumers());
    }

    @Test
    public void defaultAutoCreatedQueueConfigTest2() throws Exception {
        String queueName = "q1";
        this.server.getAddressSettingsRepository().addMatch("q1", (Object)new AddressSettings().setDefaultMaxConsumers(Integer.valueOf(5)).setDefaultPurgeOnNoConsumers(Boolean.valueOf(true)));
        Connection connection = this.cf.createConnection();
        Session session = connection.createSession();
        session.createProducer((Destination)session.createQueue("q1"));
        Queue queue = this.server.locateQueue(SimpleString.of((String)"q1"));
        Assertions.assertEquals((int)5, (int)queue.getMaxConsumers());
        Assertions.assertTrue((boolean)queue.isPurgeOnNoConsumers());
        connection.close();
    }

    @Test
    public void testDeliveryMode() {
        this.producer.setDeliveryMode(2);
        Assertions.assertEquals((int)2, (int)this.producer.getDeliveryMode());
        this.producer.setDeliveryMode(1);
        Assertions.assertEquals((int)1, (int)this.producer.getDeliveryMode());
    }

    @Test
    public void testGetNonExistentProperties() throws Exception {
        block55: {
            Throwable expected;
            block54: {
                block53: {
                    block52: {
                        block51: {
                            block50: {
                                byte value0;
                                block49: {
                                    expected = null;
                                    value0 = 0;
                                    try {
                                        value0 = Byte.valueOf(null);
                                    }
                                    catch (Throwable t) {
                                        expected = t;
                                    }
                                    try {
                                        byte value1 = this.producer.getByteProperty("testGetNonExistentProperties");
                                        if (expected == null) {
                                            Assertions.assertTrue((value1 == value0 ? 1 : 0) != 0, (String)("value0: " + value0 + " value1: " + value1));
                                        } else {
                                            Assertions.fail((String)("non existent byte property expects exception, but got value: " + value1));
                                        }
                                    }
                                    catch (Throwable t) {
                                        if (expected == null) {
                                            throw t;
                                        }
                                        if (t.getClass().equals(expected.getClass())) break block49;
                                        throw new Exception("Expected exception: " + expected.getClass().getName() + " but got: " + t.getClass(), t);
                                    }
                                }
                                expected = null;
                                value0 = 0;
                                try {
                                    value0 = Boolean.valueOf(null).booleanValue() ? 1 : 0;
                                }
                                catch (Throwable t) {
                                    expected = t;
                                }
                                try {
                                    boolean value1 = this.producer.getBooleanProperty("testGetNonExistentProperties");
                                    if (expected == null) {
                                        Assertions.assertEquals((Object)value1, (Object)(value0 != 0), (String)("value0: " + (value0 != 0) + " value1: " + value1));
                                    } else {
                                        Assertions.fail((String)("non existent boolean property expects exception, but got value: " + value1));
                                    }
                                }
                                catch (Throwable t) {
                                    if (expected == null) {
                                        throw t;
                                    }
                                    if (t.getClass().equals(expected.getClass())) break block50;
                                    throw new Exception("Expected exception: " + expected.getClass().getName() + " but got: " + t.getClass(), t);
                                }
                            }
                            expected = null;
                            double value0 = 0.0;
                            try {
                                value0 = Double.valueOf(null);
                            }
                            catch (Throwable t) {
                                expected = t;
                            }
                            try {
                                double value1 = this.producer.getDoubleProperty("testGetNonExistentProperties");
                                if (expected == null) {
                                    Assertions.assertTrue((value1 == value0 ? 1 : 0) != 0, (String)("value0: " + value0 + " value1: " + value1));
                                } else {
                                    Assertions.fail((String)("non existent double property expects exception, but got value: " + value1));
                                }
                            }
                            catch (Throwable t) {
                                if (expected == null) {
                                    throw t;
                                }
                                if (t.getClass().equals(expected.getClass())) break block51;
                                throw new Exception("Expected exception: " + expected.getClass().getName() + " but got: " + t.getClass(), t);
                            }
                        }
                        expected = null;
                        float value0 = 0.0f;
                        try {
                            value0 = Float.valueOf(null).floatValue();
                        }
                        catch (Throwable t) {
                            expected = t;
                        }
                        try {
                            float value1 = this.producer.getFloatProperty("testGetNonExistentProperties");
                            if (expected == null) {
                                Assertions.assertTrue((value1 == value0 ? 1 : 0) != 0, (String)("value0: " + value0 + " value1: " + value1));
                            } else {
                                Assertions.fail((String)("non existent double property expects exception, but got value: " + value1));
                            }
                        }
                        catch (Throwable t) {
                            if (expected == null) {
                                throw t;
                            }
                            if (t.getClass().equals(expected.getClass())) break block52;
                            throw new Exception("Expected exception: " + expected.getClass().getName() + " but got: " + t.getClass(), t);
                        }
                    }
                    expected = null;
                    int value0 = 0;
                    try {
                        value0 = Integer.valueOf(null);
                    }
                    catch (Throwable t) {
                        expected = t;
                    }
                    try {
                        int value1 = this.producer.getIntProperty("testGetNonExistentProperties");
                        if (expected == null) {
                            Assertions.assertTrue((value1 == value0 ? 1 : 0) != 0, (String)("value0: " + value0 + " value1: " + value1));
                        } else {
                            Assertions.fail((String)("non existent double property expects exception, but got value: " + value1));
                        }
                    }
                    catch (Throwable t) {
                        if (expected == null) {
                            throw t;
                        }
                        if (t.getClass().equals(expected.getClass())) break block53;
                        throw new Exception("Expected exception: " + expected.getClass().getName() + " but got: " + t.getClass(), t);
                    }
                }
                expected = null;
                long value0 = 0L;
                try {
                    value0 = Integer.valueOf(null).intValue();
                }
                catch (Throwable t) {
                    expected = t;
                }
                try {
                    long value1 = this.producer.getLongProperty("testGetNonExistentProperties");
                    if (expected == null) {
                        Assertions.assertEquals((long)value1, (long)value0, (String)("value0: " + value0 + " value1: " + value1));
                    } else {
                        Assertions.fail((String)("non existent double property expects exception, but got value: " + value1));
                    }
                }
                catch (Throwable t) {
                    if (expected == null) {
                        throw t;
                    }
                    if (t.getClass().equals(expected.getClass())) break block54;
                    throw new Exception("Expected exception: " + expected.getClass().getName() + " but got: " + t.getClass(), t);
                }
            }
            expected = null;
            short value0 = 0;
            try {
                value0 = Short.valueOf(null);
            }
            catch (Throwable t) {
                expected = t;
            }
            try {
                short value1 = this.producer.getShortProperty("testGetNonExistentProperties");
                if (expected == null) {
                    Assertions.assertTrue((value1 == value0 ? 1 : 0) != 0, (String)("value0: " + value0 + " value1: " + value1));
                } else {
                    Assertions.fail((String)("non existent double property expects exception, but got value: " + value1));
                }
            }
            catch (Throwable t) {
                if (expected == null) {
                    throw t;
                }
                if (t.getClass().equals(expected.getClass())) break block55;
                throw new Exception("Expected exception: " + expected.getClass().getName() + " but got: " + t.getClass(), t);
            }
        }
        Object value0 = this.producer.getObjectProperty("testGetNonExistentProperties");
        Assertions.assertNull((Object)value0);
        String value1 = this.producer.getStringProperty("testGetNonExistentProperties");
        Assertions.assertNull((Object)value1);
    }
}

