/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.tests.integration.jms.connection;

import jakarta.jms.Queue;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.NotSerializableException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import org.apache.activemq.artemis.api.core.BroadcastEndpoint;
import org.apache.activemq.artemis.api.core.BroadcastEndpointFactory;
import org.apache.activemq.artemis.api.core.ChannelBroadcastEndpointFactory;
import org.apache.activemq.artemis.api.core.DiscoveryGroupConfiguration;
import org.apache.activemq.artemis.api.core.JGroupsFileBroadcastEndpointFactory;
import org.apache.activemq.artemis.api.jms.JMSFactoryType;
import org.apache.activemq.artemis.core.config.Configuration;
import org.apache.activemq.artemis.jms.client.ActiveMQConnectionFactory;
import org.apache.activemq.artemis.tests.util.JMSTestBase;
import org.jgroups.JChannel;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

public class ConnectionFactoryWithJGroupsSerializationTest
extends JMSTestBase {
    protected static ActiveMQConnectionFactory jmsCf1;
    protected static ActiveMQConnectionFactory jmsCf2;
    JChannel channel = null;
    Queue testQueue = null;

    @Override
    @BeforeEach
    public void setUp() throws Exception {
        try {
            super.setUp();
            this.channel = new JChannel("udp.xml");
            String channelName1 = "channel1";
            String channelName2 = "channel2";
            ChannelBroadcastEndpointFactory jgroupsBroadcastCfg1 = new ChannelBroadcastEndpointFactory(this.channel, channelName1);
            JGroupsFileBroadcastEndpointFactory jgroupsBroadcastCfg2 = new JGroupsFileBroadcastEndpointFactory().setChannelName(channelName2).setFile("udp.xml");
            DiscoveryGroupConfiguration dcConfig1 = new DiscoveryGroupConfiguration().setName("dg1").setRefreshTimeout(5000L).setDiscoveryInitialWaitTimeout(5000L).setBroadcastEndpointFactory((BroadcastEndpointFactory)jgroupsBroadcastCfg1);
            DiscoveryGroupConfiguration dcConfig2 = new DiscoveryGroupConfiguration().setName("dg2").setRefreshTimeout(5000L).setDiscoveryInitialWaitTimeout(5000L).setBroadcastEndpointFactory((BroadcastEndpointFactory)jgroupsBroadcastCfg2);
            this.jmsServer.getActiveMQServer().getConfiguration().getDiscoveryGroupConfigurations().put(dcConfig1.getName(), dcConfig1);
            this.jmsServer.getActiveMQServer().getConfiguration().getDiscoveryGroupConfigurations().put(dcConfig2.getName(), dcConfig2);
            this.jmsServer.createConnectionFactory("ConnectionFactory1", false, JMSFactoryType.CF, dcConfig1.getName(), new String[]{"/ConnectionFactory1"});
            this.jmsServer.createConnectionFactory("ConnectionFactory2", false, JMSFactoryType.CF, dcConfig2.getName(), new String[]{"/ConnectionFactory2"});
            this.testQueue = this.createQueue("testQueueFor1389");
        }
        catch (Exception e) {
            e.printStackTrace();
            throw e;
        }
    }

    @Test
    public void testSerialization() throws Exception {
        jmsCf1 = (ActiveMQConnectionFactory)this.namingContext.lookup("/ConnectionFactory1");
        jmsCf2 = (ActiveMQConnectionFactory)this.namingContext.lookup("/ConnectionFactory2");
        try {
            ConnectionFactoryWithJGroupsSerializationTest.serialize(jmsCf1);
        }
        catch (NotSerializableException notSerializableException) {
            // empty catch block
        }
        byte[] x = ConnectionFactoryWithJGroupsSerializationTest.serialize(jmsCf2);
        ActiveMQConnectionFactory jmsCf2Copy = ConnectionFactoryWithJGroupsSerializationTest.deserialize(x, ActiveMQConnectionFactory.class);
        Assertions.assertNotNull((Object)jmsCf2Copy);
        BroadcastEndpointFactory broadcastEndpoint = jmsCf2Copy.getDiscoveryGroupConfiguration().getBroadcastEndpointFactory();
        Assertions.assertTrue((boolean)(broadcastEndpoint instanceof JGroupsFileBroadcastEndpointFactory));
    }

    @Test
    public void testCopyConfiguration() throws Exception {
        Assertions.assertEquals((int)2, (int)this.jmsServer.getActiveMQServer().getConfiguration().getDiscoveryGroupConfigurations().size());
        Configuration copiedconfig = this.jmsServer.getActiveMQServer().getConfiguration().copy();
        Assertions.assertEquals((int)2, (int)copiedconfig.getDiscoveryGroupConfigurations().size());
    }

    @Override
    @AfterEach
    public void tearDown() throws Exception {
        BroadcastEndpoint broadcastEndpoint = ((DiscoveryGroupConfiguration)this.jmsServer.getActiveMQServer().getConfiguration().getDiscoveryGroupConfigurations().get("dg1")).getBroadcastEndpointFactory().createBroadcastEndpoint();
        broadcastEndpoint.close(true);
        if (this.channel != null) {
            Assertions.assertFalse((boolean)this.channel.isClosed());
            this.channel.close();
        }
        super.tearDown();
    }

    private static <T extends Serializable> byte[] serialize(T obj) throws IOException {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        ObjectOutputStream oos = new ObjectOutputStream(baos);
        oos.writeObject(obj);
        oos.close();
        return baos.toByteArray();
    }

    private static <T extends Serializable> T deserialize(byte[] b, Class<T> cl) throws IOException, ClassNotFoundException {
        ByteArrayInputStream bais = new ByteArrayInputStream(b);
        ObjectInputStream ois = new ObjectInputStream(bais);
        Object o = ois.readObject();
        return (T)((Serializable)cl.cast(o));
    }
}

