/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.tests.integration.journal;

import java.io.File;
import java.nio.ByteBuffer;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.activemq.artemis.api.core.ActiveMQBuffer;
import org.apache.activemq.artemis.api.core.ActiveMQBuffers;
import org.apache.activemq.artemis.core.io.SequentialFile;
import org.apache.activemq.artemis.core.io.SequentialFileFactory;
import org.apache.activemq.artemis.core.io.nio.NIOSequentialFileFactory;
import org.apache.activemq.artemis.core.journal.EncoderPersister;
import org.apache.activemq.artemis.core.journal.EncodingSupport;
import org.apache.activemq.artemis.core.journal.LoaderCallback;
import org.apache.activemq.artemis.core.journal.PreparedTransactionInfo;
import org.apache.activemq.artemis.core.journal.RecordInfo;
import org.apache.activemq.artemis.core.journal.impl.JournalImpl;
import org.apache.activemq.artemis.core.journal.impl.dataformat.ByteArrayEncoding;
import org.apache.activemq.artemis.core.journal.impl.dataformat.JournalAddRecord;
import org.apache.activemq.artemis.core.persistence.Persister;
import org.apache.activemq.artemis.tests.util.ActiveMQTestBase;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class JournalCompactSplitTest
extends ActiveMQTestBase {
    private static final long RECORDS_TO_CREATE = 100L;
    private static final int JOURNAL_FILE_SIZE = 102400;
    private static final int BODY_SIZE = 124;

    @Test
    public void testJournalSplit() throws Exception {
        NIOSequentialFileFactory fileFactory = new NIOSequentialFileFactory(new File(this.getTemporaryDir()), 1);
        this.createFileWithRecords((SequentialFileFactory)fileFactory);
        this.createAndCompactJournal((SequentialFileFactory)fileFactory);
    }

    private void createAndCompactJournal(SequentialFileFactory fileFactory) throws Exception {
        int minFiles = 2;
        int compactMinFiles = 2;
        int compactPercentage = 30;
        String filePrefix = "activemq-data";
        String fileExtension = "amq";
        int maxAIO = 1024;
        JournalImpl journalImpl = new JournalImpl(102400, 2, 2, 2, 30, fileFactory, "activemq-data", "amq", 1024, 1);
        final AtomicInteger recordCount = new AtomicInteger(0);
        journalImpl.start();
        this.runAfter(() -> ((JournalImpl)journalImpl).stop());
        journalImpl.load(new LoaderCallback(){

            public void addPreparedTransaction(PreparedTransactionInfo preparedTransaction) {
            }

            public void addRecord(RecordInfo info) {
                recordCount.incrementAndGet();
            }

            public void deleteRecord(long id) {
            }

            public void updateRecord(RecordInfo info) {
            }

            public void failedTransaction(long transactionID, List<RecordInfo> records, List<RecordInfo> recordsToDelete) {
            }
        });
        Assertions.assertEquals((long)100L, (long)recordCount.get());
        journalImpl.compact();
        Assertions.assertEquals((int)2, (int)journalImpl.getDataFilesCount());
    }

    private void createFileWithRecords(SequentialFileFactory fileFactory) throws Exception {
        SequentialFile file = fileFactory.createSequentialFile("activemq-data-1.amq", 102400);
        file.open();
        file.fill(102400);
        file.position(0L);
        ByteBuffer bb = fileFactory.newBuffer(16);
        ActiveMQBuffer buffer = ActiveMQBuffers.wrappedBuffer((ByteBuffer)bb);
        JournalImpl.writeHeader((ActiveMQBuffer)buffer, (int)1, (long)1L);
        file.write(buffer, true);
        byte[] z = new byte[124];
        for (int i = 0; i < 124; ++i) {
            z[i] = 122;
        }
        short compactCount = 10;
        for (long i = 0L; i < 100L; ++i) {
            JournalAddRecord record = new JournalAddRecord(true, i, 11, (Persister)EncoderPersister.getInstance(), (Object)new ByteArrayEncoding(z));
            record.setFileID(1);
            compactCount = (short)(compactCount - 1);
            if (compactCount < 0) {
                compactCount = 10;
            }
            record.setCompactCount(compactCount);
            file.write((EncodingSupport)record, false);
        }
        file.close();
    }
}

