/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.tests.integration.largemessage;

import java.io.File;
import java.io.IOException;
import java.lang.management.ManagementFactory;
import java.net.URL;
import java.nio.ByteBuffer;
import java.util.HashSet;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.management.MBeanServer;
import org.apache.activemq.artemis.api.core.ActiveMQBuffer;
import org.apache.activemq.artemis.api.core.ActiveMQException;
import org.apache.activemq.artemis.api.core.Message;
import org.apache.activemq.artemis.api.core.QueueConfiguration;
import org.apache.activemq.artemis.api.core.RoutingType;
import org.apache.activemq.artemis.api.core.client.ClientConsumer;
import org.apache.activemq.artemis.api.core.client.ClientMessage;
import org.apache.activemq.artemis.api.core.client.ClientProducer;
import org.apache.activemq.artemis.api.core.client.ClientSession;
import org.apache.activemq.artemis.api.core.client.ClientSessionFactory;
import org.apache.activemq.artemis.api.core.client.ServerLocator;
import org.apache.activemq.artemis.core.config.Configuration;
import org.apache.activemq.artemis.core.io.AbstractSequentialFile;
import org.apache.activemq.artemis.core.io.IOCallback;
import org.apache.activemq.artemis.core.io.SequentialFile;
import org.apache.activemq.artemis.core.io.SequentialFileFactory;
import org.apache.activemq.artemis.core.io.buffer.TimedBuffer;
import org.apache.activemq.artemis.core.journal.EncodingSupport;
import org.apache.activemq.artemis.core.persistence.StorageManager;
import org.apache.activemq.artemis.core.persistence.impl.journal.JournalStorageManager;
import org.apache.activemq.artemis.core.persistence.impl.journal.LargeServerMessageImpl;
import org.apache.activemq.artemis.core.security.Role;
import org.apache.activemq.artemis.core.server.ActiveMQServer;
import org.apache.activemq.artemis.core.server.ActiveMQServers;
import org.apache.activemq.artemis.spi.core.security.ActiveMQJAASSecurityManager;
import org.apache.activemq.artemis.spi.core.security.ActiveMQSecurityManager;
import org.apache.activemq.artemis.tests.integration.security.SecurityTest;
import org.apache.activemq.artemis.tests.unit.core.journal.impl.fakes.FakeSequentialFileFactory;
import org.apache.activemq.artemis.tests.util.ActiveMQTestBase;
import org.apache.activemq.artemis.utils.ExecutorFactory;
import org.apache.activemq.artemis.utils.critical.CriticalAnalyzer;
import org.apache.activemq.artemis.utils.critical.EmptyCriticalAnalyzer;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

public class ServerLargeMessageTest
extends ActiveMQTestBase {
    String originalPath;

    @BeforeEach
    public void setupProperty() {
        URL resource;
        this.originalPath = System.getProperty("java.security.auth.login.config");
        if (this.originalPath == null && (resource = SecurityTest.class.getClassLoader().getResource("login.config")) != null) {
            this.originalPath = resource.getFile();
            System.setProperty("java.security.auth.login.config", this.originalPath);
        }
    }

    @AfterEach
    public void clearProperty() {
        if (this.originalPath == null) {
            System.clearProperty("java.security.auth.login.config");
        } else {
            System.setProperty("java.security.auth.login.config", this.originalPath);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testSendServerMessage() throws Exception {
        ActiveMQServer server = this.createServer(true);
        server.start();
        ServerLocator locator = this.createInVMNonHALocator();
        ClientSessionFactory sf = this.createSessionFactory(locator);
        ClientSession session = sf.createSession(false, false);
        try {
            LargeServerMessageImpl fileMessage = new LargeServerMessageImpl((StorageManager)((JournalStorageManager)server.getStorageManager()));
            fileMessage.setMessageID(1005L);
            for (int i = 0; i < 204800; ++i) {
                fileMessage.addBytes(new byte[]{ActiveMQTestBase.getSamplebyte(i)});
            }
            fileMessage.putLongProperty(Message.HDR_LARGE_BODY_SIZE, 204800L);
            fileMessage.releaseResources(false, true);
            session.createQueue(QueueConfiguration.of((String)"A").setRoutingType(RoutingType.ANYCAST));
            ClientProducer prod = session.createProducer("A");
            prod.send((Message)fileMessage);
            fileMessage.deleteFile();
            session.commit();
            session.start();
            ClientConsumer cons = session.createConsumer("A");
            ClientMessage msg = cons.receive(5000L);
            Assertions.assertNotNull((Object)msg);
            Assertions.assertEquals((int)msg.getBodySize(), (int)204800);
            for (int i = 0; i < 204800; ++i) {
                Assertions.assertEquals((byte)ActiveMQTestBase.getSamplebyte(i), (byte)msg.getBodyBuffer().readByte());
            }
            msg.acknowledge();
            session.commit();
        }
        finally {
            sf.close();
            locator.close();
            server.stop();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testSendServerMessageWithValidatedUser() throws Exception {
        ActiveMQJAASSecurityManager securityManager = new ActiveMQJAASSecurityManager("PropertiesLogin");
        ActiveMQServer server = this.addServer(ActiveMQServers.newActiveMQServer((Configuration)this.createDefaultInVMConfig().setSecurityEnabled(true), (MBeanServer)ManagementFactory.getPlatformMBeanServer(), (ActiveMQSecurityManager)securityManager, (boolean)false));
        server.getConfiguration().setPopulateValidatedUser(true);
        Role role = new Role("programmers", true, true, true, true, true, true, true, true, true, true, false, false);
        HashSet<Role> roles = new HashSet<Role>();
        roles.add(role);
        server.getSecurityRepository().addMatch("#", roles);
        server.start();
        ServerLocator locator = this.createInVMNonHALocator();
        ClientSessionFactory sf = this.createSessionFactory(locator);
        try {
            ClientSession session = sf.createSession("first", "secret", false, true, true, false, 0);
            ClientMessage clientMessage = session.createMessage(false);
            clientMessage.setBodyInputStream(ActiveMQTestBase.createFakeLargeStream(102400L));
            session.createQueue(QueueConfiguration.of((String)"A").setRoutingType(RoutingType.ANYCAST));
            ClientProducer prod = session.createProducer("A");
            prod.send((Message)clientMessage);
            session.commit();
            session.start();
            ClientConsumer cons = session.createConsumer("A");
            ClientMessage msg = cons.receive(5000L);
            Assertions.assertEquals((Object)"first", (Object)msg.getValidatedUserID());
        }
        finally {
            sf.close();
            locator.close();
            server.stop();
        }
    }

    @Test
    public void testLargeServerMessageSync() throws Exception {
        final AtomicBoolean open = new AtomicBoolean(false);
        final AtomicBoolean sync = new AtomicBoolean(false);
        JournalStorageManager storageManager = new JournalStorageManager(this.createDefaultInVMConfig(), (CriticalAnalyzer)EmptyCriticalAnalyzer.getInstance(), (ExecutorFactory)this.getOrderedExecutor(), (ExecutorFactory)this.getOrderedExecutor()){

            public SequentialFile createFileForLargeMessage(long messageID, StorageManager.LargeMessageExtension extension) {
                return new SequentialFile(){

                    public boolean isOpen() {
                        return open.get();
                    }

                    public boolean exists() {
                        return true;
                    }

                    public void open() throws Exception {
                        open.set(true);
                    }

                    public void open(int maxIO, boolean useExecutor) throws Exception {
                        open.set(true);
                    }

                    public boolean fits(int size) {
                        return false;
                    }

                    public int calculateBlockStart(int position) throws Exception {
                        return 0;
                    }

                    public ByteBuffer map(int position, long size) throws IOException {
                        return null;
                    }

                    public String getFileName() {
                        return null;
                    }

                    public void fill(int size) throws Exception {
                    }

                    public void delete() throws IOException, InterruptedException, ActiveMQException {
                    }

                    public void write(ActiveMQBuffer bytes, boolean sync, IOCallback callback) throws Exception {
                    }

                    public void write(ActiveMQBuffer bytes, boolean sync) throws Exception {
                    }

                    public void write(EncodingSupport bytes, boolean sync, IOCallback callback) throws Exception {
                    }

                    public void write(EncodingSupport bytes, boolean sync) throws Exception {
                    }

                    public void writeDirect(ByteBuffer bytes, boolean sync, IOCallback callback) {
                    }

                    public void writeDirect(ByteBuffer bytes, boolean sync) throws Exception {
                    }

                    public void blockingWriteDirect(ByteBuffer bytes, boolean sync, boolean releaseBuffer) throws Exception {
                    }

                    public int read(ByteBuffer bytes, IOCallback callback) throws Exception {
                        return 0;
                    }

                    public int read(ByteBuffer bytes) throws Exception {
                        return 0;
                    }

                    public void position(long pos) throws IOException {
                    }

                    public long position() {
                        return 0L;
                    }

                    public void close() throws Exception {
                        open.set(false);
                    }

                    public void sync() throws IOException {
                        sync.set(true);
                    }

                    public long size() throws Exception {
                        return 0L;
                    }

                    public void renameTo(String newFileName) throws Exception {
                    }

                    public SequentialFile cloneFile() {
                        return null;
                    }

                    public void copyTo(SequentialFile newFileName) throws Exception {
                    }

                    public void setTimedBuffer(TimedBuffer buffer) {
                    }

                    public File getJavaFile() {
                        return null;
                    }
                };
            }
        };
        LargeServerMessageImpl largeServerMessage = new LargeServerMessageImpl((StorageManager)storageManager);
        largeServerMessage.setMessageID(1234L);
        largeServerMessage.addBytes(new byte[0]);
        Assertions.assertTrue((boolean)open.get());
        largeServerMessage.releaseResources(true, true);
        Assertions.assertTrue((boolean)sync.get());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testLargeServerMessageCopyIsolation() throws Exception {
        ActiveMQServer server = this.createServer(true);
        server.start();
        try {
            LargeServerMessageImpl largeMessage = new LargeServerMessageImpl((StorageManager)((JournalStorageManager)server.getStorageManager()));
            largeMessage.setMessageID(23456L);
            for (int i = 0; i < 204800; ++i) {
                largeMessage.addBytes(new byte[]{ActiveMQTestBase.getSamplebyte(i)});
            }
            this.replaceFile(largeMessage);
            Message copied = largeMessage.copy(99999L);
            Assertions.assertEquals((long)99999L, (long)copied.getMessageID());
        }
        finally {
            server.stop();
        }
    }

    private void replaceFile(LargeServerMessageImpl largeMessage) throws Exception {
        SequentialFile originalFile = largeMessage.getAppendFile();
        MockSequentialFile mockFile = new MockSequentialFile(originalFile);
        largeMessage.getLargeBody().replaceFile((SequentialFile)mockFile);
        mockFile.close();
    }

    private class MockSequentialFile
    extends AbstractSequentialFile {
        private SequentialFile originalFile;

        MockSequentialFile(SequentialFile originalFile) throws Exception {
            super(originalFile.getJavaFile().getParentFile(), originalFile.getFileName(), (SequentialFileFactory)new FakeSequentialFileFactory(), null);
            this.originalFile = originalFile;
            this.originalFile.close();
        }

        public void open() throws Exception {
            this.originalFile.open();
            this.originalFile.close();
        }

        public void open(int maxIO, boolean useExecutor) throws Exception {
        }

        public ByteBuffer map(int position, long size) throws IOException {
            return null;
        }

        public boolean isOpen() {
            return this.originalFile.isOpen();
        }

        public int calculateBlockStart(int position) throws Exception {
            return this.originalFile.calculateBlockStart(position);
        }

        public void fill(int size) throws Exception {
            this.originalFile.fill(size);
        }

        public void writeDirect(ByteBuffer bytes, boolean sync, IOCallback callback) {
            this.originalFile.writeDirect(bytes, sync, callback);
        }

        public void writeDirect(ByteBuffer bytes, boolean sync) throws Exception {
            this.originalFile.writeDirect(bytes, sync);
        }

        public void blockingWriteDirect(ByteBuffer bytes, boolean sync, boolean releaseBuffer) throws Exception {
            this.originalFile.blockingWriteDirect(bytes, sync, releaseBuffer);
        }

        public int read(ByteBuffer bytes, IOCallback callback) throws Exception {
            return this.originalFile.read(bytes, callback);
        }

        public int read(ByteBuffer bytes) throws Exception {
            return this.originalFile.read(bytes);
        }

        public void sync() throws IOException {
            this.originalFile.sync();
        }

        public long size() throws Exception {
            return this.originalFile.size();
        }

        public SequentialFile cloneFile() {
            return this.originalFile.cloneFile();
        }
    }
}

