/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.tests.integration.management;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.management.MBeanServer;
import org.apache.activemq.artemis.api.core.BroadcastEndpointFactory;
import org.apache.activemq.artemis.api.core.DiscoveryGroupConfiguration;
import org.apache.activemq.artemis.api.core.JsonUtil;
import org.apache.activemq.artemis.api.core.QueueConfiguration;
import org.apache.activemq.artemis.api.core.SimpleString;
import org.apache.activemq.artemis.api.core.TransportConfiguration;
import org.apache.activemq.artemis.api.core.UDPBroadcastEndpointFactory;
import org.apache.activemq.artemis.api.core.management.ClusterConnectionControl;
import org.apache.activemq.artemis.api.core.management.CoreNotificationType;
import org.apache.activemq.artemis.api.core.management.ObjectNameBuilder;
import org.apache.activemq.artemis.core.config.ClusterConnectionConfiguration;
import org.apache.activemq.artemis.core.config.Configuration;
import org.apache.activemq.artemis.core.config.impl.ConfigurationImpl;
import org.apache.activemq.artemis.core.remoting.impl.invm.InVMAcceptorFactory;
import org.apache.activemq.artemis.core.remoting.impl.invm.InVMConnectorFactory;
import org.apache.activemq.artemis.core.server.ActiveMQServer;
import org.apache.activemq.artemis.core.server.ActiveMQServers;
import org.apache.activemq.artemis.core.server.cluster.impl.MessageLoadBalancingType;
import org.apache.activemq.artemis.core.server.management.Notification;
import org.apache.activemq.artemis.core.server.management.NotificationListener;
import org.apache.activemq.artemis.json.JsonArray;
import org.apache.activemq.artemis.tests.integration.SimpleNotificationService;
import org.apache.activemq.artemis.tests.integration.management.ManagementControlHelper;
import org.apache.activemq.artemis.tests.integration.management.ManagementTestBase;
import org.apache.activemq.artemis.utils.RandomUtil;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

public class ClusterConnectionControlTest
extends ManagementTestBase {
    private ActiveMQServer server_0;
    private ClusterConnectionConfiguration clusterConnectionConfig1;
    private ClusterConnectionConfiguration clusterConnectionConfig2;
    private ActiveMQServer server_1;
    private MBeanServer mbeanServer_1;

    @Test
    public void testAttributes1() throws Exception {
        this.checkResource(ObjectNameBuilder.DEFAULT.getClusterConnectionObjectName(this.clusterConnectionConfig1.getName()));
        ClusterConnectionControl clusterConnectionControl = this.createManagementControl(this.clusterConnectionConfig1.getName());
        Assertions.assertEquals((Object)this.clusterConnectionConfig1.getName(), (Object)clusterConnectionControl.getName());
        Assertions.assertEquals((Object)this.clusterConnectionConfig1.getAddress(), (Object)clusterConnectionControl.getAddress());
        Assertions.assertEquals((Object)this.clusterConnectionConfig1.getDiscoveryGroupName(), (Object)clusterConnectionControl.getDiscoveryGroupName());
        Assertions.assertEquals((long)this.clusterConnectionConfig1.getRetryInterval(), (long)clusterConnectionControl.getRetryInterval());
        Assertions.assertEquals((Object)this.clusterConnectionConfig1.isDuplicateDetection(), (Object)clusterConnectionControl.isDuplicateDetection());
        Assertions.assertEquals((Object)this.clusterConnectionConfig1.getMessageLoadBalancingType().toString(), (Object)clusterConnectionControl.getMessageLoadBalancingType());
        Assertions.assertEquals((int)this.clusterConnectionConfig1.getMaxHops(), (int)clusterConnectionControl.getMaxHops());
        Assertions.assertEquals((long)this.clusterConnectionConfig1.getProducerWindowSize(), (long)clusterConnectionControl.getProducerWindowSize());
        Assertions.assertEquals((long)0L, (long)clusterConnectionControl.getMessagesPendingAcknowledgement());
        Assertions.assertEquals((long)0L, (long)clusterConnectionControl.getMessagesAcknowledged());
        Map clusterMetrics = clusterConnectionControl.getMetrics();
        Assertions.assertEquals((Object)0L, clusterMetrics.get("messagesPendingAcknowledgement"));
        Assertions.assertEquals((Object)0L, clusterMetrics.get("messagesAcknowledged"));
        Assertions.assertNull((Object)clusterConnectionControl.getBridgeMetrics("bad"));
        Object[] connectors = clusterConnectionControl.getStaticConnectors();
        Assertions.assertEquals((int)1, (int)connectors.length);
        String connector = (String)connectors[0];
        Assertions.assertEquals(this.clusterConnectionConfig1.getStaticConnectors().get(0), (Object)connector);
        String jsonString = clusterConnectionControl.getStaticConnectorsAsJSON();
        Assertions.assertNotNull((Object)jsonString);
        JsonArray array = JsonUtil.readJsonArray((String)jsonString);
        Assertions.assertEquals((int)1, (int)array.size());
        Assertions.assertEquals(this.clusterConnectionConfig1.getStaticConnectors().get(0), (Object)array.getString(0));
        Assertions.assertNull((Object)clusterConnectionControl.getDiscoveryGroupName());
        Assertions.assertTrue((boolean)clusterConnectionControl.isStarted());
    }

    @Test
    public void testAttributes2() throws Exception {
        this.checkResource(ObjectNameBuilder.DEFAULT.getClusterConnectionObjectName(this.clusterConnectionConfig2.getName()));
        ClusterConnectionControl clusterConnectionControl = this.createManagementControl(this.clusterConnectionConfig2.getName());
        Assertions.assertEquals((Object)this.clusterConnectionConfig2.getName(), (Object)clusterConnectionControl.getName());
        Assertions.assertEquals((Object)this.clusterConnectionConfig2.getAddress(), (Object)clusterConnectionControl.getAddress());
        Assertions.assertEquals((Object)this.clusterConnectionConfig2.getDiscoveryGroupName(), (Object)clusterConnectionControl.getDiscoveryGroupName());
        Assertions.assertEquals((long)this.clusterConnectionConfig2.getRetryInterval(), (long)clusterConnectionControl.getRetryInterval());
        Assertions.assertEquals((Object)this.clusterConnectionConfig2.isDuplicateDetection(), (Object)clusterConnectionControl.isDuplicateDetection());
        Assertions.assertEquals((Object)this.clusterConnectionConfig2.getMessageLoadBalancingType().toString(), (Object)clusterConnectionControl.getMessageLoadBalancingType());
        Assertions.assertEquals((int)this.clusterConnectionConfig2.getMaxHops(), (int)clusterConnectionControl.getMaxHops());
        Assertions.assertEquals((long)this.clusterConnectionConfig2.getProducerWindowSize(), (long)clusterConnectionControl.getProducerWindowSize());
        Object[] connectorPairs = clusterConnectionControl.getStaticConnectors();
        Assertions.assertEquals((int)0, (int)connectorPairs.length);
        String jsonPairs = clusterConnectionControl.getStaticConnectorsAsJSON();
        Assertions.assertEquals((Object)"[]", (Object)jsonPairs);
        Assertions.assertEquals((Object)this.clusterConnectionConfig2.getDiscoveryGroupName(), (Object)clusterConnectionControl.getDiscoveryGroupName());
    }

    @Test
    public void testStartStop() throws Exception {
        this.checkResource(ObjectNameBuilder.DEFAULT.getClusterConnectionObjectName(this.clusterConnectionConfig1.getName()));
        ClusterConnectionControl clusterConnectionControl = this.createManagementControl(this.clusterConnectionConfig1.getName());
        Assertions.assertTrue((boolean)clusterConnectionControl.isStarted());
        clusterConnectionControl.stop();
        Assertions.assertFalse((boolean)clusterConnectionControl.isStarted());
        clusterConnectionControl.start();
        Assertions.assertTrue((boolean)clusterConnectionControl.isStarted());
    }

    @Test
    public void testNotifications() throws Exception {
        SimpleNotificationService.Listener notifListener = new SimpleNotificationService.Listener();
        this.checkResource(ObjectNameBuilder.DEFAULT.getClusterConnectionObjectName(this.clusterConnectionConfig1.getName()));
        ClusterConnectionControl clusterConnectionControl = this.createManagementControl(this.clusterConnectionConfig1.getName());
        this.server_0.getManagementService().addNotificationListener((NotificationListener)notifListener);
        Assertions.assertEquals((int)0, (int)notifListener.getNotifications().size());
        clusterConnectionControl.stop();
        Assertions.assertTrue((notifListener.getNotifications().size() > 0 ? (byte)1 : 0) != 0);
        Notification notif = this.getFirstNotificationOfType(notifListener.getNotifications(), CoreNotificationType.CLUSTER_CONNECTION_STOPPED);
        Assertions.assertNotNull((Object)notif);
        Assertions.assertEquals((Object)clusterConnectionControl.getName(), (Object)notif.getProperties().getSimpleStringProperty(SimpleString.of((String)"name")).toString());
        clusterConnectionControl.start();
        Assertions.assertTrue((notifListener.getNotifications().size() > 0 ? (byte)1 : 0) != 0);
        notif = this.getFirstNotificationOfType(notifListener.getNotifications(), CoreNotificationType.CLUSTER_CONNECTION_STARTED);
        Assertions.assertNotNull((Object)notif);
        Assertions.assertEquals((Object)clusterConnectionControl.getName(), (Object)notif.getProperties().getSimpleStringProperty(SimpleString.of((String)"name")).toString());
    }

    private Notification getFirstNotificationOfType(List<Notification> notifications, CoreNotificationType type) {
        Notification result = null;
        ArrayList<Notification> notificationsClone = new ArrayList<Notification>(notifications);
        for (Notification notification : notificationsClone) {
            if (!notification.getType().equals(type)) continue;
            result = notification;
        }
        return result;
    }

    @Override
    @BeforeEach
    public void setUp() throws Exception {
        super.setUp();
        HashMap<String, Integer> acceptorParams = new HashMap<String, Integer>();
        acceptorParams.put("serverId", 1);
        TransportConfiguration acceptorConfig = new TransportConfiguration(InVMAcceptorFactory.class.getName(), acceptorParams, RandomUtil.randomString());
        TransportConfiguration connectorConfig = new TransportConfiguration(InVMConnectorFactory.class.getName(), acceptorParams, RandomUtil.randomString());
        QueueConfiguration queueConfig = QueueConfiguration.of((String)RandomUtil.randomString()).setDurable(Boolean.valueOf(false));
        ArrayList<String> connectors = new ArrayList<String>();
        connectors.add(connectorConfig.getName());
        String discoveryGroupName = RandomUtil.randomString();
        DiscoveryGroupConfiguration discoveryGroupConfig = new DiscoveryGroupConfiguration().setName(discoveryGroupName).setRefreshTimeout(500L).setDiscoveryInitialWaitTimeout(0L).setBroadcastEndpointFactory((BroadcastEndpointFactory)new UDPBroadcastEndpointFactory().setGroupAddress(ClusterConnectionControlTest.getUDPDiscoveryAddress()).setGroupPort(ClusterConnectionControlTest.getUDPDiscoveryPort()));
        ConfigurationImpl conf_1 = this.createBasicConfig().addAcceptorConfiguration(acceptorConfig).addQueueConfiguration(queueConfig);
        this.clusterConnectionConfig1 = new ClusterConnectionConfiguration().setName(RandomUtil.randomString()).setAddress(queueConfig.getAddress().toString()).setConnectorName(connectorConfig.getName()).setRetryInterval(RandomUtil.randomPositiveLong()).setDuplicateDetection(RandomUtil.randomBoolean()).setMessageLoadBalancingType(MessageLoadBalancingType.STRICT).setMaxHops(RandomUtil.randomPositiveInt()).setConfirmationWindowSize(RandomUtil.randomPositiveInt()).setMessageLoadBalancingType(MessageLoadBalancingType.ON_DEMAND).setStaticConnectors(connectors).setCallTimeout(500L).setCallFailoverTimeout(500L).setProducerWindowSize(1234);
        this.clusterConnectionConfig2 = new ClusterConnectionConfiguration().setName(RandomUtil.randomString()).setAddress(queueConfig.getAddress().toString()).setConnectorName(connectorConfig.getName()).setRetryInterval(RandomUtil.randomPositiveLong()).setDuplicateDetection(RandomUtil.randomBoolean()).setMessageLoadBalancingType(MessageLoadBalancingType.OFF).setMaxHops(RandomUtil.randomPositiveInt()).setConfirmationWindowSize(RandomUtil.randomPositiveInt()).setMessageLoadBalancingType(MessageLoadBalancingType.ON_DEMAND).setDiscoveryGroupName(discoveryGroupName).setCallTimeout(500L).setCallFailoverTimeout(500L).setProducerWindowSize(1234);
        ConfigurationImpl conf_0 = this.createBasicConfig().addAcceptorConfiguration(new TransportConfiguration(InVMAcceptorFactory.class.getName())).addConnectorConfiguration(connectorConfig.getName(), connectorConfig).addClusterConfiguration(this.clusterConnectionConfig1).addClusterConfiguration(this.clusterConnectionConfig2).addDiscoveryGroupConfiguration(discoveryGroupName, discoveryGroupConfig);
        this.mbeanServer_1 = this.createMBeanServer();
        this.server_1 = this.addServer(ActiveMQServers.newActiveMQServer((Configuration)conf_1, (MBeanServer)this.mbeanServer_1, (boolean)false));
        this.server_1.start();
        this.server_0 = this.addServer(ActiveMQServers.newActiveMQServer((Configuration)conf_0, (MBeanServer)this.mbeanServer, (boolean)false));
        this.server_0.start();
    }

    @Override
    @AfterEach
    public void tearDown() throws Exception {
        super.tearDown();
    }

    protected ClusterConnectionControl createManagementControl(String name) throws Exception {
        return ManagementControlHelper.createClusterConnectionControl(name, this.mbeanServer);
    }
}

