/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.tests.integration.management;

import javax.management.MBeanServer;
import javax.management.ObjectName;
import org.apache.activemq.artemis.api.core.RoutingType;
import org.apache.activemq.artemis.api.core.SimpleString;
import org.apache.activemq.artemis.api.core.client.ClientConsumer;
import org.apache.activemq.artemis.api.core.client.ClientMessage;
import org.apache.activemq.artemis.api.core.client.ClientSession;
import org.apache.activemq.artemis.api.core.management.QueueControl;
import org.apache.activemq.artemis.tests.integration.management.ManagementControlHelper;
import org.apache.activemq.artemis.tests.util.ActiveMQTestBase;
import org.apache.activemq.artemis.tests.util.Wait;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;

public abstract class ManagementTestBase
extends ActiveMQTestBase {
    protected MBeanServer mbeanServer = this.createMBeanServer();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static void consumeMessages(int expected, ClientSession session, SimpleString queue) throws Exception {
        try (ClientConsumer consumer = null;){
            consumer = session.createConsumer(queue);
            ClientMessage m = null;
            for (int i = 0; i < expected; ++i) {
                m = consumer.receive(500L);
                Assertions.assertNotNull((Object)m, (String)("expected to received " + expected + " messages, got only " + i));
                m.acknowledge();
            }
            session.commit();
            m = consumer.receiveImmediate();
            Assertions.assertNull((Object)m, (String)("received one more message than expected (" + expected + ")"));
        }
    }

    @Override
    @BeforeEach
    public void setUp() throws Exception {
        super.setUp();
        this.createMBeanServer();
    }

    @Override
    @AfterEach
    public void tearDown() throws Exception {
        super.tearDown();
    }

    protected void checkNoResource(ObjectName on) {
        Wait.assertFalse((String)("unexpected resource for " + on), () -> this.mbeanServer.isRegistered(on));
    }

    protected void checkResource(ObjectName on) {
        Wait.assertTrue((String)("no resource for " + on), () -> this.mbeanServer.isRegistered(on));
    }

    protected QueueControl createManagementControl(String address, String queue) throws Exception {
        return this.createManagementControl(SimpleString.of((String)address), SimpleString.of((String)queue));
    }

    protected QueueControl createManagementControl(SimpleString address, SimpleString queue) throws Exception {
        QueueControl queueControl = ManagementControlHelper.createQueueControl(address, queue, this.mbeanServer);
        return queueControl;
    }

    protected QueueControl createManagementControl(SimpleString address, SimpleString queue, RoutingType routingType) throws Exception {
        QueueControl queueControl = ManagementControlHelper.createQueueControl(address, queue, routingType, this.mbeanServer);
        return queueControl;
    }

    protected long getMessageCount(QueueControl control) throws Exception {
        control.flushExecutor();
        return control.getMessageCount();
    }

    protected int getGroupCount(QueueControl control) throws Exception {
        control.flushExecutor();
        return control.getGroupCount();
    }

    protected long getDurableMessageCount(QueueControl control) throws Exception {
        control.flushExecutor();
        return control.getDurableMessageCount();
    }

    protected long getMessageSize(QueueControl control) throws Exception {
        control.flushExecutor();
        return control.getPersistentSize();
    }

    protected long getDurableMessageSize(QueueControl control) throws Exception {
        control.flushExecutor();
        return control.getDurablePersistentSize();
    }

    protected long getMessagesAdded(QueueControl control) throws Exception {
        control.flushExecutor();
        return control.getMessagesAdded();
    }
}

