/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.tests.integration.mqtt5.spec;

import io.netty.handler.codec.mqtt.MqttMessageIdAndPropertiesVariableHeader;
import io.netty.handler.codec.mqtt.MqttMessageType;
import io.netty.handler.codec.mqtt.MqttPubAckMessage;
import io.netty.handler.codec.mqtt.MqttPubReplyMessageVariableHeader;
import io.netty.handler.codec.mqtt.MqttPublishMessage;
import io.netty.handler.codec.mqtt.MqttSubscribeMessage;
import io.netty.handler.codec.mqtt.MqttUnsubscribeMessage;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.activemq.artemis.api.core.BaseInterceptor;
import org.apache.activemq.artemis.core.protocol.mqtt.MQTTInterceptor;
import org.apache.activemq.artemis.tests.integration.mqtt5.MQTT5TestSupport;
import org.apache.activemq.artemis.tests.util.RandomUtil;
import org.apache.activemq.artemis.tests.util.Wait;
import org.eclipse.paho.mqttv5.client.MqttCallback;
import org.eclipse.paho.mqttv5.client.MqttClient;
import org.eclipse.paho.mqttv5.common.MqttMessage;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.Timeout;

public class ControlPacketFormatTests
extends MQTT5TestSupport {
    @Test
    @Timeout(value=60L)
    public void testPacketIdQoSZero() throws Exception {
        String TOPIC = this.getTopicName();
        String CONSUMER_CLIENT_ID = "consumer";
        int MESSAGE_COUNT = 100;
        final CountDownLatch latch = new CountDownLatch(100);
        MqttClient consumer = this.createPahoClient("consumer");
        consumer.setCallback((MqttCallback)new MQTT5TestSupport.DefaultMqttCallback(){

            @Override
            public void messageArrived(String topic, MqttMessage message) throws Exception {
                Assertions.assertEquals((int)0, (int)message.getId());
                Assertions.assertEquals((int)0, (int)message.getQos());
                latch.countDown();
            }
        });
        consumer.connect();
        consumer.subscribe(TOPIC, 0);
        MqttClient producer = this.createPahoClient("producer");
        producer.connect();
        for (int i = 0; i < 100; ++i) {
            producer.publish(TOPIC, ("foo" + i).getBytes(), 0, false);
        }
        Wait.assertEquals((long)100L, () -> this.getSubscriptionQueue(TOPIC, "consumer").getMessagesAdded());
        producer.disconnect();
        producer.close();
        Assertions.assertTrue((boolean)latch.await(3L, TimeUnit.SECONDS));
        consumer.disconnect();
        consumer.close();
    }

    @Test
    @Timeout(value=60L)
    public void testPacketIdQoSGreaterThanZero() throws Exception {
        String CONSUMER_ID = RandomUtil.randomString();
        String TOPIC = this.getTopicName();
        int MESSAGE_COUNT = 10;
        final ArrayList IDS = new ArrayList();
        final Object lock = new Object();
        final CountDownLatch latch = new CountDownLatch(10);
        MqttClient consumer = this.createPahoClient(CONSUMER_ID);
        consumer.setCallback((MqttCallback)new MQTT5TestSupport.DefaultMqttCallback(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void messageArrived(String topic, MqttMessage message) throws Exception {
                Object object = lock;
                synchronized (object) {
                    System.out.println(message.getId());
                    Assertions.assertFalse((boolean)IDS.contains(message.getId()));
                    IDS.add(message.getId());
                    latch.countDown();
                }
            }
        });
        consumer.connect();
        consumer.subscribe(TOPIC, 2);
        Wait.assertTrue(() -> this.getSubscriptionQueue(TOPIC, CONSUMER_ID) != null);
        Wait.assertEquals((int)1, () -> this.getSubscriptionQueue(TOPIC, CONSUMER_ID).getConsumerCount());
        MqttClient producer = this.createPahoClient("producer");
        producer.connect();
        for (int i = 0; i < 10; ++i) {
            producer.publish(TOPIC, ("foo" + i).getBytes(), RandomUtil.randomPositiveInt() % 2 + 1, false);
        }
        Wait.assertEquals((long)10L, () -> this.getSubscriptionQueue(TOPIC, CONSUMER_ID).getMessagesAdded());
        producer.disconnect();
        producer.close();
        Assertions.assertTrue((boolean)latch.await(3L, TimeUnit.SECONDS));
        consumer.disconnect();
        consumer.close();
    }

    @Test
    @Timeout(value=60L)
    public void testPacketIdPubAckQoS2() throws Exception {
        AtomicInteger id = new AtomicInteger(0);
        AtomicBoolean failed = new AtomicBoolean(false);
        AtomicInteger packetCount = new AtomicInteger(0);
        MQTTInterceptor incomingInterceptor = (packet, connection) -> {
            if (packet.fixedHeader().messageType() == MqttMessageType.PUBLISH) {
                id.set(((MqttPublishMessage)packet).variableHeader().packetId());
                packetCount.incrementAndGet();
            }
            if (packet.fixedHeader().messageType() == MqttMessageType.PUBREL || packet.fixedHeader().messageType() == MqttMessageType.PUBREC || packet.fixedHeader().messageType() == MqttMessageType.PUBCOMP) {
                if (((MqttPubReplyMessageVariableHeader)packet.variableHeader()).messageId() != id.get()) {
                    failed.set(true);
                }
                packetCount.incrementAndGet();
            }
            return true;
        };
        MQTTInterceptor outgoingInterceptor = (packet, connection) -> {
            if (packet.fixedHeader().messageType() == MqttMessageType.PUBLISH) {
                if (((MqttPublishMessage)packet).variableHeader().packetId() != id.get()) {
                    failed.set(true);
                }
                packetCount.incrementAndGet();
            }
            if (packet.fixedHeader().messageType() == MqttMessageType.PUBREL || packet.fixedHeader().messageType() == MqttMessageType.PUBREC || packet.fixedHeader().messageType() == MqttMessageType.PUBCOMP) {
                if (((MqttPubAckMessage)packet).variableHeader().messageId() != id.get()) {
                    failed.set(true);
                }
                packetCount.incrementAndGet();
            }
            return true;
        };
        this.server.getRemotingService().addIncomingInterceptor((BaseInterceptor)incomingInterceptor);
        this.server.getRemotingService().addOutgoingInterceptor((BaseInterceptor)outgoingInterceptor);
        String TOPIC = this.getTopicName();
        final CountDownLatch latch = new CountDownLatch(1);
        String CONSUMER_ID = "consumer";
        MqttClient consumer = this.createPahoClient("consumer");
        consumer.setCallback((MqttCallback)new MQTT5TestSupport.DefaultMqttCallback(){

            @Override
            public void messageArrived(String topic, MqttMessage message) throws Exception {
                latch.countDown();
            }
        });
        consumer.connect();
        consumer.subscribe(TOPIC, 2);
        MqttClient producer = this.createPahoClient("producer");
        producer.connect();
        producer.publish(TOPIC, "foo".getBytes(StandardCharsets.UTF_8), 2, false);
        Wait.assertEquals((Long)1L, () -> this.getSubscriptionQueue(TOPIC, "consumer").getMessagesAdded(), (long)2000L, (long)100L);
        producer.disconnect();
        producer.close();
        Wait.assertEquals((Long)1L, () -> this.getSubscriptionQueue(TOPIC, "consumer").getMessagesAcknowledged(), (long)15000L, (long)100L);
        Assertions.assertTrue((boolean)latch.await(15L, TimeUnit.SECONDS));
        Wait.assertFalse(() -> failed.get(), (long)2000L, (long)100L);
        Wait.assertEquals((int)8, () -> packetCount.get());
        consumer.disconnect();
        consumer.close();
    }

    @Test
    @Timeout(value=60L)
    public void testPacketIdPubAckQoS1() throws Exception {
        AtomicInteger id = new AtomicInteger(0);
        AtomicBoolean failed = new AtomicBoolean(false);
        AtomicInteger packetCount = new AtomicInteger(0);
        MQTTInterceptor incomingInterceptor = (packet, connection) -> {
            if (packet.fixedHeader().messageType() == MqttMessageType.PUBLISH) {
                id.set(((MqttPublishMessage)packet).variableHeader().packetId());
                packetCount.incrementAndGet();
            }
            if (packet.fixedHeader().messageType() == MqttMessageType.PUBACK) {
                if (((MqttPubReplyMessageVariableHeader)packet.variableHeader()).messageId() != id.get()) {
                    failed.set(true);
                }
                packetCount.incrementAndGet();
            }
            return true;
        };
        MQTTInterceptor outgoingInterceptor = (packet, connection) -> {
            if (packet.fixedHeader().messageType() == MqttMessageType.PUBLISH) {
                if (((MqttPublishMessage)packet).variableHeader().packetId() != id.get()) {
                    failed.set(true);
                }
                packetCount.incrementAndGet();
            }
            if (packet.fixedHeader().messageType() == MqttMessageType.PUBACK) {
                if (((MqttPubAckMessage)packet).variableHeader().messageId() != id.get()) {
                    failed.set(true);
                }
                packetCount.incrementAndGet();
            }
            return true;
        };
        this.server.getRemotingService().addIncomingInterceptor((BaseInterceptor)incomingInterceptor);
        this.server.getRemotingService().addOutgoingInterceptor((BaseInterceptor)outgoingInterceptor);
        String TOPIC = this.getTopicName();
        final CountDownLatch latch = new CountDownLatch(1);
        String CONSUMER_ID = "consumer";
        MqttClient consumer = this.createPahoClient("consumer");
        consumer.setCallback((MqttCallback)new MQTT5TestSupport.DefaultMqttCallback(){

            @Override
            public void messageArrived(String topic, MqttMessage message) throws Exception {
                latch.countDown();
            }
        });
        consumer.connect();
        consumer.subscribe(TOPIC, 1);
        MqttClient producer = this.createPahoClient("producer");
        producer.connect();
        producer.publish(TOPIC, "foo".getBytes(StandardCharsets.UTF_8), 1, false);
        Wait.assertEquals((Long)1L, () -> this.getSubscriptionQueue(TOPIC, "consumer").getMessagesAdded(), (long)2000L, (long)100L);
        producer.disconnect();
        producer.close();
        Wait.assertEquals((Long)1L, () -> this.getSubscriptionQueue(TOPIC, "consumer").getMessagesAcknowledged(), (long)15000L, (long)100L);
        Assertions.assertTrue((boolean)latch.await(15L, TimeUnit.SECONDS));
        Wait.assertFalse(() -> failed.get(), (long)2000L, (long)100L);
        Wait.assertEquals((int)4, () -> packetCount.get());
        consumer.disconnect();
        consumer.close();
    }

    @Test
    @Timeout(value=60L)
    public void testPacketIdSubAckAndUnsubAck() throws Exception {
        AtomicInteger subId = new AtomicInteger(0);
        AtomicInteger unsubId = new AtomicInteger(0);
        AtomicInteger packetCount = new AtomicInteger(0);
        AtomicBoolean failed = new AtomicBoolean(false);
        MQTTInterceptor incomingInterceptor = (packet, connection) -> {
            if (packet.fixedHeader().messageType() == MqttMessageType.SUBSCRIBE) {
                subId.set(((MqttSubscribeMessage)packet).variableHeader().messageId());
                packetCount.incrementAndGet();
            }
            if (packet.fixedHeader().messageType() == MqttMessageType.UNSUBSCRIBE) {
                unsubId.set(((MqttUnsubscribeMessage)packet).variableHeader().messageId());
                packetCount.incrementAndGet();
            }
            return true;
        };
        MQTTInterceptor outgoingInterceptor = (packet, connection) -> {
            if (packet.fixedHeader().messageType() == MqttMessageType.SUBACK) {
                if (((MqttMessageIdAndPropertiesVariableHeader)packet.variableHeader()).messageId() != subId.get()) {
                    failed.set(true);
                }
                packetCount.incrementAndGet();
            } else if (packet.fixedHeader().messageType() == MqttMessageType.UNSUBACK) {
                if (((MqttMessageIdAndPropertiesVariableHeader)packet.variableHeader()).messageId() != unsubId.get()) {
                    failed.set(true);
                }
                packetCount.incrementAndGet();
            }
            return true;
        };
        this.server.getRemotingService().addIncomingInterceptor((BaseInterceptor)incomingInterceptor);
        this.server.getRemotingService().addOutgoingInterceptor((BaseInterceptor)outgoingInterceptor);
        String TOPIC = this.getTopicName();
        MqttClient consumer = this.createPahoClient("consumer");
        consumer.connect();
        consumer.subscribe(TOPIC, 1);
        consumer.unsubscribe(TOPIC);
        Wait.assertFalse(() -> failed.get(), (long)2000L, (long)100L);
        Wait.assertEquals((int)4, () -> packetCount.get());
        consumer.disconnect();
        consumer.close();
    }
}

