/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.tests.integration.mqtt5.spec.controlpackets;

import io.netty.handler.codec.mqtt.MqttMessageType;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import org.apache.activemq.artemis.api.core.BaseInterceptor;
import org.apache.activemq.artemis.core.protocol.mqtt.MQTTInterceptor;
import org.apache.activemq.artemis.tests.integration.mqtt5.MQTT5TestSupport;
import org.apache.activemq.artemis.tests.util.RandomUtil;
import org.eclipse.paho.mqttv5.client.MqttClient;
import org.eclipse.paho.mqttv5.client.MqttConnectionOptions;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.Timeout;

public class PingReqTests
extends MQTT5TestSupport {
    @Test
    @Timeout(value=60L)
    public void testPingResp() throws Exception {
        CountDownLatch latch = new CountDownLatch(4);
        MQTTInterceptor outgoingInterceptor = (packet, connection) -> {
            if (packet.fixedHeader().messageType() == MqttMessageType.PINGRESP) {
                latch.countDown();
            }
            return true;
        };
        this.server.getRemotingService().addOutgoingInterceptor((BaseInterceptor)outgoingInterceptor);
        MqttClient client = this.createPahoClient(RandomUtil.randomString());
        MqttConnectionOptions options = new MqttConnectionOptions();
        options.setKeepAliveInterval(1);
        client.connect(options);
        Assertions.assertTrue((boolean)latch.await(5L, TimeUnit.SECONDS));
        client.disconnect();
    }
}

