/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.tests.integration.mqtt5.spec.controlpackets;

import java.nio.charset.StandardCharsets;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import org.apache.activemq.artemis.api.core.SimpleString;
import org.apache.activemq.artemis.api.core.management.CoreNotificationType;
import org.apache.activemq.artemis.api.core.management.ManagementHelper;
import org.apache.activemq.artemis.core.config.WildcardConfiguration;
import org.apache.activemq.artemis.core.protocol.mqtt.MQTTUtil;
import org.apache.activemq.artemis.core.security.CheckType;
import org.apache.activemq.artemis.tests.integration.mqtt5.MQTT5TestSupport;
import org.apache.activemq.artemis.tests.util.RandomUtil;
import org.apache.activemq.artemis.utils.Wait;
import org.eclipse.paho.mqttv5.client.MqttCallback;
import org.eclipse.paho.mqttv5.client.MqttClient;
import org.eclipse.paho.mqttv5.client.MqttConnectionOptions;
import org.eclipse.paho.mqttv5.client.MqttConnectionOptionsBuilder;
import org.eclipse.paho.mqttv5.common.MqttException;
import org.eclipse.paho.mqttv5.common.MqttMessage;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.Timeout;

public class PublishTestsWithSecurity
extends MQTT5TestSupport {
    @Override
    public boolean isSecurityEnabled() {
        return true;
    }

    @Test
    @Timeout(value=60L)
    public void testCreateAddressAuthorizationFailure() throws Exception {
        String CLIENT_ID = "publisher";
        CountDownLatch latch = new CountDownLatch(1);
        MqttConnectionOptions options = new MqttConnectionOptionsBuilder().username(this.noprivUser).password(this.noprivPass.getBytes(StandardCharsets.UTF_8)).build();
        MqttClient client = this.createPahoClient("publisher");
        client.connect(options);
        this.server.getManagementService().addNotificationListener(notification -> {
            if (notification.getType() == CoreNotificationType.SECURITY_PERMISSION_VIOLATION && CheckType.valueOf((String)notification.getProperties().getSimpleStringProperty(ManagementHelper.HDR_CHECK_TYPE).toString()) == CheckType.CREATE_ADDRESS) {
                latch.countDown();
            }
        });
        try {
            client.publish("/foo", new byte[0], 2, false);
            Assertions.fail((String)"Publishing should have failed with a security problem");
        }
        catch (MqttException e) {
            Assertions.assertEquals((byte)-121, (byte)((byte)e.getReasonCode()));
        }
        catch (Exception e) {
            Assertions.fail((String)"Should have thrown an MqttException");
        }
        Assertions.assertTrue((boolean)latch.await(2L, TimeUnit.SECONDS));
        Assertions.assertFalse((boolean)client.isConnected());
    }

    @Test
    @Timeout(value=60L)
    public void testSendAuthorizationFailure() throws Exception {
        String CLIENT_ID = "publisher";
        String TOPIC = "/foo";
        CountDownLatch latch = new CountDownLatch(1);
        MqttConnectionOptions options = new MqttConnectionOptionsBuilder().username(this.createAddressUser).password(this.createAddressPass.getBytes(StandardCharsets.UTF_8)).build();
        MqttClient client = this.createPahoClient("publisher");
        client.connect(options);
        this.server.getManagementService().addNotificationListener(notification -> {
            if (notification.getType() == CoreNotificationType.SECURITY_PERMISSION_VIOLATION && CheckType.valueOf((String)notification.getProperties().getSimpleStringProperty(ManagementHelper.HDR_CHECK_TYPE).toString()) == CheckType.SEND) {
                latch.countDown();
            }
        });
        try {
            client.publish("/foo", new byte[0], 2, false);
            Assertions.fail((String)"Publishing should have failed with a security problem");
        }
        catch (MqttException e) {
            Assertions.assertEquals((byte)-121, (byte)((byte)e.getReasonCode()));
        }
        catch (Exception e) {
            Assertions.fail((String)"Should have thrown an MqttException");
        }
        Assertions.assertTrue((boolean)latch.await(2L, TimeUnit.SECONDS));
        Assertions.assertFalse((boolean)client.isConnected());
        Wait.assertTrue(() -> this.server.getAddressInfo(SimpleString.of((String)MQTTUtil.getCoreAddressFromMqttTopic((String)"/foo", (WildcardConfiguration)this.server.getConfiguration().getWildcardConfiguration()))) != null, (long)2000L, (long)100L);
    }

    @Test
    @Timeout(value=60L)
    public void testAuthorizationSuccess() throws Exception {
        String CLIENT_ID = "publisher";
        MqttConnectionOptions options = new MqttConnectionOptionsBuilder().username(this.fullUser).password(this.fullPass.getBytes(StandardCharsets.UTF_8)).build();
        MqttClient client = this.createPahoClient("publisher");
        client.connect(options);
        try {
            client.publish("/foo", new byte[0], 2, false);
        }
        catch (MqttException e) {
            Assertions.fail((String)"Publishing should not have failed with a security problem");
        }
        catch (Exception e) {
            Assertions.fail((String)"Should have thrown an MqttException");
        }
        client.isConnected();
    }

    @Test
    @Timeout(value=60L)
    public void testWillAuthorizationSuccess() throws Exception {
        this.internalTestWillAuthorization(this.fullUser, this.fullPass, true);
    }

    @Test
    @Timeout(value=60L)
    public void testWillAuthorizationFailure() throws Exception {
        this.internalTestWillAuthorization(this.noprivUser, this.noprivPass, false);
    }

    private void internalTestWillAuthorization(String username, String password, boolean succeed) throws Exception {
        byte[] WILL = RandomUtil.randomBytes();
        String TOPIC = RandomUtil.randomString();
        MqttClient client1 = this.createPahoClient("willConsumer");
        final CountDownLatch latch = new CountDownLatch(1);
        client1.setCallback((MqttCallback)new MQTT5TestSupport.DefaultMqttCallback(){

            @Override
            public void messageArrived(String topic, MqttMessage message) {
                latch.countDown();
            }
        });
        MqttConnectionOptions options = new MqttConnectionOptionsBuilder().username(this.fullUser).password(this.fullPass.getBytes(StandardCharsets.UTF_8)).build();
        client1.connect(options);
        client1.subscribe(TOPIC, 1);
        MqttClient client2 = this.createPahoClient("willGenerator");
        options = new MqttConnectionOptionsBuilder().username(username).password(password.getBytes(StandardCharsets.UTF_8)).will(TOPIC, new MqttMessage(WILL)).build();
        client2.connect(options);
        client2.disconnectForcibly(0L, 0L, false);
        Assertions.assertEquals((Object)succeed, (Object)latch.await(2L, TimeUnit.SECONDS));
    }
}

