/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.tests.integration.openwire;

import jakarta.jms.Connection;
import jakarta.jms.ConnectionFactory;
import jakarta.jms.Destination;
import jakarta.jms.Message;
import jakarta.jms.MessageConsumer;
import jakarta.jms.MessageProducer;
import jakarta.jms.Queue;
import jakarta.jms.Session;
import jakarta.jms.TextMessage;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import org.apache.activemq.artemis.api.core.SimpleString;
import org.apache.activemq.artemis.jms.client.ActiveMQMessage;
import org.apache.activemq.artemis.tests.extensions.parameterized.ParameterizedTestExtension;
import org.apache.activemq.artemis.tests.extensions.parameterized.Parameters;
import org.apache.activemq.artemis.tests.integration.openwire.BasicOpenWireTest;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.TestTemplate;
import org.junit.jupiter.api.extension.ExtendWith;

@ExtendWith(value={ParameterizedTestExtension.class})
public class OpenWireGroupingTest
extends BasicOpenWireTest {
    private boolean coreSend;
    private boolean coreReceive;

    @Parameters(name="core-send={0} core-receive={1}")
    public static Collection<Object[]> params() {
        return Arrays.asList({true, true}, {true, false}, {false, true}, {false, false});
    }

    public OpenWireGroupingTest(boolean coreSend, boolean coreReceive) {
        this.coreSend = coreSend;
        this.coreReceive = coreReceive;
    }

    @TestTemplate
    public void testGrouping() throws Exception {
        Queue queue;
        Session session;
        String jmsxgroupID = null;
        ConnectionFactory sendFact = this.coreSend ? this.coreCf : this.factory;
        ConnectionFactory receiveFact = this.coreReceive ? this.coreCf : this.factory;
        int num = 10;
        try (Connection coreConn = sendFact.createConnection();){
            session = coreConn.createSession(false, 2);
            queue = session.createQueue(this.queueName);
            MessageProducer producer = session.createProducer((Destination)queue);
            for (int j = 0; j < 10; ++j) {
                TextMessage message = session.createTextMessage();
                message.setText("Message" + j);
                this.setProperty((Message)message);
                producer.send((Message)message);
                String prop = message.getStringProperty("JMSXGroupID");
                Assertions.assertNotNull((Object)prop);
                if (jmsxgroupID != null) {
                    Assertions.assertEquals((Object)jmsxgroupID, (Object)prop);
                    continue;
                }
                jmsxgroupID = prop;
            }
        }
        try (Connection connection = receiveFact.createConnection();){
            session = connection.createSession(false, 2);
            queue = session.createQueue(this.queueName);
            MessageConsumer consumer1 = session.createConsumer((Destination)queue);
            MessageConsumer consumer2 = session.createConsumer((Destination)queue);
            MessageConsumer consumer3 = session.createConsumer((Destination)queue);
            connection.start();
            ArrayList<MessageConsumer> otherConsumers = new ArrayList<MessageConsumer>();
            otherConsumers.add(consumer1);
            otherConsumers.add(consumer2);
            otherConsumers.add(consumer3);
            MessageConsumer groupConsumer = null;
            for (MessageConsumer consumer : otherConsumers) {
                TextMessage tm = (TextMessage)consumer.receive(2000L);
                if (tm == null) continue;
                Assertions.assertEquals((Object)"Message0", (Object)tm.getText());
                otherConsumers.remove(consumer);
                groupConsumer = consumer;
                break;
            }
            Assertions.assertNotNull(groupConsumer);
            for (int j = 1; j < 10; ++j) {
                TextMessage tm = (TextMessage)groupConsumer.receive(2000L);
                Assertions.assertNotNull((Object)tm);
                Assertions.assertEquals((Object)("Message" + j), (Object)tm.getText());
                Assertions.assertEquals((Object)tm.getStringProperty("JMSXGroupID"), (Object)jmsxgroupID);
            }
            for (MessageConsumer consumer : otherConsumers) {
                Assertions.assertNull((Object)consumer.receive(100L));
            }
        }
    }

    protected void setProperty(Message message) {
        if (this.coreSend) {
            ((ActiveMQMessage)message).getCoreMessage().putStringProperty(org.apache.activemq.artemis.api.core.Message.HDR_GROUP_ID, SimpleString.of((String)"foo"));
        } else {
            org.apache.activemq.command.ActiveMQMessage m = (org.apache.activemq.command.ActiveMQMessage)message;
            m.setGroupID("foo");
        }
    }
}

