/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.tests.integration.openwire.amq;

import jakarta.jms.Destination;
import jakarta.jms.Message;
import jakarta.jms.MessageProducer;
import jakarta.jms.Session;
import jakarta.jms.TextMessage;
import jakarta.jms.Topic;
import jakarta.jms.TopicSubscriber;
import java.util.Arrays;
import java.util.Collection;
import org.apache.activemq.artemis.tests.extensions.parameterized.ParameterizedTestExtension;
import org.apache.activemq.artemis.tests.extensions.parameterized.Parameters;
import org.apache.activemq.artemis.tests.integration.openwire.BasicOpenWireTest;
import org.apache.activemq.command.ActiveMQDestination;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.TestTemplate;
import org.junit.jupiter.api.extension.ExtendWith;

@ExtendWith(value={ParameterizedTestExtension.class})
public class JMSConsumer4Test
extends BasicOpenWireTest {
    public int deliveryMode;
    public byte destinationType;

    @Parameters(name="deliveryMode={0} destinationType={1}")
    public static Collection<Object[]> getParams() {
        return Arrays.asList({1, (byte)2}, {2, (byte)2});
    }

    public JMSConsumer4Test(int deliveryMode, byte destinationType) {
        this.deliveryMode = deliveryMode;
        this.destinationType = destinationType;
    }

    @TestTemplate
    public void testDurableConsumerSelectorChange() throws Exception {
        this.connection.setClientID("test");
        this.connection.start();
        Session session = this.connection.createSession(false, 1);
        ActiveMQDestination destination = this.createDestination(session, this.destinationType);
        MessageProducer producer = session.createProducer((Destination)destination);
        producer.setDeliveryMode(this.deliveryMode);
        TopicSubscriber consumer = session.createDurableSubscriber((Topic)destination, "test", "color='red'", false);
        TextMessage message = session.createTextMessage("1st");
        message.setStringProperty("color", "red");
        producer.send((Message)message);
        Message m = consumer.receive(1000L);
        Assertions.assertNotNull((Object)m);
        Assertions.assertEquals((Object)"1st", (Object)((TextMessage)m).getText());
        consumer.close();
        consumer = session.createDurableSubscriber((Topic)destination, "test", "color='blue'", false);
        message = session.createTextMessage("2nd");
        message.setStringProperty("color", "red");
        producer.send((Message)message);
        message = session.createTextMessage("3rd");
        message.setStringProperty("color", "blue");
        producer.send((Message)message);
        m = consumer.receive(1000L);
        Assertions.assertNotNull((Object)m);
        Assertions.assertEquals((Object)"3rd", (Object)((TextMessage)m).getText());
        Assertions.assertNull((Object)consumer.receiveNoWait());
    }
}

