/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.tests.integration.openwire.amq;

import jakarta.jms.Destination;
import jakarta.jms.Message;
import jakarta.jms.MessageConsumer;
import jakarta.jms.MessageProducer;
import jakarta.jms.Queue;
import jakarta.jms.QueueBrowser;
import jakarta.jms.Session;
import jakarta.jms.TextMessage;
import java.util.Enumeration;
import org.apache.activemq.artemis.tests.integration.openwire.BasicOpenWireTest;
import org.apache.activemq.command.ActiveMQQueue;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class JmsQueueBrowserTest
extends BasicOpenWireTest {
    @Test
    public void testReceiveBrowseReceive() throws Exception {
        Session session = this.connection.createSession(false, 1);
        ActiveMQQueue destination = (ActiveMQQueue)this.createDestination(session, (byte)1);
        MessageProducer producer = session.createProducer((Destination)destination);
        MessageConsumer consumer = session.createConsumer((Destination)destination);
        this.connection.start();
        Message[] outbound = new Message[]{session.createTextMessage("First Message"), session.createTextMessage("Second Message"), session.createTextMessage("Third Message")};
        while (consumer.receive(1000L) != null) {
        }
        producer.send(outbound[0]);
        producer.send(outbound[1]);
        producer.send(outbound[2]);
        Assertions.assertEquals((Object)outbound[0], (Object)consumer.receive(1000L));
        consumer.close();
        QueueBrowser browser = session.createBrowser((Queue)destination);
        Enumeration enumeration = browser.getEnumeration();
        Assertions.assertTrue((boolean)enumeration.hasMoreElements(), (String)"should have received the second message");
        Assertions.assertEquals((Object)outbound[1], enumeration.nextElement());
        Assertions.assertTrue((boolean)enumeration.hasMoreElements(), (String)"Should have received the third message");
        Assertions.assertEquals((Object)outbound[2], enumeration.nextElement());
        boolean tooMany = false;
        while (enumeration.hasMoreElements()) {
            tooMany = true;
        }
        Assertions.assertFalse((boolean)tooMany);
        browser.close();
        consumer = session.createConsumer((Destination)destination);
        Assertions.assertEquals((Object)outbound[1], (Object)consumer.receive(1000L));
        Assertions.assertEquals((Object)outbound[2], (Object)consumer.receive(1000L));
        consumer.close();
    }

    @Test
    public void testBatchSendBrowseReceive() throws Exception {
        int i;
        int i2;
        Session session = this.connection.createSession(false, 1);
        ActiveMQQueue destination = (ActiveMQQueue)this.createDestination(session, (byte)1);
        MessageProducer producer = session.createProducer((Destination)destination);
        MessageConsumer consumer = session.createConsumer((Destination)destination);
        this.connection.start();
        TextMessage[] outbound = new TextMessage[10];
        for (i2 = 0; i2 < 10; ++i2) {
            outbound[i2] = session.createTextMessage(i2 + " Message");
        }
        while (consumer.receive(1000L) != null) {
        }
        consumer.close();
        for (i2 = 0; i2 < outbound.length; ++i2) {
            producer.send((Message)outbound[i2]);
        }
        QueueBrowser browser = session.createBrowser((Queue)destination);
        Enumeration enumeration = browser.getEnumeration();
        for (i = 0; i < outbound.length; ++i) {
            Assertions.assertTrue((boolean)enumeration.hasMoreElements(), (String)"should have a");
            Assertions.assertEquals((Object)outbound[i], enumeration.nextElement());
        }
        browser.close();
        for (i = 0; i < outbound.length; ++i) {
            producer.send((Message)outbound[i]);
        }
        browser = session.createBrowser((Queue)destination);
        enumeration = browser.getEnumeration();
        for (int j = 0; j < 2; ++j) {
            for (int i3 = 0; i3 < outbound.length; ++i3) {
                Assertions.assertTrue((boolean)enumeration.hasMoreElements(), (String)"should have a");
                Assertions.assertEquals((Object)outbound[i3].getText(), (Object)((TextMessage)enumeration.nextElement()).getText(), (String)("j=" + j + ", i=" + i3));
            }
        }
        browser.close();
        consumer = session.createConsumer((Destination)destination);
        for (i = 0; i < outbound.length * 2; ++i) {
            Assertions.assertNotNull((Object)consumer.receive(2000L), (String)("Got message: " + i));
        }
        consumer.close();
    }

    @Test
    public void testBrowseReceive() throws Exception {
        Session session = this.connection.createSession(false, 1);
        ActiveMQQueue destination = (ActiveMQQueue)this.createDestination(session, (byte)1);
        this.connection.start();
        MessageConsumer consumer = session.createConsumer((Destination)destination);
        while (consumer.receive(1000L) != null) {
        }
        consumer.close();
        Message[] outbound = new Message[]{session.createTextMessage("First Message"), session.createTextMessage("Second Message"), session.createTextMessage("Third Message")};
        MessageProducer producer = session.createProducer((Destination)destination);
        producer.send(outbound[0]);
        QueueBrowser browser = session.createBrowser((Queue)destination);
        Enumeration enumeration = browser.getEnumeration();
        Assertions.assertTrue((boolean)enumeration.hasMoreElements(), (String)"should have received the first message");
        Assertions.assertEquals((Object)outbound[0], enumeration.nextElement());
        consumer = session.createConsumer((Destination)destination);
        Assertions.assertEquals((Object)outbound[0], (Object)consumer.receive(1000L));
        consumer.close();
        browser.close();
        producer.close();
    }

    @Test
    public void testLargeNumberOfMessages() throws Exception {
        Session session = this.connection.createSession(false, 1);
        ActiveMQQueue destination = (ActiveMQQueue)this.createDestination(session, (byte)1);
        this.connection.start();
        MessageProducer producer = session.createProducer((Destination)destination);
        int numberOfMessages = 4096;
        for (int i = 0; i < numberOfMessages; ++i) {
            producer.send((Message)session.createTextMessage("Message: " + i));
        }
        QueueBrowser browser = session.createBrowser((Queue)destination);
        Enumeration enumeration = browser.getEnumeration();
        Assertions.assertTrue((boolean)enumeration.hasMoreElements());
        int numberBrowsed = 0;
        while (enumeration.hasMoreElements()) {
            Message browsed = (Message)enumeration.nextElement();
            ++numberBrowsed;
        }
        Assertions.assertEquals((int)numberOfMessages, (int)numberBrowsed);
        browser.close();
        producer.close();
    }

    @Test
    public void testBrowseClose() throws Exception {
        Session session = this.connection.createSession(false, 1);
        ActiveMQQueue destination = (ActiveMQQueue)this.createDestination(session, (byte)1);
        this.connection.start();
        TextMessage[] outbound = new TextMessage[]{session.createTextMessage("First Message"), session.createTextMessage("Second Message"), session.createTextMessage("Third Message")};
        MessageConsumer consumer = session.createConsumer((Destination)destination);
        while (consumer.receive(1000L) != null) {
        }
        consumer.close();
        MessageProducer producer = session.createProducer((Destination)destination);
        producer.send((Message)outbound[0]);
        producer.send((Message)outbound[1]);
        producer.send((Message)outbound[2]);
        QueueBrowser browser = session.createBrowser((Queue)destination);
        Enumeration enumeration = browser.getEnumeration();
        Assertions.assertEquals((Object)outbound[0], enumeration.nextElement());
        Assertions.assertEquals((Object)outbound[1], enumeration.nextElement());
        browser.close();
        consumer = session.createConsumer((Destination)destination);
        TextMessage msg = (TextMessage)consumer.receive(1000L);
        Assertions.assertEquals((Object)outbound[0], (Object)msg, (String)("Expected " + outbound[0].getText() + " but received " + msg.getText()));
        msg = (TextMessage)consumer.receive(1000L);
        Assertions.assertEquals((Object)outbound[1], (Object)msg, (String)("Expected " + outbound[1].getText() + " but received " + msg.getText()));
        msg = (TextMessage)consumer.receive(1000L);
        Assertions.assertEquals((Object)outbound[2], (Object)msg, (String)("Expected " + outbound[2].getText() + " but received " + msg.getText()));
        consumer.close();
        producer.close();
    }
}

