/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.tests.integration.openwire.amq;

import jakarta.jms.Destination;
import jakarta.jms.Message;
import jakarta.jms.MessageConsumer;
import jakarta.jms.MessageProducer;
import jakarta.jms.Queue;
import jakarta.jms.Session;
import jakarta.jms.TextMessage;
import jakarta.jms.Topic;
import jakarta.jms.TopicSubscriber;
import java.util.concurrent.TimeUnit;
import org.apache.activemq.ActiveMQConnection;
import org.apache.activemq.RedeliveryPolicy;
import org.apache.activemq.artemis.api.core.management.QueueControl;
import org.apache.activemq.artemis.core.protocol.openwire.amq.AMQConsumer;
import org.apache.activemq.artemis.core.protocol.openwire.amq.AMQConsumerAccessor;
import org.apache.activemq.artemis.core.server.ServerConsumer;
import org.apache.activemq.artemis.core.server.ServerSession;
import org.apache.activemq.artemis.tests.integration.openwire.BasicOpenWireTest;
import org.apache.activemq.artemis.tests.util.Wait;
import org.apache.activemq.broker.region.policy.RedeliveryPolicyMap;
import org.apache.activemq.command.ActiveMQDestination;
import org.apache.activemq.command.ActiveMQQueue;
import org.apache.activemq.command.ActiveMQTopic;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

public class RedeliveryPolicyTest
extends BasicOpenWireTest {
    @Override
    @BeforeEach
    public void setUp() throws Exception {
        this.realStore = true;
        super.setUp();
    }

    @Test
    public void testGetNext() throws Exception {
        RedeliveryPolicy policy = new RedeliveryPolicy();
        policy.setInitialRedeliveryDelay(0L);
        policy.setRedeliveryDelay(500L);
        policy.setBackOffMultiplier(2.0);
        policy.setUseExponentialBackOff(true);
        long delay = policy.getNextRedeliveryDelay(0L);
        Assertions.assertEquals((long)500L, (long)delay);
        delay = policy.getNextRedeliveryDelay(delay);
        Assertions.assertEquals((long)1000L, (long)delay);
        delay = policy.getNextRedeliveryDelay(delay);
        Assertions.assertEquals((long)2000L, (long)delay);
        policy.setUseExponentialBackOff(false);
        delay = policy.getNextRedeliveryDelay(delay);
        Assertions.assertEquals((long)500L, (long)delay);
    }

    @Test
    public void testExponentialRedeliveryPolicyDelaysDeliveryOnRollback() throws Exception {
        RedeliveryPolicy policy = this.connection.getRedeliveryPolicy();
        policy.setInitialRedeliveryDelay(0L);
        policy.setRedeliveryDelay(500L);
        policy.setBackOffMultiplier(2.0);
        policy.setUseExponentialBackOff(true);
        this.connection.start();
        Session session = this.connection.createSession(true, 1);
        ActiveMQQueue destination = new ActiveMQQueue("testExponentialRedeliveryPolicyDelaysDeliveryOnRollback");
        this.makeSureCoreQueueExist("testExponentialRedeliveryPolicyDelaysDeliveryOnRollback");
        MessageProducer producer = session.createProducer((Destination)destination);
        MessageConsumer consumer = session.createConsumer((Destination)destination);
        producer.send((Message)session.createTextMessage("1st"));
        producer.send((Message)session.createTextMessage("2nd"));
        session.commit();
        TextMessage m = (TextMessage)consumer.receive(1000L);
        Assertions.assertNotNull((Object)m);
        Assertions.assertEquals((Object)"1st", (Object)m.getText());
        session.rollback();
        m = (TextMessage)consumer.receive(100L);
        Assertions.assertNotNull((Object)m);
        session.rollback();
        m = (TextMessage)consumer.receive(100L);
        Assertions.assertNull((Object)m);
        m = (TextMessage)consumer.receive(700L);
        Assertions.assertNotNull((Object)m);
        Assertions.assertEquals((Object)"1st", (Object)m.getText());
        session.rollback();
        m = (TextMessage)consumer.receive(100L);
        Assertions.assertNull((Object)m);
        m = (TextMessage)consumer.receive(500L);
        Assertions.assertNull((Object)m);
        m = (TextMessage)consumer.receive(700L);
        Assertions.assertNotNull((Object)m);
        Assertions.assertEquals((Object)"1st", (Object)m.getText());
    }

    @Test
    public void testNornalRedeliveryPolicyDelaysDeliveryOnRollback() throws Exception {
        RedeliveryPolicy policy = this.connection.getRedeliveryPolicy();
        policy.setInitialRedeliveryDelay(0L);
        policy.setRedeliveryDelay(500L);
        this.connection.start();
        Session session = this.connection.createSession(true, 1);
        ActiveMQQueue destination = new ActiveMQQueue("testNornalRedeliveryPolicyDelaysDeliveryOnRollback");
        this.makeSureCoreQueueExist("testNornalRedeliveryPolicyDelaysDeliveryOnRollback");
        MessageProducer producer = session.createProducer((Destination)destination);
        MessageConsumer consumer = session.createConsumer((Destination)destination);
        producer.send((Message)session.createTextMessage("1st"));
        producer.send((Message)session.createTextMessage("2nd"));
        session.commit();
        TextMessage m = (TextMessage)consumer.receive(1000L);
        Assertions.assertNotNull((Object)m);
        Assertions.assertEquals((Object)"1st", (Object)m.getText());
        session.rollback();
        m = (TextMessage)consumer.receive(100L);
        Assertions.assertNotNull((Object)m);
        session.rollback();
        m = (TextMessage)consumer.receive(100L);
        Assertions.assertNull((Object)m);
        m = (TextMessage)consumer.receive(700L);
        Assertions.assertNotNull((Object)m);
        Assertions.assertEquals((Object)"1st", (Object)m.getText());
        session.rollback();
        m = (TextMessage)consumer.receive(100L);
        Assertions.assertNull((Object)m);
        m = (TextMessage)consumer.receive(700L);
        Assertions.assertNotNull((Object)m);
        Assertions.assertEquals((Object)"1st", (Object)m.getText());
    }

    @Test
    public void testDLQHandling() throws Exception {
        this.makeSureCoreQueueExist("ActiveMQ.DLQ");
        RedeliveryPolicy policy = this.connection.getRedeliveryPolicy();
        policy.setInitialRedeliveryDelay(100L);
        policy.setUseExponentialBackOff(false);
        policy.setMaximumRedeliveries(2);
        this.connection.start();
        Session session = this.connection.createSession(true, 2);
        ActiveMQQueue destination = new ActiveMQQueue("TEST");
        this.makeSureCoreQueueExist("TEST");
        MessageProducer producer = session.createProducer((Destination)destination);
        MessageConsumer consumer = session.createConsumer((Destination)destination);
        MessageConsumer dlqConsumer = session.createConsumer((Destination)new ActiveMQQueue("ActiveMQ.DLQ"));
        producer.send((Message)session.createTextMessage("1st"));
        producer.send((Message)session.createTextMessage("2nd"));
        session.commit();
        TextMessage m = (TextMessage)consumer.receive(1000L);
        Assertions.assertNotNull((Object)m);
        Assertions.assertEquals((Object)"1st", (Object)m.getText());
        session.rollback();
        m = (TextMessage)consumer.receive(1000L);
        Assertions.assertNotNull((Object)m);
        Assertions.assertEquals((Object)"1st", (Object)m.getText());
        session.rollback();
        m = (TextMessage)consumer.receive(2000L);
        Assertions.assertNotNull((Object)m);
        Assertions.assertEquals((Object)"1st", (Object)m.getText());
        session.rollback();
        m = (TextMessage)consumer.receive(1000L);
        Assertions.assertNotNull((Object)m);
        Assertions.assertEquals((Object)"2nd", (Object)m.getText());
        session.commit();
        m = (TextMessage)dlqConsumer.receive(1000L);
        Assertions.assertNotNull((Object)m);
        Assertions.assertEquals((Object)"1st", (Object)m.getText());
        String cause = m.getStringProperty("dlqDeliveryFailureCause");
        Assertions.assertTrue((boolean)cause.contains("RedeliveryPolicy"), (String)"cause exception has policy ref");
        session.commit();
    }

    @Test
    public void testInfiniteMaximumNumberOfRedeliveries() throws Exception {
        RedeliveryPolicy policy = this.connection.getRedeliveryPolicy();
        policy.setInitialRedeliveryDelay(100L);
        policy.setUseExponentialBackOff(false);
        policy.setMaximumRedeliveries(-1);
        this.connection.start();
        Session session = this.connection.createSession(true, 1);
        ActiveMQQueue destination = new ActiveMQQueue("TEST");
        this.makeSureCoreQueueExist("TEST");
        MessageProducer producer = session.createProducer((Destination)destination);
        MessageConsumer consumer = session.createConsumer((Destination)destination);
        producer.send((Message)session.createTextMessage("1st"));
        producer.send((Message)session.createTextMessage("2nd"));
        session.commit();
        TextMessage m = (TextMessage)consumer.receive(1000L);
        Assertions.assertNotNull((Object)m);
        Assertions.assertEquals((Object)"1st", (Object)m.getText());
        session.rollback();
        m = (TextMessage)consumer.receive(1000L);
        Assertions.assertNotNull((Object)m);
        Assertions.assertEquals((Object)"1st", (Object)m.getText());
        session.rollback();
        m = (TextMessage)consumer.receive(2000L);
        Assertions.assertNotNull((Object)m);
        Assertions.assertEquals((Object)"1st", (Object)m.getText());
        session.rollback();
        m = (TextMessage)consumer.receive(2000L);
        Assertions.assertNotNull((Object)m);
        Assertions.assertEquals((Object)"1st", (Object)m.getText());
        session.rollback();
        m = (TextMessage)consumer.receive(2000L);
        Assertions.assertNotNull((Object)m);
        Assertions.assertEquals((Object)"1st", (Object)m.getText());
        session.rollback();
        m = (TextMessage)consumer.receive(2000L);
        Assertions.assertNotNull((Object)m);
        Assertions.assertEquals((Object)"1st", (Object)m.getText());
        session.commit();
        m = (TextMessage)consumer.receive(2000L);
        Assertions.assertNotNull((Object)m);
        Assertions.assertEquals((Object)"2nd", (Object)m.getText());
        session.commit();
    }

    @Test
    public void testMaximumRedeliveryDelay() throws Exception {
        TextMessage m;
        RedeliveryPolicy policy = this.connection.getRedeliveryPolicy();
        policy.setInitialRedeliveryDelay(10L);
        policy.setUseExponentialBackOff(true);
        policy.setMaximumRedeliveries(-1);
        policy.setRedeliveryDelay(50L);
        policy.setMaximumRedeliveryDelay(1000L);
        policy.setBackOffMultiplier(2.0);
        policy.setUseExponentialBackOff(true);
        this.connection.start();
        Session session = this.connection.createSession(true, 1);
        ActiveMQQueue destination = new ActiveMQQueue("TEST");
        this.makeSureCoreQueueExist("TEST");
        MessageProducer producer = session.createProducer((Destination)destination);
        MessageConsumer consumer = session.createConsumer((Destination)destination);
        producer.send((Message)session.createTextMessage("1st"));
        producer.send((Message)session.createTextMessage("2nd"));
        session.commit();
        for (int i = 0; i < 10; ++i) {
            m = (TextMessage)consumer.receive(2000L);
            Assertions.assertNotNull((Object)m);
            Assertions.assertEquals((Object)"1st", (Object)m.getText());
            session.rollback();
        }
        m = (TextMessage)consumer.receive(2000L);
        Assertions.assertNotNull((Object)m);
        Assertions.assertEquals((Object)"1st", (Object)m.getText());
        session.commit();
        m = (TextMessage)consumer.receive(2000L);
        Assertions.assertNotNull((Object)m);
        Assertions.assertEquals((Object)"2nd", (Object)m.getText());
        session.commit();
        Assertions.assertTrue((policy.getNextRedeliveryDelay(Long.MAX_VALUE) == 1000L ? (byte)1 : 0) != 0);
    }

    @Test
    public void testZeroMaximumNumberOfRedeliveries() throws Exception {
        RedeliveryPolicy policy = this.connection.getRedeliveryPolicy();
        policy.setInitialRedeliveryDelay(100L);
        policy.setUseExponentialBackOff(false);
        policy.setMaximumRedeliveries(0);
        this.connection.start();
        Session session = this.connection.createSession(true, 1);
        ActiveMQQueue destination = new ActiveMQQueue("TEST");
        this.makeSureCoreQueueExist("TEST");
        MessageProducer producer = session.createProducer((Destination)destination);
        MessageConsumer consumer = session.createConsumer((Destination)destination);
        producer.send((Message)session.createTextMessage("1st"));
        producer.send((Message)session.createTextMessage("2nd"));
        session.commit();
        TextMessage m = (TextMessage)consumer.receive(1000L);
        Assertions.assertNotNull((Object)m);
        Assertions.assertEquals((Object)"1st", (Object)m.getText());
        session.rollback();
        m = (TextMessage)consumer.receive(1000L);
        Assertions.assertNotNull((Object)m);
        Assertions.assertEquals((Object)"2nd", (Object)m.getText());
        session.commit();
    }

    @Test
    public void testRedeliveredMessageNotOverflowingPrefetch() throws Exception {
        int prefetchSize = 10;
        int messageCount = 20;
        this.connection.getPrefetchPolicy().setAll(10);
        this.connection.start();
        Session session = this.connection.createSession(true, 0);
        ActiveMQQueue destination = new ActiveMQQueue("TEST");
        this.makeSureCoreQueueExist("TEST");
        QueueControl queueControl = (QueueControl)this.server.getManagementService().getResource("queue.TEST");
        MessageProducer producer = session.createProducer((Destination)destination);
        for (int i = 0; i < 20; ++i) {
            producer.send((Message)session.createTextMessage("MSG" + i));
            session.commit();
        }
        MessageConsumer consumer = session.createConsumer((Destination)destination);
        Wait.assertEquals((int)10, () -> queueControl.getDeliveringCount(), (long)3000L, (long)100L);
        for (int i = 0; i < 20; ++i) {
            Message m = consumer.receive(2000L);
            Assertions.assertNotNull((Object)m, (String)("null@:" + i));
            if (i == 3) {
                session.rollback();
                continue;
            }
            session.commit();
            Assertions.assertTrue((queueControl.getDeliveringCount() <= 11 ? (byte)1 : 0) != 0);
        }
        Message m = consumer.receive(2000L);
        Assertions.assertNotNull((Object)m);
        session.commit();
    }

    @Test
    public void testCanRollbackPastPrefetch() throws Exception {
        int i;
        int prefetchSize = 10;
        int messageCount = 20;
        this.connection.getPrefetchPolicy().setAll(10);
        this.connection.getRedeliveryPolicy().setMaximumRedeliveries(11);
        this.connection.start();
        Session session = this.connection.createSession(true, 0);
        ActiveMQQueue destination = new ActiveMQQueue("TEST");
        this.makeSureCoreQueueExist("TEST");
        QueueControl queueControl = (QueueControl)this.server.getManagementService().getResource("queue.TEST");
        MessageProducer producer = session.createProducer((Destination)destination);
        for (int i2 = 0; i2 < 20; ++i2) {
            producer.send((Message)session.createTextMessage("MSG" + i2));
            session.commit();
        }
        MessageConsumer consumer = session.createConsumer((Destination)destination);
        Wait.assertEquals((int)10, () -> queueControl.getDeliveringCount(), (long)3000L, (long)100L);
        for (i = 0; i < 10; ++i) {
            Message m = consumer.receive(2000L);
            Assertions.assertNotNull((Object)m, (String)("null@:" + i));
            session.rollback();
        }
        for (i = 0; i < 20; ++i) {
            Message m = consumer.receive(2000L);
            Assertions.assertNotNull((Object)m, (String)("null@:" + i));
            session.commit();
            Assertions.assertTrue((queueControl.getDeliveringCount() <= 11 ? (byte)1 : 0) != 0, (String)("deliveryCount: " + queueControl.getDeliveringCount() + " @:" + i));
        }
    }

    @Test
    public void testCountersAreCorrectAfterSendToDLQ() throws Exception {
        RedeliveryPolicy policy = this.connection.getRedeliveryPolicy();
        policy.setMaximumRedeliveries(0);
        policy.setInitialRedeliveryDelay(0L);
        this.connection.start();
        Session session = this.connection.createSession(true, 1);
        ActiveMQQueue destination = new ActiveMQQueue("TEST");
        this.makeSureCoreQueueExist("TEST");
        QueueControl queueControl = (QueueControl)this.server.getManagementService().getResource("queue.TEST");
        MessageProducer producer = session.createProducer((Destination)destination);
        producer.send((Message)session.createTextMessage("The Message"));
        session.commit();
        MessageConsumer consumer = session.createConsumer((Destination)destination);
        Message m = consumer.receive(2000L);
        Assertions.assertNotNull((Object)m);
        session.rollback();
        Wait.assertEquals((long)0L, () -> queueControl.getMessageCount());
        session.close();
        Assertions.assertEquals((long)0L, (long)queueControl.getPersistentSize());
    }

    @Test
    public void testRedeliveryRefCleanup() throws Exception {
        RedeliveryPolicy policy = this.connection.getRedeliveryPolicy();
        policy.setUseExponentialBackOff(false);
        policy.setMaximumRedeliveries(-1);
        policy.setRedeliveryDelay(50L);
        this.connection.start();
        Session pSession = this.connection.createSession(true, 1);
        Session cSession = this.connection.createSession(true, 1);
        ActiveMQQueue destination = new ActiveMQQueue("TEST");
        this.makeSureCoreQueueExist("TEST");
        MessageProducer producer = pSession.createProducer((Destination)destination);
        MessageConsumer consumer = cSession.createConsumer((Destination)destination);
        for (int i = 0; i < 5; ++i) {
            producer.send((Message)pSession.createTextMessage("MessageText"));
            pSession.commit();
            TextMessage m = (TextMessage)consumer.receive(2000L);
            Assertions.assertNotNull((Object)m);
            cSession.rollback();
            m = (TextMessage)consumer.receive(2000L);
            Assertions.assertNotNull((Object)m);
            cSession.commit();
        }
        ServerConsumer serverConsumer = null;
        for (ServerSession session : this.server.getSessions()) {
            for (ServerConsumer sessionConsumer : session.getServerConsumers()) {
                if (sessionConsumer.getQueue().getName().toString() != "TEST") continue;
                serverConsumer = sessionConsumer;
            }
        }
        AMQConsumer amqConsumer = (AMQConsumer)serverConsumer.getProtocolData();
        Assertions.assertTrue((boolean)AMQConsumerAccessor.getRolledbackMessageRefs(amqConsumer).isEmpty());
    }

    @Test
    public void testInitialRedeliveryDelayZero() throws Exception {
        RedeliveryPolicy policy = this.connection.getRedeliveryPolicy();
        policy.setInitialRedeliveryDelay(0L);
        policy.setUseExponentialBackOff(false);
        policy.setMaximumRedeliveries(1);
        this.connection.start();
        Session session = this.connection.createSession(true, 1);
        ActiveMQQueue destination = new ActiveMQQueue("TEST");
        this.makeSureCoreQueueExist("TEST");
        MessageProducer producer = session.createProducer((Destination)destination);
        MessageConsumer consumer = session.createConsumer((Destination)destination);
        producer.send((Message)session.createTextMessage("1st"));
        producer.send((Message)session.createTextMessage("2nd"));
        session.commit();
        TextMessage m = (TextMessage)consumer.receive(100L);
        Assertions.assertNotNull((Object)m);
        Assertions.assertEquals((Object)"1st", (Object)m.getText());
        session.rollback();
        m = (TextMessage)consumer.receive(100L);
        Assertions.assertNotNull((Object)m);
        Assertions.assertEquals((Object)"1st", (Object)m.getText());
        m = (TextMessage)consumer.receive(100L);
        Assertions.assertNotNull((Object)m);
        Assertions.assertEquals((Object)"2nd", (Object)m.getText());
        session.commit();
        session.commit();
    }

    @Test
    public void testInitialRedeliveryDelayOne() throws Exception {
        RedeliveryPolicy policy = this.connection.getRedeliveryPolicy();
        policy.setInitialRedeliveryDelay(1000L);
        policy.setUseExponentialBackOff(false);
        policy.setMaximumRedeliveries(1);
        this.connection.start();
        Session session = this.connection.createSession(true, 1);
        ActiveMQQueue destination = new ActiveMQQueue("TEST");
        this.makeSureCoreQueueExist("TEST");
        MessageProducer producer = session.createProducer((Destination)destination);
        MessageConsumer consumer = session.createConsumer((Destination)destination);
        producer.send((Message)session.createTextMessage("1st"));
        producer.send((Message)session.createTextMessage("2nd"));
        session.commit();
        TextMessage m = (TextMessage)consumer.receive(100L);
        Assertions.assertNotNull((Object)m);
        Assertions.assertEquals((Object)"1st", (Object)m.getText());
        session.rollback();
        m = (TextMessage)consumer.receive(100L);
        Assertions.assertNull((Object)m);
        m = (TextMessage)consumer.receive(2000L);
        Assertions.assertNotNull((Object)m);
        Assertions.assertEquals((Object)"1st", (Object)m.getText());
        m = (TextMessage)consumer.receive(100L);
        Assertions.assertNotNull((Object)m);
        Assertions.assertEquals((Object)"2nd", (Object)m.getText());
        session.commit();
    }

    @Test
    public void testRedeliveryDelayOne() throws Exception {
        RedeliveryPolicy policy = this.connection.getRedeliveryPolicy();
        policy.setInitialRedeliveryDelay(0L);
        policy.setRedeliveryDelay(1000L);
        policy.setUseExponentialBackOff(false);
        policy.setMaximumRedeliveries(2);
        this.connection.start();
        Session session = this.connection.createSession(true, 1);
        ActiveMQQueue destination = new ActiveMQQueue("TEST");
        this.makeSureCoreQueueExist("TEST");
        MessageProducer producer = session.createProducer((Destination)destination);
        MessageConsumer consumer = session.createConsumer((Destination)destination);
        producer.send((Message)session.createTextMessage("1st"));
        producer.send((Message)session.createTextMessage("2nd"));
        session.commit();
        TextMessage m = (TextMessage)consumer.receive(100L);
        Assertions.assertNotNull((Object)m);
        Assertions.assertEquals((Object)"1st", (Object)m.getText());
        session.rollback();
        m = (TextMessage)consumer.receive(100L);
        Assertions.assertNotNull((Object)m, (String)"first immediate redelivery");
        session.rollback();
        m = (TextMessage)consumer.receive(100L);
        Assertions.assertNull((Object)m, (String)("second delivery delayed: " + m));
        m = (TextMessage)consumer.receive(2000L);
        Assertions.assertNotNull((Object)m);
        Assertions.assertEquals((Object)"1st", (Object)m.getText());
        m = (TextMessage)consumer.receive(100L);
        Assertions.assertNotNull((Object)m);
        Assertions.assertEquals((Object)"2nd", (Object)m.getText());
        session.commit();
    }

    private void send(Session session, MessageProducer producer, Destination destination, String text) throws Exception {
        TextMessage message = session.createTextMessage(text);
        message.setStringProperty("texto", text);
        producer.send(destination, (Message)message);
    }

    @Test
    public void testRedeliveryPolicyPerDestination() throws Exception {
        RedeliveryPolicy queuePolicy = new RedeliveryPolicy();
        queuePolicy.setInitialRedeliveryDelay(0L);
        queuePolicy.setRedeliveryDelay(1000L);
        queuePolicy.setUseExponentialBackOff(false);
        queuePolicy.setMaximumRedeliveries(2);
        RedeliveryPolicy topicPolicy = new RedeliveryPolicy();
        topicPolicy.setInitialRedeliveryDelay(0L);
        topicPolicy.setRedeliveryDelay(1000L);
        topicPolicy.setUseExponentialBackOff(false);
        topicPolicy.setMaximumRedeliveries(3);
        RedeliveryPolicyMap map = this.connection.getRedeliveryPolicyMap();
        map.put((ActiveMQDestination)new ActiveMQTopic(">"), (Object)topicPolicy);
        map.put((ActiveMQDestination)new ActiveMQQueue(">"), (Object)queuePolicy);
        this.connection.setClientID("id1");
        this.connection.start();
        Session session = this.connection.createSession(true, 1);
        ActiveMQQueue queue = new ActiveMQQueue("TEST");
        ActiveMQTopic topic = new ActiveMQTopic("TESTTOPIC");
        this.makeSureCoreQueueExist("TEST");
        MessageProducer producer = session.createProducer(null);
        producer.setDeliveryMode(2);
        MessageConsumer queueConsumer = session.createConsumer((Destination)queue);
        TopicSubscriber topicConsumer = session.createDurableSubscriber((Topic)topic, "tp1");
        this.send(session, producer, (Destination)queue, "1st");
        this.send(session, producer, (Destination)queue, "2nd");
        this.send(session, producer, (Destination)topic, "1st");
        this.send(session, producer, (Destination)topic, "2nd");
        session.commit();
        TextMessage m = (TextMessage)queueConsumer.receive(100L);
        Assertions.assertNotNull((Object)m);
        Assertions.assertEquals((Object)"1st", (Object)m.getText());
        m = (TextMessage)topicConsumer.receive(100L);
        Assertions.assertNotNull((Object)m);
        Assertions.assertEquals((Object)"1st", (Object)m.getText());
        m = (TextMessage)queueConsumer.receive(100L);
        Assertions.assertNotNull((Object)m);
        Assertions.assertEquals((Object)"2nd", (Object)m.getText());
        m = (TextMessage)topicConsumer.receive(100L);
        Assertions.assertNotNull((Object)m);
        Assertions.assertEquals((Object)"2nd", (Object)m.getText());
        session.rollback();
        m = (TextMessage)queueConsumer.receive(100L);
        Assertions.assertNotNull((Object)m, (String)"first immediate redelivery");
        m = (TextMessage)topicConsumer.receive(100L);
        Assertions.assertNotNull((Object)m, (String)"first immediate redelivery");
        session.rollback();
        m = (TextMessage)queueConsumer.receive(100L);
        Assertions.assertNull((Object)m, (String)("second delivery delayed: " + m));
        m = (TextMessage)topicConsumer.receive(100L);
        Assertions.assertNull((Object)m, (String)("second delivery delayed: " + m));
        m = (TextMessage)queueConsumer.receive(2000L);
        Assertions.assertNotNull((Object)m);
        Assertions.assertEquals((Object)"1st", (Object)m.getText());
        m = (TextMessage)topicConsumer.receive(2000L);
        Assertions.assertNotNull((Object)m);
        Assertions.assertEquals((Object)"1st", (Object)m.getText());
        m = (TextMessage)queueConsumer.receive(100L);
        Assertions.assertNotNull((Object)m);
        Assertions.assertEquals((Object)"2nd", (Object)m.getText());
        m = (TextMessage)topicConsumer.receive(100L);
        Assertions.assertNotNull((Object)m);
        Assertions.assertEquals((Object)"2nd", (Object)m.getText());
        session.rollback();
        m = (TextMessage)queueConsumer.receive(2000L);
        Assertions.assertNotNull((Object)m);
        Assertions.assertEquals((Object)"1st", (Object)m.getText());
        m = (TextMessage)topicConsumer.receive(2000L);
        Assertions.assertNotNull((Object)m);
        Assertions.assertEquals((Object)"1st", (Object)m.getText());
        m = (TextMessage)queueConsumer.receive(100L);
        Assertions.assertNotNull((Object)m);
        Assertions.assertEquals((Object)"2nd", (Object)m.getText());
        m = (TextMessage)topicConsumer.receive(100L);
        Assertions.assertNotNull((Object)m);
        Assertions.assertEquals((Object)"2nd", (Object)m.getText());
        session.rollback();
        m = (TextMessage)queueConsumer.receive(2000L);
        Assertions.assertNull((Object)m);
        m = (TextMessage)topicConsumer.receive(2000L);
        Assertions.assertNotNull((Object)m);
        Assertions.assertEquals((Object)"1st", (Object)m.getText());
        m = (TextMessage)queueConsumer.receive(100L);
        Assertions.assertNull((Object)m);
        m = (TextMessage)topicConsumer.receive(100L);
        Assertions.assertNotNull((Object)m);
        Assertions.assertEquals((Object)"2nd", (Object)m.getText());
        session.commit();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testClientRedlivery() throws Exception {
        try {
            Session session = this.connection.createSession(false, 2);
            this.makeSureCoreQueueExist("TEST");
            Queue queue = session.createQueue("TEST");
            MessageProducer producer = session.createProducer((Destination)queue);
            producer.send((Message)session.createTextMessage("test"));
        }
        finally {
            this.connection.close();
        }
        for (int i = 0; i < 10; ++i) {
            this.connection = (ActiveMQConnection)this.factory.createConnection();
            this.connection.start();
            try {
                Session session = this.connection.createSession(false, 2);
                Queue queue = session.createQueue("TEST");
                MessageConsumer consumer = session.createConsumer((Destination)queue);
                Message message = consumer.receive(1000L);
                Assertions.assertNotNull((Object)message, (String)("Message null on iteration " + i));
                if (i <= 0) continue;
                Assertions.assertTrue((boolean)message.getJMSRedelivered());
                continue;
            }
            finally {
                this.connection.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void verifyNoRedeliveryFlagAfterCloseNoReceive() throws Exception {
        Queue queue;
        Session session;
        try {
            session = this.connection.createSession(false, 2);
            this.makeSureCoreQueueExist("TEST");
            queue = session.createQueue("TEST");
            MessageProducer producer = session.createProducer((Destination)queue);
            producer.send((Message)session.createTextMessage("test"));
        }
        finally {
            this.connection.close();
        }
        this.connection = (ActiveMQConnection)this.factory.createConnection();
        this.connection.start();
        try {
            session = this.connection.createSession(false, 2);
            queue = session.createQueue("TEST");
            MessageConsumer consumer = session.createConsumer((Destination)queue);
            TimeUnit.MILLISECONDS.sleep(500L);
            consumer.close();
            consumer = session.createConsumer((Destination)queue);
            Message message = consumer.receive(1000L);
            Assertions.assertNotNull((Object)message, (String)"Message null");
            Assertions.assertFalse((boolean)message.getJMSRedelivered());
        }
        finally {
            this.connection.close();
        }
    }
}

