/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.tests.integration.paging;

import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.apache.activemq.artemis.api.core.Message;
import org.apache.activemq.artemis.api.core.QueueConfiguration;
import org.apache.activemq.artemis.api.core.client.ClientConsumer;
import org.apache.activemq.artemis.api.core.client.ClientMessage;
import org.apache.activemq.artemis.api.core.client.ClientProducer;
import org.apache.activemq.artemis.api.core.client.ClientSession;
import org.apache.activemq.artemis.api.core.client.ClientSessionFactory;
import org.apache.activemq.artemis.api.core.client.ServerLocator;
import org.apache.activemq.artemis.core.server.ActiveMQServer;
import org.apache.activemq.artemis.core.server.ActiveMQServerLogger;
import org.apache.activemq.artemis.core.settings.impl.AddressFullMessagePolicy;
import org.apache.activemq.artemis.core.settings.impl.AddressSettings;
import org.apache.activemq.artemis.logs.AssertionLoggerHandler;
import org.apache.activemq.artemis.tests.util.ActiveMQTestBase;
import org.apache.activemq.artemis.utils.ActiveMQThreadFactory;
import org.junit.jupiter.api.AfterAll;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeAll;
import org.junit.jupiter.api.Test;

public class AddressFullLoggingTest
extends ActiveMQTestBase {
    private static final String SERVER_LOGGER_NAME = ActiveMQServerLogger.class.getPackage().getName();
    private static AssertionLoggerHandler.LogLevel previousLevel;

    @BeforeAll
    public static void prepareLogger() {
        previousLevel = AssertionLoggerHandler.setLevel((String)SERVER_LOGGER_NAME, (AssertionLoggerHandler.LogLevel)AssertionLoggerHandler.LogLevel.INFO);
    }

    @AfterAll
    public static void clearLogger() throws Exception {
        AssertionLoggerHandler.setLevel((String)SERVER_LOGGER_NAME, (AssertionLoggerHandler.LogLevel)previousLevel);
    }

    @Test
    public void testBlockLogging() throws Exception {
        int MAX_MESSAGES = 200;
        String MY_ADDRESS = "myAddress";
        String MY_QUEUE = "myQueue";
        ActiveMQServer server = this.createServer(false);
        AddressSettings defaultSetting = new AddressSettings().setPageSizeBytes(10240).setMaxSizeBytes(20480L).setAddressFullMessagePolicy(AddressFullMessagePolicy.BLOCK);
        server.getAddressSettingsRepository().addMatch("#", (Object)defaultSetting);
        server.getConfiguration().setDiskScanPeriod(100);
        server.start();
        this.internalTest(200, "myAddress", "myQueue", server);
    }

    @Test
    public void testGlobalBlockLogging() throws Exception {
        int MAX_MESSAGES = 200;
        String MY_ADDRESS = "myAddress";
        String MY_QUEUE = "myQueue";
        ActiveMQServer server = this.createServer(false);
        AddressSettings defaultSetting = new AddressSettings().setAddressFullMessagePolicy(AddressFullMessagePolicy.BLOCK);
        server.getAddressSettingsRepository().addMatch("#", (Object)defaultSetting);
        server.getConfiguration().setGlobalMaxSize(20480L).setDiskScanPeriod(100);
        server.start();
        this.internalTest(200, "myAddress", "myQueue", server);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void internalTest(int MAX_MESSAGES, String MY_ADDRESS, String MY_QUEUE, ActiveMQServer server) throws Exception {
        ServerLocator locator = this.createInVMNonHALocator().setBlockOnNonDurableSend(true).setBlockOnDurableSend(true).setBlockOnAcknowledge(true);
        ClientSessionFactory factory = this.createSessionFactory(locator);
        ClientSession session = factory.createSession(false, true, true);
        session.createQueue(QueueConfiguration.of((String)MY_QUEUE).setAddress(MY_ADDRESS));
        ClientProducer producer = session.createProducer(MY_ADDRESS);
        ClientMessage message = session.createMessage(false);
        message.getBodyBuffer().writeBytes(new byte[1024]);
        ExecutorService executor = Executors.newFixedThreadPool(1, (ThreadFactory)ActiveMQThreadFactory.defaultThreadFactory((String)((Object)((Object)this)).getClass().getName()));
        Callable<Object> sendMessageTask = () -> {
            producer.send((Message)message);
            return null;
        };
        try (AssertionLoggerHandler loggerHandler = new AssertionLoggerHandler();){
            ClientMessage msg;
            int sendCount = 0;
            for (int i = 0; i < MAX_MESSAGES; ++i) {
                Future<Object> future = executor.submit(sendMessageTask);
                try {
                    future.get(3L, TimeUnit.SECONDS);
                    ++sendCount;
                    continue;
                }
                catch (TimeoutException ex) {
                    break;
                }
                finally {
                    future.cancel(true);
                }
            }
            executor.shutdown();
            session.close();
            session = factory.createSession(false, true, true);
            session.start();
            ClientConsumer consumer = session.createConsumer(MY_QUEUE);
            for (int i = 0; i < sendCount && (msg = consumer.receive(250L)) != null; ++i) {
                msg.acknowledge();
            }
            TimeUnit.MILLISECONDS.sleep(server.getConfiguration().getDiskScanPeriod() * 2);
            session.close();
            locator.close();
            server.stop();
            Assertions.assertTrue((boolean)loggerHandler.findText(new String[]{"AMQ222183", MY_ADDRESS}), (String)"Expected to find AMQ222183");
            Assertions.assertTrue((boolean)loggerHandler.findText(new String[]{"AMQ221046", MY_ADDRESS}), (String)"Expected to find AMQ221046");
            Assertions.assertFalse((boolean)loggerHandler.findText(new String[]{"AMQ222211"}), (String)"Expected to not find AMQ222211");
        }
    }
}

