/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.tests.integration.scheduling;

import org.apache.activemq.artemis.api.core.Message;
import org.apache.activemq.artemis.api.core.QueueConfiguration;
import org.apache.activemq.artemis.api.core.client.ClientConsumer;
import org.apache.activemq.artemis.api.core.client.ClientMessage;
import org.apache.activemq.artemis.api.core.client.ClientProducer;
import org.apache.activemq.artemis.api.core.client.ClientSession;
import org.apache.activemq.artemis.api.core.client.ClientSessionFactory;
import org.apache.activemq.artemis.api.core.client.ServerLocator;
import org.apache.activemq.artemis.core.server.ActiveMQServer;
import org.apache.activemq.artemis.core.settings.impl.AddressSettings;
import org.apache.activemq.artemis.tests.util.ActiveMQTestBase;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

public class DelayedMessageTest
extends ActiveMQTestBase {
    private ActiveMQServer server;
    private static final long DELAY = 3000L;
    private final String qName = "DelayedMessageTestQueue";
    private ServerLocator locator;

    @Override
    @BeforeEach
    public void setUp() throws Exception {
        super.setUp();
        this.initServer();
    }

    protected void initServer() throws Exception {
        this.server = this.createServer(true, this.createDefaultInVMConfig());
        this.server.start();
        AddressSettings qs = (AddressSettings)this.server.getAddressSettingsRepository().getMatch("*");
        AddressSettings newSets = new AddressSettings().setRedeliveryDelay(3000L);
        newSets.merge(qs);
        this.server.getAddressSettingsRepository().addMatch("DelayedMessageTestQueue", (Object)newSets);
        this.locator = this.createInVMNonHALocator();
    }

    @Test
    public void testDelayedRedeliveryDefaultOnClose() throws Exception {
        ClientSessionFactory sessionFactory = this.createSessionFactory(this.locator);
        ClientSession session = sessionFactory.createSession(false, false, false);
        session.createQueue(QueueConfiguration.of((String)"DelayedMessageTestQueue"));
        session.close();
        ClientSession session1 = sessionFactory.createSession(false, true, true);
        ClientProducer producer = session1.createProducer("DelayedMessageTestQueue");
        int NUM_MESSAGES = 5;
        ActiveMQTestBase.forceGC();
        for (int i = 0; i < 5; ++i) {
            ClientMessage tm = this.createDurableMessage(session1, "message" + i);
            producer.send((Message)tm);
        }
        session1.close();
        ClientSession session2 = sessionFactory.createSession(false, false, false);
        ClientConsumer consumer2 = session2.createConsumer("DelayedMessageTestQueue");
        session2.start();
        for (int i = 0; i < 5; ++i) {
            ClientMessage tm = consumer2.receive(500L);
            tm.acknowledge();
            Assertions.assertNotNull((Object)tm);
            Assertions.assertEquals((Object)("message" + i), (Object)tm.getBodyBuffer().readString());
        }
        long now = System.currentTimeMillis();
        session2.close();
        ClientSession session3 = sessionFactory.createSession(false, false, false);
        ClientConsumer consumer3 = session3.createConsumer("DelayedMessageTestQueue");
        session3.start();
        for (int i = 0; i < 5; ++i) {
            ClientMessage tm = consumer3.receive(4000L);
            Assertions.assertNotNull((Object)tm);
            long time = System.currentTimeMillis();
            Assertions.assertTrue((time - now >= 3000L ? (byte)1 : 0) != 0);
            Assertions.assertTrue((time - now < 4000L ? (byte)1 : 0) != 0, (String)(time - now + ">4000"));
        }
        session3.commit();
        session3.close();
    }

    @Test
    public void testDelayedRedeliveryDefaultOnRollback() throws Exception {
        ClientSessionFactory sessionFactory = this.createSessionFactory(this.locator);
        ClientSession session = sessionFactory.createSession(false, false, false);
        session.createQueue(QueueConfiguration.of((String)"DelayedMessageTestQueue"));
        session.close();
        ClientSession session1 = sessionFactory.createSession(false, true, true);
        ClientProducer producer = session1.createProducer("DelayedMessageTestQueue");
        int NUM_MESSAGES = 5;
        for (int i = 0; i < 5; ++i) {
            ClientMessage tm = this.createDurableMessage(session1, "message" + i);
            producer.send((Message)tm);
        }
        session1.close();
        ClientSession session2 = sessionFactory.createSession(false, false, false);
        ClientConsumer consumer2 = session2.createConsumer("DelayedMessageTestQueue");
        session2.start();
        for (int i = 0; i < 5; ++i) {
            ClientMessage tm = consumer2.receive(500L);
            Assertions.assertNotNull((Object)tm);
            Assertions.assertEquals((Object)("message" + i), (Object)tm.getBodyBuffer().readString());
        }
        long now = System.currentTimeMillis();
        session2.rollback();
        for (int i = 0; i < 5; ++i) {
            ClientMessage tm = consumer2.receive(4000L);
            Assertions.assertNotNull((Object)tm);
            long time = System.currentTimeMillis();
            Assertions.assertTrue((time - now >= 3000L ? (byte)1 : 0) != 0);
            Assertions.assertTrue((time - now < 4000L ? (byte)1 : 0) != 0, (String)(time - now + ">4000"));
        }
        session2.commit();
        session2.close();
    }

    @Test
    public void testDelayedRedeliveryWithStart() throws Exception {
        ClientSessionFactory sessionFactory = this.createSessionFactory(this.locator);
        ClientSession session = sessionFactory.createSession(false, false, false);
        session.createQueue(QueueConfiguration.of((String)"DelayedMessageTestQueue"));
        session.close();
        ClientSession session1 = sessionFactory.createSession(false, true, true);
        ClientProducer producer = session1.createProducer("DelayedMessageTestQueue");
        boolean NUM_MESSAGES = true;
        for (int i = 0; i < 1; ++i) {
            ClientMessage tm = this.createDurableMessage(session1, "message" + i);
            producer.send((Message)tm);
        }
        session1.close();
        ClientSession session2 = sessionFactory.createSession(false, false, false);
        ClientConsumer consumer2 = session2.createConsumer("DelayedMessageTestQueue");
        session2.start();
        for (int i = 0; i < 1; ++i) {
            ClientMessage tm = consumer2.receive(500L);
            Assertions.assertNotNull((Object)tm);
            Assertions.assertEquals((Object)("message" + i), (Object)tm.getBodyBuffer().readString());
        }
        long now = System.currentTimeMillis();
        session2.rollback();
        session2.close();
        sessionFactory.close();
        this.locator.close();
        this.server.stop();
        this.initServer();
        sessionFactory = this.createSessionFactory(this.locator);
        session2 = sessionFactory.createSession(false, false, false);
        consumer2 = session2.createConsumer("DelayedMessageTestQueue");
        Thread.sleep(3000L);
        session2.start();
        for (int i = 0; i < 1; ++i) {
            ClientMessage tm = consumer2.receive(4000L);
            Assertions.assertNotNull((Object)tm);
            long time = System.currentTimeMillis();
            Assertions.assertTrue((time - now >= 3000L ? (byte)1 : 0) != 0);
        }
        session2.commit();
        session2.close();
    }

    private ClientMessage createDurableMessage(ClientSession session, String body) {
        ClientMessage message = session.createMessage((byte)3, true, 0L, System.currentTimeMillis(), (byte)1);
        message.getBodyBuffer().writeString(body);
        return message;
    }
}

