/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.tests.integration.server;

import jakarta.jms.Connection;
import jakarta.jms.ConnectionFactory;
import jakarta.jms.Destination;
import jakarta.jms.JMSException;
import jakarta.jms.Message;
import jakarta.jms.MessageProducer;
import jakarta.jms.Session;
import jakarta.jms.TextMessage;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import org.apache.activemq.artemis.api.core.QueueConfiguration;
import org.apache.activemq.artemis.api.core.RoutingType;
import org.apache.activemq.artemis.api.core.SimpleString;
import org.apache.activemq.artemis.core.server.ActiveMQServer;
import org.apache.activemq.artemis.jms.client.ActiveMQConnectionFactory;
import org.apache.activemq.artemis.jms.client.ActiveMQTopic;
import org.apache.activemq.artemis.tests.util.ActiveMQTestBase;
import org.apache.activemq.artemis.tests.util.Wait;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

public class ServerFilterTest
extends ActiveMQTestBase {
    private ActiveMQServer server;

    @Override
    @BeforeEach
    public void setUp() throws Exception {
        super.setUp();
        this.server = this.createServer(false);
        this.server.start();
    }

    @Test
    public void concurrentXpathTest() throws Exception {
        long threadCount = 5L;
        long messageCount = 5L;
        String address = "myAddress";
        String xpathFilter = "XPATH '/a/b/c/d[text()=\"foo\"]'";
        String text = "<a><b><c><d>foo</d></c></b></a>";
        this.server.createQueue(QueueConfiguration.of((String)"A").setAddress("myAddress").setFilterString("XPATH '/a/b/c/d[text()=\"foo\"]'").setRoutingType(RoutingType.MULTICAST));
        this.server.createQueue(QueueConfiguration.of((String)"B").setAddress("myAddress").setFilterString("XPATH '/a/b/c/d[text()=\"foo\"]'").setRoutingType(RoutingType.MULTICAST));
        ActiveMQConnectionFactory cf = new ActiveMQConnectionFactory("vm://0");
        ExecutorService executor = Executors.newFixedThreadPool(5);
        int i = 0;
        while ((long)i < 5L) {
            executor.submit(() -> ServerFilterTest.lambda$concurrentXpathTest$0((ConnectionFactory)cf));
            ++i;
        }
        this.runAfter(executor::shutdownNow);
        Wait.assertEquals((Long)25L, () -> this.server.getAddressInfo(SimpleString.of((String)"myAddress")).getRoutedMessageCount(), (long)2000L, (long)100L);
        Wait.assertEquals((Long)25L, () -> this.server.locateQueue("A").getMessageCount(), (long)2000L, (long)100L);
        Wait.assertEquals((Long)25L, () -> this.server.locateQueue("B").getMessageCount(), (long)2000L, (long)100L);
    }

    private static /* synthetic */ void lambda$concurrentXpathTest$0(ConnectionFactory cf) {
        try (Connection conn = cf.createConnection();){
            Session session = conn.createSession();
            MessageProducer producer = session.createProducer((Destination)new ActiveMQTopic("myAddress"));
            TextMessage msg = session.createTextMessage("<a><b><c><d>foo</d></c></b></a>");
            int count = 0;
            while ((long)count++ < 5L) {
                msg.setStringProperty("MessageId", String.valueOf(count));
                producer.send((Message)msg);
            }
            session.close();
        }
        catch (JMSException e) {
            e.printStackTrace();
        }
    }
}

