/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.tests.integration.server;

import java.util.HashMap;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.activemq.artemis.core.server.ActiveMQServer;
import org.apache.activemq.artemis.logs.AssertionLoggerHandler;
import org.apache.activemq.artemis.tests.util.ActiveMQTestBase;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class SimpleStartStopTest
extends ActiveMQTestBase {
    @Test
    public void testStartStopAndCleanupIDs() throws Exception {
        try (AssertionLoggerHandler loggerHandler = new AssertionLoggerHandler();){
            ActiveMQServer server = null;
            for (int i = 0; i < 50; ++i) {
                server = this.createServer(true, false);
                server.start();
                server.fail(false);
            }
            Assertions.assertFalse((boolean)loggerHandler.hasLevel(AssertionLoggerHandler.LogLevel.ERROR), (String)"There shouldn't be any error for just starting / stopping the server");
            Assertions.assertFalse((boolean)loggerHandler.findText(new String[]{"AMQ224008"}));
            HashMap<Integer, AtomicInteger> records = this.internalCountJournalLivingRecords(server.getConfiguration(), false);
            AtomicInteger recordCount = records.get(24);
            Assertions.assertNotNull((Object)recordCount);
            Assertions.assertTrue((recordCount.intValue() < 5 ? (byte)1 : 0) != 0, (String)("The server should cleanup after IDs on the bindings record. It left " + recordCount + " ids on the journal"));
            server.start();
            records = this.internalCountJournalLivingRecords(server.getConfiguration(), false);
            recordCount = records.get(24);
            Assertions.assertNotNull((Object)recordCount);
            Assertions.assertTrue((recordCount.intValue() != 0 ? (byte)1 : 0) != 0, (String)"If this is zero it means we are removing too many records");
            server.stop();
        }
    }
}

