/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.tests.integration.spring;

import java.util.concurrent.TimeUnit;
import org.apache.activemq.artemis.core.server.embedded.EmbeddedActiveMQ;
import org.apache.activemq.artemis.jms.client.ActiveMQConnectionFactory;
import org.apache.activemq.artemis.tests.integration.spring.ExampleListener;
import org.apache.activemq.artemis.tests.integration.spring.MessageSender;
import org.apache.activemq.artemis.tests.util.ActiveMQTestBase;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.springframework.context.support.ClassPathXmlApplicationContext;
import org.springframework.jms.listener.DefaultMessageListenerContainer;

public class SpringIntegrationTest
extends ActiveMQTestBase {
    @Override
    @BeforeEach
    public void setUp() throws Exception {
        super.setUp();
        SpringIntegrationTest.forceGC();
    }

    @Test
    public void testSpring() throws Exception {
        ClassPathXmlApplicationContext context = null;
        try {
            context = new ClassPathXmlApplicationContext(new String[]{"spring-jms-beans.xml"});
            MessageSender sender = (MessageSender)context.getBean("MessageSender");
            ExampleListener.latch.countUp();
            sender.send("Hello world");
            ExampleListener.latch.await(10L, TimeUnit.SECONDS);
            Thread.sleep(500L);
            Assertions.assertEquals((Object)ExampleListener.lastMessage, (Object)"Hello world");
            ((ActiveMQConnectionFactory)sender.getConnectionFactory()).close();
        }
        finally {
            try {
                if (context != null) {
                    DefaultMessageListenerContainer container = (DefaultMessageListenerContainer)context.getBean("listenerContainer");
                    container.stop();
                }
            }
            catch (Throwable ignored) {
                ignored.printStackTrace();
            }
            try {
                if (context != null) {
                    EmbeddedActiveMQ jms = (EmbeddedActiveMQ)context.getBean("EmbeddedActiveMQ");
                    jms.stop();
                }
            }
            catch (Throwable ignored) {
                ignored.printStackTrace();
            }
        }
    }
}

