/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.tests.integration.stomp;

import java.net.URI;
import java.util.Arrays;
import java.util.Collection;
import org.apache.activemq.artemis.tests.extensions.parameterized.ParameterizedTestExtension;
import org.apache.activemq.artemis.tests.extensions.parameterized.Parameters;
import org.apache.activemq.artemis.tests.integration.stomp.StompTestBase;
import org.apache.activemq.artemis.tests.integration.stomp.util.ClientStompFrame;
import org.apache.activemq.artemis.tests.integration.stomp.util.StompClientConnection;
import org.apache.activemq.artemis.tests.integration.stomp.util.StompClientConnectionFactory;
import org.apache.activemq.artemis.tests.util.Wait;
import org.apache.commons.lang3.RandomStringUtils;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.TestTemplate;
import org.junit.jupiter.api.extension.ExtendWith;

@ExtendWith(value={ParameterizedTestExtension.class})
public class StompWebSocketMaxFrameTest
extends StompTestBase {
    private final int wsPortWithStompMaxFrame = 61614;
    private final int wsPortWithWebSocketMaxFrame = 61615;
    private final int wsPortWithBothMaxFrameAndWorks = 61619;
    private final int wsPortWithBothMaxFrameButFails = 61620;
    private URI wsURIForStompMaxFrame;
    private URI wsURIForWebSocketMaxFrame;
    private URI wsURIForBothMaxFrameAndWorks;
    private URI wsURIForBothMaxFrameButFails;
    private final int stompWSMaxFrameSize = 131072;

    @Parameters(name="{0}")
    public static Collection<Object[]> data() {
        return Arrays.asList({"ws+v10.stomp"}, {"ws+v11.stomp"}, {"ws+v12.stomp"});
    }

    @Override
    @BeforeEach
    public void setUp() throws Exception {
        super.setUp();
        this.server.getRemotingService().createAcceptor("test1", "tcp://127.0.0.1:61614?stompMaxFramePayloadLength=131072").start();
        this.server.getRemotingService().createAcceptor("test2", "tcp://127.0.0.1:61615?webSocketMaxFramePayloadLength=131072").start();
        this.server.getRemotingService().createAcceptor("test3", "tcp://127.0.0.1:61619?stompMaxFramePayloadLength=65536;webSocketMaxFramePayloadLength=131072").start();
        this.server.getRemotingService().createAcceptor("test4", "tcp://127.0.0.1:61620?stompMaxFramePayloadLength=131072;webSocketMaxFramePayloadLength=65536").start();
        this.wsURIForStompMaxFrame = StompWebSocketMaxFrameTest.createStompClientUri(this.scheme, this.hostname, 61614);
        this.wsURIForWebSocketMaxFrame = StompWebSocketMaxFrameTest.createStompClientUri(this.scheme, this.hostname, 61615);
        this.wsURIForBothMaxFrameAndWorks = StompWebSocketMaxFrameTest.createStompClientUri(this.scheme, this.hostname, 61619);
        this.wsURIForBothMaxFrameButFails = StompWebSocketMaxFrameTest.createStompClientUri(this.scheme, this.hostname, 61620);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @TestTemplate
    public void testStompSendReceiveWithMaxFramePayloadLength() throws Exception {
        int size = 65536;
        String largeString1 = RandomStringUtils.randomAlphabetic((int)size);
        String largeString2 = RandomStringUtils.randomAlphabetic((int)size);
        StompClientConnection conn = StompClientConnectionFactory.createClientConnection(this.uri, false);
        conn.getTransport().setMaxFrameSize(131072);
        conn.getTransport().connect();
        StompClientConnection conn2 = StompClientConnectionFactory.createClientConnection(this.wsURIForStompMaxFrame, false);
        conn2.getTransport().setMaxFrameSize(131072);
        conn2.getTransport().connect();
        StompClientConnection conn3 = StompClientConnectionFactory.createClientConnection(this.wsURIForWebSocketMaxFrame, false);
        conn3.getTransport().setMaxFrameSize(131072);
        conn3.getTransport().connect();
        StompClientConnection conn4 = StompClientConnectionFactory.createClientConnection(this.wsURIForBothMaxFrameAndWorks, false);
        conn4.getTransport().setMaxFrameSize(131072);
        conn4.getTransport().connect();
        StompClientConnection conn5 = StompClientConnectionFactory.createClientConnection(this.wsURIForBothMaxFrameButFails, false);
        conn5.getTransport().setMaxFrameSize(131072);
        conn5.getTransport().connect();
        Wait.waitFor(() -> conn5.getTransport().isConnected() && conn4.getTransport().isConnected() && conn3.getTransport().isConnected() && conn2.getTransport().isConnected() && conn.getTransport().isConnected(), (long)10000L);
        conn.connect();
        conn2.connect();
        conn3.connect();
        conn4.connect();
        conn5.connect();
        StompWebSocketMaxFrameTest.subscribeQueue(conn2, "sub1", StompWebSocketMaxFrameTest.getQueuePrefix() + StompWebSocketMaxFrameTest.getQueueName());
        StompWebSocketMaxFrameTest.subscribeQueue(conn3, "sub2", StompWebSocketMaxFrameTest.getQueuePrefix() + StompWebSocketMaxFrameTest.getQueueName());
        StompWebSocketMaxFrameTest.subscribeQueue(conn4, "sub3", StompWebSocketMaxFrameTest.getQueuePrefix() + StompWebSocketMaxFrameTest.getQueueName());
        try {
            StompWebSocketMaxFrameTest.send(conn, StompWebSocketMaxFrameTest.getQueuePrefix() + StompWebSocketMaxFrameTest.getQueueName(), "text/plain", largeString1, false);
            Wait.waitFor(() -> !conn.getTransport().isConnected(), (long)2000L);
            Assertions.assertFalse((boolean)conn.getTransport().isConnected());
            StompWebSocketMaxFrameTest.send(conn5, StompWebSocketMaxFrameTest.getQueuePrefix() + StompWebSocketMaxFrameTest.getQueueName(), "text/plain", largeString1, false);
            Wait.waitFor(() -> !conn5.getTransport().isConnected(), (long)2000L);
            Assertions.assertFalse((boolean)conn5.getTransport().isConnected());
            StompWebSocketMaxFrameTest.send(conn2, StompWebSocketMaxFrameTest.getQueuePrefix() + StompWebSocketMaxFrameTest.getQueueName(), "text/plain", largeString2, false);
            Wait.waitFor(() -> !conn2.getTransport().isConnected(), (long)2000L);
            Assertions.assertTrue((boolean)conn2.getTransport().isConnected());
            StompWebSocketMaxFrameTest.send(conn3, StompWebSocketMaxFrameTest.getQueuePrefix() + StompWebSocketMaxFrameTest.getQueueName(), "text/plain", largeString2, false);
            Wait.waitFor(() -> !conn3.getTransport().isConnected(), (long)2000L);
            Assertions.assertTrue((boolean)conn3.getTransport().isConnected());
            StompWebSocketMaxFrameTest.send(conn4, StompWebSocketMaxFrameTest.getQueuePrefix() + StompWebSocketMaxFrameTest.getQueueName(), "text/plain", largeString2, false);
            Wait.waitFor(() -> !conn4.getTransport().isConnected(), (long)2000L);
            Assertions.assertTrue((boolean)conn4.getTransport().isConnected());
            ClientStompFrame frame2 = conn2.receiveFrame();
            Assertions.assertNotNull((Object)frame2);
            Assertions.assertEquals((Object)largeString2, (Object)frame2.getBody());
            ClientStompFrame frame3 = conn3.receiveFrame();
            Assertions.assertNotNull((Object)frame3);
            Assertions.assertEquals((Object)largeString2, (Object)frame3.getBody());
            ClientStompFrame frame4 = conn4.receiveFrame();
            Assertions.assertNotNull((Object)frame4);
            Assertions.assertEquals((Object)largeString2, (Object)frame4.getBody());
        }
        finally {
            conn5.closeTransport();
            conn4.closeTransport();
            conn3.closeTransport();
            conn2.closeTransport();
            conn.closeTransport();
        }
    }
}

