/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.tests.integration.stomp.v11;

import java.lang.invoke.MethodHandles;
import java.net.URI;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.Collection;
import org.apache.activemq.artemis.tests.extensions.parameterized.ParameterizedTestExtension;
import org.apache.activemq.artemis.tests.extensions.parameterized.Parameters;
import org.apache.activemq.artemis.tests.integration.stomp.StompTestBase;
import org.apache.activemq.artemis.tests.integration.stomp.util.ClientStompFrame;
import org.apache.activemq.artemis.tests.integration.stomp.util.StompClientConnection;
import org.apache.activemq.artemis.tests.integration.stomp.util.StompClientConnectionFactory;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.TestTemplate;
import org.junit.jupiter.api.extension.ExtendWith;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ExtendWith(value={ParameterizedTestExtension.class})
public class ExtraStompTest
extends StompTestBase {
    private static final Logger logger = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    private StompClientConnection connV10;
    private StompClientConnection connV11;

    @Parameters(name="{0}")
    public static Collection<Object[]> data() {
        return Arrays.asList({"ws+v11.stomp"}, {"tcp+v11.stomp"});
    }

    @Override
    public boolean isPersistenceEnabled() {
        return true;
    }

    @Override
    @BeforeEach
    public void setUp() throws Exception {
        super.setUp();
        URI v10Uri = new URI(this.uri.toString().replace("v11", "v10"));
        this.connV10 = StompClientConnectionFactory.createClientConnection(v10Uri);
        this.connV10.connect(this.defUser, this.defPass);
        this.connV11 = StompClientConnectionFactory.createClientConnection(this.uri);
        this.connV11.connect(this.defUser, this.defPass);
    }

    @Override
    @AfterEach
    public void tearDown() throws Exception {
        try {
            this.connV10.disconnect();
            this.connV11.disconnect();
        }
        finally {
            super.tearDown();
        }
    }

    @TestTemplate
    public void testSendAndReceive10() throws Exception {
        this.testSendAndReceive(this.connV10);
    }

    @TestTemplate
    public void testSendAndReceive11() throws Exception {
        this.testSendAndReceive(this.connV11);
    }

    public void testSendAndReceive(StompClientConnection conn) throws Exception {
        String msg1 = "Hello World 1!";
        String msg2 = "Hello World 2!";
        ClientStompFrame frame = conn.createFrame("SEND");
        frame.addHeader("destination", ExtraStompTest.getQueuePrefix() + ExtraStompTest.getQueueName());
        frame.addHeader("content-length", String.valueOf(msg1.getBytes(StandardCharsets.UTF_8).length));
        frame.addHeader("persistent", Boolean.TRUE.toString());
        frame.setBody(msg1);
        conn.sendFrame(frame);
        ClientStompFrame frame2 = conn.createFrame("SEND");
        frame2.addHeader("destination", ExtraStompTest.getQueuePrefix() + ExtraStompTest.getQueueName());
        frame2.addHeader("content-length", String.valueOf(msg2.getBytes(StandardCharsets.UTF_8).length));
        frame2.addHeader("persistent", Boolean.TRUE.toString());
        frame2.setBody(msg2);
        conn.sendFrame(frame2);
        ExtraStompTest.subscribe(conn, "a-sub");
        frame = conn.receiveFrame();
        Assertions.assertEquals((Object)"MESSAGE", (Object)frame.getCommand());
        Assertions.assertEquals((Object)"a-sub", (Object)frame.getHeader("subscription"));
        Assertions.assertNotNull((Object)frame.getHeader("message-id"));
        Assertions.assertEquals((Object)(ExtraStompTest.getQueuePrefix() + ExtraStompTest.getQueueName()), (Object)frame.getHeader("destination"));
        Assertions.assertEquals((Object)msg1, (Object)frame.getBody());
        frame = conn.receiveFrame();
        Assertions.assertEquals((Object)"MESSAGE", (Object)frame.getCommand());
        Assertions.assertEquals((Object)"a-sub", (Object)frame.getHeader("subscription"));
        Assertions.assertNotNull((Object)frame.getHeader("message-id"));
        Assertions.assertEquals((Object)(ExtraStompTest.getQueuePrefix() + ExtraStompTest.getQueueName()), (Object)frame.getHeader("destination"));
        Assertions.assertEquals((Object)msg2, (Object)frame.getBody());
        ExtraStompTest.unsubscribe(conn, "a-sub");
    }

    @TestTemplate
    public void testNoGarbageAfterPersistentMessageV10() throws Exception {
        this.testNoGarbageAfterPersistentMessage(this.connV10);
    }

    @TestTemplate
    public void testNoGarbageAfterPersistentMessageV11() throws Exception {
        this.testNoGarbageAfterPersistentMessage(this.connV11);
    }

    public void testNoGarbageAfterPersistentMessage(StompClientConnection conn) throws Exception {
        ExtraStompTest.subscribe(conn, "a-sub");
        ClientStompFrame frame = conn.createFrame("SEND");
        frame.addHeader("destination", ExtraStompTest.getQueuePrefix() + ExtraStompTest.getQueueName());
        frame.addHeader("content-length", "11");
        frame.addHeader("persistent", Boolean.TRUE.toString());
        frame.setBody("Hello World");
        conn.sendFrame(frame);
        frame = conn.createFrame("SEND");
        frame.addHeader("destination", ExtraStompTest.getQueuePrefix() + ExtraStompTest.getQueueName());
        frame.addHeader("content-length", "11");
        frame.addHeader("persistent", Boolean.TRUE.toString());
        frame.setBody("Hello World");
        conn.sendFrame(frame);
        frame = conn.receiveFrame(10000L);
        Assertions.assertEquals((Object)"Hello World", (Object)frame.getBody());
        frame = conn.receiveFrame(10000L);
        Assertions.assertEquals((Object)"Hello World", (Object)frame.getBody());
        ExtraStompTest.unsubscribe(conn, "a-sub");
    }

    @TestTemplate
    public void testNoGarbageOnPersistentRedeliveryV10() throws Exception {
        this.testNoGarbageOnPersistentRedelivery(this.connV10);
    }

    @TestTemplate
    public void testNoGarbageOnPersistentRedeliveryV11() throws Exception {
        this.testNoGarbageOnPersistentRedelivery(this.connV11);
    }

    public void testNoGarbageOnPersistentRedelivery(StompClientConnection conn) throws Exception {
        ClientStompFrame frame = conn.createFrame("SEND");
        frame.addHeader("destination", ExtraStompTest.getQueuePrefix() + ExtraStompTest.getQueueName());
        frame.addHeader("content-length", "11");
        frame.addHeader("persistent", Boolean.TRUE.toString());
        frame.setBody("Hello World");
        conn.sendFrame(frame);
        frame = conn.createFrame("SEND");
        frame.addHeader("destination", ExtraStompTest.getQueuePrefix() + ExtraStompTest.getQueueName());
        frame.addHeader("content-length", "11");
        frame.addHeader("persistent", Boolean.TRUE.toString());
        frame.setBody("Hello World");
        conn.sendFrame(frame);
        frame = ExtraStompTest.subscribe(conn, "a-sub", "client");
        frame = conn.receiveFrame(10000L);
        logger.debug("{}", (Object)frame);
        frame = conn.receiveFrame(10000L);
        logger.debug("{}", (Object)frame);
        ExtraStompTest.unsubscribe(conn, "a-sub");
        frame = ExtraStompTest.subscribe(conn, "a-sub");
        frame = conn.receiveFrame(10000L);
        Assertions.assertEquals((Object)"Hello World", (Object)frame.getBody());
        ExtraStompTest.unsubscribe(conn, "a-sub");
    }
}

