/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.tests.unit.core.journal.impl;

import java.lang.invoke.MethodHandles;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.activemq.artemis.core.io.SequentialFile;
import org.apache.activemq.artemis.core.io.SequentialFileFactory;
import org.apache.activemq.artemis.core.journal.EncodingSupport;
import org.apache.activemq.artemis.core.journal.LoaderCallback;
import org.apache.activemq.artemis.core.journal.PreparedTransactionInfo;
import org.apache.activemq.artemis.core.journal.RecordInfo;
import org.apache.activemq.artemis.core.journal.impl.JournalImpl;
import org.apache.activemq.artemis.core.server.ActiveMQComponent;
import org.apache.activemq.artemis.tests.unit.core.journal.impl.fakes.FakeSequentialFileFactory;
import org.apache.activemq.artemis.tests.unit.core.journal.impl.fakes.SimpleEncoding;
import org.apache.activemq.artemis.tests.util.ActiveMQTestBase;
import org.apache.activemq.artemis.utils.Wait;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AlignedJournalImplTest
extends ActiveMQTestBase {
    private static final Logger logger = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    private static final LoaderCallback dummyLoader = new LoaderCallback(){

        public void addPreparedTransaction(PreparedTransactionInfo preparedTransaction) {
        }

        public void addRecord(RecordInfo info) {
        }

        public void deleteRecord(long id) {
        }

        public void updateRecord(RecordInfo info) {
        }

        public void failedTransaction(long transactionID, List<RecordInfo> records, List<RecordInfo> recordsToDelete) {
        }
    };
    private SequentialFileFactory factory;
    JournalImpl journalImpl = null;
    private ArrayList<RecordInfo> records = null;
    private ArrayList<Long> incompleteTransactions = null;
    private ArrayList<PreparedTransactionInfo> transactions = null;

    @Test
    public void testBasicAlignment() throws Exception {
        FakeSequentialFileFactory factory = new FakeSequentialFileFactory(200, true);
        SequentialFile file = factory.createSequentialFile("test1");
        file.open();
        try {
            int i;
            ByteBuffer buffer = ByteBuffer.allocateDirect(200);
            for (i = 0; i < 200; ++i) {
                buffer.put(i, (byte)1);
            }
            file.writeDirect(buffer, true);
            buffer = ByteBuffer.allocate(400);
            for (i = 0; i < 400; ++i) {
                buffer.put(i, (byte)2);
            }
            file.writeDirect(buffer, true);
            buffer = ByteBuffer.allocate(600);
            file.position(0L);
            file.read(buffer);
            for (i = 0; i < 200; ++i) {
                Assertions.assertEquals((byte)1, (byte)buffer.get(i));
            }
            for (i = 201; i < 600; ++i) {
                Assertions.assertEquals((byte)2, (byte)buffer.get(i), (String)("Position " + i));
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @Test
    public void testInconsistentAlignment() throws Exception {
        this.factory = new FakeSequentialFileFactory(512, true);
        try {
            this.journalImpl = new JournalImpl(2000, 2, 2, 0, 0, this.factory, "tt", "tt", 1000);
            Assertions.fail((String)"Expected IllegalArgumentException");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void testSimpleAdd() throws Exception {
        int JOURNAL_SIZE = 1060;
        this.setupAndLoadJournal(1060, 10);
        this.journalImpl.appendAddRecord(13L, (byte)14, (EncodingSupport)new SimpleEncoding(1, 15), false);
        this.journalImpl.forceMoveNextFile();
        this.journalImpl.checkReclaimStatus();
        this.setupAndLoadJournal(1060, 10);
        Assertions.assertEquals((int)1, (int)this.records.size());
        Assertions.assertEquals((long)13L, (long)this.records.get((int)0).id);
        Assertions.assertEquals((int)14, (int)this.records.get((int)0).userRecordType);
        Assertions.assertEquals((int)1, (int)this.records.get((int)0).data.length);
        Assertions.assertEquals((int)15, (int)this.records.get((int)0).data[0]);
    }

    @Test
    public void testAppendAndUpdateRecords() throws Exception {
        int j;
        byte[] bytes;
        int i;
        int JOURNAL_SIZE = 1060;
        this.setupAndLoadJournal(1060, 10);
        Assertions.assertEquals((int)0, (int)this.records.size());
        Assertions.assertEquals((int)0, (int)this.transactions.size());
        for (i = 0; i < 25; ++i) {
            bytes = new byte[5];
            for (int j2 = 0; j2 < bytes.length; ++j2) {
                bytes[j2] = (byte)i;
            }
            this.journalImpl.appendAddRecord((long)i * 100L, (byte)i, bytes, false);
        }
        for (i = 25; i < 50; ++i) {
            SimpleEncoding support = new SimpleEncoding(5, (byte)i);
            this.journalImpl.appendAddRecord((long)i * 100L, (byte)i, (EncodingSupport)support, false);
        }
        this.setupAndLoadJournal(1060, 1024);
        Assertions.assertEquals((int)50, (int)this.records.size());
        i = 0;
        for (RecordInfo recordItem : this.records) {
            Assertions.assertEquals((long)((long)i * 100L), (long)recordItem.id);
            Assertions.assertEquals((int)i, (int)recordItem.getUserRecordType());
            Assertions.assertEquals((int)5, (int)recordItem.data.length);
            for (j = 0; j < 5; ++j) {
                Assertions.assertEquals((byte)((byte)i), (byte)recordItem.data[j]);
            }
            ++i;
        }
        for (i = 40; i < 50; ++i) {
            bytes = new byte[10];
            for (int j3 = 0; j3 < 10; ++j3) {
                bytes[j3] = 120;
            }
            this.journalImpl.appendUpdateRecord((long)i * 100L, (byte)i, bytes, false);
        }
        this.setupAndLoadJournal(1060, 1024);
        i = 0;
        for (RecordInfo recordItem : this.records) {
            if (i < 50) {
                Assertions.assertEquals((long)((long)i * 100L), (long)recordItem.id);
                Assertions.assertEquals((int)i, (int)recordItem.getUserRecordType());
                Assertions.assertEquals((int)5, (int)recordItem.data.length);
                for (j = 0; j < 5; ++j) {
                    Assertions.assertEquals((byte)((byte)i), (byte)recordItem.data[j]);
                }
            } else {
                Assertions.assertEquals((long)((long)(i - 10) * 100L), (long)recordItem.id);
                Assertions.assertEquals((int)(i - 10), (int)recordItem.getUserRecordType());
                Assertions.assertTrue((boolean)recordItem.isUpdate);
                Assertions.assertEquals((int)10, (int)recordItem.data.length);
                for (j = 0; j < 10; ++j) {
                    Assertions.assertEquals((byte)120, (byte)recordItem.data[j]);
                }
            }
            ++i;
        }
        this.journalImpl.stop();
    }

    @Test
    public void testPartialDelete() throws Exception {
        int i;
        int JOURNAL_SIZE = 10000;
        this.setupAndLoadJournal(10000, 100);
        this.journalImpl.setAutoReclaim(false);
        this.journalImpl.checkReclaimStatus();
        this.journalImpl.debugWait();
        Assertions.assertEquals((int)2, (int)this.factory.listFiles("tt").size());
        logger.debug("Initial:--> {}", (Object)this.journalImpl.debug());
        logger.debug("_______________________________");
        for (i = 0; i < 50; ++i) {
            this.journalImpl.appendAddRecord((long)i, (byte)1, (EncodingSupport)new SimpleEncoding(1, 120), false);
        }
        this.journalImpl.forceMoveNextFile();
        this.journalImpl.debugWait();
        Assertions.assertEquals((int)3, (int)this.factory.listFiles("tt").size());
        for (i = 10; i < 50; ++i) {
            this.journalImpl.appendDeleteRecord((long)i, false);
        }
        this.journalImpl.debugWait();
        this.setupAndLoadJournal(10000, 100);
        Assertions.assertEquals((int)10, (int)this.records.size());
        Assertions.assertEquals((int)3, (int)this.factory.listFiles("tt").size());
    }

    @Test
    public void testAddAndDeleteReclaimWithoutTransactions() throws Exception {
        int i;
        int JOURNAL_SIZE = 10000;
        this.setupAndLoadJournal(10000, 1);
        this.journalImpl.setAutoReclaim(false);
        this.journalImpl.checkReclaimStatus();
        this.journalImpl.debugWait();
        Assertions.assertEquals((int)2, (int)this.factory.listFiles("tt").size());
        logger.debug("Initial:--> {}", (Object)this.journalImpl.debug());
        logger.debug("_______________________________");
        for (i = 0; i < 50; ++i) {
            this.journalImpl.appendAddRecord((long)i, (byte)1, (EncodingSupport)new SimpleEncoding(1, 120), false);
        }
        this.journalImpl.debugWait();
        Assertions.assertEquals((int)2, (int)this.factory.listFiles("tt").size());
        for (i = 0; i < 50; ++i) {
            this.journalImpl.appendDeleteRecord((long)i, false);
        }
        this.journalImpl.forceMoveNextFile();
        this.journalImpl.appendAddRecord(1000L, (byte)1, (EncodingSupport)new SimpleEncoding(1, 120), false);
        this.journalImpl.debugWait();
        Assertions.assertEquals((int)3, (int)this.factory.listFiles("tt").size());
        this.setupAndLoadJournal(10000, 1);
        Assertions.assertEquals((int)1, (int)this.records.size());
        Assertions.assertEquals((long)1000L, (long)this.records.get((int)0).id);
        this.journalImpl.checkReclaimStatus();
        logger.debug(this.journalImpl.debug());
        this.journalImpl.debugWait();
        logger.debug("Final:--> {}", (Object)this.journalImpl.debug());
        logger.debug("_______________________________");
        logger.debug("Files bufferSize: {}", (Object)this.factory.listFiles("tt").size());
        Assertions.assertEquals((int)2, (int)this.factory.listFiles("tt").size());
    }

    @Test
    public void testReloadWithTransaction() throws Exception {
        int JOURNAL_SIZE = 2000;
        this.setupAndLoadJournal(2000, 100);
        Assertions.assertEquals((int)0, (int)this.records.size());
        Assertions.assertEquals((int)0, (int)this.transactions.size());
        this.journalImpl.appendAddRecordTransactional(1L, 1L, (byte)1, (EncodingSupport)new SimpleEncoding(1, 1));
        this.setupAndLoadJournal(2000, 100);
        Assertions.assertEquals((int)0, (int)this.records.size());
        Assertions.assertEquals((int)0, (int)this.transactions.size());
        try {
            this.journalImpl.appendCommitRecord(1L, true);
            Assertions.fail((String)"Supposed to throw exception");
        }
        catch (Exception e) {
            logger.warn(e.getMessage(), (Throwable)e);
        }
        this.setupAndLoadJournal(2000, 100);
        Assertions.assertEquals((int)0, (int)this.records.size());
        Assertions.assertEquals((int)0, (int)this.transactions.size());
    }

    @Test
    public void testReloadWithInterruptedTransaction() throws Exception {
        int JOURNAL_SIZE = 1100;
        this.setupAndLoadJournal(1100, 100);
        this.journalImpl.setAutoReclaim(false);
        Assertions.assertEquals((int)0, (int)this.records.size());
        Assertions.assertEquals((int)0, (int)this.transactions.size());
        for (int i = 0; i < 10; ++i) {
            this.journalImpl.appendAddRecordTransactional(77L, 1L, (byte)1, (EncodingSupport)new SimpleEncoding(1, 1));
            this.journalImpl.forceMoveNextFile();
        }
        this.journalImpl.debugWait();
        Assertions.assertEquals((int)12, (int)this.factory.listFiles("tt").size());
        this.journalImpl.appendAddRecordTransactional(78L, 1L, (byte)1, (EncodingSupport)new SimpleEncoding(1, 1));
        Assertions.assertEquals((int)12, (int)this.factory.listFiles("tt").size());
        this.setupAndLoadJournal(1100, 100);
        Assertions.assertEquals((int)0, (int)this.records.size());
        Assertions.assertEquals((int)0, (int)this.transactions.size());
        Assertions.assertEquals((int)2, (int)this.incompleteTransactions.size());
        Assertions.assertEquals((Long)77L, (Long)this.incompleteTransactions.get(0));
        Assertions.assertEquals((Long)78L, (Long)this.incompleteTransactions.get(1));
        try {
            this.journalImpl.appendCommitRecord(77L, true);
            Assertions.fail((String)"Supposed to throw exception");
        }
        catch (Exception e) {
            logger.debug("Got an expected exception:", (Throwable)e);
        }
        this.setupAndLoadJournal(1100, 100);
        this.journalImpl.forceMoveNextFile();
        this.journalImpl.checkReclaimStatus();
        Assertions.assertEquals((int)0, (int)this.records.size());
        Assertions.assertEquals((int)0, (int)this.transactions.size());
    }

    @Test
    public void testReloadWithCompletedTransaction() throws Exception {
        int i;
        int JOURNAL_SIZE = 2000;
        this.setupAndLoadJournal(2000, 100);
        Assertions.assertEquals((int)0, (int)this.records.size());
        Assertions.assertEquals((int)0, (int)this.transactions.size());
        for (i = 0; i < 10; ++i) {
            this.journalImpl.appendAddRecordTransactional(1L, (long)i, (byte)1, (EncodingSupport)new SimpleEncoding(1, 1));
            this.journalImpl.forceMoveNextFile();
        }
        this.journalImpl.appendCommitRecord(1L, false);
        this.journalImpl.debugWait();
        Assertions.assertEquals((int)12, (int)this.factory.listFiles("tt").size());
        this.setupAndLoadJournal(2000, 100);
        Assertions.assertEquals((int)10, (int)this.records.size());
        Assertions.assertEquals((int)0, (int)this.transactions.size());
        this.journalImpl.checkReclaimStatus();
        Assertions.assertEquals((int)10, (int)this.journalImpl.getDataFilesCount());
        Assertions.assertEquals((int)12, (int)this.factory.listFiles("tt").size());
        for (i = 0; i < 10; ++i) {
            this.journalImpl.appendDeleteRecordTransactional(2L, (long)i);
            this.journalImpl.forceMoveNextFile();
        }
        this.journalImpl.appendCommitRecord(2L, false);
        this.journalImpl.appendAddRecord(100L, (byte)1, (EncodingSupport)new SimpleEncoding(5, 1), false);
        this.journalImpl.forceMoveNextFile();
        this.journalImpl.appendAddRecord(101L, (byte)1, (EncodingSupport)new SimpleEncoding(5, 1), false);
        this.journalImpl.checkReclaimStatus();
        Assertions.assertEquals((int)1, (int)this.journalImpl.getDataFilesCount());
        this.setupAndLoadJournal(2000, 100);
        Assertions.assertEquals((int)1, (int)this.journalImpl.getDataFilesCount());
        Assertions.assertEquals((int)3, (int)this.factory.listFiles("tt").size());
    }

    @Test
    public void testTotalSize() throws Exception {
        int JOURNAL_SIZE = 2000;
        this.setupAndLoadJournal(2000, 100);
        Assertions.assertEquals((int)0, (int)this.records.size());
        Assertions.assertEquals((int)0, (int)this.transactions.size());
        this.journalImpl.appendAddRecordTransactional(1L, 2L, (byte)3, (EncodingSupport)new SimpleEncoding(1869, 4));
        this.journalImpl.appendCommitRecord(1L, false);
        this.journalImpl.debugWait();
        this.setupAndLoadJournal(2000, 100);
        Assertions.assertEquals((int)1, (int)this.records.size());
    }

    @Test
    public void testReloadInvalidCheckSizeOnTransaction() throws Exception {
        int JOURNAL_SIZE = 2000;
        this.setupAndLoadJournal(2000, 100);
        Assertions.assertEquals((int)2, (int)this.factory.listFiles("tt").size());
        Assertions.assertEquals((int)0, (int)this.records.size());
        Assertions.assertEquals((int)0, (int)this.transactions.size());
        for (int i = 0; i < 2; ++i) {
            this.journalImpl.appendAddRecordTransactional(1L, (long)i, (byte)0, (EncodingSupport)new SimpleEncoding(1, 15));
        }
        this.journalImpl.appendCommitRecord(1L, false);
        this.journalImpl.debugWait();
        logger.debug("Files = {}", (Object)this.factory.listFiles("tt"));
        SequentialFile file = this.factory.createSequentialFile("tt-1.tt");
        file.open();
        ByteBuffer buffer = ByteBuffer.allocate(100);
        file.position(100L);
        file.read(buffer);
        buffer.position(28);
        int posCheckSize = buffer.position();
        Assertions.assertEquals((int)32, (int)buffer.getInt());
        buffer.position(posCheckSize);
        buffer.putInt(-1);
        buffer.rewind();
        file.position(100L);
        file.writeDirect(buffer, true);
        file.close();
        this.setupAndLoadJournal(2000, 100);
        Assertions.assertEquals((int)0, (int)this.records.size());
        this.journalImpl.checkReclaimStatus();
        Assertions.assertEquals((int)0, (int)this.journalImpl.getDataFilesCount());
        Assertions.assertEquals((int)2, (int)this.factory.listFiles("tt").size());
    }

    @Test
    public void testPartiallyBrokenFile() throws Exception {
        int JOURNAL_SIZE = 20000;
        this.setupAndLoadJournal(20000, 100);
        Assertions.assertEquals((int)2, (int)this.factory.listFiles("tt").size());
        Assertions.assertEquals((int)0, (int)this.records.size());
        Assertions.assertEquals((int)0, (int)this.transactions.size());
        for (int i = 0; i < 20; ++i) {
            this.journalImpl.appendAddRecordTransactional(1L, (long)i, (byte)0, (EncodingSupport)new SimpleEncoding(1, 15));
            this.journalImpl.appendAddRecordTransactional(2L, (long)i + 20L, (byte)0, (EncodingSupport)new SimpleEncoding(1, 15));
        }
        this.journalImpl.appendCommitRecord(1L, false);
        this.journalImpl.appendCommitRecord(2L, false);
        this.journalImpl.debugWait();
        SequentialFile file = this.factory.createSequentialFile("tt-1.tt");
        file.open();
        ByteBuffer buffer = ByteBuffer.allocate(100);
        file.position(100L);
        file.read(buffer);
        buffer.position(28);
        int posCheckSize = buffer.position();
        Assertions.assertEquals((int)32, (int)buffer.getInt());
        buffer.position(posCheckSize);
        buffer.putInt(-1);
        buffer.rewind();
        file.position(100L);
        file.writeDirect(buffer, true);
        file.close();
        this.setupAndLoadJournal(20000, 100);
        Assertions.assertEquals((int)20, (int)this.records.size());
        this.journalImpl.checkReclaimStatus();
    }

    @Test
    public void testReduceFreeFiles() throws Exception {
        int i;
        int JOURNAL_SIZE = 2000;
        this.setupAndLoadJournal(2000, 100, 10);
        Assertions.assertEquals((int)10, (int)this.factory.listFiles("tt").size());
        this.setupAndLoadJournal(2000, 100, 2);
        Assertions.assertEquals((int)10, (int)this.factory.listFiles("tt").size());
        for (i = 0; i < 10; ++i) {
            this.journalImpl.appendAddRecord((long)i, (byte)0, (EncodingSupport)new SimpleEncoding(1, 0), false);
            this.journalImpl.forceMoveNextFile();
        }
        this.setupAndLoadJournal(2000, 100, 2);
        Assertions.assertEquals((int)10, (int)this.records.size());
        Assertions.assertEquals((int)12, (int)this.factory.listFiles("tt").size());
        for (i = 0; i < 10; ++i) {
            this.journalImpl.appendDeleteRecord((long)i, false);
        }
        this.journalImpl.forceMoveNextFile();
        this.journalImpl.checkReclaimStatus();
        this.setupAndLoadJournal(2000, 100, 2);
        Assertions.assertEquals((int)0, (int)this.records.size());
        Assertions.assertEquals((int)2, (int)this.factory.listFiles("tt").size());
    }

    @Test
    public void testReloadIncompleteTransaction() throws Exception {
        int i;
        int JOURNAL_SIZE = 2000;
        this.setupAndLoadJournal(2000, 1);
        Assertions.assertEquals((int)2, (int)this.factory.listFiles("tt").size());
        Assertions.assertEquals((int)0, (int)this.records.size());
        Assertions.assertEquals((int)0, (int)this.transactions.size());
        for (i = 0; i < 10; ++i) {
            this.journalImpl.appendAddRecordTransactional(1L, (long)i, (byte)0, (EncodingSupport)new SimpleEncoding(1, 15));
        }
        for (i = 10; i < 20; ++i) {
            this.journalImpl.appendAddRecordTransactional(1L, (long)i, (byte)0, (EncodingSupport)new SimpleEncoding(1, 15));
        }
        this.journalImpl.appendCommitRecord(1L, false);
        this.journalImpl.debugWait();
        SequentialFile file = this.factory.createSequentialFile("tt-1.tt");
        file.open();
        ByteBuffer buffer = ByteBuffer.allocate(100);
        file.position(100L);
        file.read(buffer);
        buffer.position(1);
        buffer.putInt(-1);
        buffer.rewind();
        file.position(100L);
        buffer.rewind();
        file.writeDirect(buffer, true);
        file.close();
        this.setupAndLoadJournal(2000, 100);
        Assertions.assertEquals((int)0, (int)this.records.size());
        this.journalImpl.checkReclaimStatus();
        Assertions.assertEquals((int)0, (int)this.journalImpl.getDataFilesCount());
        Assertions.assertEquals((int)2, (int)this.factory.listFiles("tt").size());
    }

    @Test
    public void testPrepareAloneOnSeparatedFile() throws Exception {
        int JOURNAL_SIZE = 20000;
        this.setupAndLoadJournal(20000, 100);
        Assertions.assertEquals((int)0, (int)this.records.size());
        Assertions.assertEquals((int)0, (int)this.transactions.size());
        for (int i = 0; i < 10; ++i) {
            this.journalImpl.appendAddRecordTransactional(1L, (long)i, (byte)0, (EncodingSupport)new SimpleEncoding(1, 15));
        }
        this.journalImpl.forceMoveNextFile();
        SimpleEncoding xidEncoding = new SimpleEncoding(10, 97);
        this.journalImpl.appendPrepareRecord(1L, (EncodingSupport)xidEncoding, false);
        this.journalImpl.appendCommitRecord(1L, false);
        for (int i = 0; i < 10; ++i) {
            this.journalImpl.appendDeleteRecordTransactional(2L, (long)i);
        }
        this.journalImpl.appendCommitRecord(2L, false);
        this.journalImpl.appendAddRecord(100L, (byte)0, (EncodingSupport)new SimpleEncoding(1, 10), false);
        this.journalImpl.forceMoveNextFile();
        this.journalImpl.checkReclaimStatus();
        this.setupAndLoadJournal(20000, 100);
        Assertions.assertEquals((int)1, (int)this.records.size());
    }

    @Test
    public void testCommitWithMultipleFiles() throws Exception {
        int i;
        int JOURNAL_SIZE = 20000;
        this.setupAndLoadJournal(20000, 100);
        Assertions.assertEquals((int)0, (int)this.records.size());
        Assertions.assertEquals((int)0, (int)this.transactions.size());
        for (i = 0; i < 50; ++i) {
            if (i == 10) {
                this.journalImpl.forceMoveNextFile();
            }
            this.journalImpl.appendAddRecordTransactional(1L, (long)i, (byte)0, (EncodingSupport)new SimpleEncoding(1, 15));
        }
        this.journalImpl.appendCommitRecord(1L, false);
        for (i = 0; i < 10; ++i) {
            if (i == 5) {
                this.journalImpl.forceMoveNextFile();
            }
            this.journalImpl.appendDeleteRecordTransactional(2L, (long)i);
        }
        this.journalImpl.appendCommitRecord(2L, false);
        this.journalImpl.forceMoveNextFile();
        this.journalImpl.checkReclaimStatus();
        this.setupAndLoadJournal(20000, 100);
        Assertions.assertEquals((int)40, (int)this.records.size());
    }

    @Test
    public void testSimplePrepare() throws Exception {
        int JOURNAL_SIZE = 3072;
        this.setupAndLoadJournal(3072, 1);
        Assertions.assertEquals((int)0, (int)this.records.size());
        Assertions.assertEquals((int)0, (int)this.transactions.size());
        SimpleEncoding xid = new SimpleEncoding(10, 1);
        this.journalImpl.appendAddRecord(10L, (byte)0, (EncodingSupport)new SimpleEncoding(10, 0), false);
        this.journalImpl.appendDeleteRecordTransactional(1L, 10L, (EncodingSupport)new SimpleEncoding(100, 106));
        this.journalImpl.appendPrepareRecord(1L, (EncodingSupport)xid, false);
        this.journalImpl.debugWait();
        this.setupAndLoadJournal(3072, 1);
        Assertions.assertEquals((int)1, (int)this.transactions.size());
        Assertions.assertEquals((int)1, (int)this.transactions.get(0).getRecordsToDelete().size());
        Assertions.assertEquals((int)1, (int)this.records.size());
        for (RecordInfo record : this.transactions.get(0).getRecordsToDelete()) {
            byte[] data = record.data;
            Assertions.assertEquals((int)100, (int)data.length);
            for (byte element : data) {
                Assertions.assertEquals((byte)106, (byte)element);
            }
        }
        Assertions.assertEquals((int)10, (int)this.transactions.get(0).getExtraData().length);
        for (int i = 0; i < 10; ++i) {
            Assertions.assertEquals((byte)1, (byte)this.transactions.get(0).getExtraData()[i]);
        }
        this.journalImpl.appendCommitRecord(1L, false);
        this.journalImpl.debugWait();
        this.setupAndLoadJournal(3072, 1);
        Assertions.assertEquals((int)0, (int)this.transactions.size());
        Assertions.assertEquals((int)0, (int)this.records.size());
    }

    @Test
    public void testReloadWithPreparedTransaction() throws Exception {
        int i;
        int JOURNAL_SIZE = 3072;
        this.setupAndLoadJournal(3072, 1);
        Assertions.assertEquals((int)0, (int)this.records.size());
        Assertions.assertEquals((int)0, (int)this.transactions.size());
        for (int i2 = 0; i2 < 10; ++i2) {
            this.journalImpl.appendAddRecordTransactional(1L, (long)i2, (byte)1, (EncodingSupport)new SimpleEncoding(50, 1));
            this.journalImpl.forceMoveNextFile();
        }
        this.journalImpl.debugWait();
        SimpleEncoding xid1 = new SimpleEncoding(10, 1);
        this.journalImpl.appendPrepareRecord(1L, (EncodingSupport)xid1, false);
        Assertions.assertEquals((int)12, (int)this.factory.listFiles("tt").size());
        this.setupAndLoadJournal(3072, 1024);
        Assertions.assertEquals((int)0, (int)this.records.size());
        Assertions.assertEquals((int)1, (int)this.transactions.size());
        Assertions.assertEquals((int)10, (int)this.transactions.get(0).getExtraData().length);
        for (i = 0; i < 10; ++i) {
            Assertions.assertEquals((byte)1, (byte)this.transactions.get(0).getExtraData()[i]);
        }
        this.journalImpl.checkReclaimStatus();
        Assertions.assertEquals((int)10, (int)this.journalImpl.getDataFilesCount());
        Assertions.assertEquals((int)12, (int)this.factory.listFiles("tt").size());
        this.journalImpl.appendCommitRecord(1L, false);
        this.setupAndLoadJournal(3072, 1024);
        Assertions.assertEquals((int)10, (int)this.records.size());
        this.journalImpl.checkReclaimStatus();
        for (i = 0; i < 10; ++i) {
            this.journalImpl.appendDeleteRecordTransactional(2L, (long)i);
        }
        SimpleEncoding xid2 = new SimpleEncoding(15, 2);
        this.journalImpl.appendPrepareRecord(2L, (EncodingSupport)xid2, false);
        this.setupAndLoadJournal(3072, 1);
        Assertions.assertEquals((int)1, (int)this.transactions.size());
        Assertions.assertEquals((int)15, (int)this.transactions.get(0).getExtraData().length);
        for (byte element : this.transactions.get(0).getExtraData()) {
            Assertions.assertEquals((int)2, (int)element);
        }
        Assertions.assertEquals((int)10, (int)this.journalImpl.getDataFilesCount());
        Assertions.assertEquals((int)12, (int)this.factory.listFiles("tt").size());
        this.journalImpl.appendCommitRecord(2L, false);
        this.setupAndLoadJournal(3072, 1);
        Assertions.assertEquals((int)0, (int)this.records.size());
        Assertions.assertEquals((int)0, (int)this.transactions.size());
        this.journalImpl.forceMoveNextFile();
        this.journalImpl.checkReclaimStatus();
        this.journalImpl.flush();
    }

    @Test
    public void testReloadInvalidPrepared() throws Exception {
        int JOURNAL_SIZE = 3000;
        this.setupAndLoadJournal(3000, 100);
        Assertions.assertEquals((int)0, (int)this.records.size());
        Assertions.assertEquals((int)0, (int)this.transactions.size());
        for (int i = 0; i < 10; ++i) {
            this.journalImpl.appendAddRecordTransactional(1L, (long)i, (byte)1, (EncodingSupport)new SimpleEncoding(50, 1));
        }
        this.journalImpl.appendPrepareRecord(1L, (EncodingSupport)new SimpleEncoding(13, 0), false);
        this.setupAndLoadJournal(3000, 100);
        Assertions.assertEquals((int)0, (int)this.records.size());
        Assertions.assertEquals((int)1, (int)this.transactions.size());
        SequentialFile file = this.factory.createSequentialFile("tt-1.tt");
        file.open();
        ByteBuffer buffer = ByteBuffer.allocate(100);
        file.position(100L);
        file.read(buffer);
        buffer.position(1);
        buffer.putInt(-1);
        buffer.rewind();
        file.position(100L);
        file.writeDirect(buffer, true);
        file.close();
        this.setupAndLoadJournal(3000, 100);
        Assertions.assertEquals((int)0, (int)this.records.size());
        Assertions.assertEquals((int)0, (int)this.transactions.size());
    }

    @Test
    public void testReclaimAfterRollabck() throws Exception {
        int JOURNAL_SIZE = 2000;
        int COUNT = 10;
        this.setupAndLoadJournal(2000, 1);
        for (int i = 0; i < 10; ++i) {
            this.journalImpl.appendAddRecordTransactional(1L, (long)i, (byte)0, (EncodingSupport)new SimpleEncoding(1, 0));
            this.journalImpl.forceMoveNextFile();
        }
        this.journalImpl.appendRollbackRecord(1L, false);
        this.journalImpl.forceMoveNextFile();
        Assertions.assertTrue((boolean)Wait.waitFor(() -> this.factory.listFiles("tt").size() == 13, (long)2000L, (long)50L));
        this.journalImpl.checkReclaimStatus();
        Assertions.assertEquals((int)0, (int)this.journalImpl.getDataFilesCount());
        this.setupAndLoadJournal(2000, 1);
        Assertions.assertEquals((int)0, (int)this.journalImpl.getDataFilesCount());
        Assertions.assertEquals((int)2, (int)this.factory.listFiles("tt").size());
    }

    @Test
    public void testDecreaseAlignment() throws Exception {
        int JOURNAL_SIZE = 2048;
        this.setupAndLoadJournal(2048, 512);
        for (int i = 0; i < 10; ++i) {
            this.journalImpl.appendAddRecordTransactional(1L, (long)i, (byte)0, (EncodingSupport)new SimpleEncoding(1, 0));
        }
        this.journalImpl.appendCommitRecord(1L, false);
        this.setupAndLoadJournal(2048, 100);
        Assertions.assertEquals((int)10, (int)this.records.size());
        this.setupAndLoadJournal(2048, 1);
        Assertions.assertEquals((int)10, (int)this.records.size());
    }

    @Test
    public void testIncreaseAlignment() throws Exception {
        int JOURNAL_SIZE = 2048;
        this.setupAndLoadJournal(2048, 1);
        for (int i = 0; i < 10; ++i) {
            this.journalImpl.appendAddRecordTransactional(1L, (long)i, (byte)0, (EncodingSupport)new SimpleEncoding(1, 0));
        }
        this.journalImpl.appendCommitRecord(1L, false);
        this.setupAndLoadJournal(2048, 100);
        Assertions.assertEquals((int)10, (int)this.records.size());
        this.setupAndLoadJournal(2048, 512);
        Assertions.assertEquals((int)10, (int)this.records.size());
    }

    @Test
    public void testEmptyPrepare() throws Exception {
        int JOURNAL_SIZE = 2048;
        this.setupAndLoadJournal(2048, 1);
        this.journalImpl.appendPrepareRecord(2L, (EncodingSupport)new SimpleEncoding(10, 106), false);
        this.journalImpl.forceMoveNextFile();
        this.journalImpl.appendAddRecord(1L, (byte)0, (EncodingSupport)new SimpleEncoding(10, 107), false);
        this.setupAndLoadJournal(2048, 1);
        Assertions.assertEquals((int)1, (int)this.journalImpl.getDataFilesCount());
        Assertions.assertEquals((int)1, (int)this.transactions.size());
        this.journalImpl.forceMoveNextFile();
        this.setupAndLoadJournal(2048, 1);
        Assertions.assertEquals((int)1, (int)this.journalImpl.getDataFilesCount());
        Assertions.assertEquals((int)1, (int)this.transactions.size());
        this.journalImpl.appendCommitRecord(2L, false);
        this.journalImpl.appendDeleteRecord(1L, false);
        this.journalImpl.forceMoveNextFile();
        this.setupAndLoadJournal(2048, 0);
        this.journalImpl.forceMoveNextFile();
        this.journalImpl.debugWait();
        this.journalImpl.checkReclaimStatus();
        Assertions.assertEquals((int)0, (int)this.transactions.size());
        Assertions.assertEquals((int)0, (int)this.journalImpl.getDataFilesCount());
    }

    @Test
    public void testReclaimingAfterConcurrentAddsAndDeletesTx() throws Exception {
        this.testReclaimingAfterConcurrentAddsAndDeletes(true);
    }

    @Test
    public void testReclaimingAfterConcurrentAddsAndDeletesNonTx() throws Exception {
        this.testReclaimingAfterConcurrentAddsAndDeletes(false);
    }

    public void testReclaimingAfterConcurrentAddsAndDeletes(boolean transactional) throws Exception {
        int JOURNAL_SIZE = 10240;
        this.setupAndLoadJournal(10240, 1);
        Assertions.assertEquals((int)0, (int)this.records.size());
        Assertions.assertEquals((int)0, (int)this.transactions.size());
        CountDownLatch latchReady = new CountDownLatch(2);
        CountDownLatch latchStart = new CountDownLatch(1);
        AtomicInteger finishedOK = new AtomicInteger(0);
        LinkedBlockingQueue queueDelete = new LinkedBlockingQueue();
        int NUMBER_OF_ELEMENTS = 500;
        Thread t1 = new Thread(() -> {
            try {
                latchReady.countDown();
                ActiveMQTestBase.waitForLatch(latchStart);
                for (int i = 0; i < 500; ++i) {
                    if (transactional) {
                        this.journalImpl.appendAddRecordTransactional((long)i, (long)i, (byte)1, (EncodingSupport)new SimpleEncoding(50, 1));
                        this.journalImpl.appendCommitRecord((long)i, false);
                    } else {
                        this.journalImpl.appendAddRecord((long)i, (byte)1, (EncodingSupport)new SimpleEncoding(50, 1), false);
                    }
                    queueDelete.offer(i);
                }
                finishedOK.incrementAndGet();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        });
        Thread t2 = new Thread(() -> {
            try {
                Integer toDelete;
                latchReady.countDown();
                ActiveMQTestBase.waitForLatch(latchStart);
                for (int i = 0; i < 500 && (toDelete = (Integer)queueDelete.poll(10L, TimeUnit.SECONDS)) != null; ++i) {
                    if (transactional) {
                        this.journalImpl.appendDeleteRecordTransactional((long)toDelete.intValue(), (long)toDelete.intValue(), (EncodingSupport)new SimpleEncoding(50, 1));
                        this.journalImpl.appendCommitRecord((long)i, false);
                        continue;
                    }
                    this.journalImpl.appendDeleteRecord((long)toDelete.intValue(), false);
                }
                finishedOK.incrementAndGet();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        });
        t1.start();
        t2.start();
        ActiveMQTestBase.waitForLatch(latchReady);
        latchStart.countDown();
        t1.join();
        t2.join();
        Assertions.assertEquals((int)2, (int)finishedOK.intValue());
        this.journalImpl.debugWait();
        this.journalImpl.forceMoveNextFile();
        this.journalImpl.debugWait();
        this.journalImpl.checkReclaimStatus();
        Assertions.assertEquals((int)0, (int)this.journalImpl.getDataFilesCount());
        Assertions.assertEquals((int)2, (int)this.factory.listFiles("tt").size());
    }

    @Test
    public void testAlignmentOverReload() throws Exception {
        this.factory = new FakeSequentialFileFactory(512, false);
        this.journalImpl = new JournalImpl(2048, 20, 20, 0, 0, this.factory, "amq", "amq", 1000);
        this.journalImpl.start();
        this.journalImpl.load(dummyLoader);
        this.journalImpl.appendAddRecord(1L, (byte)0, (EncodingSupport)new SimpleEncoding(100, 97), false);
        this.journalImpl.appendAddRecord(2L, (byte)0, (EncodingSupport)new SimpleEncoding(100, 98), false);
        this.journalImpl.appendAddRecord(3L, (byte)0, (EncodingSupport)new SimpleEncoding(100, 98), false);
        this.journalImpl.appendAddRecord(4L, (byte)0, (EncodingSupport)new SimpleEncoding(100, 98), false);
        this.journalImpl.stop();
        this.journalImpl = new JournalImpl(2048, 20, 20, 0, 0, this.factory, "amq", "amq", 1000);
        this.addActiveMQComponent((ActiveMQComponent)this.journalImpl);
        this.journalImpl.start();
        this.journalImpl.load(dummyLoader);
        this.journalImpl.forceMoveNextFile();
        this.journalImpl.appendDeleteRecord(1L, false);
        this.journalImpl.appendDeleteRecord(2L, false);
        this.journalImpl.appendDeleteRecord(3L, false);
        this.journalImpl.appendDeleteRecord(4L, false);
        this.journalImpl.stop();
        this.journalImpl = new JournalImpl(2048, 20, 20, 0, 0, this.factory, "amq", "amq", 1000);
        this.addActiveMQComponent((ActiveMQComponent)this.journalImpl);
        this.journalImpl.start();
        ArrayList info = new ArrayList();
        ArrayList trans = new ArrayList();
        this.journalImpl.load(info, trans, null);
        Assertions.assertEquals((int)0, (int)info.size());
        Assertions.assertEquals((int)0, (int)trans.size());
    }

    @Override
    @BeforeEach
    public void setUp() throws Exception {
        super.setUp();
        this.records = new ArrayList();
        this.transactions = new ArrayList();
        this.incompleteTransactions = new ArrayList();
        this.factory = null;
        this.journalImpl = null;
    }

    @Override
    @AfterEach
    public void tearDown() throws Exception {
        AlignedJournalImplTest.stopComponent((ActiveMQComponent)this.journalImpl);
        if (this.factory != null) {
            this.factory.stop();
        }
        this.records = null;
        this.transactions = null;
        this.incompleteTransactions = null;
        this.factory = null;
        this.journalImpl = null;
        super.tearDown();
    }

    private void setupAndLoadJournal(int journalSize, int alignment) throws Exception {
        this.setupAndLoadJournal(journalSize, alignment, 2);
    }

    private void setupAndLoadJournal(int journalSize, int alignment, int numberOfMinimalFiles) throws Exception {
        if (this.factory == null) {
            this.factory = new FakeSequentialFileFactory(alignment, true);
        }
        if (this.journalImpl != null) {
            this.journalImpl.stop();
        }
        this.journalImpl = new JournalImpl(journalSize, numberOfMinimalFiles, numberOfMinimalFiles, 0, 0, this.factory, "tt", "tt", 1000);
        this.addActiveMQComponent((ActiveMQComponent)this.journalImpl);
        this.journalImpl.start();
        this.records.clear();
        this.transactions.clear();
        this.incompleteTransactions.clear();
        this.journalImpl.load(this.records, this.transactions, (transactionID, records, recordsToDelete) -> {
            logger.debug("records.length = {}", (Object)records.size());
            this.incompleteTransactions.add(transactionID);
        });
    }
}

