/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.tests.unit.core.journal.impl;

import java.io.File;
import java.lang.invoke.MethodHandles;
import java.nio.ByteBuffer;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import org.apache.activemq.artemis.api.core.ActiveMQException;
import org.apache.activemq.artemis.api.core.ActiveMQIOErrorException;
import org.apache.activemq.artemis.core.io.SequentialFile;
import org.apache.activemq.artemis.core.io.SequentialFileFactory;
import org.apache.activemq.artemis.core.journal.EncodingSupport;
import org.apache.activemq.artemis.core.journal.RecordInfo;
import org.apache.activemq.artemis.core.journal.TestableJournal;
import org.apache.activemq.artemis.core.journal.impl.JournalImpl;
import org.apache.activemq.artemis.core.server.ActiveMQComponent;
import org.apache.activemq.artemis.logs.AssertionLoggerHandler;
import org.apache.activemq.artemis.tests.unit.core.journal.impl.JournalImplTestBase;
import org.apache.activemq.artemis.tests.unit.core.journal.impl.fakes.SimpleEncoding;
import org.apache.activemq.artemis.utils.RandomUtil;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class JournalImplTestUnit
extends JournalImplTestBase {
    private static final Logger logger = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());

    @Override
    @AfterEach
    public void tearDown() throws Exception {
        JournalImplTestUnit.stopComponent((ActiveMQComponent)this.journal);
        List files = this.fileFactory.listFiles(this.fileExtension);
        for (String file : files) {
            SequentialFile seqFile = this.fileFactory.createSequentialFile(file);
            Assertions.assertEquals((long)this.fileSize, (long)seqFile.size());
        }
        super.tearDown();
    }

    @Test
    public void testState() throws Exception {
        this.setup(10, 10240, true);
        this.createJournal();
        try {
            this.load();
            Assertions.fail((String)"Should throw exception");
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
        this.startJournal();
        try {
            this.startJournal();
            Assertions.fail((String)"Should throw exception");
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
        this.stopJournal();
        this.startJournal();
        this.load();
        try {
            this.load();
            Assertions.fail((String)"Should throw exception");
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
        try {
            this.startJournal();
            Assertions.fail((String)"Should throw exception");
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
        this.stopJournal();
    }

    @Test
    public void testRestartJournal() throws Exception {
        int i;
        this.setup(10, 10240, true);
        this.createJournal();
        this.startJournal();
        this.load();
        this.stopJournal();
        this.startJournal();
        this.load();
        byte[] record = new byte[1000];
        for (i = 0; i < record.length; ++i) {
            record[i] = 97;
        }
        for (i = 0; i < 100; ++i) {
            this.journal.appendAddRecord(1L, (byte)1, (EncodingSupport)new SimpleEncoding(2, 97), false);
        }
        this.stopJournal();
    }

    @Test
    public void testFlushAppendsAndDeletes() throws Exception {
        int i;
        this.setup(10, 10240, true);
        this.createJournal();
        this.startJournal();
        this.load();
        byte[] record = new byte[1000];
        for (i = 0; i < record.length; ++i) {
            record[i] = 97;
        }
        for (i = 0; i < 10000; ++i) {
            this.journal.appendAddRecord((long)i, (byte)1, (EncodingSupport)new SimpleEncoding(2, 97), false);
            this.journal.appendDeleteRecord((long)i, false);
        }
        this.stopJournal();
        List files = this.fileFactory.listFiles(this.fileExtension);
        int size = files.size();
        Assertions.assertTrue((size <= 11 ? (byte)1 : 0) != 0, (String)("Supposed to have up to 10 (or 11) files, but got " + size + ":" + Arrays.toString(files.toArray())));
    }

    @Test
    public void testParams() throws Exception {
        try {
            new JournalImpl(1023, 10, 10, 0, 0, this.fileFactory, this.filePrefix, this.fileExtension, 1);
            Assertions.fail((String)"Should throw exception");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        try {
            new JournalImpl(10240, 1, 0, 0, 0, this.fileFactory, this.filePrefix, this.fileExtension, 1);
            Assertions.fail((String)"Should throw exception");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        try {
            new JournalImpl(10240, 10, 0, 0, 0, null, this.filePrefix, this.fileExtension, 1);
            Assertions.fail((String)"Should throw exception");
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
        try {
            new JournalImpl(10240, 10, 0, 0, 0, this.fileFactory, null, this.fileExtension, 1);
            Assertions.fail((String)"Should throw exception");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        try {
            new JournalImpl(10240, 10, 0, 0, 0, this.fileFactory, this.filePrefix, null, 1);
            Assertions.fail((String)"Should throw exception");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        try {
            new JournalImpl(10240, 10, 0, 0, 0, this.fileFactory, this.filePrefix, null, 0);
            Assertions.fail((String)"Should throw exception");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void testVersionCheck() throws Exception {
        this.setup(10, 10240, true);
        this.createJournal();
        this.startJournal();
        this.load();
        this.stopJournal();
        this.fileFactory.start();
        List files = this.fileFactory.listFiles(this.fileExtension);
        for (String fileStr : files) {
            SequentialFile file = this.fileFactory.createSequentialFile(fileStr);
            ByteBuffer buffer = this.fileFactory.newBuffer(16);
            for (int i = 0; i < 16; ++i) {
                buffer.put((byte)127);
            }
            buffer.rewind();
            file.open();
            file.position(0L);
            file.writeDirect(buffer, this.sync);
            file.close();
        }
        this.fileFactory.stop();
        this.startJournal();
        boolean exceptionHappened = false;
        try {
            this.load();
        }
        catch (ActiveMQIOErrorException ioe) {
            exceptionHappened = true;
        }
        catch (ActiveMQException e) {
            Assertions.fail((String)("invalid exception type:" + e.getType()));
        }
        Assertions.assertTrue((boolean)exceptionHappened, (String)"Exception was expected");
        this.stopJournal();
    }

    @Test
    public void testMaxInt() throws Exception {
        this.setup(10, 10240, true);
        this.createJournal();
        this.startJournal();
        this.load();
        this.stopJournal();
        this.fileFactory.start();
        List files = this.fileFactory.listFiles(this.fileExtension);
        long fileID = Integer.MAX_VALUE;
        for (String fileStr : files) {
            SequentialFile file = this.fileFactory.createSequentialFile(fileStr);
            file.open();
            JournalImpl.initFileHeader((SequentialFileFactory)this.fileFactory, (SequentialFile)file, (int)this.journal.getUserVersion(), (long)fileID++);
            file.close();
        }
        this.fileFactory.stop();
        this.startJournal();
        this.load();
        long i = 0L;
        while (i < 100L) {
            this.add(i++);
            this.stopJournal();
            this.startJournal();
            this.loadAndCheck();
        }
        this.stopJournal();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testFilesImmediatelyAfterload() throws Exception {
        try {
            this.setup(10, 10240, true);
            this.createJournal();
            this.startJournal();
            this.load();
            List files = this.fileFactory.listFiles(this.fileExtension);
            Assertions.assertEquals((int)10, (int)files.size());
            for (String file : files) {
                Assertions.assertTrue((boolean)file.startsWith(this.filePrefix));
            }
            this.stopJournal();
            this.resetFileFactory();
            this.setup(20, 10240, true);
            this.createJournal();
            this.startJournal();
            this.load();
            files = this.fileFactory.listFiles(this.fileExtension);
            Assertions.assertEquals((int)20, (int)files.size());
            for (String file : files) {
                Assertions.assertTrue((boolean)file.startsWith(this.filePrefix));
            }
            this.stopJournal();
            this.fileExtension = "tim";
            this.resetFileFactory();
            this.setup(17, 10240, true);
            this.createJournal();
            this.startJournal();
            this.load();
            files = this.fileFactory.listFiles(this.fileExtension);
            Assertions.assertEquals((int)17, (int)files.size());
            for (String file : files) {
                Assertions.assertTrue((boolean)file.startsWith(this.filePrefix));
            }
            this.stopJournal();
            this.filePrefix = "echidna";
            this.resetFileFactory();
            this.setup(11, 10240, true);
            this.createJournal();
            this.startJournal();
            this.load();
            files = this.fileFactory.listFiles(this.fileExtension);
            Assertions.assertEquals((int)11, (int)files.size());
            for (String file : files) {
                Assertions.assertTrue((boolean)file.startsWith(this.filePrefix));
            }
            this.stopJournal();
        }
        finally {
            this.filePrefix = "amq";
            this.fileExtension = "amq";
        }
    }

    @Test
    public void testEmptyReopen() throws Exception {
        this.setup(2, 10240, true);
        this.createJournal();
        this.startJournal();
        this.load();
        List files1 = this.fileFactory.listFiles(this.fileExtension);
        Assertions.assertEquals((int)2, (int)files1.size());
        this.stopJournal();
        this.setup(2, 10240, true);
        this.createJournal();
        this.startJournal();
        this.load();
        List files2 = this.fileFactory.listFiles(this.fileExtension);
        Assertions.assertEquals((int)2, (int)files2.size());
        for (String file : files1) {
            Assertions.assertTrue((boolean)files2.contains(file));
        }
        this.stopJournal();
    }

    @Test
    public void testCreateFilesOnLoad() throws Exception {
        this.setup(10, 10240, true);
        this.createJournal();
        this.startJournal();
        this.load();
        List files1 = this.fileFactory.listFiles(this.fileExtension);
        Assertions.assertEquals((int)10, (int)files1.size());
        this.stopJournal();
        this.setup(20, 10240, true);
        this.createJournal();
        this.startJournal();
        this.load();
        List files2 = this.fileFactory.listFiles(this.fileExtension);
        Assertions.assertEquals((int)20, (int)files2.size());
        for (String file : files1) {
            Assertions.assertTrue((boolean)files2.contains(file));
        }
        this.stopJournal();
    }

    @Test
    public void testReduceFreeFiles() throws Exception {
        this.setup(10, 10240, true);
        this.createJournal();
        this.startJournal();
        this.load();
        List files1 = this.fileFactory.listFiles(this.fileExtension);
        Assertions.assertEquals((int)10, (int)files1.size());
        this.stopJournal();
        this.setup(5, 10240, true);
        this.createJournal();
        this.startJournal();
        this.load();
        List files2 = this.fileFactory.listFiles(this.fileExtension);
        Assertions.assertEquals((int)10, (int)files2.size());
        for (String file : files1) {
            Assertions.assertTrue((boolean)files2.contains(file));
        }
        this.stopJournal();
    }

    @Test
    public void testReduceFreeFilesWithCleanup() throws Exception {
        this.setup(10, 10240, true);
        this.createJournal();
        this.startJournal();
        this.load();
        List files1 = this.fileFactory.listFiles(this.fileExtension);
        Assertions.assertEquals((int)10, (int)files1.size());
        this.stopJournal();
        this.setup(5, 10240, true);
        this.createJournal();
        this.journal.setRemoveExtraFilesOnLoad(true);
        this.startJournal();
        this.load();
        List files2 = this.fileFactory.listFiles(this.fileExtension);
        Assertions.assertEquals((int)5, (int)files2.size());
        this.stopJournal();
    }

    private int calculateRecordsPerFile(int fileSize, int alignment, int recordSize) {
        recordSize = this.calculateRecordSize(recordSize, alignment);
        int headerSize = this.calculateRecordSize(16, alignment);
        return (fileSize - headerSize) / recordSize;
    }

    private int calculateNumberOfFiles(TestableJournal journal, int fileSize, int alignment, int ... record) throws Exception {
        int headerSize;
        if (journal != null) {
            journal.flush();
        }
        int currentPosition = headerSize = this.calculateRecordSize(16, alignment);
        int totalFiles = 0;
        for (int i = 0; i < record.length; i += 2) {
            int numberOfRecords = record[i];
            int recordSize = this.calculateRecordSize(record[i + 1], alignment);
            while (numberOfRecords > 0) {
                int recordsFit = (fileSize - currentPosition) / recordSize;
                if (numberOfRecords < recordsFit) {
                    currentPosition += numberOfRecords * recordSize;
                    numberOfRecords = 0;
                    continue;
                }
                if (recordsFit > 0) {
                    currentPosition += recordsFit * recordSize;
                    numberOfRecords -= recordsFit;
                    continue;
                }
                ++totalFiles;
                currentPosition = headerSize;
            }
        }
        return totalFiles;
    }

    @Test
    public void testCheckCreateMoreFiles() throws Exception {
        this.setup(2, 10240, true);
        this.createJournal();
        this.startJournal();
        this.load();
        List files1 = this.fileFactory.listFiles(this.fileExtension);
        Assertions.assertEquals((int)2, (int)files1.size());
        Assertions.assertEquals((int)0, (int)this.journal.getDataFilesCount());
        Assertions.assertEquals((int)0, (int)this.journal.getFreeFilesCount());
        Assertions.assertEquals((int)1, (int)this.journal.getOpenedFilesCount());
        Assertions.assertEquals((int)0, (int)this.journal.getIDMapSize());
        for (int i = 0; i < 91; ++i) {
            this.add(i);
        }
        int numberOfFiles = this.calculateNumberOfFiles(this.journal, 10240, this.journal.getAlignment(), 91, 22 + this.recordLength);
        Assertions.assertEquals((int)numberOfFiles, (int)this.journal.getDataFilesCount());
        Assertions.assertEquals((int)0, (int)this.journal.getFreeFilesCount());
        Assertions.assertEquals((int)91, (int)this.journal.getIDMapSize());
        this.journal.processBackup();
        List files2 = this.fileFactory.listFiles(this.fileExtension);
        Assertions.assertEquals((int)(numberOfFiles + 2), (int)files2.size());
        Assertions.assertEquals((int)1, (int)this.journal.getOpenedFilesCount());
        for (Object file : files1) {
            Assertions.assertTrue((boolean)files2.contains(file));
        }
        for (int i = 90; i < 95; ++i) {
            this.add(i);
        }
        numberOfFiles = this.calculateNumberOfFiles(this.journal, 10240, this.journal.getAlignment(), 95, 22 + this.recordLength);
        Assertions.assertEquals((int)numberOfFiles, (int)this.journal.getDataFilesCount());
        Assertions.assertEquals((int)0, (int)this.journal.getFreeFilesCount());
        Assertions.assertEquals((int)95, (int)this.journal.getIDMapSize());
        List files3 = this.fileFactory.listFiles(this.fileExtension);
        Assertions.assertEquals((int)(numberOfFiles + 2), (int)files3.size());
        Assertions.assertEquals((int)1, (int)this.journal.getOpenedFilesCount());
        for (String file : files1) {
            Assertions.assertTrue((boolean)files3.contains(file));
        }
        for (int i = 95; i < 200; ++i) {
            this.add(i);
        }
        numberOfFiles = this.calculateNumberOfFiles(this.journal, 10240, this.journal.getAlignment(), 200, 22 + this.recordLength);
        Assertions.assertEquals((int)numberOfFiles, (int)this.journal.getDataFilesCount());
        Assertions.assertEquals((int)0, (int)this.journal.getFreeFilesCount());
        Assertions.assertEquals((int)200, (int)this.journal.getIDMapSize());
        this.journal.processBackup();
        List files4 = this.fileFactory.listFiles(this.fileExtension);
        Assertions.assertEquals((int)(numberOfFiles + 2), (int)files4.size());
        Assertions.assertEquals((int)1, (int)this.journal.getOpenedFilesCount());
        for (String file : files1) {
            Assertions.assertTrue((boolean)files4.contains(file));
        }
        this.stopJournal();
    }

    @Test
    public void testOrganicallyGrowNoLimit() throws Exception {
        int i;
        this.setup(2, -1, 10240, true, 50);
        this.createJournal();
        this.journal.setAutoReclaim(true);
        this.startJournal();
        this.load();
        List files1 = this.fileFactory.listFiles(this.fileExtension);
        Assertions.assertEquals((int)2, (int)files1.size());
        Assertions.assertEquals((int)0, (int)this.journal.getDataFilesCount());
        Assertions.assertEquals((int)0, (int)this.journal.getFreeFilesCount());
        Assertions.assertEquals((int)1, (int)this.journal.getOpenedFilesCount());
        Assertions.assertEquals((int)0, (int)this.journal.getIDMapSize());
        for (i = 0; i < 200; ++i) {
            this.add(i);
            this.journal.forceMoveNextFile();
        }
        for (i = 0; i < 200; ++i) {
            this.delete(i);
        }
        this.journal.forceMoveNextFile();
        this.journal.checkReclaimStatus();
        files1 = this.fileFactory.listFiles(this.fileExtension);
        Assertions.assertTrue((files1.size() > 200 ? (byte)1 : 0) != 0);
        int numberOfFiles = files1.size();
        for (int i2 = 300; i2 < 350; ++i2) {
            this.add(i2);
            this.journal.forceMoveNextFile();
        }
        this.journal.checkReclaimStatus();
        files1 = this.fileFactory.listFiles(this.fileExtension);
        Assertions.assertTrue((files1.size() > 200 ? (byte)1 : 0) != 0);
        this.stopJournal();
    }

    @Test
    public void testOrganicallyWithALimit() throws Exception {
        int i;
        this.setup(2, 5, 10240, true, 50);
        this.createJournal();
        this.journal.setAutoReclaim(true);
        this.startJournal();
        this.load();
        List files1 = this.fileFactory.listFiles(this.fileExtension);
        Assertions.assertEquals((int)2, (int)files1.size());
        Assertions.assertEquals((int)0, (int)this.journal.getDataFilesCount());
        Assertions.assertEquals((int)0, (int)this.journal.getFreeFilesCount());
        Assertions.assertEquals((int)1, (int)this.journal.getOpenedFilesCount());
        Assertions.assertEquals((int)0, (int)this.journal.getIDMapSize());
        for (i = 0; i < 200; ++i) {
            this.add(i);
            this.journal.forceMoveNextFile();
        }
        this.journal.checkReclaimStatus();
        for (i = 0; i < 200; ++i) {
            this.delete(i);
        }
        this.journal.forceMoveNextFile();
        this.journal.checkReclaimStatus();
        files1 = this.fileFactory.listFiles(this.fileExtension);
        Assertions.assertTrue((files1.size() < 10 ? (byte)1 : 0) != 0, (String)("supposed to have less than 10 but it had " + files1.size() + " files created"));
        this.stopJournal();
    }

    @Test
    public void testCalculations() throws Exception {
        Assertions.assertEquals((int)0, (int)this.calculateNumberOfFiles(this.journal, 10240, 1, 1, 10, 2, 20));
        Assertions.assertEquals((int)0, (int)this.calculateNumberOfFiles(this.journal, 10240, 512, 1, 1));
        Assertions.assertEquals((int)0, (int)this.calculateNumberOfFiles(this.journal, 10240, 512, 19, 10));
        Assertions.assertEquals((int)1, (int)this.calculateNumberOfFiles(this.journal, 10240, 512, 20, 10));
        Assertions.assertEquals((int)0, (int)this.calculateNumberOfFiles(this.journal, 3000, 500, 2, 1000, 1, 500));
        Assertions.assertEquals((int)1, (int)this.calculateNumberOfFiles(this.journal, 3000, 500, 2, 1000, 1, 1000));
        Assertions.assertEquals((int)9, (int)this.calculateNumberOfFiles(this.journal, 10240, 1, 90, 1038, 45, 10));
        Assertions.assertEquals((int)11, (int)this.calculateNumberOfFiles(this.journal, 10240, 512, 60, 1038, 30, 14));
    }

    @Test
    public void testReclaim() throws Exception {
        int i;
        int i2;
        this.setup(10, 10240, true);
        this.createJournal();
        this.startJournal();
        this.load();
        List files1 = this.fileFactory.listFiles(this.fileExtension);
        Assertions.assertEquals((int)10, (int)files1.size());
        Assertions.assertEquals((int)0, (int)this.journal.getDataFilesCount());
        Assertions.assertEquals((int)8, (int)this.journal.getFreeFilesCount());
        Assertions.assertEquals((int)1, (int)this.journal.getOpenedFilesCount());
        Assertions.assertEquals((int)0, (int)this.journal.getIDMapSize());
        int addRecordsPerFile = this.calculateRecordsPerFile(10240, this.journal.getAlignment(), 23 + this.recordLength);
        logger.debug("{}", (Object)(23 + this.recordLength));
        int initialNumberOfAddRecords = addRecordsPerFile * 10;
        for (int i3 = 0; i3 < initialNumberOfAddRecords; ++i3) {
            this.add(i3);
        }
        Assertions.assertEquals((int)9, (int)this.journal.getDataFilesCount());
        Assertions.assertEquals((int)0, (int)this.journal.getFreeFilesCount());
        Assertions.assertEquals((int)initialNumberOfAddRecords, (int)this.journal.getIDMapSize());
        this.journal.processBackup();
        List files4 = this.fileFactory.listFiles(this.fileExtension);
        Assertions.assertEquals((int)11, (int)files4.size());
        Assertions.assertEquals((int)1, (int)this.journal.getOpenedFilesCount());
        for (String file : files1) {
            Assertions.assertTrue((boolean)files4.contains(file));
        }
        for (i2 = 0; i2 < initialNumberOfAddRecords / 2; ++i2) {
            this.delete(i2);
        }
        Assertions.assertEquals((int)0, (int)this.journal.getFreeFilesCount());
        Assertions.assertEquals((int)(initialNumberOfAddRecords / 2), (int)this.journal.getIDMapSize());
        for (i2 = 0; i2 < 10; ++i2) {
            this.add(initialNumberOfAddRecords + i2);
        }
        Assertions.assertEquals((int)0, (int)this.journal.getFreeFilesCount());
        Assertions.assertEquals((int)(initialNumberOfAddRecords / 2 + 10), (int)this.journal.getIDMapSize());
        this.checkAndReclaimFiles();
        Assertions.assertEquals((int)(this.journal.getAlignment() == 1 ? 6 : 7), (int)this.journal.getDataFilesCount());
        Assertions.assertEquals((int)(this.journal.getAlignment() == 1 ? 2 : 1), (int)this.journal.getFreeFilesCount());
        Assertions.assertEquals((int)(initialNumberOfAddRecords / 2 + 10), (int)this.journal.getIDMapSize());
        List files5 = this.fileFactory.listFiles(this.fileExtension);
        Assertions.assertEquals((int)10, (int)files5.size());
        Assertions.assertEquals((int)1, (int)this.journal.getOpenedFilesCount());
        for (i = initialNumberOfAddRecords / 2; i < initialNumberOfAddRecords + 10; ++i) {
            this.delete(i);
        }
        for (i = 110; i < 120; ++i) {
            this.add(i);
            this.delete(i);
        }
        this.checkAndReclaimFiles();
        Assertions.assertEquals((int)(this.journal.getAlignment() == 1 ? 0 : 1), (int)this.journal.getDataFilesCount());
        Assertions.assertEquals((int)(this.journal.getAlignment() == 1 ? 8 : 7), (int)this.journal.getFreeFilesCount());
        Assertions.assertEquals((int)0, (int)this.journal.getIDMapSize());
        List files6 = this.fileFactory.listFiles(this.fileExtension);
        Assertions.assertEquals((int)10, (int)files6.size());
        Assertions.assertEquals((int)1, (int)this.journal.getOpenedFilesCount());
        this.stopJournal();
    }

    @Test
    public void testReclaimAddUpdateDeleteDifferentFiles1() throws Exception {
        this.setup(2, this.calculateRecordSize(16, this.getAlignment()) + this.calculateRecordSize(23 + this.recordLength, this.getAlignment()), true);
        this.createJournal();
        this.startJournal();
        this.load();
        this.add(1L);
        this.update(1L);
        this.delete(1L);
        this.journal.processBackup();
        List files1 = this.fileFactory.listFiles(this.fileExtension);
        Assertions.assertEquals((int)4, (int)files1.size());
        Assertions.assertEquals((int)1, (int)this.journal.getOpenedFilesCount());
        Assertions.assertEquals((int)2, (int)this.journal.getDataFilesCount());
        Assertions.assertEquals((int)0, (int)this.journal.getFreeFilesCount());
        Assertions.assertEquals((int)0, (int)this.journal.getIDMapSize());
        this.checkAndReclaimFiles();
        List files2 = this.fileFactory.listFiles(this.fileExtension);
        Assertions.assertEquals((int)4, (int)files2.size());
        Assertions.assertEquals((int)1, (int)this.journal.getOpenedFilesCount());
        Assertions.assertEquals((int)2, (int)this.journal.getDataFilesCount());
        Assertions.assertEquals((int)0, (int)this.journal.getFreeFilesCount());
        Assertions.assertEquals((int)0, (int)this.journal.getIDMapSize());
        this.stopJournal();
    }

    @Test
    public void testReclaimAddUpdateDeleteDifferentFiles2() throws Exception {
        this.setup(2, this.calculateRecordSize(16, this.getAlignment()) + this.calculateRecordSize(23 + this.recordLength, this.getAlignment()), true);
        this.createJournal();
        this.startJournal();
        this.load();
        this.add(1L);
        this.update(1L);
        this.add(2L);
        this.journal.processBackup();
        List files1 = this.fileFactory.listFiles(this.fileExtension);
        Assertions.assertEquals((int)4, (int)files1.size());
        Assertions.assertEquals((int)1, (int)this.journal.getOpenedFilesCount());
        Assertions.assertEquals((int)2, (int)this.journal.getDataFilesCount());
        Assertions.assertEquals((int)0, (int)this.journal.getFreeFilesCount());
        Assertions.assertEquals((int)2, (int)this.journal.getIDMapSize());
        this.checkAndReclaimFiles();
        List files2 = this.fileFactory.listFiles(this.fileExtension);
        Assertions.assertEquals((int)4, (int)files2.size());
        Assertions.assertEquals((int)1, (int)this.journal.getOpenedFilesCount());
        Assertions.assertEquals((int)2, (int)this.journal.getDataFilesCount());
        Assertions.assertEquals((int)0, (int)this.journal.getFreeFilesCount());
        Assertions.assertEquals((int)2, (int)this.journal.getIDMapSize());
        this.stopJournal();
    }

    @Test
    public void testReclaimTransactionalAddCommit() throws Exception {
        this.testReclaimTransactionalAdd(true);
    }

    @Test
    public void testReclaimTransactionalAddRollback() throws Exception {
        this.testReclaimTransactionalAdd(false);
    }

    private void testReclaimTransactionalAdd(boolean commit) throws Exception {
        this.setup(10, 10240, true);
        this.createJournal();
        this.startJournal();
        this.load();
        List files1 = this.fileFactory.listFiles(this.fileExtension);
        Assertions.assertEquals((int)10, (int)files1.size());
        Assertions.assertEquals((int)0, (int)this.journal.getDataFilesCount());
        Assertions.assertEquals((int)8, (int)this.journal.getFreeFilesCount());
        Assertions.assertEquals((int)1, (int)this.journal.getOpenedFilesCount());
        Assertions.assertEquals((int)0, (int)this.journal.getIDMapSize());
        for (int i = 0; i < 100; ++i) {
            this.addTx(1L, i);
        }
        this.journal.processBackup();
        Assertions.assertEquals((int)this.calculateNumberOfFiles(this.journal, this.fileSize, this.journal.getAlignment(), 100, this.recordLength), (int)this.journal.getDataFilesCount());
        Assertions.assertEquals((int)0, (int)this.journal.getFreeFilesCount());
        Assertions.assertEquals((int)0, (int)this.journal.getIDMapSize());
        List files2 = this.fileFactory.listFiles(this.fileExtension);
        Assertions.assertEquals((int)(this.calculateNumberOfFiles(this.journal, this.fileSize, this.journal.getAlignment(), 100, this.recordLength) + 2), (int)files2.size());
        Assertions.assertEquals((int)1, (int)this.journal.getOpenedFilesCount());
        for (Object file : files1) {
            Assertions.assertTrue((boolean)files2.contains(file));
        }
        this.checkAndReclaimFiles();
        Assertions.assertEquals((int)this.calculateNumberOfFiles(this.journal, this.fileSize, this.journal.getAlignment(), 100, this.recordLength), (int)this.journal.getDataFilesCount());
        Assertions.assertEquals((int)0, (int)this.journal.getFreeFilesCount());
        Assertions.assertEquals((int)0, (int)this.journal.getIDMapSize());
        this.journal.processBackup();
        List files3 = this.fileFactory.listFiles(this.fileExtension);
        Assertions.assertEquals((int)(this.calculateNumberOfFiles(this.journal, this.fileSize, this.journal.getAlignment(), 100, this.recordLength) + 2), (int)files3.size());
        Assertions.assertEquals((int)1, (int)this.journal.getOpenedFilesCount());
        for (Object file : files1) {
            Assertions.assertTrue((boolean)files3.contains(file));
        }
        for (int i = 100; i < 200; ++i) {
            this.updateTx(1L, i);
        }
        Assertions.assertEquals((int)this.calculateNumberOfFiles(this.journal, this.fileSize, this.journal.getAlignment(), 200, this.recordLength), (int)this.journal.getDataFilesCount());
        Assertions.assertEquals((int)0, (int)this.journal.getFreeFilesCount());
        Assertions.assertEquals((int)0, (int)this.journal.getIDMapSize());
        this.journal.processBackup();
        List files4 = this.fileFactory.listFiles(this.fileExtension);
        Assertions.assertEquals((int)(this.calculateNumberOfFiles(this.journal, this.fileSize, this.journal.getAlignment(), 200, this.recordLength) + 2), (int)files4.size());
        Assertions.assertEquals((int)1, (int)this.journal.getOpenedFilesCount());
        for (Object file : files1) {
            Assertions.assertTrue((boolean)files4.contains(file));
        }
        this.checkAndReclaimFiles();
        Assertions.assertEquals((int)0, (int)this.journal.getFreeFilesCount());
        Assertions.assertEquals((int)0, (int)this.journal.getIDMapSize());
        this.journal.processBackup();
        List files5 = this.fileFactory.listFiles(this.fileExtension);
        Assertions.assertEquals((int)24, (int)files5.size());
        Assertions.assertEquals((int)1, (int)this.journal.getOpenedFilesCount());
        for (Object file : files1) {
            Assertions.assertTrue((boolean)files5.contains(file));
        }
        for (int i = 0; i < 200; ++i) {
            this.deleteTx(1L, i);
        }
        Assertions.assertEquals((int)0, (int)this.journal.getFreeFilesCount());
        Assertions.assertEquals((int)0, (int)this.journal.getIDMapSize());
        this.journal.processBackup();
        List files7 = this.fileFactory.listFiles(this.fileExtension);
        Assertions.assertEquals((int)1, (int)this.journal.getOpenedFilesCount());
        for (Object file : files1) {
            Assertions.assertTrue((boolean)files7.contains(file));
        }
        this.checkAndReclaimFiles();
        Assertions.assertEquals((int)0, (int)this.journal.getFreeFilesCount());
        Assertions.assertEquals((int)0, (int)this.journal.getIDMapSize());
        this.journal.processBackup();
        List files8 = this.fileFactory.listFiles(this.fileExtension);
        Assertions.assertEquals((int)1, (int)this.journal.getOpenedFilesCount());
        for (String file : files1) {
            Assertions.assertTrue((boolean)files8.contains(file));
        }
        if (commit) {
            this.commit(1L);
        } else {
            this.rollback(1L);
        }
        for (int i = 200; i < 210; ++i) {
            this.add(i);
        }
        Assertions.assertEquals((int)0, (int)this.journal.getFreeFilesCount());
        Assertions.assertEquals((int)10, (int)this.journal.getIDMapSize());
        this.journal.processBackup();
        List files9 = this.fileFactory.listFiles(this.fileExtension);
        Assertions.assertEquals((int)1, (int)this.journal.getOpenedFilesCount());
        for (String file : files1) {
            Assertions.assertTrue((boolean)files9.contains(file));
        }
        this.checkAndReclaimFiles();
        Assertions.assertEquals((int)10, (int)this.journal.getIDMapSize());
    }

    @Test
    public void testReclaimTransactionalSimple() throws Exception {
        this.setup(2, this.calculateRecordSize(16, this.getAlignment()) + this.calculateRecordSize(this.recordLength, this.getAlignment()), true);
        this.createJournal();
        this.startJournal();
        this.load();
        this.journal.processBackup();
        List files1 = this.fileFactory.listFiles(this.fileExtension);
        Assertions.assertEquals((int)2, (int)files1.size());
        Assertions.assertEquals((int)0, (int)this.journal.getDataFilesCount());
        Assertions.assertEquals((int)0, (int)this.journal.getFreeFilesCount());
        Assertions.assertEquals((int)1, (int)this.journal.getOpenedFilesCount());
        Assertions.assertEquals((int)0, (int)this.journal.getIDMapSize());
        this.addTx(1L, 1L);
        this.deleteTx(1L, 1L);
        this.journal.debugWait();
        if (logger.isDebugEnabled()) {
            logger.debug("journal tmp : {}", (Object)this.journal.debug());
        }
        this.journal.processBackup();
        List files2 = this.fileFactory.listFiles(this.fileExtension);
        Assertions.assertEquals((int)3, (int)files2.size());
        Assertions.assertEquals((int)1, (int)this.journal.getOpenedFilesCount());
        Assertions.assertEquals((int)1, (int)this.journal.getDataFilesCount());
        Assertions.assertEquals((int)0, (int)this.journal.getFreeFilesCount());
        Assertions.assertEquals((int)0, (int)this.journal.getIDMapSize());
        this.addWithSize(this.recordLength - 22 - 1, 2L);
        this.journal.debugWait();
        if (logger.isDebugEnabled()) {
            logger.debug("journal tmp2 : {}", (Object)this.journal.debug());
        }
        this.journal.processBackup();
        List files3 = this.fileFactory.listFiles(this.fileExtension);
        Assertions.assertEquals((int)4, (int)files3.size());
        Assertions.assertEquals((int)1, (int)this.journal.getOpenedFilesCount());
        logger.debug("data files count {}", (Object)this.journal.getDataFilesCount());
        logger.debug("free files count {}", (Object)this.journal.getFreeFilesCount());
        Assertions.assertEquals((int)2, (int)this.journal.getDataFilesCount());
        Assertions.assertEquals((int)0, (int)this.journal.getFreeFilesCount());
        Assertions.assertEquals((int)1, (int)this.journal.getIDMapSize());
        this.commit(1L);
        this.journal.processBackup();
        List files4 = this.fileFactory.listFiles(this.fileExtension);
        Assertions.assertEquals((int)5, (int)files4.size());
        Assertions.assertEquals((int)1, (int)this.journal.getOpenedFilesCount());
        Assertions.assertEquals((int)3, (int)this.journal.getDataFilesCount());
        Assertions.assertEquals((int)0, (int)this.journal.getFreeFilesCount());
        Assertions.assertEquals((int)1, (int)this.journal.getIDMapSize());
        this.addWithSize(this.recordLength - 22 - 1, 3L);
        this.journal.processBackup();
        List files5 = this.fileFactory.listFiles(this.fileExtension);
        Assertions.assertEquals((int)6, (int)files5.size());
        Assertions.assertEquals((int)1, (int)this.journal.getOpenedFilesCount());
        Assertions.assertEquals((int)4, (int)this.journal.getDataFilesCount());
        Assertions.assertEquals((int)0, (int)this.journal.getFreeFilesCount());
        Assertions.assertEquals((int)2, (int)this.journal.getIDMapSize());
        this.checkAndReclaimFiles();
        this.journal.processBackup();
        List files6 = this.fileFactory.listFiles(this.fileExtension);
        Assertions.assertEquals((int)3, (int)files6.size());
        Assertions.assertEquals((int)1, (int)this.journal.getOpenedFilesCount());
        Assertions.assertEquals((int)1, (int)this.journal.getDataFilesCount());
        Assertions.assertEquals((int)0, (int)this.journal.getFreeFilesCount());
        Assertions.assertEquals((int)2, (int)this.journal.getIDMapSize());
        this.journal.checkReclaimStatus();
        if (logger.isDebugEnabled()) {
            logger.debug("journal: {}", (Object)this.journal.debug());
        }
        this.stopJournal(false);
        this.createJournal();
        this.startJournal();
        this.loadAndCheck();
        Assertions.assertEquals((int)3, (int)files6.size());
        Assertions.assertEquals((int)1, (int)this.journal.getOpenedFilesCount());
        Assertions.assertEquals((int)1, (int)this.journal.getDataFilesCount());
        Assertions.assertEquals((int)0, (int)this.journal.getFreeFilesCount());
        Assertions.assertEquals((int)2, (int)this.journal.getIDMapSize());
    }

    @Test
    public void testAddDeleteCommitTXIDMap1() throws Exception {
        this.setup(10, 10240, true);
        this.createJournal();
        this.startJournal();
        this.load();
        this.journal.processBackup();
        List files1 = this.fileFactory.listFiles(this.fileExtension);
        Assertions.assertEquals((int)10, (int)files1.size());
        Assertions.assertEquals((int)0, (int)this.journal.getDataFilesCount());
        Assertions.assertEquals((int)8, (int)this.journal.getFreeFilesCount());
        Assertions.assertEquals((int)1, (int)this.journal.getOpenedFilesCount());
        Assertions.assertEquals((int)0, (int)this.journal.getIDMapSize());
        this.addTx(1L, 1L);
        Assertions.assertEquals((int)0, (int)this.journal.getDataFilesCount());
        Assertions.assertEquals((int)8, (int)this.journal.getFreeFilesCount());
        Assertions.assertEquals((int)1, (int)this.journal.getOpenedFilesCount());
        Assertions.assertEquals((int)0, (int)this.journal.getIDMapSize());
        this.deleteTx(1L, 1L);
        Assertions.assertEquals((int)0, (int)this.journal.getDataFilesCount());
        Assertions.assertEquals((int)8, (int)this.journal.getFreeFilesCount());
        Assertions.assertEquals((int)1, (int)this.journal.getOpenedFilesCount());
        Assertions.assertEquals((int)0, (int)this.journal.getIDMapSize());
        this.commit(1L);
        Assertions.assertEquals((int)0, (int)this.journal.getDataFilesCount());
        Assertions.assertEquals((int)8, (int)this.journal.getFreeFilesCount());
        Assertions.assertEquals((int)1, (int)this.journal.getOpenedFilesCount());
        Assertions.assertEquals((int)0, (int)this.journal.getIDMapSize());
    }

    @Test
    public void testAddCommitTXIDMap1() throws Exception {
        this.setup(10, 10240, true);
        this.createJournal();
        this.startJournal();
        this.load();
        this.journal.processBackup();
        List files1 = this.fileFactory.listFiles(this.fileExtension);
        Assertions.assertEquals((int)10, (int)files1.size());
        Assertions.assertEquals((int)0, (int)this.journal.getDataFilesCount());
        Assertions.assertEquals((int)8, (int)this.journal.getFreeFilesCount());
        Assertions.assertEquals((int)1, (int)this.journal.getOpenedFilesCount());
        Assertions.assertEquals((int)0, (int)this.journal.getIDMapSize());
        this.addTx(1L, 1L);
        Assertions.assertEquals((int)0, (int)this.journal.getDataFilesCount());
        Assertions.assertEquals((int)8, (int)this.journal.getFreeFilesCount());
        Assertions.assertEquals((int)1, (int)this.journal.getOpenedFilesCount());
        Assertions.assertEquals((int)0, (int)this.journal.getIDMapSize());
        this.commit(1L);
        Assertions.assertEquals((int)0, (int)this.journal.getDataFilesCount());
        Assertions.assertEquals((int)8, (int)this.journal.getFreeFilesCount());
        Assertions.assertEquals((int)1, (int)this.journal.getOpenedFilesCount());
        Assertions.assertEquals((int)1, (int)this.journal.getIDMapSize());
    }

    @Test
    public void testAddDeleteCommitTXIDMap2() throws Exception {
        this.setup(10, 10240, true);
        this.createJournal();
        this.startJournal();
        this.load();
        this.journal.processBackup();
        List files1 = this.fileFactory.listFiles(this.fileExtension);
        Assertions.assertEquals((int)10, (int)files1.size());
        Assertions.assertEquals((int)0, (int)this.journal.getDataFilesCount());
        Assertions.assertEquals((int)8, (int)this.journal.getFreeFilesCount());
        Assertions.assertEquals((int)1, (int)this.journal.getOpenedFilesCount());
        Assertions.assertEquals((int)0, (int)this.journal.getIDMapSize());
        this.add(1L, 1L);
        Assertions.assertEquals((int)0, (int)this.journal.getDataFilesCount());
        Assertions.assertEquals((int)8, (int)this.journal.getFreeFilesCount());
        Assertions.assertEquals((int)1, (int)this.journal.getOpenedFilesCount());
        Assertions.assertEquals((int)1, (int)this.journal.getIDMapSize());
        this.deleteTx(1L, 1L);
        Assertions.assertEquals((int)0, (int)this.journal.getDataFilesCount());
        Assertions.assertEquals((int)8, (int)this.journal.getFreeFilesCount());
        Assertions.assertEquals((int)1, (int)this.journal.getOpenedFilesCount());
        Assertions.assertEquals((int)1, (int)this.journal.getIDMapSize());
        this.commit(1L);
        Assertions.assertEquals((int)0, (int)this.journal.getDataFilesCount());
        Assertions.assertEquals((int)8, (int)this.journal.getFreeFilesCount());
        Assertions.assertEquals((int)1, (int)this.journal.getOpenedFilesCount());
        Assertions.assertEquals((int)0, (int)this.journal.getIDMapSize());
    }

    @Test
    public void testAddDeleteRollbackTXIDMap1() throws Exception {
        this.setup(10, 10240, true);
        this.createJournal();
        this.startJournal();
        this.load();
        this.journal.processBackup();
        List files1 = this.fileFactory.listFiles(this.fileExtension);
        Assertions.assertEquals((int)10, (int)files1.size());
        Assertions.assertEquals((int)0, (int)this.journal.getDataFilesCount());
        Assertions.assertEquals((int)8, (int)this.journal.getFreeFilesCount());
        Assertions.assertEquals((int)1, (int)this.journal.getOpenedFilesCount());
        Assertions.assertEquals((int)0, (int)this.journal.getIDMapSize());
        this.addTx(1L, 1L);
        Assertions.assertEquals((int)0, (int)this.journal.getDataFilesCount());
        Assertions.assertEquals((int)8, (int)this.journal.getFreeFilesCount());
        Assertions.assertEquals((int)1, (int)this.journal.getOpenedFilesCount());
        Assertions.assertEquals((int)0, (int)this.journal.getIDMapSize());
        this.deleteTx(1L, 1L);
        Assertions.assertEquals((int)0, (int)this.journal.getDataFilesCount());
        Assertions.assertEquals((int)8, (int)this.journal.getFreeFilesCount());
        Assertions.assertEquals((int)1, (int)this.journal.getOpenedFilesCount());
        Assertions.assertEquals((int)0, (int)this.journal.getIDMapSize());
        this.rollback(1L);
        Assertions.assertEquals((int)0, (int)this.journal.getDataFilesCount());
        Assertions.assertEquals((int)8, (int)this.journal.getFreeFilesCount());
        Assertions.assertEquals((int)1, (int)this.journal.getOpenedFilesCount());
        Assertions.assertEquals((int)0, (int)this.journal.getIDMapSize());
    }

    @Test
    public void testAddRollbackTXIDMap1() throws Exception {
        this.setup(10, 10240, true);
        this.createJournal();
        this.startJournal();
        this.load();
        this.journal.processBackup();
        List files1 = this.fileFactory.listFiles(this.fileExtension);
        Assertions.assertEquals((int)10, (int)files1.size());
        Assertions.assertEquals((int)0, (int)this.journal.getDataFilesCount());
        Assertions.assertEquals((int)8, (int)this.journal.getFreeFilesCount());
        Assertions.assertEquals((int)1, (int)this.journal.getOpenedFilesCount());
        Assertions.assertEquals((int)0, (int)this.journal.getIDMapSize());
        this.addTx(1L, 1L);
        Assertions.assertEquals((int)0, (int)this.journal.getDataFilesCount());
        Assertions.assertEquals((int)8, (int)this.journal.getFreeFilesCount());
        Assertions.assertEquals((int)1, (int)this.journal.getOpenedFilesCount());
        Assertions.assertEquals((int)0, (int)this.journal.getIDMapSize());
        this.rollback(1L);
        Assertions.assertEquals((int)0, (int)this.journal.getDataFilesCount());
        Assertions.assertEquals((int)8, (int)this.journal.getFreeFilesCount());
        Assertions.assertEquals((int)1, (int)this.journal.getOpenedFilesCount());
        Assertions.assertEquals((int)0, (int)this.journal.getIDMapSize());
    }

    @Test
    public void testAddDeleteRollbackTXIDMap2() throws Exception {
        this.setup(10, 10240, true);
        this.createJournal();
        this.startJournal();
        this.load();
        this.journal.processBackup();
        List files1 = this.fileFactory.listFiles(this.fileExtension);
        Assertions.assertEquals((int)10, (int)files1.size());
        Assertions.assertEquals((int)0, (int)this.journal.getDataFilesCount());
        Assertions.assertEquals((int)8, (int)this.journal.getFreeFilesCount());
        Assertions.assertEquals((int)1, (int)this.journal.getOpenedFilesCount());
        Assertions.assertEquals((int)0, (int)this.journal.getIDMapSize());
        this.add(1L, 1L);
        Assertions.assertEquals((int)0, (int)this.journal.getDataFilesCount());
        Assertions.assertEquals((int)8, (int)this.journal.getFreeFilesCount());
        Assertions.assertEquals((int)1, (int)this.journal.getOpenedFilesCount());
        Assertions.assertEquals((int)1, (int)this.journal.getIDMapSize());
        this.deleteTx(1L, 1L);
        Assertions.assertEquals((int)0, (int)this.journal.getDataFilesCount());
        Assertions.assertEquals((int)8, (int)this.journal.getFreeFilesCount());
        Assertions.assertEquals((int)1, (int)this.journal.getOpenedFilesCount());
        Assertions.assertEquals((int)1, (int)this.journal.getIDMapSize());
        this.rollback(1L);
        Assertions.assertEquals((int)0, (int)this.journal.getDataFilesCount());
        Assertions.assertEquals((int)8, (int)this.journal.getFreeFilesCount());
        Assertions.assertEquals((int)1, (int)this.journal.getOpenedFilesCount());
        Assertions.assertEquals((int)1, (int)this.journal.getIDMapSize());
    }

    @Test
    public void testAddDeleteIDMap() throws Exception {
        this.setup(10, 10240, true);
        this.createJournal();
        this.startJournal();
        this.load();
        this.journal.processBackup();
        List files1 = this.fileFactory.listFiles(this.fileExtension);
        Assertions.assertEquals((int)10, (int)files1.size());
        Assertions.assertEquals((int)0, (int)this.journal.getDataFilesCount());
        Assertions.assertEquals((int)8, (int)this.journal.getFreeFilesCount());
        Assertions.assertEquals((int)1, (int)this.journal.getOpenedFilesCount());
        Assertions.assertEquals((int)0, (int)this.journal.getIDMapSize());
        this.add(1L);
        Assertions.assertEquals((int)0, (int)this.journal.getDataFilesCount());
        Assertions.assertEquals((int)8, (int)this.journal.getFreeFilesCount());
        Assertions.assertEquals((int)1, (int)this.journal.getOpenedFilesCount());
        Assertions.assertEquals((int)1, (int)this.journal.getIDMapSize());
        this.delete(1L);
        Assertions.assertEquals((int)0, (int)this.journal.getDataFilesCount());
        Assertions.assertEquals((int)8, (int)this.journal.getFreeFilesCount());
        Assertions.assertEquals((int)1, (int)this.journal.getOpenedFilesCount());
        Assertions.assertEquals((int)0, (int)this.journal.getIDMapSize());
    }

    @Test
    public void testCommitRecordsInFileReclaim() throws Exception {
        this.setup(2, this.calculateRecordSize(16, this.getAlignment()) + this.calculateRecordSize(this.recordLength, this.getAlignment()), true);
        this.createJournal();
        this.startJournal();
        this.load();
        this.journal.processBackup();
        List files1 = this.fileFactory.listFiles(this.fileExtension);
        Assertions.assertEquals((int)2, (int)files1.size());
        Assertions.assertEquals((int)0, (int)this.journal.getDataFilesCount());
        Assertions.assertEquals((int)0, (int)this.journal.getFreeFilesCount());
        Assertions.assertEquals((int)1, (int)this.journal.getOpenedFilesCount());
        Assertions.assertEquals((int)0, (int)this.journal.getIDMapSize());
        this.addTx(1L, 1L);
        this.journal.processBackup();
        List files2 = this.fileFactory.listFiles(this.fileExtension);
        Assertions.assertEquals((int)2, (int)files2.size());
        Assertions.assertEquals((int)0, (int)this.journal.getDataFilesCount());
        Assertions.assertEquals((int)0, (int)this.journal.getFreeFilesCount());
        Assertions.assertEquals((int)1, (int)this.journal.getOpenedFilesCount());
        Assertions.assertEquals((int)0, (int)this.journal.getIDMapSize());
        this.commit(1L);
        this.journal.processBackup();
        List files3 = this.fileFactory.listFiles(this.fileExtension);
        Assertions.assertEquals((int)3, (int)files3.size());
        Assertions.assertEquals((int)1, (int)this.journal.getDataFilesCount());
        Assertions.assertEquals((int)0, (int)this.journal.getFreeFilesCount());
        Assertions.assertEquals((int)1, (int)this.journal.getOpenedFilesCount());
        Assertions.assertEquals((int)1, (int)this.journal.getIDMapSize());
        this.addWithSize(this.recordLength - 22 - 1, 2L);
        this.journal.processBackup();
        List files4 = this.fileFactory.listFiles(this.fileExtension);
        Assertions.assertEquals((int)4, (int)files4.size());
        Assertions.assertEquals((int)2, (int)this.journal.getDataFilesCount());
        Assertions.assertEquals((int)0, (int)this.journal.getFreeFilesCount());
        Assertions.assertEquals((int)1, (int)this.journal.getOpenedFilesCount());
        Assertions.assertEquals((int)2, (int)this.journal.getIDMapSize());
        this.checkAndReclaimFiles();
        this.journal.processBackup();
        List files5 = this.fileFactory.listFiles(this.fileExtension);
        Assertions.assertEquals((int)4, (int)files5.size());
        Assertions.assertEquals((int)2, (int)this.journal.getDataFilesCount());
        Assertions.assertEquals((int)0, (int)this.journal.getFreeFilesCount());
        Assertions.assertEquals((int)1, (int)this.journal.getOpenedFilesCount());
        Assertions.assertEquals((int)2, (int)this.journal.getIDMapSize());
    }

    @Test
    public void testCommitRecordsInFileNoReclaim() throws Exception {
        this.setup(2, this.calculateRecordSize(16, this.getAlignment()) + this.calculateRecordSize(this.recordLength, this.getAlignment()) + 512, true);
        this.createJournal();
        this.startJournal();
        this.load();
        this.journal.processBackup();
        List files1 = this.fileFactory.listFiles(this.fileExtension);
        Assertions.assertEquals((int)2, (int)files1.size());
        Assertions.assertEquals((int)0, (int)this.journal.getDataFilesCount());
        Assertions.assertEquals((int)0, (int)this.journal.getFreeFilesCount());
        Assertions.assertEquals((int)1, (int)this.journal.getOpenedFilesCount());
        Assertions.assertEquals((int)0, (int)this.journal.getIDMapSize());
        this.addTx(1L, 1L);
        this.addWithSize(this.recordLength - 22 - 1, 2L);
        this.journal.processBackup();
        List files2 = this.fileFactory.listFiles(this.fileExtension);
        Assertions.assertEquals((int)3, (int)files2.size());
        Assertions.assertEquals((int)this.calculateNumberOfFiles(this.journal, this.fileSize, this.journal.getAlignment(), 2, this.recordLength), (int)this.journal.getDataFilesCount());
        Assertions.assertEquals((int)0, (int)this.journal.getFreeFilesCount());
        Assertions.assertEquals((int)1, (int)this.journal.getOpenedFilesCount());
        Assertions.assertEquals((int)1, (int)this.journal.getIDMapSize());
        this.commit(1L);
        this.journal.processBackup();
        List files3 = this.fileFactory.listFiles(this.fileExtension);
        Assertions.assertEquals((int)(this.calculateNumberOfFiles(this.journal, this.fileSize, this.journal.getAlignment(), 2, this.recordLength, 1, 22) + 2), (int)files3.size());
        Assertions.assertEquals((int)1, (int)this.journal.getOpenedFilesCount());
        Assertions.assertEquals((int)this.calculateNumberOfFiles(this.journal, this.fileSize, this.journal.getAlignment(), 2, this.recordLength, 1, 21), (int)this.journal.getDataFilesCount());
        Assertions.assertEquals((int)0, (int)this.journal.getFreeFilesCount());
        Assertions.assertEquals((int)2, (int)this.journal.getIDMapSize());
        this.delete(2L);
        this.journal.processBackup();
        List files4 = this.fileFactory.listFiles(this.fileExtension);
        Assertions.assertEquals((int)(this.calculateNumberOfFiles(this.journal, this.fileSize, this.journal.getAlignment(), 2, this.recordLength, 1, 22, 1, 18) + 2), (int)files4.size());
        Assertions.assertEquals((int)1, (int)this.journal.getOpenedFilesCount());
        Assertions.assertEquals((int)this.calculateNumberOfFiles(this.journal, this.fileSize, this.journal.getAlignment(), 2, this.recordLength, 1, 22, 1, 18), (int)this.journal.getDataFilesCount());
        Assertions.assertEquals((int)0, (int)this.journal.getFreeFilesCount());
        Assertions.assertEquals((int)1, (int)this.journal.getIDMapSize());
        this.addWithSize(this.recordLength - 22, 3L);
        this.journal.processBackup();
        List files5 = this.fileFactory.listFiles(this.fileExtension);
        Assertions.assertEquals((int)0, (int)this.journal.getFreeFilesCount());
        Assertions.assertEquals((int)1, (int)this.journal.getOpenedFilesCount());
        Assertions.assertEquals((int)2, (int)this.journal.getIDMapSize());
        this.checkAndReclaimFiles();
        this.journal.processBackup();
        List files6 = this.fileFactory.listFiles(this.fileExtension);
        Assertions.assertEquals((int)0, (int)this.journal.getFreeFilesCount());
        Assertions.assertEquals((int)1, (int)this.journal.getOpenedFilesCount());
        Assertions.assertEquals((int)2, (int)this.journal.getIDMapSize());
        this.stopJournal();
        this.createJournal();
        this.startJournal();
        this.loadAndCheck();
        Assertions.assertEquals((int)0, (int)this.journal.getFreeFilesCount());
        Assertions.assertEquals((int)1, (int)this.journal.getOpenedFilesCount());
        Assertions.assertEquals((int)2, (int)this.journal.getIDMapSize());
    }

    @Test
    public void testRollbackRecordsInFileNoReclaim() throws Exception {
        this.setup(2, this.calculateRecordSize(16, this.getAlignment()) + this.calculateRecordSize(this.recordLength, this.getAlignment()) + 512, true);
        this.createJournal();
        this.startJournal();
        this.load();
        this.journal.processBackup();
        List files1 = this.fileFactory.listFiles(this.fileExtension);
        Assertions.assertEquals((int)2, (int)files1.size());
        Assertions.assertEquals((int)0, (int)this.journal.getDataFilesCount());
        Assertions.assertEquals((int)0, (int)this.journal.getFreeFilesCount());
        Assertions.assertEquals((int)1, (int)this.journal.getOpenedFilesCount());
        Assertions.assertEquals((int)0, (int)this.journal.getIDMapSize());
        this.addTx(1L, 1L);
        this.addWithSize(this.recordLength - 22 - 1, 2L);
        this.journal.processBackup();
        List files2 = this.fileFactory.listFiles(this.fileExtension);
        Assertions.assertEquals((int)3, (int)files2.size());
        Assertions.assertEquals((int)1, (int)this.journal.getDataFilesCount());
        Assertions.assertEquals((int)0, (int)this.journal.getFreeFilesCount());
        Assertions.assertEquals((int)1, (int)this.journal.getOpenedFilesCount());
        Assertions.assertEquals((int)1, (int)this.journal.getIDMapSize());
        this.rollback(1L);
        Assertions.assertEquals((int)this.calculateNumberOfFiles(this.journal, this.fileSize, this.journal.getAlignment(), 2, this.recordLength, 1, 18), (int)this.journal.getDataFilesCount());
        Assertions.assertEquals((int)1, (int)this.journal.getOpenedFilesCount());
        Assertions.assertEquals((int)this.calculateNumberOfFiles(this.journal, this.fileSize, this.journal.getAlignment(), 2, this.recordLength, 1, 18), (int)this.journal.getDataFilesCount());
        Assertions.assertEquals((int)0, (int)this.journal.getFreeFilesCount());
        Assertions.assertEquals((int)1, (int)this.journal.getIDMapSize());
        this.delete(2L);
        this.journal.processBackup();
        List files4 = this.fileFactory.listFiles(this.fileExtension);
        Assertions.assertEquals((int)(this.calculateNumberOfFiles(this.journal, this.fileSize, this.journal.getAlignment(), 2, this.recordLength, 1, 18, 1, 18) + 2), (int)files4.size());
        Assertions.assertEquals((int)1, (int)this.journal.getOpenedFilesCount());
        Assertions.assertEquals((int)this.calculateNumberOfFiles(this.journal, this.fileSize, this.journal.getAlignment(), 2, this.recordLength, 1, 18, 1, 18), (int)this.journal.getDataFilesCount());
        Assertions.assertEquals((int)0, (int)this.journal.getFreeFilesCount());
        Assertions.assertEquals((int)0, (int)this.journal.getIDMapSize());
        this.addWithSize(this.recordLength - 22 - 1, 3L);
        Assertions.assertEquals((int)1, (int)this.journal.getOpenedFilesCount());
        Assertions.assertEquals((int)0, (int)this.journal.getFreeFilesCount());
        Assertions.assertEquals((int)1, (int)this.journal.getIDMapSize());
        this.checkAndReclaimFiles();
        this.journal.processBackup();
        List files6 = this.fileFactory.listFiles(this.fileExtension);
        Assertions.assertEquals((int)(this.journal.getAlignment() == 1 ? 2 : 3), (int)files6.size());
        Assertions.assertEquals((int)(this.journal.getAlignment() == 1 ? 0 : 1), (int)this.journal.getDataFilesCount());
        Assertions.assertEquals((int)0, (int)this.journal.getFreeFilesCount());
        Assertions.assertEquals((int)1, (int)this.journal.getOpenedFilesCount());
        Assertions.assertEquals((int)1, (int)this.journal.getIDMapSize());
        this.stopJournal();
        this.createJournal();
        this.startJournal();
        this.loadAndCheck();
        this.journal.processBackup();
        List files7 = this.fileFactory.listFiles(this.fileExtension);
        Assertions.assertEquals((int)(this.journal.getAlignment() == 1 ? 2 : 3), (int)files7.size());
        Assertions.assertEquals((int)(this.journal.getAlignment() == 1 ? 0 : 1), (int)this.journal.getDataFilesCount());
        Assertions.assertEquals((int)0, (int)this.journal.getFreeFilesCount());
        Assertions.assertEquals((int)1, (int)this.journal.getOpenedFilesCount());
        Assertions.assertEquals((int)1, (int)this.journal.getIDMapSize());
    }

    @Test
    public void testEmptyPrepare() throws Exception {
        this.setup(2, this.calculateRecordSize(16, this.getAlignment()) + this.calculateRecordSize(this.recordLength, this.getAlignment()) + 512, true);
        this.createJournal();
        this.startJournal();
        this.load();
        SimpleEncoding xid = new SimpleEncoding(10, 0);
        this.prepare(1L, xid);
        this.stopJournal();
        this.createJournal();
        this.startJournal();
        this.loadAndCheck();
        this.commit(1L);
        xid = new SimpleEncoding(10, 1);
        this.prepare(2L, xid);
        this.stopJournal();
        this.createJournal();
        this.startJournal();
        this.loadAndCheck();
        this.rollback(2L);
        this.stopJournal();
        this.createJournal();
        this.startJournal();
        this.loadAndCheck();
    }

    @Test
    public void testPrepareNoReclaim() throws Exception {
        this.setup(2, this.calculateRecordSize(16, this.getAlignment()) + this.calculateRecordSize(this.recordLength, this.getAlignment()) + 512, true);
        this.createJournal();
        this.startJournal();
        this.load();
        this.journal.processBackup();
        List files1 = this.fileFactory.listFiles(this.fileExtension);
        Assertions.assertEquals((int)2, (int)files1.size());
        Assertions.assertEquals((int)0, (int)this.journal.getDataFilesCount());
        Assertions.assertEquals((int)0, (int)this.journal.getFreeFilesCount());
        Assertions.assertEquals((int)1, (int)this.journal.getOpenedFilesCount());
        Assertions.assertEquals((int)0, (int)this.journal.getIDMapSize());
        this.addTx(1L, 1L);
        this.addWithSize(1002, 2L);
        this.journal.processBackup();
        List files2 = this.fileFactory.listFiles(this.fileExtension);
        Assertions.assertEquals((int)3, (int)files2.size());
        Assertions.assertEquals((int)this.calculateNumberOfFiles(this.journal, this.fileSize, this.journal.getAlignment(), 2, this.recordLength), (int)this.journal.getDataFilesCount());
        Assertions.assertEquals((int)0, (int)this.journal.getFreeFilesCount());
        Assertions.assertEquals((int)1, (int)this.journal.getOpenedFilesCount());
        Assertions.assertEquals((int)1, (int)this.journal.getIDMapSize());
        SimpleEncoding xid = new SimpleEncoding(10, 0);
        this.prepare(1L, xid);
        Assertions.assertEquals((int)0, (int)this.journal.getFreeFilesCount());
        Assertions.assertEquals((int)1, (int)this.journal.getIDMapSize());
        Assertions.assertEquals((int)1, (int)this.journal.getOpenedFilesCount());
        this.delete(2L);
        Assertions.assertEquals((int)1, (int)this.journal.getOpenedFilesCount());
        Assertions.assertEquals((int)0, (int)this.journal.getFreeFilesCount());
        Assertions.assertEquals((int)0, (int)this.journal.getIDMapSize());
        this.addWithSize(this.recordLength - 22 - 1, 3L);
        Assertions.assertEquals((int)1, (int)this.journal.getOpenedFilesCount());
        Assertions.assertEquals((int)0, (int)this.journal.getFreeFilesCount());
        Assertions.assertEquals((int)1, (int)this.journal.getIDMapSize());
        this.checkAndReclaimFiles();
        this.journal.processBackup();
        List files6 = this.fileFactory.listFiles(this.fileExtension);
        Assertions.assertEquals((int)4, (int)files6.size());
        Assertions.assertEquals((int)2, (int)this.journal.getDataFilesCount());
        Assertions.assertEquals((int)0, (int)this.journal.getFreeFilesCount());
        Assertions.assertEquals((int)1, (int)this.journal.getOpenedFilesCount());
        Assertions.assertEquals((int)1, (int)this.journal.getIDMapSize());
        this.addWithSize(this.recordLength - 22 - 1, 4L);
        this.journal.processBackup();
        List files7 = this.fileFactory.listFiles(this.fileExtension);
        Assertions.assertEquals((int)5, (int)files7.size());
        Assertions.assertEquals((int)3, (int)this.journal.getDataFilesCount());
        Assertions.assertEquals((int)0, (int)this.journal.getFreeFilesCount());
        Assertions.assertEquals((int)1, (int)this.journal.getOpenedFilesCount());
        Assertions.assertEquals((int)2, (int)this.journal.getIDMapSize());
        this.commit(1L);
        this.journal.processBackup();
        List files8 = this.fileFactory.listFiles(this.fileExtension);
        Assertions.assertEquals((int)5, (int)files8.size());
        Assertions.assertEquals((int)3, (int)this.journal.getDataFilesCount());
        Assertions.assertEquals((int)0, (int)this.journal.getFreeFilesCount());
        Assertions.assertEquals((int)1, (int)this.journal.getOpenedFilesCount());
        Assertions.assertEquals((int)3, (int)this.journal.getIDMapSize());
        this.stopJournal();
        this.createJournal();
        this.startJournal();
        this.loadAndCheck();
    }

    @Test
    public void testPrepareReclaim() throws Exception {
        this.setup(2, 102400, true);
        this.createJournal();
        this.startJournal();
        this.load();
        this.journal.processBackup();
        List files1 = this.fileFactory.listFiles(this.fileExtension);
        Assertions.assertEquals((int)2, (int)files1.size());
        Assertions.assertEquals((int)0, (int)this.journal.getDataFilesCount());
        Assertions.assertEquals((int)0, (int)this.journal.getFreeFilesCount());
        Assertions.assertEquals((int)1, (int)this.journal.getOpenedFilesCount());
        Assertions.assertEquals((int)0, (int)this.journal.getIDMapSize());
        this.addTx(1L, 1L);
        this.journal.processBackup();
        files1 = this.fileFactory.listFiles(this.fileExtension);
        Assertions.assertEquals((int)2, (int)files1.size());
        Assertions.assertEquals((int)0, (int)this.journal.getDataFilesCount());
        Assertions.assertEquals((int)0, (int)this.journal.getFreeFilesCount());
        Assertions.assertEquals((int)1, (int)this.journal.getOpenedFilesCount());
        Assertions.assertEquals((int)0, (int)this.journal.getIDMapSize());
        this.journal.forceMoveNextFile();
        this.journal.debugWait();
        this.addWithSize(this.recordLength - 22, 2L);
        this.journal.processBackup();
        List files2 = this.fileFactory.listFiles(this.fileExtension);
        Assertions.assertEquals((int)3, (int)files2.size());
        Assertions.assertEquals((int)1, (int)this.journal.getDataFilesCount());
        Assertions.assertEquals((int)0, (int)this.journal.getFreeFilesCount());
        Assertions.assertEquals((int)1, (int)this.journal.getIDMapSize());
        SimpleEncoding xid = new SimpleEncoding(10, 0);
        this.prepare(1L, xid);
        this.journal.processBackup();
        List files3 = this.fileFactory.listFiles(this.fileExtension);
        Assertions.assertEquals((int)3, (int)files3.size());
        Assertions.assertEquals((int)1, (int)this.journal.getDataFilesCount());
        Assertions.assertEquals((int)0, (int)this.journal.getFreeFilesCount());
        Assertions.assertEquals((int)1, (int)this.journal.getOpenedFilesCount());
        Assertions.assertEquals((int)1, (int)this.journal.getIDMapSize());
        this.delete(2L);
        this.journal.processBackup();
        List files4 = this.fileFactory.listFiles(this.fileExtension);
        Assertions.assertEquals((int)3, (int)files4.size());
        Assertions.assertEquals((int)1, (int)this.journal.getOpenedFilesCount());
        Assertions.assertEquals((int)1, (int)this.journal.getDataFilesCount());
        Assertions.assertEquals((int)0, (int)this.journal.getFreeFilesCount());
        Assertions.assertEquals((int)0, (int)this.journal.getIDMapSize());
        this.journal.forceMoveNextFile();
        this.addWithSize(1002, 3L);
        this.checkAndReclaimFiles();
        this.journal.processBackup();
        List files5 = this.fileFactory.listFiles(this.fileExtension);
        Assertions.assertEquals((int)4, (int)files5.size());
        Assertions.assertEquals((int)2, (int)this.journal.getDataFilesCount());
        Assertions.assertEquals((int)0, (int)this.journal.getFreeFilesCount());
        Assertions.assertEquals((int)1, (int)this.journal.getIDMapSize());
        Assertions.assertEquals((int)1, (int)this.journal.getOpenedFilesCount());
        this.checkAndReclaimFiles();
        this.journal.processBackup();
        List files6 = this.fileFactory.listFiles(this.fileExtension);
        Assertions.assertEquals((int)4, (int)files6.size());
        Assertions.assertEquals((int)2, (int)this.journal.getDataFilesCount());
        Assertions.assertEquals((int)0, (int)this.journal.getFreeFilesCount());
        Assertions.assertEquals((int)1, (int)this.journal.getIDMapSize());
        Assertions.assertEquals((int)1, (int)this.journal.getOpenedFilesCount());
        this.journal.forceMoveNextFile();
        this.addWithSize(1002, 4L);
        this.journal.processBackup();
        List files7 = this.fileFactory.listFiles(this.fileExtension);
        Assertions.assertEquals((int)5, (int)files7.size());
        Assertions.assertEquals((int)3, (int)this.journal.getDataFilesCount());
        Assertions.assertEquals((int)0, (int)this.journal.getFreeFilesCount());
        Assertions.assertEquals((int)1, (int)this.journal.getOpenedFilesCount());
        Assertions.assertEquals((int)2, (int)this.journal.getIDMapSize());
        this.commit(1L);
        this.journal.processBackup();
        List files8 = this.fileFactory.listFiles(this.fileExtension);
        Assertions.assertEquals((int)5, (int)files8.size());
        Assertions.assertEquals((int)3, (int)this.journal.getDataFilesCount());
        Assertions.assertEquals((int)0, (int)this.journal.getFreeFilesCount());
        Assertions.assertEquals((int)3, (int)this.journal.getIDMapSize());
        Assertions.assertEquals((int)1, (int)this.journal.getOpenedFilesCount());
        this.delete(1L);
        this.journal.processBackup();
        List files9 = this.fileFactory.listFiles(this.fileExtension);
        Assertions.assertEquals((int)5, (int)files9.size());
        Assertions.assertEquals((int)3, (int)this.journal.getDataFilesCount());
        Assertions.assertEquals((int)0, (int)this.journal.getFreeFilesCount());
        Assertions.assertEquals((int)1, (int)this.journal.getOpenedFilesCount());
        Assertions.assertEquals((int)2, (int)this.journal.getIDMapSize());
        this.checkAndReclaimFiles();
        this.journal.processBackup();
        List files10 = this.fileFactory.listFiles(this.fileExtension);
        Assertions.assertEquals((int)(this.journal.getAlignment() == 1 ? 5 : 5), (int)files10.size());
        Assertions.assertEquals((int)(this.journal.getAlignment() == 1 ? 3 : 3), (int)this.journal.getDataFilesCount());
        Assertions.assertEquals((int)0, (int)this.journal.getFreeFilesCount());
        Assertions.assertEquals((int)2, (int)this.journal.getIDMapSize());
        this.journal.forceMoveNextFile();
        this.addWithSize(1002, 5L);
        this.journal.processBackup();
        List files11 = this.fileFactory.listFiles(this.fileExtension);
        Assertions.assertEquals((int)6, (int)files11.size());
        Assertions.assertEquals((int)4, (int)this.journal.getDataFilesCount());
        Assertions.assertEquals((int)0, (int)this.journal.getFreeFilesCount());
        Assertions.assertEquals((int)1, (int)this.journal.getOpenedFilesCount());
        Assertions.assertEquals((int)3, (int)this.journal.getIDMapSize());
        this.checkAndReclaimFiles();
        this.journal.processBackup();
        List files12 = this.fileFactory.listFiles(this.fileExtension);
        Assertions.assertEquals((int)4, (int)files12.size());
        Assertions.assertEquals((int)1, (int)this.journal.getOpenedFilesCount());
        Assertions.assertEquals((int)2, (int)this.journal.getDataFilesCount());
        Assertions.assertEquals((int)0, (int)this.journal.getFreeFilesCount());
        Assertions.assertEquals((int)3, (int)this.journal.getIDMapSize());
        this.stopJournal();
        this.createJournal();
        this.startJournal();
        this.loadAndCheck();
        this.delete(4L);
        Assertions.assertEquals((int)1, (int)this.journal.getOpenedFilesCount());
        Assertions.assertEquals((int)0, (int)this.journal.getFreeFilesCount());
        Assertions.assertEquals((int)2, (int)this.journal.getIDMapSize());
        this.addWithSize(1002, 6L);
        if (logger.isDebugEnabled()) {
            logger.debug("Debug journal on testPrepareReclaim ->\n{}", (Object)this.debugJournal());
        }
        Assertions.assertEquals((int)1, (int)this.journal.getOpenedFilesCount());
        Assertions.assertEquals((int)0, (int)this.journal.getFreeFilesCount());
        Assertions.assertEquals((int)3, (int)this.journal.getIDMapSize());
        this.checkAndReclaimFiles();
        this.journal.processBackup();
        List files15 = this.fileFactory.listFiles(this.fileExtension);
        Assertions.assertEquals((int)4, (int)files15.size());
        Assertions.assertEquals((int)1, (int)this.journal.getOpenedFilesCount());
        Assertions.assertEquals((int)2, (int)this.journal.getDataFilesCount());
        Assertions.assertEquals((int)0, (int)this.journal.getFreeFilesCount());
        Assertions.assertEquals((int)3, (int)this.journal.getIDMapSize());
        this.stopJournal();
        this.createJournal();
        this.startJournal();
        this.loadAndCheck();
    }

    @Test
    public void testSimpleAdd() throws Exception {
        this.setup(2, 10240, true);
        this.createJournal();
        this.startJournal();
        this.load();
        this.sync = true;
        this.add(1L);
        this.stopJournal();
        this.createJournal();
        this.startJournal();
        this.loadAndCheck();
    }

    @Test
    public void testMultipleAdd() throws Exception {
        this.setup(10, 10240, true);
        this.createJournal();
        this.startJournal();
        this.load();
        this.add(1L, 2L, 3L, 4L, 5L, 6L, 7L, 8L, 9L, 10L);
        this.stopJournal();
        this.createJournal();
        this.startJournal();
        this.loadAndCheck();
    }

    @Test
    public void testMultipleAddNonContiguous() throws Exception {
        this.setup(10, 10240, true);
        this.createJournal();
        this.startJournal();
        this.load();
        this.add(1L, 3L, 5L, 7L, 10L, 13L, 56L, 100L, 102L, 200L, 201L, 202L, 203L);
        this.stopJournal();
        this.createJournal();
        this.startJournal();
        this.loadAndCheck();
        this.stopJournal();
    }

    @Test
    public void testSimpleAddUpdate() throws Exception {
        this.setup(10, 10240, true);
        this.createJournal();
        this.startJournal();
        this.load();
        this.add(1L);
        this.update(1L);
        this.stopJournal();
        this.createJournal();
        this.startJournal();
        this.loadAndCheck();
    }

    @Test
    public void testMultipleAddUpdate() throws Exception {
        this.setup(10, 10240, true);
        this.createJournal();
        this.startJournal();
        this.load();
        this.add(1L, 2L, 3L, 4L, 5L, 6L, 7L, 8L, 9L, 10L);
        this.update(1L, 2L, 4L, 7L, 9L, 10L);
        this.stopJournal();
        this.createJournal();
        this.startJournal();
        this.loadAndCheck();
    }

    @Test
    public void testDoubleDelete() throws Exception {
        try (AssertionLoggerHandler loggerHandler = new AssertionLoggerHandler(true);){
            this.setup(10, 10240, true);
            this.createJournal();
            this.startJournal();
            this.load();
            byte[] record = this.generateRecord(100);
            this.add(1L);
            this.journal.appendAddRecord(2L, (byte)0, record, this.sync);
            Thread[] threads = new Thread[100];
            CountDownLatch alignLatch = new CountDownLatch(threads.length);
            CountDownLatch startFlag = new CountDownLatch(1);
            for (int i = 0; i < threads.length; ++i) {
                threads[i] = new Thread(() -> {
                    alignLatch.countDown();
                    try {
                        startFlag.await(5L, TimeUnit.SECONDS);
                        this.journal.appendDeleteRecord(2L, false);
                    }
                    catch (IllegalStateException illegalStateException) {
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                });
                threads[i].start();
            }
            Assertions.assertTrue((boolean)alignLatch.await(5L, TimeUnit.SECONDS));
            startFlag.countDown();
            for (Thread t : threads) {
                t.join(TimeUnit.SECONDS.toMillis(10L));
                Assertions.assertFalse((boolean)t.isAlive());
            }
            this.journal.flush();
            Assertions.assertFalse((boolean)loggerHandler.findTrace("NullPointerException"));
            this.stopJournal();
            this.createJournal();
            this.startJournal();
            this.loadAndCheck();
        }
    }

    @Test
    public void testMultipleAddUpdateAll() throws Exception {
        this.setup(10, 10240, true);
        this.createJournal();
        this.startJournal();
        this.load();
        this.add(1L, 2L, 3L, 4L, 5L, 6L, 7L, 8L, 9L, 10L);
        this.update(1L, 2L, 3L, 4L, 5L, 6L, 7L, 8L, 9L, 10L);
        this.stopJournal();
        this.createJournal();
        this.startJournal();
        this.loadAndCheck();
    }

    @Test
    public void testMultipleAddUpdateNonContiguous() throws Exception {
        this.setup(10, 10240, true);
        this.createJournal();
        this.startJournal();
        this.load();
        this.add(1L, 3L, 5L, 7L, 10L, 13L, 56L, 100L, 102L, 200L, 201L, 202L, 203L);
        this.add(3L, 7L, 10L, 13L, 56L, 100L, 200L, 202L, 203L);
        this.stopJournal();
        this.createJournal();
        this.startJournal();
        this.loadAndCheck();
    }

    @Test
    public void testMultipleAddUpdateAllNonContiguous() throws Exception {
        this.setup(10, 10240, true);
        this.createJournal();
        this.startJournal();
        this.load();
        this.add(1L, 3L, 5L, 7L, 10L, 13L, 56L, 100L, 102L, 200L, 201L, 202L, 203L);
        this.update(1L, 3L, 5L, 7L, 10L, 13L, 56L, 100L, 102L, 200L, 201L, 202L, 203L);
        this.stopJournal();
        this.createJournal();
        this.startJournal();
        this.loadAndCheck();
    }

    @Test
    public void testSimpleAddUpdateDelete() throws Exception {
        this.setup(10, 10240, true);
        this.createJournal();
        this.startJournal();
        this.load();
        this.add(1L);
        this.update(1L);
        this.delete(1L);
        this.stopJournal();
        this.createJournal();
        this.startJournal();
        this.loadAndCheck();
    }

    @Test
    public void testSimpleAddUpdateDeleteTransactional() throws Exception {
        this.setup(10, 10240, true);
        this.createJournal();
        this.startJournal();
        this.load();
        this.addTx(1L, 1L);
        this.commit(1L);
        this.updateTx(2L, 1L);
        this.commit(2L);
        this.deleteTx(3L, 1L);
        this.commit(3L);
        this.stopJournal();
        this.createJournal();
        this.startJournal();
        this.loadAndCheck();
    }

    @Test
    public void testMultipleAddUpdateDelete() throws Exception {
        this.setup(10, 10240, true);
        this.createJournal();
        this.startJournal();
        this.load();
        this.add(1L, 2L, 3L, 4L, 5L, 6L, 7L, 8L, 9L, 10L);
        this.update(1L, 2L, 4L, 7L, 9L, 10L);
        this.delete(1L, 4L, 7L, 9L, 10L);
        this.stopJournal();
        this.createJournal();
        this.startJournal();
        this.loadAndCheck();
    }

    @Test
    public void testMultipleAddUpdateDeleteAll() throws Exception {
        this.setup(10, 10240, true);
        this.createJournal();
        this.startJournal();
        this.load();
        this.add(1L, 2L, 3L, 4L, 5L, 6L, 7L, 8L, 9L, 10L);
        this.update(1L, 2L, 3L, 4L, 5L, 6L, 7L, 8L, 9L, 10L);
        this.update(1L, 2L, 3L, 4L, 5L, 6L, 7L, 8L, 9L, 10L);
        this.stopJournal();
        this.createJournal();
        this.startJournal();
        this.loadAndCheck();
    }

    @Test
    public void testMultipleAddUpdateDeleteNonContiguous() throws Exception {
        this.setup(10, 10240, true);
        this.createJournal();
        this.startJournal();
        this.load();
        this.add(1L, 3L, 5L, 7L, 10L, 13L, 56L, 100L, 102L, 200L, 201L, 202L, 203L);
        this.add(3L, 7L, 10L, 13L, 56L, 100L, 200L, 202L, 203L);
        this.delete(3L, 10L, 56L, 100L, 200L, 203L);
        this.stopJournal();
        this.createJournal();
        this.startJournal();
        this.loadAndCheck();
    }

    @Test
    public void testMultipleAddUpdateDeleteAllNonContiguous() throws Exception {
        this.setup(10, 10240, true);
        this.createJournal();
        this.startJournal();
        this.load();
        this.add(1L, 3L, 5L, 7L, 10L, 13L, 56L, 100L, 102L, 200L, 201L, 202L, 203L);
        this.update(1L, 3L, 5L, 7L, 10L, 13L, 56L, 100L, 102L, 200L, 201L, 202L, 203L);
        this.delete(1L, 3L, 5L, 7L, 10L, 13L, 56L, 100L, 102L, 200L, 201L, 202L, 203L);
        this.stopJournal();
        this.createJournal();
        this.startJournal();
        this.loadAndCheck();
    }

    @Test
    public void testMultipleAddUpdateDeleteDifferentOrder() throws Exception {
        this.setup(10, 10240, true);
        this.createJournal();
        this.startJournal();
        this.load();
        this.add(1L, 3L, 5L, 7L, 10L, 13L, 56L, 100L, 102L, 200L, 201L, 202L, 203L);
        this.update(203L, 202L, 201L, 200L, 102L, 100L, 1L, 3L, 5L, 7L, 10L, 13L, 56L);
        this.delete(56L, 13L, 10L, 7L, 5L, 3L, 1L, 203L, 202L, 201L, 200L, 102L, 100L);
        this.stopJournal();
        this.createJournal();
        this.startJournal();
        this.loadAndCheck();
    }

    @Test
    public void testMultipleAddUpdateDeleteDifferentRecordLengths() throws Exception {
        byte[] record;
        int i;
        this.setup(10, 20480, true);
        this.createJournal();
        this.startJournal();
        this.load();
        for (i = 0; i < 100; ++i) {
            record = this.generateRecord(RandomUtil.randomInterval((int)1500, (int)10000));
            this.journal.appendAddRecord((long)i, (byte)0, record, false);
            this.records.add(new RecordInfo((long)i, 0, record, false, false, 0));
        }
        for (i = 0; i < 100; ++i) {
            record = this.generateRecord(10 + RandomUtil.randomInterval((int)1500, (int)10000));
            this.journal.appendUpdateRecord((long)i, (byte)0, record, false);
            this.records.add(new RecordInfo((long)i, 0, record, true, false, 0));
        }
        for (i = 0; i < 100; ++i) {
            this.journal.appendDeleteRecord((long)i, false);
            this.removeRecordsForID(i);
        }
        this.stopJournal();
        this.createJournal();
        this.startJournal();
        this.loadAndCheck();
        this.stopJournal();
    }

    @Test
    public void testAddUpdateDeleteRestartAndContinue() throws Exception {
        this.setup(10, 10240, true);
        this.createJournal();
        this.startJournal();
        this.load();
        this.add(1L, 2L, 3L);
        this.update(1L, 2L);
        this.stopJournal();
        this.createJournal();
        this.startJournal();
        this.loadAndCheck();
        this.add(4L, 5L, 6L);
        this.update(5L);
        this.delete(3L);
        this.stopJournal();
        this.createJournal();
        this.startJournal();
        this.loadAndCheck();
        this.add(7L, 8L);
        this.delete(1L, 2L);
        this.delete(4L, 5L, 6L);
        this.stopJournal();
        this.createJournal();
        this.startJournal();
        this.loadAndCheck();
    }

    @Test
    public void testSimpleAddTXReload() throws Exception {
        this.setup(2, 10240, true);
        this.createJournal();
        this.startJournal();
        this.load();
        this.addTx(1L, 1L);
        this.commit(1L);
        this.stopJournal();
        this.createJournal();
        this.startJournal();
        this.loadAndCheck();
    }

    @Test
    public void testSimpleAddTXXAReload() throws Exception {
        this.setup(2, 10240, true);
        this.createJournal();
        this.startJournal();
        this.load();
        this.addTx(1L, 1L);
        SimpleEncoding xid = new SimpleEncoding(10, 112);
        this.prepare(1L, xid);
        this.stopJournal();
        this.createJournal();
        this.startJournal();
        this.loadAndCheck();
    }

    @Test
    public void testAddUpdateDeleteTransactionalRestartAndContinue() throws Exception {
        this.setup(10, 10240, true);
        this.createJournal();
        this.startJournal();
        this.load();
        this.add(1L, 2L, 3L);
        this.updateTx(1L, 1L, 2L);
        this.commit(1L);
        this.stopJournal();
        this.createJournal();
        this.startJournal();
        this.loadAndCheck();
        this.addTx(2L, 4L, 5L, 6L);
        this.update(2L, 2L);
        this.delete(2L, 3L);
        this.commit(2L);
        this.stopJournal();
        this.createJournal();
        this.startJournal();
        this.loadAndCheck();
        this.addTx(3L, 7L, 8L);
        this.deleteTx(3L, 1L);
        this.deleteTx(3L, 4L, 5L, 6L);
        this.commit(3L);
        this.stopJournal();
        this.createJournal();
        this.startJournal();
        this.loadAndCheck();
    }

    @Test
    public void testFillFileExactly() throws Exception {
        this.recordLength = 500;
        int numRecords = 2;
        int realLength = this.calculateRecordSize(22 + this.recordLength, this.getAlignment());
        int fileSize = numRecords * realLength + this.calculateRecordSize(8, this.getAlignment());
        this.setup(10, fileSize, true);
        this.createJournal();
        this.startJournal();
        this.load();
        this.add(1L, 2L);
        this.stopJournal();
        this.createJournal();
        this.startJournal();
        this.loadAndCheck();
        this.add(3L, 4L);
        this.stopJournal();
        this.createJournal();
        this.startJournal();
        this.loadAndCheck();
        this.add(4L, 5L, 6L, 7L, 8L, 9L, 10L);
        this.stopJournal();
        this.createJournal();
        this.startJournal();
        this.loadAndCheck();
    }

    @Test
    public void testSimpleTransaction() throws Exception {
        this.setup(10, 10240, true);
        this.createJournal();
        this.startJournal();
        this.load();
        this.addTx(1L, 1L);
        this.updateTx(1L, 1L);
        this.deleteTx(1L, 1L);
        this.commit(1L);
        this.stopJournal();
        this.createJournal();
        this.startJournal();
        this.loadAndCheck();
    }

    @Test
    public void testTransactionDontDeleteAll() throws Exception {
        this.setup(10, 10240, true);
        this.createJournal();
        this.startJournal();
        this.load();
        this.addTx(1L, 1L, 2L, 3L);
        this.updateTx(1L, 1L, 2L);
        this.deleteTx(1L, 1L);
        this.commit(1L);
        this.stopJournal();
        this.createJournal();
        this.startJournal();
        this.loadAndCheck();
    }

    @Test
    public void testTransactionDeleteAll() throws Exception {
        this.setup(10, 10240, true);
        this.createJournal();
        this.startJournal();
        this.load();
        this.addTx(1L, 1L, 2L, 3L);
        this.updateTx(1L, 1L, 2L);
        this.deleteTx(1L, 1L, 2L, 3L);
        this.commit(1L);
        this.stopJournal();
        this.createJournal();
        this.startJournal();
        this.loadAndCheck();
    }

    @Test
    public void testTransactionUpdateFromBeforeTx() throws Exception {
        this.setup(10, 10240, true);
        this.createJournal();
        this.startJournal();
        this.load();
        this.add(1L, 2L, 3L);
        this.addTx(1L, 4L, 5L, 6L);
        this.updateTx(1L, 1L, 5L);
        this.commit(1L);
        this.stopJournal();
        this.createJournal();
        this.startJournal();
        this.loadAndCheck();
    }

    @Test
    public void testTransactionDeleteFromBeforeTx() throws Exception {
        this.setup(10, 10240, true);
        this.createJournal();
        this.startJournal();
        this.load();
        this.add(1L, 2L, 3L);
        this.addTx(1L, 4L, 5L, 6L);
        this.deleteTx(1L, 1L, 2L, 3L, 4L, 5L, 6L);
        this.commit(1L);
        this.stopJournal();
        this.createJournal();
        this.startJournal();
        this.loadAndCheck();
    }

    @Test
    public void testTransactionChangesNotVisibleOutsideTXtestTransactionChangesNotVisibleOutsideTX() throws Exception {
        this.setup(10, 10240, true);
        this.createJournal();
        this.startJournal();
        this.load();
        this.add(1L, 2L, 3L);
        this.addTx(1L, 4L, 5L, 6L);
        this.updateTx(1L, 1L, 2L, 4L, 5L);
        this.deleteTx(1L, 1L, 2L, 3L, 4L, 5L, 6L);
        this.stopJournal();
        this.createJournal();
        this.startJournal();
        this.loadAndCheck();
    }

    @Test
    public void testMultipleTransactionsDifferentIDs() throws Exception {
        this.setup(10, 10240, true);
        this.createJournal();
        this.startJournal();
        this.load();
        this.addTx(1L, 1L, 2L, 3L, 4L, 5L, 6L);
        this.updateTx(1L, 1L, 3L, 5L);
        this.deleteTx(1L, 1L, 2L, 3L, 4L, 5L, 6L);
        this.commit(1L);
        this.addTx(2L, 11L, 12L, 13L, 14L, 15L, 16L);
        this.updateTx(2L, 11L, 13L, 15L);
        this.deleteTx(2L, 11L, 12L, 13L, 14L, 15L, 16L);
        this.commit(2L);
        this.addTx(3L, 21L, 22L, 23L, 24L, 25L, 26L);
        this.updateTx(3L, 21L, 23L, 25L);
        this.deleteTx(3L, 21L, 22L, 23L, 24L, 25L, 26L);
        this.commit(3L);
        this.stopJournal();
        this.createJournal();
        this.startJournal();
        this.loadAndCheck();
    }

    @Test
    public void testMultipleInterleavedTransactionsDifferentIDs() throws Exception {
        this.setup(10, 10240, true);
        this.createJournal();
        this.startJournal();
        this.load();
        this.addTx(1L, 1L, 2L, 3L, 4L, 5L, 6L);
        this.addTx(3L, 21L, 22L, 23L, 24L, 25L, 26L);
        this.updateTx(1L, 1L, 3L, 5L);
        this.addTx(2L, 11L, 12L, 13L, 14L, 15L, 16L);
        this.deleteTx(1L, 1L, 2L, 3L, 4L, 5L, 6L);
        this.updateTx(2L, 11L, 13L, 15L);
        this.updateTx(3L, 21L, 23L, 25L);
        this.deleteTx(2L, 11L, 12L, 13L, 14L, 15L, 16L);
        this.deleteTx(3L, 21L, 22L, 23L, 24L, 25L, 26L);
        this.commit(1L);
        this.commit(2L);
        this.commit(3L);
        this.stopJournal();
        this.createJournal();
        this.startJournal();
        this.loadAndCheck();
    }

    @Test
    public void testMultipleInterleavedTransactionsSameIDs() throws Exception {
        this.setup(10, 10240, true);
        this.createJournal();
        this.startJournal();
        this.load();
        this.add(1L, 2L, 3L, 4L, 5L, 6L, 7L, 8L);
        this.addTx(1L, 9L, 10L, 11L, 12L);
        this.addTx(2L, 13L, 14L, 15L, 16L, 17L);
        this.addTx(3L, 18L, 19L, 20L, 21L, 22L);
        this.updateTx(1L, 1L, 2L, 3L);
        this.updateTx(2L, 4L, 5L, 6L);
        this.commit(2L);
        this.updateTx(3L, 7L, 8L);
        this.deleteTx(1L, 1L, 2L);
        this.commit(1L);
        this.deleteTx(3L, 7L, 8L);
        this.commit(3L);
        this.stopJournal();
        this.createJournal();
        this.startJournal();
        this.loadAndCheck();
    }

    @Test
    public void testTransactionMixed() throws Exception {
        this.setup(10, 10240, true);
        this.createJournal();
        this.startJournal();
        this.load();
        this.add(1L, 3L, 5L, 7L, 10L, 13L, 56L, 100L, 102L, 200L, 201L, 202L, 203L);
        this.addTx(1L, 675L, 676L, 677L, 700L, 703L);
        this.update(1L, 3L, 5L, 7L, 10L, 13L, 56L, 100L, 102L, 200L, 201L, 202L, 203L);
        this.updateTx(1L, 677L, 700L);
        this.delete(1L, 3L, 5L, 7L, 10L, 13L, 56L, 100L, 102L, 200L, 201L, 202L, 203L);
        this.deleteTx(1L, 703L, 675L);
        this.commit(1L);
        this.stopJournal();
        this.createJournal();
        this.startJournal();
        this.loadAndCheck();
    }

    @Test
    public void testTransactionAddDeleteDifferentOrder() throws Exception {
        this.setup(10, 10240, true);
        this.createJournal();
        this.startJournal();
        this.load();
        this.addTx(1L, 1L, 2L, 3L, 4L, 5L, 6L, 7L, 8L, 9L);
        this.deleteTx(1L, 9L, 8L, 5L, 3L, 7L, 6L, 2L, 1L, 4L);
        this.commit(1L);
        this.stopJournal();
        this.createJournal();
        this.startJournal();
        this.loadAndCheck();
    }

    @Test
    public void testAddOutsideTXThenUpdateInsideTX() throws Exception {
        this.setup(10, 10240, true);
        this.createJournal();
        this.startJournal();
        this.load();
        this.add(1L, 2L, 3L);
        this.updateTx(1L, 1L, 2L, 3L);
        this.commit(1L);
        this.stopJournal();
        this.createJournal();
        this.startJournal();
        this.loadAndCheck();
    }

    @Test
    public void testAddOutsideTXThenDeleteInsideTX() throws Exception {
        this.setup(10, 10240, true);
        this.createJournal();
        this.startJournal();
        this.load();
        this.add(1L, 2L, 3L);
        this.deleteTx(1L, 1L, 2L, 3L);
        this.commit(1L);
        this.stopJournal();
        this.createJournal();
        this.startJournal();
        this.loadAndCheck();
    }

    @Test
    public void testRollback() throws Exception {
        this.setup(10, 10240, true);
        this.createJournal();
        this.startJournal();
        this.load();
        this.add(1L, 2L, 3L);
        this.deleteTx(1L, 1L, 2L, 3L);
        this.rollback(1L);
        this.stopJournal();
        this.createJournal();
        this.startJournal();
        this.loadAndCheck();
    }

    @Test
    public void testRollbackMultiple() throws Exception {
        this.setup(10, 10240, true);
        this.createJournal();
        this.startJournal();
        this.load();
        this.add(1L, 2L, 3L);
        this.deleteTx(1L, 1L, 2L, 3L);
        this.addTx(2L, 4L, 5L, 6L);
        this.rollback(1L);
        this.rollback(2L);
        this.stopJournal();
        this.createJournal();
        this.startJournal();
        this.loadAndCheck();
    }

    @Test
    public void testIsolation1() throws Exception {
        this.setup(10, 10240, true);
        this.createJournal();
        this.startJournal();
        this.load();
        this.addTx(1L, 1L, 2L, 3L);
        this.deleteTx(1L, 1L, 2L, 3L);
        this.commit(1L);
        this.stopJournal();
        this.createJournal();
        this.startJournal();
        this.loadAndCheck();
    }

    @Test
    public void testIsolation2() throws Exception {
        this.setup(10, 10240, true);
        this.createJournal();
        this.startJournal();
        this.load();
        this.addTx(1L, 1L, 2L, 3L);
        try {
            this.update(1L);
            Assertions.fail((String)"Should throw exception");
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
        this.stopJournal();
        this.createJournal();
        this.startJournal();
        this.loadAndCheck();
    }

    @Test
    public void testTryIsolation2() throws Exception {
        this.setup(10, 10240, true);
        this.createJournal();
        this.startJournal();
        this.load();
        this.addTx(1L, 1L, 2L, 3L);
        Assertions.assertFalse((boolean)this.tryUpdate(1L));
        this.stopJournal();
        this.createJournal();
        this.startJournal();
        this.loadAndCheck();
    }

    @Test
    public void testIsolation3() throws Exception {
        this.setup(10, 10240, true);
        this.createJournal();
        this.startJournal();
        this.load();
        this.addTx(1L, 1L, 2L, 3L);
        try {
            this.delete(1L);
            Assertions.fail((String)"Should throw exception");
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
        this.stopJournal();
        this.createJournal();
        this.startJournal();
        this.loadAndCheck();
    }

    @Test
    public void testTryDelete() throws Exception {
        this.setup(10, 10240, true);
        this.createJournal();
        this.startJournal();
        this.load();
        this.addTx(1L, 1L, 2L, 3L);
        Assertions.assertFalse((boolean)this.tryDelete(1L));
        this.stopJournal();
        this.createJournal();
        this.startJournal();
        this.loadAndCheck();
    }

    @Test
    public void testXASimpleNotPrepared() throws Exception {
        this.setup(10, 10240, true);
        this.createJournal();
        this.startJournal();
        this.load();
        this.addTx(1L, 1L, 2L, 3L, 4L, 5L, 6L, 7L, 8L, 9L);
        this.updateTx(1L, 1L, 2L, 3L, 4L, 7L, 8L);
        this.deleteTx(1L, 1L, 2L, 3L, 4L, 5L);
        this.stopJournal();
        this.createJournal();
        this.startJournal();
        this.loadAndCheck();
    }

    @Test
    public void testXASimplePrepared() throws Exception {
        this.setup(10, 10240, true);
        this.createJournal();
        this.startJournal();
        this.load();
        this.addTx(1L, 1L, 2L, 3L, 4L, 5L, 6L, 7L, 8L, 9L);
        this.updateTx(1L, 1L, 2L, 3L, 4L, 7L, 8L);
        this.deleteTx(1L, 1L, 2L, 3L, 4L, 5L);
        SimpleEncoding xid = new SimpleEncoding(10, 0);
        this.prepare(1L, xid);
        this.stopJournal();
        this.createJournal();
        this.startJournal();
        this.loadAndCheck();
    }

    @Test
    public void testXASimpleCommit() throws Exception {
        this.setup(10, 10240, true);
        this.createJournal();
        this.startJournal();
        this.load();
        this.addTx(1L, 1L, 2L, 3L, 4L, 5L, 6L, 7L, 8L, 9L);
        this.updateTx(1L, 1L, 2L, 3L, 4L, 7L, 8L);
        this.deleteTx(1L, 1L, 2L, 3L, 4L, 5L);
        SimpleEncoding xid = new SimpleEncoding(10, 0);
        this.prepare(1L, xid);
        this.commit(1L);
        this.stopJournal();
        this.createJournal();
        this.startJournal();
        this.loadAndCheck();
    }

    @Test
    public void testXASimpleRollback() throws Exception {
        this.setup(10, 10240, true);
        this.createJournal();
        this.startJournal();
        this.load();
        this.addTx(1L, 1L, 2L, 3L, 4L, 5L, 6L, 7L, 8L, 9L);
        this.updateTx(1L, 1L, 2L, 3L, 4L, 7L, 8L);
        this.deleteTx(1L, 1L, 2L, 3L, 4L, 5L);
        SimpleEncoding xid = new SimpleEncoding(10, 0);
        this.prepare(1L, xid);
        this.rollback(1L);
        this.stopJournal();
        this.createJournal();
        this.startJournal();
        this.loadAndCheck();
    }

    @Test
    public void testXAChangesNotVisibleNotPrepared() throws Exception {
        this.setup(10, 10240, true);
        this.createJournal();
        this.startJournal();
        this.load();
        this.add(1L, 2L, 3L, 4L, 5L, 6L);
        this.addTx(1L, 7L, 8L, 9L, 10L);
        this.updateTx(1L, 1L, 2L, 3L, 7L, 8L, 9L);
        this.deleteTx(1L, 1L, 2L, 3L, 4L, 5L);
        this.stopJournal();
        this.createJournal();
        this.startJournal();
        this.loadAndCheck();
    }

    @Test
    public void testXAChangesNotVisiblePrepared() throws Exception {
        this.setup(10, 10240, true);
        this.createJournal();
        this.startJournal();
        this.load();
        this.add(1L, 2L, 3L, 4L, 5L, 6L);
        this.addTx(1L, 7L, 8L, 9L, 10L);
        this.updateTx(1L, 1L, 2L, 3L, 7L, 8L, 9L);
        this.deleteTx(1L, 1L, 2L, 3L, 4L, 5L);
        SimpleEncoding xid = new SimpleEncoding(10, 0);
        this.prepare(1L, xid);
        this.stopJournal();
        this.createJournal();
        this.startJournal();
        this.loadAndCheck();
    }

    @Test
    public void testXAChangesNotVisibleRollback() throws Exception {
        this.setup(10, 10240, true);
        this.createJournal();
        this.startJournal();
        this.load();
        this.add(1L, 2L, 3L, 4L, 5L, 6L);
        this.addTx(1L, 7L, 8L, 9L, 10L);
        this.updateTx(1L, 1L, 2L, 3L, 7L, 8L, 9L);
        this.deleteTx(1L, 1L, 2L, 3L, 4L, 5L);
        SimpleEncoding xid = new SimpleEncoding(10, 0);
        this.prepare(1L, xid);
        this.rollback(1L);
        this.stopJournal();
        this.createJournal();
        this.startJournal();
        this.loadAndCheck();
    }

    @Test
    public void testXAChangesisibleCommit() throws Exception {
        this.setup(10, 10240, true);
        this.createJournal();
        this.startJournal();
        this.load();
        this.add(1L, 2L, 3L, 4L, 5L, 6L);
        this.addTx(1L, 7L, 8L, 9L, 10L);
        this.updateTx(1L, 1L, 2L, 3L, 7L, 8L, 9L);
        this.deleteTx(1L, 1L, 2L, 3L, 4L, 5L);
        SimpleEncoding xid = new SimpleEncoding(10, 0);
        this.prepare(1L, xid);
        this.commit(1L);
        this.stopJournal();
        this.createJournal();
        this.startJournal();
        this.loadAndCheck();
    }

    @Test
    public void testXAMultiple() throws Exception {
        this.setup(10, 10240, true);
        this.createJournal();
        this.startJournal();
        this.load();
        this.add(1L, 2L, 3L, 4L, 5L, 6L, 7L, 8L, 9L, 10L);
        this.addTx(1L, 11L, 12L, 13L, 14L, 15L, 16L, 17L, 18L, 19L, 20L);
        this.addTx(2L, 21L, 22L, 23L, 24L, 25L, 26L, 27L);
        this.updateTx(1L, 1L, 3L, 6L, 11L, 14L, 17L);
        this.addTx(3L, 28L, 29L, 30L, 31L, 32L, 33L, 34L, 35L);
        this.updateTx(3L, 7L, 8L, 9L, 10L);
        this.deleteTx(2L, 4L, 5L, 6L, 23L, 25L, 27L);
        SimpleEncoding xid = new SimpleEncoding(10, 0);
        this.prepare(2L, xid);
        this.deleteTx(1L, 1L, 2L, 11L, 14L, 15L);
        this.prepare(1L, xid);
        this.deleteTx(3L, 28L, 31L, 32L, 9L);
        this.prepare(3L, xid);
        this.commit(1L);
        this.rollback(2L);
        this.commit(3L);
    }

    @Test
    public void testTransactionOnDifferentFiles() throws Exception {
        this.setup(2, 2560, true);
        this.createJournal();
        this.startJournal();
        this.load();
        this.addTx(1L, 1L, 2L, 3L, 4L, 5L, 6L);
        this.updateTx(1L, 1L, 3L, 5L);
        this.commit(1L);
        this.deleteTx(2L, 1L, 2L, 3L, 4L, 5L, 6L);
        this.commit(2L);
        this.addTx(3L, 11L);
        this.addTx(4L, 31L);
        this.commit(3L);
        if (logger.isDebugEnabled()) {
            logger.debug("Debug on Journal before stopJournal - \n{}", (Object)this.debugJournal());
        }
        this.stopJournal();
        this.createJournal();
        this.startJournal();
        this.loadAndCheck();
    }

    @Test
    public void testReclaimAfterUpdate() throws Exception {
        int i;
        this.setup(2, 61440, true);
        this.createJournal();
        this.startJournal();
        this.load();
        int transactionID = 0;
        for (i = 0; i < 100; ++i) {
            this.add(i);
            if (i % 10 == 0 && i > 0) {
                this.journal.forceMoveNextFile();
            }
            this.update(i);
        }
        for (i = 100; i < 200; ++i) {
            this.addTx(transactionID, i);
            if (i % 10 == 0 && i > 0) {
                this.journal.forceMoveNextFile();
            }
            this.commit(transactionID++);
            this.update(i);
        }
        this.stopJournal();
        this.createJournal();
        this.startJournal();
        this.loadAndCheck();
        this.journal.forceMoveNextFile();
        for (i = 0; i < 100; ++i) {
            this.delete(i);
        }
        for (i = 100; i < 200; ++i) {
            this.updateTx(transactionID, i);
        }
        this.journal.forceMoveNextFile();
        this.commit(transactionID++);
        for (i = 100; i < 200; ++i) {
            this.updateTx(transactionID, i);
            this.deleteTx(transactionID, i);
        }
        this.commit(transactionID++);
        this.journal.processBackup();
        this.stopJournal();
        this.createJournal();
        this.startJournal();
        this.loadAndCheck();
        this.journal.forceMoveNextFile();
        this.checkAndReclaimFiles();
        Assertions.assertEquals((int)0, (int)this.journal.getDataFilesCount());
        this.stopJournal();
        this.createJournal();
        this.startJournal();
        this.loadAndCheck();
        Assertions.assertEquals((int)0, (int)this.journal.getDataFilesCount());
    }

    @Test
    public void testAddTexThenUpdate() throws Exception {
        this.setup(2, 61440, true);
        this.createJournal();
        this.startJournal();
        this.load();
        this.addTx(1L, 1L);
        this.addTx(1L, 2L);
        this.updateTx(1L, 1L);
        this.updateTx(1L, 3L);
        this.commit(1L);
        this.update(1L);
        this.stopJournal();
        this.createJournal();
        this.startJournal();
        this.loadAndCheck();
    }

    @Test
    public void testLoadTruncatedFile() throws Exception {
        this.setup(2, 2048, true);
        this.createJournal();
        this.startJournal();
        String testDir = this.getTestDir();
        new File(testDir + File.separator + this.filePrefix + "-1." + this.fileExtension).createNewFile();
        try {
            this.load();
        }
        catch (Exception e) {
            Assertions.fail((String)("Unexpected exception: " + e.toString()));
        }
    }

    protected abstract int getAlignment();
}

