/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.tests.unit.core.journal.impl;

import java.util.HashMap;
import java.util.Map;
import org.apache.activemq.artemis.core.io.SequentialFile;
import org.apache.activemq.artemis.core.journal.impl.JournalFile;
import org.apache.activemq.artemis.core.journal.impl.Reclaimer;
import org.apache.activemq.artemis.tests.util.ActiveMQTestBase;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

public class ReclaimerTest
extends ActiveMQTestBase {
    private JournalFile[] files;

    @Override
    @BeforeEach
    public void setUp() throws Exception {
        super.setUp();
    }

    @Test
    public void testOneFilePosNegAll() throws Exception {
        this.setup(1);
        this.setupPosNeg(0, 10, 10);
        Reclaimer.scan((JournalFile[])this.files);
        this.assertCanDelete(0);
    }

    @Test
    public void testOneFilePosNegNotAll() throws Exception {
        this.setup(1);
        this.setupPosNeg(0, 10, 7);
        Reclaimer.scan((JournalFile[])this.files);
        this.assertCantDelete(0);
    }

    @Test
    public void testOneFilePosOnly() throws Exception {
        this.setup(1);
        this.setupPosNeg(0, 10, new int[0]);
        Reclaimer.scan((JournalFile[])this.files);
        this.assertCantDelete(0);
    }

    @Test
    public void testOneFileNegOnly() throws Exception {
        this.setup(1);
        this.setupPosNeg(0, 0, 10);
        Reclaimer.scan((JournalFile[])this.files);
        this.assertCanDelete(0);
    }

    @Test
    public void testTwoFilesPosNegAllDifferentFiles() throws Exception {
        this.setup(2);
        this.setupPosNeg(0, 10, new int[0]);
        this.setupPosNeg(1, 0, 10);
        Reclaimer.scan((JournalFile[])this.files);
        this.assertCanDelete(0);
        this.assertCanDelete(1);
    }

    @Test
    public void testTwoFilesPosNegAllSameFiles() throws Exception {
        this.setup(2);
        this.setupPosNeg(0, 10, 10);
        this.setupPosNeg(1, 10, 0, 10);
        Reclaimer.scan((JournalFile[])this.files);
        this.assertCanDelete(0);
        this.assertCanDelete(1);
    }

    @Test
    public void testTwoFilesPosNegMixedFiles() throws Exception {
        this.setup(2);
        this.setupPosNeg(0, 10, 7);
        this.setupPosNeg(1, 10, 3, 10);
        Reclaimer.scan((JournalFile[])this.files);
        this.assertCanDelete(0);
        this.assertCanDelete(1);
    }

    @Test
    public void testTwoFilesPosNegAllFirstFile() throws Exception {
        this.setup(2);
        this.setupPosNeg(0, 10, 10);
        this.setupPosNeg(1, 10, new int[0]);
        Reclaimer.scan((JournalFile[])this.files);
        this.assertCanDelete(0);
        this.assertCantDelete(1);
    }

    @Test
    public void testTwoFilesPosNegAllSecondFile() throws Exception {
        this.setup(2);
        this.setupPosNeg(0, 10, new int[0]);
        this.setupPosNeg(1, 10, 0, 10);
        Reclaimer.scan((JournalFile[])this.files);
        this.assertCantDelete(0);
        this.assertCanDelete(1);
    }

    @Test
    public void testTwoFilesPosOnly() throws Exception {
        this.setup(2);
        this.setupPosNeg(0, 10, new int[0]);
        this.setupPosNeg(1, 10, new int[0]);
        Reclaimer.scan((JournalFile[])this.files);
        this.assertCantDelete(0);
        this.assertCantDelete(1);
    }

    @Test
    public void testTwoFilesxyz() throws Exception {
        this.setup(2);
        this.setupPosNeg(0, 10, new int[0]);
        this.setupPosNeg(1, 10, 10);
        Reclaimer.scan((JournalFile[])this.files);
        this.assertCanDelete(0);
        this.assertCantDelete(1);
    }

    @Test
    public void testThreeFiles1() throws Exception {
        this.setup(3);
        this.setupPosNeg(0, 10, 10, 0, 0);
        this.setupPosNeg(1, 10, 0, 10, 0);
        this.setupPosNeg(2, 10, 0, 0, 10);
        Reclaimer.scan((JournalFile[])this.files);
        this.assertCanDelete(0);
        this.assertCanDelete(1);
        this.assertCanDelete(2);
    }

    @Test
    public void testThreeFiles2() throws Exception {
        this.setup(3);
        this.setupPosNeg(0, 10, 7, 0, 0);
        this.setupPosNeg(1, 10, 3, 5, 0);
        this.setupPosNeg(2, 10, 0, 5, 10);
        Reclaimer.scan((JournalFile[])this.files);
        this.assertCanDelete(0);
        this.assertCanDelete(1);
        this.assertCanDelete(2);
    }

    @Test
    public void testThreeFiles3() throws Exception {
        this.setup(3);
        this.setupPosNeg(0, 10, 1, 0, 0);
        this.setupPosNeg(1, 10, 6, 5, 0);
        this.setupPosNeg(2, 10, 3, 5, 10);
        Reclaimer.scan((JournalFile[])this.files);
        this.assertCanDelete(0);
        this.assertCanDelete(1);
        this.assertCanDelete(2);
    }

    @Test
    public void testThreeFiles3_1() throws Exception {
        this.setup(3);
        this.setupPosNeg(0, 10, 1, 0, 0);
        this.setupPosNeg(1, 10, 6, 5, 0);
        this.setupPosNeg(2, 0, 3, 5, 0);
        Reclaimer.scan((JournalFile[])this.files);
        this.assertCanDelete(0);
        this.assertCanDelete(1);
        this.assertCanDelete(2);
    }

    @Test
    public void testThreeFiles3_2() throws Exception {
        this.setup(3);
        this.setupPosNeg(0, 10, 1, 0, 0);
        this.setupPosNeg(1, 0, 6, 0, 0);
        this.setupPosNeg(2, 0, 3, 0, 0);
        Reclaimer.scan((JournalFile[])this.files);
        this.assertCanDelete(0);
        this.assertCanDelete(1);
        this.assertCanDelete(2);
    }

    @Test
    public void testThreeFiles4() throws Exception {
        this.setup(3);
        this.setupPosNeg(0, 10, 3, 0, 0);
        this.setupPosNeg(1, 10, 0, 5, 0);
        this.setupPosNeg(2, 10, 0, 5, 10);
        Reclaimer.scan((JournalFile[])this.files);
        this.assertCantDelete(0);
        this.assertCanDelete(1);
        this.assertCanDelete(2);
    }

    @Test
    public void testThreeFiles5() throws Exception {
        this.setup(3);
        this.setupPosNeg(0, 10, 3, 0, 0);
        this.setupPosNeg(1, 10, 0, 5, 0);
        this.setupPosNeg(2, 0, 0, 5, 0);
        Reclaimer.scan((JournalFile[])this.files);
        this.assertCantDelete(0);
        this.assertCanDelete(1);
        this.assertCanDelete(2);
    }

    @Test
    public void testThreeFiles6() throws Exception {
        this.setup(3);
        this.setupPosNeg(0, 10, 0, 0, 0);
        this.setupPosNeg(1, 10, 0, 5, 0);
        this.setupPosNeg(2, 0, 0, 5, 10);
        Reclaimer.scan((JournalFile[])this.files);
        this.assertCantDelete(0);
        this.assertCanDelete(1);
        this.assertCanDelete(2);
    }

    @Test
    public void testThreeFiles7() throws Exception {
        this.setup(3);
        this.setupPosNeg(0, 10, 0, 0, 0);
        this.setupPosNeg(1, 10, 0, 5, 0);
        this.setupPosNeg(2, 0, 0, 5, 0);
        Reclaimer.scan((JournalFile[])this.files);
        this.assertCantDelete(0);
        this.assertCanDelete(1);
        this.assertCanDelete(2);
    }

    @Test
    public void testThreeFiles8() throws Exception {
        this.setup(3);
        this.setupPosNeg(0, 10, 3, 0, 0);
        this.setupPosNeg(1, 10, 0, 10, 0);
        this.setupPosNeg(2, 10, 0, 0, 2);
        Reclaimer.scan((JournalFile[])this.files);
        this.assertCantDelete(0);
        this.assertCanDelete(1);
        this.assertCantDelete(2);
    }

    @Test
    public void testThreeFiles9() throws Exception {
        this.setup(3);
        this.setupPosNeg(0, 10, 3, 0, 0);
        this.setupPosNeg(1, 10, 0, 10, 0);
        this.setupPosNeg(2, 10, 1, 0, 2);
        Reclaimer.scan((JournalFile[])this.files);
        this.assertCantDelete(0);
        this.assertCanDelete(1);
        this.assertCantDelete(2);
    }

    @Test
    public void testThreeFiles10() throws Exception {
        this.setup(3);
        this.setupPosNeg(0, 10, 3, 0, 0);
        this.setupPosNeg(1, 10, 0, 10, 0);
        this.setupPosNeg(2, 10, 1, 0, 0);
        Reclaimer.scan((JournalFile[])this.files);
        this.assertCantDelete(0);
        this.assertCanDelete(1);
        this.assertCantDelete(2);
    }

    @Test
    public void testThreeFiles11() throws Exception {
        this.setup(3);
        this.setupPosNeg(0, 10, 0, 0, 0);
        this.setupPosNeg(1, 10, 0, 10, 0);
        this.setupPosNeg(2, 10, 0, 0, 0);
        Reclaimer.scan((JournalFile[])this.files);
        this.assertCantDelete(0);
        this.assertCanDelete(1);
        this.assertCantDelete(2);
    }

    @Test
    public void testThreeFiles12() throws Exception {
        this.setup(3);
        this.setupPosNeg(0, 10, 0, 0, 0);
        this.setupPosNeg(1, 10, 0, 10, 0);
        this.setupPosNeg(2, 0, 3, 0, 0);
        Reclaimer.scan((JournalFile[])this.files);
        this.assertCantDelete(0);
        this.assertCanDelete(1);
        this.assertCantDelete(2);
    }

    @Test
    public void testThreeFiles13() throws Exception {
        this.setup(3);
        this.setupPosNeg(0, 10, 3, 0, 0);
        this.setupPosNeg(1, 10, 2, 3, 0);
        this.setupPosNeg(2, 10, 1, 5, 7);
        Reclaimer.scan((JournalFile[])this.files);
        this.assertCantDelete(0);
        this.assertCantDelete(1);
        this.assertCantDelete(2);
    }

    @Test
    public void testThreeFiles14() throws Exception {
        this.setup(3);
        this.setupPosNeg(0, 10, 3, 0, 0);
        this.setupPosNeg(1, 0, 2, 0, 0);
        this.setupPosNeg(2, 10, 1, 0, 7);
        Reclaimer.scan((JournalFile[])this.files);
        this.assertCantDelete(0);
        this.assertCantDelete(1);
        this.assertCantDelete(2);
    }

    @Test
    public void testThreeFiles15() throws Exception {
        this.setup(3);
        this.setupPosNeg(0, 10, 3, 0, 0);
        this.setupPosNeg(1, 10, 2, 3, 0);
        this.setupPosNeg(2, 0, 1, 5, 0);
        Reclaimer.scan((JournalFile[])this.files);
        this.assertCantDelete(0);
        this.assertCantDelete(1);
        this.assertCantDelete(2);
    }

    @Test
    public void testThreeFiles16() throws Exception {
        this.setup(3);
        this.setupPosNeg(0, 10, 3, 0, 0);
        this.setupPosNeg(1, 0, 2, 0, 0);
        this.setupPosNeg(2, 0, 1, 0, 0);
        Reclaimer.scan((JournalFile[])this.files);
        this.assertCantDelete(0);
        this.assertCantDelete(1);
        this.assertCantDelete(2);
    }

    @Test
    public void testThreeFiles17() throws Exception {
        this.setup(3);
        this.setupPosNeg(0, 10, 3, 0, 0);
        this.setupPosNeg(1, 10, 0, 3, 0);
        this.setupPosNeg(2, 10, 1, 5, 7);
        Reclaimer.scan((JournalFile[])this.files);
        this.assertCantDelete(0);
        this.assertCantDelete(1);
        this.assertCantDelete(2);
    }

    @Test
    public void testThreeFiles18() throws Exception {
        this.setup(3);
        this.setupPosNeg(0, 10, 3, 0, 0);
        this.setupPosNeg(1, 10, 0, 3, 0);
        this.setupPosNeg(2, 10, 1, 0, 7);
        Reclaimer.scan((JournalFile[])this.files);
        this.assertCantDelete(0);
        this.assertCantDelete(1);
        this.assertCantDelete(2);
    }

    @Test
    public void testThreeFiles19() throws Exception {
        this.setup(3);
        this.setupPosNeg(0, 10, 3, 0, 0);
        this.setupPosNeg(1, 10, 0, 3, 0);
        this.setupPosNeg(2, 10, 1, 0, 0);
        Reclaimer.scan((JournalFile[])this.files);
        this.assertCantDelete(0);
        this.assertCantDelete(1);
        this.assertCantDelete(2);
    }

    @Test
    public void testThreeFiles20() throws Exception {
        this.setup(3);
        this.setupPosNeg(0, 10, 3, 0, 0);
        this.setupPosNeg(1, 10, 0, 0, 0);
        this.setupPosNeg(2, 10, 1, 0, 0);
        Reclaimer.scan((JournalFile[])this.files);
        this.assertCantDelete(0);
        this.assertCantDelete(1);
        this.assertCantDelete(2);
    }

    @Test
    public void testThreeFiles21() throws Exception {
        this.setup(3);
        this.setupPosNeg(0, 10, 0, 0, 0);
        this.setupPosNeg(1, 10, 0, 0, 0);
        this.setupPosNeg(2, 10, 0, 0, 0);
        Reclaimer.scan((JournalFile[])this.files);
        this.assertCantDelete(0);
        this.assertCantDelete(1);
        this.assertCantDelete(2);
    }

    @Test
    public void testThreeFiles22() throws Exception {
        this.setup(3);
        this.setupPosNeg(0, 10, 10, 0, 0);
        this.setupPosNeg(1, 10, 0, 10, 0);
        this.setupPosNeg(2, 10, 0, 0, 0);
        Reclaimer.scan((JournalFile[])this.files);
        this.assertCanDelete(0);
        this.assertCanDelete(1);
        this.assertCantDelete(2);
    }

    @Test
    public void testThreeFiles23() throws Exception {
        this.setup(3);
        this.setupPosNeg(0, 10, 10, 0, 0);
        this.setupPosNeg(1, 10, 0, 10, 0);
        this.setupPosNeg(2, 10, 3, 0, 0);
        Reclaimer.scan((JournalFile[])this.files);
        this.assertCanDelete(0);
        this.assertCanDelete(1);
        this.assertCantDelete(2);
    }

    @Test
    public void testThreeFiles24() throws Exception {
        this.setup(3);
        this.setupPosNeg(0, 10, 7, 0, 0);
        this.setupPosNeg(1, 10, 3, 10, 0);
        this.setupPosNeg(2, 10, 3, 0, 0);
        Reclaimer.scan((JournalFile[])this.files);
        this.assertCanDelete(0);
        this.assertCanDelete(1);
        this.assertCantDelete(2);
    }

    @Test
    public void testThreeFiles25() throws Exception {
        this.setup(3);
        this.setupPosNeg(0, 10, 7, 0, 0);
        this.setupPosNeg(1, 0, 3, 10, 0);
        this.setupPosNeg(2, 10, 3, 0, 0);
        Reclaimer.scan((JournalFile[])this.files);
        this.assertCanDelete(0);
        this.assertCanDelete(1);
        this.assertCantDelete(2);
    }

    @Test
    public void testThreeFiles26() throws Exception {
        this.setup(3);
        this.setupPosNeg(0, 10, 7, 0, 0);
        this.setupPosNeg(1, 0, 3, 10, 0);
        this.setupPosNeg(2, 10, 0, 0, 0);
        Reclaimer.scan((JournalFile[])this.files);
        this.assertCanDelete(0);
        this.assertCanDelete(1);
        this.assertCantDelete(2);
    }

    @Test
    public void testThreeFiles27() throws Exception {
        this.setup(3);
        this.setupPosNeg(0, 10, 10, 0, 0);
        this.setupPosNeg(1, 10, 0, 0, 0);
        this.setupPosNeg(2, 10, 0, 0, 0);
        Reclaimer.scan((JournalFile[])this.files);
        this.assertCanDelete(0);
        this.assertCantDelete(1);
        this.assertCantDelete(2);
    }

    @Test
    public void testThreeFiles28() throws Exception {
        this.setup(3);
        this.setupPosNeg(0, 10, 10, 0, 0);
        this.setupPosNeg(1, 10, 0, 3, 0);
        this.setupPosNeg(2, 10, 0, 0, 5);
        Reclaimer.scan((JournalFile[])this.files);
        this.assertCanDelete(0);
        this.assertCantDelete(1);
        this.assertCantDelete(2);
    }

    @Test
    public void testThreeFiles29() throws Exception {
        this.setup(3);
        this.setupPosNeg(0, 10, 10, 0, 0);
        this.setupPosNeg(1, 10, 0, 3, 0);
        this.setupPosNeg(2, 10, 0, 6, 5);
        Reclaimer.scan((JournalFile[])this.files);
        this.assertCanDelete(0);
        this.assertCantDelete(1);
        this.assertCantDelete(2);
    }

    @Test
    public void testThreeFiles30() throws Exception {
        this.setup(3);
        this.setupPosNeg(0, 10, 10, 0, 0);
        this.setupPosNeg(1, 10, 0, 3, 0);
        this.setupPosNeg(2, 0, 0, 6, 0);
        Reclaimer.scan((JournalFile[])this.files);
        this.assertCanDelete(0);
        this.assertCantDelete(1);
        this.assertCantDelete(2);
    }

    private void setup(int numFiles) {
        this.files = new JournalFile[numFiles];
        for (int i = 0; i < numFiles; ++i) {
            this.files[i] = new MockJournalFile();
        }
    }

    private void setupPosNeg(int fileNumber, int pos, int ... neg) {
        int i;
        JournalFile file = this.files[fileNumber];
        int totalDep = file.getTotalNegativeToOthers();
        for (i = 0; i < pos; ++i) {
            file.incPosCount();
        }
        for (i = 0; i < neg.length; ++i) {
            JournalFile reclaimable2 = this.files[i];
            for (int j = 0; j < neg[i]; ++j) {
                file.incNegCount(reclaimable2);
                ++totalDep;
            }
        }
        Assertions.assertEquals((int)totalDep, (int)file.getTotalNegativeToOthers());
    }

    private void assertCanDelete(int ... fileNumber) {
        for (int num : fileNumber) {
            Assertions.assertTrue((boolean)this.files[num].isCanReclaim());
        }
    }

    private void assertCantDelete(int ... fileNumber) {
        for (int num : fileNumber) {
            Assertions.assertFalse((boolean)this.files[num].isCanReclaim());
        }
    }

    static final class MockJournalFile
    implements JournalFile {
        private final Map<JournalFile, Integer> negCounts = new HashMap<JournalFile, Integer>();
        private int posCount;
        private int totalDep;
        private boolean posReclaimCriteria;
        private boolean negReclaimCriteria;

        MockJournalFile() {
        }

        public SequentialFile getFile() {
            return null;
        }

        public long getFileID() {
            return 0L;
        }

        public int getNegCount(JournalFile file) {
            Integer count = this.negCounts.get(file);
            if (count != null) {
                return count;
            }
            return 0;
        }

        public void fileRemoved(JournalFile fileRemoved) {
        }

        public int getReplaceableCount() {
            return 0;
        }

        public void incReplaceableCount() {
        }

        public void incAddRecord() {
        }

        public int getAddRecord() {
            return 0;
        }

        public void incNegCount(JournalFile file) {
            this.incNegCount(file, 1);
        }

        public void incNegCount(JournalFile file, int delta) {
            Integer count = this.negCounts.get(file);
            int c = count == null ? delta : count + delta;
            this.negCounts.put(file, c);
            this.totalDep += delta;
        }

        public int getPosCount() {
            return this.posCount;
        }

        public void incPosCount() {
            ++this.posCount;
        }

        public void decPosCount() {
            --this.posCount;
        }

        public boolean isPosReclaimCriteria() {
            return this.posReclaimCriteria;
        }

        public void setPosReclaimCriteria() {
            this.posReclaimCriteria = true;
        }

        public boolean isNegReclaimCriteria() {
            return this.negReclaimCriteria;
        }

        public void setNegReclaimCriteria() {
            this.negReclaimCriteria = true;
        }

        public boolean isCanReclaim() {
            return this.posReclaimCriteria && this.negReclaimCriteria;
        }

        public void addSize(int bytes) {
        }

        public void decSize(int bytes) {
        }

        public int getLiveSize() {
            return 0;
        }

        public int getRecordID() {
            return 0;
        }

        public int getTotalNegativeToOthers() {
            return this.totalDep;
        }

        public int getJournalVersion() {
            return 2;
        }
    }
}

