/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.tests.unit.core.remoting;

import org.apache.activemq.artemis.api.core.ActiveMQBuffer;
import org.apache.activemq.artemis.api.core.SimpleString;
import org.apache.activemq.artemis.tests.util.ActiveMQTestBase;
import org.apache.activemq.artemis.utils.RandomUtil;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

public abstract class ActiveMQBufferTestBase
extends ActiveMQTestBase {
    private ActiveMQBuffer wrapper;

    @Override
    @BeforeEach
    public void setUp() throws Exception {
        super.setUp();
        this.wrapper = this.createBuffer();
    }

    @Override
    @AfterEach
    public void tearDown() throws Exception {
        this.wrapper = null;
        super.tearDown();
    }

    protected abstract ActiveMQBuffer createBuffer();

    @Test
    public void testNullString() throws Exception {
        Assertions.assertNull((Object)this.putAndGetNullableString(null));
    }

    @Test
    public void testEmptyString() throws Exception {
        String result = this.putAndGetNullableString("");
        Assertions.assertNotNull((Object)result);
        Assertions.assertEquals((Object)"", (Object)result);
    }

    @Test
    public void testNonEmptyString() throws Exception {
        String junk = RandomUtil.randomString();
        String result = this.putAndGetNullableString(junk);
        Assertions.assertNotNull((Object)result);
        Assertions.assertEquals((Object)junk, (Object)result);
    }

    @Test
    public void testNullSimpleString() throws Exception {
        Assertions.assertNull((Object)this.putAndGetNullableSimpleString(null));
    }

    @Test
    public void testEmptySimpleString() throws Exception {
        SimpleString emptySimpleString = SimpleString.of((String)"");
        SimpleString result = this.putAndGetNullableSimpleString(emptySimpleString);
        Assertions.assertNotNull((Object)result);
        ActiveMQTestBase.assertEqualsByteArrays(emptySimpleString.getData(), result.getData());
    }

    @Test
    public void testNonEmptySimpleString() throws Exception {
        SimpleString junk = RandomUtil.randomSimpleString();
        SimpleString result = this.putAndGetNullableSimpleString(junk);
        Assertions.assertNotNull((Object)result);
        ActiveMQTestBase.assertEqualsByteArrays(junk.getData(), result.getData());
    }

    @Test
    public void testByte() throws Exception {
        byte b = RandomUtil.randomByte();
        this.wrapper.writeByte(b);
        Assertions.assertEquals((byte)b, (byte)this.wrapper.readByte());
    }

    @Test
    public void testUnsignedByte() throws Exception {
        byte b = -1;
        this.wrapper.writeByte(b);
        Assertions.assertEquals((int)255, (int)this.wrapper.readUnsignedByte());
        b = 15;
        this.wrapper.writeByte(b);
        Assertions.assertEquals((int)b, (int)this.wrapper.readUnsignedByte());
    }

    @Test
    public void testBytes() throws Exception {
        byte[] bytes = RandomUtil.randomBytes();
        this.wrapper.writeBytes(bytes);
        byte[] b = new byte[bytes.length];
        this.wrapper.readBytes(b);
        ActiveMQTestBase.assertEqualsByteArrays(bytes, b);
    }

    @Test
    public void testBytesWithLength() throws Exception {
        byte[] bytes = RandomUtil.randomBytes();
        this.wrapper.writeBytes(bytes, 0, bytes.length / 2);
        byte[] b = new byte[bytes.length / 2];
        this.wrapper.readBytes(b, 0, b.length);
        ActiveMQTestBase.assertEqualsByteArrays(b.length, bytes, b);
    }

    @Test
    public void testPutTrueBoolean() throws Exception {
        this.wrapper.writeBoolean(true);
        Assertions.assertTrue((boolean)this.wrapper.readBoolean());
    }

    @Test
    public void testPutFalseBoolean() throws Exception {
        this.wrapper.writeBoolean(false);
        Assertions.assertFalse((boolean)this.wrapper.readBoolean());
    }

    @Test
    public void testPutNullableTrueBoolean() throws Exception {
        this.wrapper.writeNullableBoolean(Boolean.valueOf(true));
        Assertions.assertTrue((boolean)this.wrapper.readNullableBoolean());
    }

    @Test
    public void testPutNullableFalseBoolean() throws Exception {
        this.wrapper.writeNullableBoolean(Boolean.valueOf(false));
        Assertions.assertFalse((boolean)this.wrapper.readNullableBoolean());
    }

    @Test
    public void testNullBoolean() throws Exception {
        this.wrapper.writeNullableBoolean(null);
        Assertions.assertNull((Object)this.wrapper.readNullableBoolean());
    }

    @Test
    public void testChar() throws Exception {
        this.wrapper.writeChar('a');
        Assertions.assertEquals((char)'a', (char)this.wrapper.readChar());
    }

    @Test
    public void testInt() throws Exception {
        int i = RandomUtil.randomInt();
        this.wrapper.writeInt(i);
        Assertions.assertEquals((int)i, (int)this.wrapper.readInt());
    }

    @Test
    public void testIntAtPosition() throws Exception {
        int firstInt = RandomUtil.randomInt();
        int secondInt = RandomUtil.randomInt();
        this.wrapper.writeInt(secondInt);
        this.wrapper.writeInt(secondInt);
        this.wrapper.setInt(0, firstInt);
        Assertions.assertEquals((int)firstInt, (int)this.wrapper.readInt());
        Assertions.assertEquals((int)secondInt, (int)this.wrapper.readInt());
    }

    @Test
    public void testLong() throws Exception {
        long l = RandomUtil.randomLong();
        this.wrapper.writeLong(l);
        Assertions.assertEquals((long)l, (long)this.wrapper.readLong());
    }

    @Test
    public void testNullableLong() throws Exception {
        Long l = RandomUtil.randomLong();
        this.wrapper.writeNullableLong(l);
        Assertions.assertEquals((Long)l, (Long)this.wrapper.readNullableLong());
    }

    @Test
    public void testNullLong() throws Exception {
        this.wrapper.writeNullableLong(null);
        Assertions.assertNull((Object)this.wrapper.readNullableLong());
    }

    @Test
    public void testUnsignedShort() throws Exception {
        short s1 = Short.MAX_VALUE;
        this.wrapper.writeShort(s1);
        int s2 = this.wrapper.readUnsignedShort();
        Assertions.assertEquals((int)s1, (int)s2);
        s1 = Short.MIN_VALUE;
        this.wrapper.writeShort(s1);
        s2 = this.wrapper.readUnsignedShort();
        Assertions.assertEquals((int)(s1 * -1), (int)s2);
        s1 = -1;
        this.wrapper.writeShort(s1);
        s2 = this.wrapper.readUnsignedShort();
        Assertions.assertEquals((int)s2, (int)65535);
    }

    @Test
    public void testShort() throws Exception {
        this.wrapper.writeShort((short)1);
        Assertions.assertEquals((short)1, (short)this.wrapper.readShort());
    }

    @Test
    public void testDouble() throws Exception {
        double d = RandomUtil.randomDouble();
        this.wrapper.writeDouble(d);
        Assertions.assertEquals((double)d, (double)this.wrapper.readDouble(), (double)1.0E-6);
    }

    @Test
    public void testFloat() throws Exception {
        float f = RandomUtil.randomFloat();
        this.wrapper.writeFloat(f);
        Assertions.assertEquals((double)f, (double)this.wrapper.readFloat(), (double)1.0E-6);
    }

    @Test
    public void testUTF() throws Exception {
        String str = RandomUtil.randomString();
        this.wrapper.writeUTF(str);
        Assertions.assertEquals((Object)str, (Object)this.wrapper.readUTF());
    }

    @Test
    public void testArray() throws Exception {
        byte[] bytes = RandomUtil.randomBytes((int)128);
        this.wrapper.writeBytes(bytes);
        byte[] array = this.wrapper.toByteBuffer().array();
        Assertions.assertEquals((int)this.wrapper.capacity(), (int)array.length);
        ActiveMQTestBase.assertEqualsByteArrays(128, bytes, this.wrapper.toByteBuffer().array());
    }

    @Test
    public void testRewind() throws Exception {
        int i = RandomUtil.randomInt();
        this.wrapper.writeInt(i);
        Assertions.assertEquals((int)i, (int)this.wrapper.readInt());
        this.wrapper.resetReaderIndex();
        Assertions.assertEquals((int)i, (int)this.wrapper.readInt());
    }

    @Test
    public void testRemaining() throws Exception {
        int capacity = this.wrapper.capacity();
        int fill = capacity / 3;
        byte[] bytes = RandomUtil.randomBytes((int)fill);
        this.wrapper.writeBytes(bytes);
        Assertions.assertEquals((int)(capacity - fill), (int)this.wrapper.writableBytes());
    }

    @Test
    public void testPosition() throws Exception {
        Assertions.assertEquals((int)0, (int)this.wrapper.writerIndex());
        byte[] bytes = RandomUtil.randomBytes((int)128);
        this.wrapper.writeBytes(bytes);
        Assertions.assertEquals((int)bytes.length, (int)this.wrapper.writerIndex());
        this.wrapper.writerIndex(0);
        Assertions.assertEquals((int)0, (int)this.wrapper.writerIndex());
    }

    private String putAndGetNullableString(String nullableString) throws Exception {
        this.wrapper.writeNullableString(nullableString);
        return this.wrapper.readNullableString();
    }

    private SimpleString putAndGetNullableSimpleString(SimpleString nullableSimpleString) throws Exception {
        this.wrapper.writeNullableSimpleString(nullableSimpleString);
        return this.wrapper.readNullableSimpleString();
    }
}

