/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.tests.unit.core.security.impl;

import java.util.HashSet;
import org.apache.activemq.artemis.core.security.CheckType;
import org.apache.activemq.artemis.core.security.Role;
import org.apache.activemq.artemis.spi.core.security.ActiveMQSecurityManagerImpl;
import org.apache.activemq.artemis.tests.util.ActiveMQTestBase;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

public class ActiveMQSecurityManagerImplTest
extends ActiveMQTestBase {
    private ActiveMQSecurityManagerImpl securityManager;

    @Override
    @BeforeEach
    public void setUp() throws Exception {
        super.setUp();
        this.securityManager = new ActiveMQSecurityManagerImpl();
    }

    @Override
    @AfterEach
    public void tearDown() throws Exception {
        this.securityManager = null;
        super.tearDown();
    }

    @Test
    public void testDefaultSecurity() {
        this.securityManager.getConfiguration().addUser("guest", "password");
        this.securityManager.getConfiguration().addRole("guest", "guest");
        this.securityManager.getConfiguration().setDefaultUser("guest");
        Assertions.assertTrue((boolean)this.securityManager.validateUser(null, null));
        Assertions.assertTrue((boolean)this.securityManager.validateUser("guest", "password"));
        Assertions.assertFalse((boolean)this.securityManager.validateUser(null, "wrongpass"));
        HashSet<Role> roles = new HashSet<Role>();
        roles.add(new Role("guest", true, true, true, true, true, true, true, true, true, true, false, false));
        Assertions.assertTrue((boolean)this.securityManager.validateUserAndRole(null, null, roles, CheckType.CREATE_DURABLE_QUEUE));
        Assertions.assertTrue((boolean)this.securityManager.validateUserAndRole(null, null, roles, CheckType.SEND));
        Assertions.assertTrue((boolean)this.securityManager.validateUserAndRole(null, null, roles, CheckType.CONSUME));
        roles = new HashSet();
        roles.add(new Role("guest", true, true, false, true, true, true, true, true, true, true, false, false));
        Assertions.assertFalse((boolean)this.securityManager.validateUserAndRole(null, null, roles, CheckType.CREATE_DURABLE_QUEUE));
        Assertions.assertTrue((boolean)this.securityManager.validateUserAndRole(null, null, roles, CheckType.SEND));
        Assertions.assertTrue((boolean)this.securityManager.validateUserAndRole(null, null, roles, CheckType.CONSUME));
        roles = new HashSet();
        roles.add(new Role("guest", true, false, false, true, true, true, true, true, true, true, false, false));
        Assertions.assertFalse((boolean)this.securityManager.validateUserAndRole(null, null, roles, CheckType.CREATE_DURABLE_QUEUE));
        Assertions.assertTrue((boolean)this.securityManager.validateUserAndRole(null, null, roles, CheckType.SEND));
        Assertions.assertFalse((boolean)this.securityManager.validateUserAndRole(null, null, roles, CheckType.CONSUME));
        roles = new HashSet();
        roles.add(new Role("guest", false, false, false, true, true, true, true, true, true, true, false, false));
        Assertions.assertFalse((boolean)this.securityManager.validateUserAndRole(null, null, roles, CheckType.CREATE_DURABLE_QUEUE));
        Assertions.assertFalse((boolean)this.securityManager.validateUserAndRole(null, null, roles, CheckType.SEND));
        Assertions.assertFalse((boolean)this.securityManager.validateUserAndRole(null, null, roles, CheckType.CONSUME));
    }

    @Test
    public void testAddingUsers() {
        this.securityManager.getConfiguration().addUser("newuser1", "newpassword1");
        Assertions.assertTrue((boolean)this.securityManager.validateUser("newuser1", "newpassword1"));
        Assertions.assertFalse((boolean)this.securityManager.validateUser("newuser1", "guest"));
        Assertions.assertFalse((boolean)this.securityManager.validateUser("newuser1", null));
        try {
            this.securityManager.getConfiguration().addUser("newuser2", null);
            Assertions.fail((String)"password cannot be null");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        try {
            this.securityManager.getConfiguration().addUser(null, "newpassword2");
            Assertions.fail((String)"password cannot be null");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void testRemovingUsers() {
        this.securityManager.getConfiguration().addUser("newuser1", "newpassword1");
        Assertions.assertTrue((boolean)this.securityManager.validateUser("newuser1", "newpassword1"));
        this.securityManager.getConfiguration().removeUser("newuser1");
        Assertions.assertFalse((boolean)this.securityManager.validateUser("newuser1", "newpassword1"));
    }

    @Test
    public void testRemovingInvalidUsers() {
        this.securityManager.getConfiguration().addUser("newuser1", "newpassword1");
        Assertions.assertTrue((boolean)this.securityManager.validateUser("newuser1", "newpassword1"));
        this.securityManager.getConfiguration().removeUser("nonuser");
        Assertions.assertTrue((boolean)this.securityManager.validateUser("newuser1", "newpassword1"));
    }

    @Test
    public void testAddingRoles() {
        this.securityManager.getConfiguration().addUser("newuser1", "newpassword1");
        this.securityManager.getConfiguration().addRole("newuser1", "role1");
        this.securityManager.getConfiguration().addRole("newuser1", "role2");
        this.securityManager.getConfiguration().addRole("newuser1", "role3");
        this.securityManager.getConfiguration().addRole("newuser1", "role4");
        HashSet<Role> roles = new HashSet<Role>();
        roles.add(new Role("role1", true, true, true, true, true, true, true, true, true, true, false, false));
        Assertions.assertTrue((boolean)this.securityManager.validateUserAndRole("newuser1", "newpassword1", roles, CheckType.SEND));
        roles = new HashSet();
        roles.add(new Role("role2", true, true, true, true, true, true, true, true, true, true, false, false));
        Assertions.assertTrue((boolean)this.securityManager.validateUserAndRole("newuser1", "newpassword1", roles, CheckType.SEND));
        roles = new HashSet();
        roles.add(new Role("role3", true, true, true, true, true, true, true, true, true, true, false, false));
        Assertions.assertTrue((boolean)this.securityManager.validateUserAndRole("newuser1", "newpassword1", roles, CheckType.SEND));
        roles = new HashSet();
        roles.add(new Role("role4", true, true, true, true, true, true, true, true, true, true, false, false));
        Assertions.assertTrue((boolean)this.securityManager.validateUserAndRole("newuser1", "newpassword1", roles, CheckType.SEND));
        roles = new HashSet();
        roles.add(new Role("role5", true, true, true, true, true, true, true, true, true, true, false, false));
        Assertions.assertFalse((boolean)this.securityManager.validateUserAndRole("newuser1", "newpassword1", roles, CheckType.SEND));
    }

    @Test
    public void testRemovingRoles() {
        this.securityManager.getConfiguration().addUser("newuser1", "newpassword1");
        this.securityManager.getConfiguration().addRole("newuser1", "role1");
        this.securityManager.getConfiguration().addRole("newuser1", "role2");
        this.securityManager.getConfiguration().addRole("newuser1", "role3");
        this.securityManager.getConfiguration().addRole("newuser1", "role4");
        this.securityManager.getConfiguration().removeRole("newuser1", "role2");
        this.securityManager.getConfiguration().removeRole("newuser1", "role4");
        HashSet<Role> roles = new HashSet<Role>();
        roles.add(new Role("role1", true, true, true, true, true, true, true, true, true, true, false, false));
        Assertions.assertTrue((boolean)this.securityManager.validateUserAndRole("newuser1", "newpassword1", roles, CheckType.SEND));
        roles = new HashSet();
        roles.add(new Role("role2", true, true, true, true, true, true, true, true, true, true, false, false));
        Assertions.assertFalse((boolean)this.securityManager.validateUserAndRole("newuser1", "newpassword1", roles, CheckType.SEND));
        roles = new HashSet();
        roles.add(new Role("role3", true, true, true, true, true, true, true, true, true, true, false, false));
        Assertions.assertTrue((boolean)this.securityManager.validateUserAndRole("newuser1", "newpassword1", roles, CheckType.SEND));
        roles = new HashSet();
        roles.add(new Role("role4", true, true, true, true, true, true, true, true, true, true, false, false));
        Assertions.assertFalse((boolean)this.securityManager.validateUserAndRole("newuser1", "newpassword1", roles, CheckType.SEND));
        roles = new HashSet();
        roles.add(new Role("role5", true, true, true, true, true, true, true, true, true, true, false, false));
        Assertions.assertFalse((boolean)this.securityManager.validateUserAndRole("newuser1", "newpassword1", roles, CheckType.SEND));
    }
}

