/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.tests.util;

import io.netty.bootstrap.Bootstrap;
import io.netty.bootstrap.ServerBootstrap;
import io.netty.buffer.Unpooled;
import io.netty.channel.Channel;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelFutureListener;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelInboundHandlerAdapter;
import io.netty.channel.ChannelInitializer;
import io.netty.channel.ChannelOption;
import io.netty.channel.ChannelPipeline;
import io.netty.channel.EventLoopGroup;
import io.netty.channel.nio.NioEventLoopGroup;
import io.netty.channel.socket.SocketChannel;
import io.netty.channel.socket.nio.NioServerSocketChannel;
import io.netty.handler.logging.LogLevel;
import io.netty.handler.logging.LoggingHandler;
import io.netty.util.concurrent.GenericFutureListener;
import jakarta.jms.Connection;
import jakarta.jms.ConnectionFactory;
import java.lang.invoke.MethodHandles;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.TimeUnit;
import org.apache.activemq.artemis.tests.util.CFUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class TcpProxy
implements Runnable {
    private static final Logger logger = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    ArrayList<OutboundHandler> outbound = new ArrayList();
    ArrayList<InboundHandler> inbound = new ArrayList();
    int localPort;
    String remoteHost;
    int remotePort;
    boolean logging;
    Thread thread;
    ChannelFuture channelFuture;

    public List<OutboundHandler> getOutbounddHandlers() {
        return this.outbound;
    }

    public List<InboundHandler> getInboundHandlers() {
        return this.inbound;
    }

    public void stopAllHandlers() {
        this.inbound.forEach(i -> i.setReadable(false));
        this.outbound.forEach(i -> i.setReadable(false));
    }

    public static void closeOnFlush(Channel ch) {
        if (ch.isActive()) {
            ch.writeAndFlush((Object)Unpooled.EMPTY_BUFFER).addListener((GenericFutureListener)ChannelFutureListener.CLOSE);
        }
    }

    public TcpProxy(String remoteHost, int remotePort, int localPort, boolean logging) {
        this.remoteHost = remoteHost;
        this.remotePort = remotePort;
        this.localPort = localPort;
        this.logging = logging;
    }

    public void tryCore(String user, String password) {
        ConnectionFactory cf = CFUtil.createConnectionFactory("CORE", "tcp://" + this.remoteHost + ":" + this.localPort);
        boolean succeeded = false;
        for (int i = 0; i < 10; ++i) {
            try (Connection connection = cf.createConnection(user, password);){
                succeeded = true;
                break;
            }
            catch (Exception e) {
                try {
                    Thread.sleep(100L);
                }
                catch (Exception exception) {
                    // empty catch block
                }
                continue;
            }
        }
        if (!succeeded) {
            throw new IllegalStateException("Proxy did not work as expected");
        }
        this.inbound.clear();
        this.outbound.clear();
    }

    public void startProxy() {
        this.thread = new Thread(this);
        this.thread.start();
    }

    public void stopProxy() throws Exception {
        this.stopProxy(5000);
    }

    public void stopProxy(int timeoutMillis) throws Exception {
        this.channelFuture.cancel(true);
        this.thread.join(timeoutMillis);
        if (this.thread.isAlive()) {
            throw new RuntimeException("Proxy thread still alive");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        logger.info("Proxying {} to {}", (Object)this.localPort, (Object)this.remotePort);
        NioEventLoopGroup bossGroup = new NioEventLoopGroup(1);
        NioEventLoopGroup workerGroup = new NioEventLoopGroup();
        try {
            ServerBootstrap b = new ServerBootstrap();
            b.group((EventLoopGroup)bossGroup, (EventLoopGroup)workerGroup).channel(NioServerSocketChannel.class);
            if (this.logging) {
                b.handler((ChannelHandler)new LoggingHandler(LogLevel.INFO));
            }
            this.channelFuture = b.childHandler((ChannelHandler)new ProxyInitializer(this.remoteHost, this.remotePort)).childOption(ChannelOption.AUTO_READ, (Object)false).bind(this.localPort).sync().channel().closeFuture();
            this.channelFuture.sync();
            logger.info("done");
        }
        catch (Throwable e) {
            logger.warn(e.getMessage(), e);
        }
        finally {
            bossGroup.shutdownGracefully(0L, 0L, TimeUnit.SECONDS);
            workerGroup.shutdownGracefully(0L, 0L, TimeUnit.SECONDS);
        }
    }

    class ProxyInitializer
    extends ChannelInitializer<SocketChannel> {
        private final String remoteHost;
        private final int remotePort;

        ProxyInitializer(String remoteHost, int remotePort) {
            this.remoteHost = remoteHost;
            this.remotePort = remotePort;
        }

        public void initChannel(SocketChannel ch) {
            ChannelPipeline pipeline = ch.pipeline();
            if (TcpProxy.this.logging) {
                pipeline.addLast(new ChannelHandler[]{new LoggingHandler(LogLevel.INFO)});
            }
            OutboundHandler outboundHandler = new OutboundHandler();
            TcpProxy.this.outbound.add(outboundHandler);
            pipeline.addLast(new ChannelHandler[]{outboundHandler});
        }
    }

    public class OutboundHandler
    extends ChannelInboundHandlerAdapter {
        private Channel outboundChannel;
        volatile boolean readable = true;

        public OutboundHandler setReadable(boolean readable) {
            this.readable = readable;
            if (readable) {
                this.outboundChannel.read();
            }
            return this;
        }

        public void channelActive(ChannelHandlerContext ctx) {
            Channel inboundChannel = ctx.channel();
            InboundHandler inboundHandler = new InboundHandler(inboundChannel);
            TcpProxy.this.inbound.add(inboundHandler);
            Bootstrap b = new Bootstrap();
            ((Bootstrap)((Bootstrap)((Bootstrap)b.group((EventLoopGroup)inboundChannel.eventLoop())).channel(ctx.channel().getClass())).handler((ChannelHandler)inboundHandler)).option(ChannelOption.AUTO_READ, (Object)false);
            ChannelFuture f = b.connect(TcpProxy.this.remoteHost, TcpProxy.this.remotePort);
            this.outboundChannel = f.channel();
            f.addListener(future -> {
                if (future.isSuccess()) {
                    inboundChannel.read();
                } else {
                    inboundChannel.close();
                }
            });
        }

        public void channelRead(ChannelHandlerContext ctx, Object msg) {
            if (this.outboundChannel.isActive()) {
                this.outboundChannel.writeAndFlush(msg).addListener((GenericFutureListener)((ChannelFutureListener)future -> {
                    if (future.isSuccess()) {
                        if (this.readable) {
                            ctx.channel().read();
                        }
                    } else {
                        new Exception("Closing").printStackTrace();
                        future.channel().close();
                    }
                }));
            }
        }

        public void channelInactive(ChannelHandlerContext ctx) {
            if (this.outboundChannel != null) {
                TcpProxy.closeOnFlush(this.outboundChannel);
            }
        }

        public void exceptionCaught(ChannelHandlerContext ctx, Throwable cause) {
            cause.printStackTrace();
            TcpProxy.closeOnFlush(ctx.channel());
        }
    }

    public class InboundHandler
    extends ChannelInboundHandlerAdapter {
        private final Channel inboundChannel;
        volatile boolean readable = true;

        public InboundHandler(Channel inboundChannel) {
            this.inboundChannel = inboundChannel;
        }

        public InboundHandler setReadable(boolean readable) {
            this.readable = readable;
            if (readable) {
                this.inboundChannel.read();
            }
            return this;
        }

        public void channelActive(ChannelHandlerContext ctx) {
            ctx.read();
        }

        public void channelRead(ChannelHandlerContext ctx, Object msg) {
            this.inboundChannel.writeAndFlush(msg).addListener((GenericFutureListener)((ChannelFutureListener)future -> {
                if (future.isSuccess()) {
                    if (this.readable) {
                        ctx.channel().read();
                    }
                } else {
                    new Exception("Closing").printStackTrace();
                    future.channel().close();
                }
            }));
        }

        public void channelInactive(ChannelHandlerContext ctx) {
            TcpProxy.closeOnFlush(this.inboundChannel);
        }

        public void exceptionCaught(ChannelHandlerContext ctx, Throwable cause) {
            cause.printStackTrace();
            TcpProxy.closeOnFlush(ctx.channel());
        }
    }
}

