/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.transport.amqp.client.sasl;

import java.lang.invoke.MethodHandles;
import java.util.ArrayList;
import java.util.Collections;
import javax.security.sasl.SaslException;
import org.apache.activemq.transport.amqp.client.sasl.AbstractMechanism;
import org.apache.activemq.transport.amqp.client.sasl.AnonymousMechanism;
import org.apache.activemq.transport.amqp.client.sasl.CramMD5Mechanism;
import org.apache.activemq.transport.amqp.client.sasl.Mechanism;
import org.apache.activemq.transport.amqp.client.sasl.PlainMechanism;
import org.apache.qpid.proton.engine.Sasl;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SaslAuthenticator {
    private static final Logger logger = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    private final Sasl sasl;
    private final String username;
    private final String password;
    private final String authzid;
    private Mechanism mechanism;
    private String mechanismRestriction;

    public SaslAuthenticator(Sasl sasl, String username, String password, String authzid, String mechanismRestriction) {
        this.sasl = sasl;
        this.username = username;
        this.password = password;
        this.authzid = authzid;
        this.mechanismRestriction = mechanismRestriction;
    }

    public boolean authenticate() throws SecurityException {
        switch (this.sasl.getState()) {
            case PN_SASL_IDLE: {
                this.handleSaslInit();
                break;
            }
            case PN_SASL_STEP: {
                this.handleSaslStep();
                break;
            }
            case PN_SASL_FAIL: {
                this.handleSaslFail();
                break;
            }
            case PN_SASL_PASS: {
                return true;
            }
        }
        return false;
    }

    private void handleSaslInit() throws SecurityException {
        block4: {
            try {
                String[] remoteMechanisms = this.sasl.getRemoteMechanisms();
                if (remoteMechanisms == null || remoteMechanisms.length == 0) break block4;
                this.mechanism = this.findMatchingMechanism(remoteMechanisms);
                if (this.mechanism != null) {
                    this.mechanism.setUsername(this.username);
                    this.mechanism.setPassword(this.password);
                    this.mechanism.setAuthzid(this.authzid);
                    this.sasl.setMechanisms(new String[]{this.mechanism.getName()});
                    byte[] response = this.mechanism.getInitialResponse();
                    if (response != null && response.length != 0) {
                        this.sasl.send(response, 0, response.length);
                    }
                    break block4;
                }
                throw new SecurityException("Could not find a matching SASL mechanism for the remote peer.");
            }
            catch (SaslException se) {
                SecurityException jmsse = new SecurityException("Exception while processing SASL init.");
                jmsse.initCause(se);
                throw jmsse;
            }
        }
    }

    private Mechanism findMatchingMechanism(String ... remoteMechanisms) {
        Mechanism match = null;
        ArrayList<PlainMechanism> found = new ArrayList<PlainMechanism>();
        for (String remoteMechanism : remoteMechanisms) {
            if (this.mechanismRestriction != null && !this.mechanismRestriction.equals(remoteMechanism)) {
                logger.debug("Skipping {} mechanism because it is not the configured mechanism restriction {}", (Object)remoteMechanism, (Object)this.mechanismRestriction);
                continue;
            }
            AbstractMechanism mechanism = null;
            if (remoteMechanism.equalsIgnoreCase("PLAIN")) {
                mechanism = new PlainMechanism();
            } else if (remoteMechanism.equalsIgnoreCase("ANONYMOUS")) {
                mechanism = new AnonymousMechanism();
            } else if (remoteMechanism.equalsIgnoreCase("CRAM-MD5")) {
                mechanism = new CramMD5Mechanism();
            } else {
                logger.debug("Unknown remote mechanism {}, skipping", (Object)remoteMechanism);
                continue;
            }
            if (!mechanism.isApplicable(this.username, this.password)) continue;
            found.add((PlainMechanism)mechanism);
        }
        if (!found.isEmpty()) {
            Collections.sort(found);
            match = (Mechanism)found.get(found.size() - 1);
        }
        logger.info("Best match for SASL auth was: {}", match);
        return match;
    }

    private void handleSaslStep() throws SecurityException {
        try {
            if (this.sasl.pending() != 0) {
                byte[] challenge = new byte[this.sasl.pending()];
                this.sasl.recv(challenge, 0, challenge.length);
                byte[] response = this.mechanism.getChallengeResponse(challenge);
                this.sasl.send(response, 0, response.length);
            }
        }
        catch (SaslException se) {
            SecurityException jmsse = new SecurityException("Exception while processing SASL step.");
            jmsse.initCause(se);
            throw jmsse;
        }
    }

    private void handleSaslFail() throws SecurityException {
        throw new SecurityException("Client failed to authenticate");
    }
}

