/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.transport.netty;

import io.netty.handler.ssl.SslHandler;
import java.io.File;
import java.io.FileInputStream;
import java.lang.invoke.MethodHandles;
import java.net.URI;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.SecureRandom;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.net.ssl.KeyManager;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLEngine;
import javax.net.ssl.SSLParameters;
import javax.net.ssl.TrustManager;
import javax.net.ssl.TrustManagerFactory;
import javax.net.ssl.X509ExtendedKeyManager;
import javax.net.ssl.X509TrustManager;
import org.apache.activemq.transport.netty.NettyTransportSslOptions;
import org.apache.activemq.transport.netty.X509AliasKeyManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NettyTransportSupport {
    private static final Logger logger = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());

    public static SslHandler createSslHandler(URI remote, NettyTransportSslOptions options) throws Exception {
        return new SslHandler(NettyTransportSupport.createSslEngine(remote, NettyTransportSupport.createSslContext(options), options));
    }

    public static SSLContext createSslContext(NettyTransportSslOptions options) throws Exception {
        try {
            String contextProtocol = options.getContextProtocol();
            logger.trace("Getting SSLContext instance using protocol: {}", (Object)contextProtocol);
            SSLContext context = SSLContext.getInstance(contextProtocol);
            KeyManager[] keyMgrs = NettyTransportSupport.loadKeyManagers(options);
            TrustManager[] trustManagers = NettyTransportSupport.loadTrustManagers(options);
            context.init(keyMgrs, trustManagers, new SecureRandom());
            return context;
        }
        catch (Exception e) {
            logger.error("Failed to create SSLContext: {}", (Object)e, (Object)e);
            throw e;
        }
    }

    public static SSLEngine createSslEngine(SSLContext context, NettyTransportSslOptions options) throws Exception {
        return NettyTransportSupport.createSslEngine(null, context, options);
    }

    public static SSLEngine createSslEngine(URI remote, SSLContext context, NettyTransportSslOptions options) throws Exception {
        SSLEngine engine = null;
        engine = remote == null ? context.createSSLEngine() : context.createSSLEngine(remote.getHost(), remote.getPort());
        engine.setEnabledProtocols(NettyTransportSupport.buildEnabledProtocols(engine, options));
        engine.setEnabledCipherSuites(NettyTransportSupport.buildEnabledCipherSuites(engine, options));
        engine.setUseClientMode(true);
        if (options.isVerifyHost()) {
            SSLParameters sslParameters = engine.getSSLParameters();
            sslParameters.setEndpointIdentificationAlgorithm("HTTPS");
            engine.setSSLParameters(sslParameters);
        }
        return engine;
    }

    private static String[] buildEnabledProtocols(SSLEngine engine, NettyTransportSslOptions options) {
        ArrayList<String> enabledProtocols = new ArrayList<String>();
        if (options.getEnabledProtocols() != null) {
            List<String> configuredProtocols = Arrays.asList(options.getEnabledProtocols());
            logger.trace("Configured protocols from transport options: {}", configuredProtocols);
            enabledProtocols.addAll(configuredProtocols);
        } else {
            List<String> engineProtocols = Arrays.asList(engine.getEnabledProtocols());
            logger.trace("Default protocols from the SSLEngine: {}", engineProtocols);
            enabledProtocols.addAll(engineProtocols);
        }
        String[] disabledProtocols = options.getDisabledProtocols();
        if (disabledProtocols != null) {
            List<String> disabled = Arrays.asList(disabledProtocols);
            logger.trace("Disabled protocols: {}", disabled);
            enabledProtocols.removeAll(disabled);
        }
        logger.trace("Enabled protocols: {}", enabledProtocols);
        return enabledProtocols.toArray(new String[0]);
    }

    private static String[] buildEnabledCipherSuites(SSLEngine engine, NettyTransportSslOptions options) {
        ArrayList<String> enabledCipherSuites = new ArrayList<String>();
        if (options.getEnabledCipherSuites() != null) {
            List<String> configuredCipherSuites = Arrays.asList(options.getEnabledCipherSuites());
            logger.trace("Configured cipher suites from transport options: {}", configuredCipherSuites);
            enabledCipherSuites.addAll(configuredCipherSuites);
        } else {
            List<String> engineCipherSuites = Arrays.asList(engine.getEnabledCipherSuites());
            logger.trace("Default cipher suites from the SSLEngine: {}", engineCipherSuites);
            enabledCipherSuites.addAll(engineCipherSuites);
        }
        String[] disabledCipherSuites = options.getDisabledCipherSuites();
        if (disabledCipherSuites != null) {
            List<String> disabled = Arrays.asList(disabledCipherSuites);
            logger.trace("Disabled cipher suites: {}", disabled);
            enabledCipherSuites.removeAll(disabled);
        }
        logger.trace("Enabled cipher suites: {}", enabledCipherSuites);
        return enabledCipherSuites.toArray(new String[0]);
    }

    private static TrustManager[] loadTrustManagers(NettyTransportSslOptions options) throws Exception {
        if (options.isTrustAll()) {
            return new TrustManager[]{NettyTransportSupport.createTrustAllTrustManager()};
        }
        if (options.getTrustStoreLocation() == null) {
            return null;
        }
        TrustManagerFactory fact = TrustManagerFactory.getInstance(TrustManagerFactory.getDefaultAlgorithm());
        String storeLocation = options.getTrustStoreLocation();
        String storePassword = options.getTrustStorePassword();
        String storeType = options.getStoreType();
        logger.trace("Attempt to load TrustStore from location {} of type {}", (Object)storeLocation, (Object)storeType);
        KeyStore trustStore = NettyTransportSupport.loadStore(storeLocation, storePassword, storeType);
        fact.init(trustStore);
        return fact.getTrustManagers();
    }

    private static KeyManager[] loadKeyManagers(NettyTransportSslOptions options) throws Exception {
        if (options.getKeyStoreLocation() == null) {
            return null;
        }
        KeyManagerFactory fact = KeyManagerFactory.getInstance(KeyManagerFactory.getDefaultAlgorithm());
        String storeLocation = options.getKeyStoreLocation();
        String storePassword = options.getKeyStorePassword();
        String storeType = options.getStoreType();
        String alias = options.getKeyAlias();
        logger.trace("Attempt to load KeyStore from location {} of type {}", (Object)storeLocation, (Object)storeType);
        KeyStore keyStore = NettyTransportSupport.loadStore(storeLocation, storePassword, storeType);
        fact.init(keyStore, storePassword != null ? storePassword.toCharArray() : null);
        if (alias == null) {
            return fact.getKeyManagers();
        }
        NettyTransportSupport.validateAlias(keyStore, alias);
        return NettyTransportSupport.wrapKeyManagers(alias, fact.getKeyManagers());
    }

    private static KeyManager[] wrapKeyManagers(String alias, KeyManager[] origKeyManagers) {
        KeyManager[] keyManagers = new KeyManager[origKeyManagers.length];
        for (int i = 0; i < origKeyManagers.length; ++i) {
            KeyManager km = origKeyManagers[i];
            if (km instanceof X509ExtendedKeyManager) {
                km = new X509AliasKeyManager(alias, (X509ExtendedKeyManager)km);
            }
            keyManagers[i] = km;
        }
        return keyManagers;
    }

    private static void validateAlias(KeyStore store, String alias) throws IllegalArgumentException, KeyStoreException {
        if (!store.containsAlias(alias)) {
            throw new IllegalArgumentException("The alias '" + alias + "' doesn't exist in the key store");
        }
        if (!store.isKeyEntry(alias)) {
            throw new IllegalArgumentException("The alias '" + alias + "' in the keystore doesn't represent a key entry");
        }
    }

    private static KeyStore loadStore(String storePath, String password, String storeType) throws Exception {
        KeyStore store = KeyStore.getInstance(storeType);
        try (FileInputStream in = new FileInputStream(new File(storePath));){
            store.load(in, password != null ? password.toCharArray() : null);
        }
        return store;
    }

    private static TrustManager createTrustAllTrustManager() {
        return new X509TrustManager(){

            @Override
            public void checkClientTrusted(X509Certificate[] x509Certificates, String s) throws CertificateException {
            }

            @Override
            public void checkServerTrusted(X509Certificate[] x509Certificates, String s) throws CertificateException {
            }

            @Override
            public X509Certificate[] getAcceptedIssuers() {
                return new X509Certificate[0];
            }
        };
    }
}

