/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.resteasy.specimpl;

import jakarta.ws.rs.core.Cookie;
import jakarta.ws.rs.core.HttpHeaders;
import jakarta.ws.rs.core.MediaType;
import jakarta.ws.rs.core.MultivaluedMap;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.StringTokenizer;
import org.jboss.resteasy.specimpl.UnmodifiableMultivaluedMap;
import org.jboss.resteasy.util.CookieParser;
import org.jboss.resteasy.util.DateUtil;
import org.jboss.resteasy.util.LocaleHelper;
import org.jboss.resteasy.util.MediaTypeHelper;
import org.jboss.resteasy.util.WeightedLanguage;

public class ResteasyHttpHeaders
implements HttpHeaders {
    private static final List<MediaType> MEDIA_WILDCARD = List.of(MediaType.WILDCARD_TYPE);
    private static final List<Locale> LANGUAGE_WILDCARD = List.of(Locale.ROOT);
    private static final Map<String, List<MediaType>> mediaTypeCache = Map.ofEntries(Map.entry(MediaType.APPLICATION_ATOM_XML_TYPE.toString(), List.of(MediaType.APPLICATION_ATOM_XML_TYPE)), Map.entry(MediaType.APPLICATION_FORM_URLENCODED_TYPE.toString(), List.of(MediaType.APPLICATION_FORM_URLENCODED_TYPE)), Map.entry(MediaType.APPLICATION_JSON_PATCH_JSON_TYPE.toString(), List.of(MediaType.APPLICATION_JSON_PATCH_JSON_TYPE)), Map.entry(MediaType.APPLICATION_JSON_TYPE.toString(), List.of(MediaType.APPLICATION_JSON_TYPE)), Map.entry(MediaType.APPLICATION_OCTET_STREAM_TYPE.toString(), List.of(MediaType.APPLICATION_OCTET_STREAM_TYPE)), Map.entry(MediaType.APPLICATION_SVG_XML_TYPE.toString(), List.of(MediaType.APPLICATION_SVG_XML_TYPE)), Map.entry(MediaType.APPLICATION_XHTML_XML_TYPE.toString(), List.of(MediaType.APPLICATION_XHTML_XML_TYPE)), Map.entry(MediaType.APPLICATION_XML_TYPE.toString(), List.of(MediaType.APPLICATION_XML_TYPE)), Map.entry(MediaType.MULTIPART_FORM_DATA_TYPE.toString(), List.of(MediaType.MULTIPART_FORM_DATA_TYPE)), Map.entry(MediaType.SERVER_SENT_EVENTS_TYPE.toString(), List.of(MediaType.SERVER_SENT_EVENTS_TYPE)), Map.entry(MediaType.TEXT_HTML_TYPE.toString(), List.of(MediaType.TEXT_HTML_TYPE)), Map.entry(MediaType.TEXT_PLAIN_TYPE.toString(), List.of(MediaType.TEXT_PLAIN_TYPE)), Map.entry(MediaType.TEXT_XML_TYPE.toString(), List.of(MediaType.TEXT_XML_TYPE)), Map.entry(MediaType.WILDCARD_TYPE.toString(), MEDIA_WILDCARD));
    private static final Map<String, List<Locale>> languageCache = Map.ofEntries(Map.entry(Locale.CHINESE.toString(), List.of(Locale.CHINESE)), Map.entry(Locale.ENGLISH.toString(), List.of(Locale.ENGLISH)), Map.entry(Locale.FRENCH.toString(), List.of(Locale.FRENCH)), Map.entry(Locale.GERMAN.toString(), List.of(Locale.GERMAN)), Map.entry(Locale.ITALIAN.toString(), List.of(Locale.ITALIAN)), Map.entry(Locale.JAPANESE.toString(), List.of(Locale.JAPANESE)), Map.entry(Locale.KOREAN.toString(), List.of(Locale.KOREAN)), Map.entry(Locale.SIMPLIFIED_CHINESE.toString(), List.of(Locale.SIMPLIFIED_CHINESE)), Map.entry(Locale.TRADITIONAL_CHINESE.toString(), List.of(Locale.TRADITIONAL_CHINESE)), Map.entry("", LANGUAGE_WILDCARD));
    private final MultivaluedMap<String, String> requestHeaders;
    private final MultivaluedMap<String, String> unmodifiableRequestHeaders;
    private Map<String, Cookie> cookies;
    private String cachedMediaTypeString;
    private MediaType cachedMediaType;

    public ResteasyHttpHeaders(MultivaluedMap<String, String> requestHeaders) {
        this(requestHeaders, new HashMap<String, Cookie>());
    }

    public ResteasyHttpHeaders(MultivaluedMap<String, String> requestHeaders, boolean eagerlyInitializeEntrySet) {
        this(requestHeaders, new HashMap<String, Cookie>(), eagerlyInitializeEntrySet);
    }

    public ResteasyHttpHeaders(MultivaluedMap<String, String> requestHeaders, Map<String, Cookie> cookies) {
        this(requestHeaders, cookies, true);
    }

    public ResteasyHttpHeaders(MultivaluedMap<String, String> requestHeaders, Map<String, Cookie> cookies, boolean eagerlyInitializeEntrySet) {
        this.requestHeaders = requestHeaders;
        this.unmodifiableRequestHeaders = new UnmodifiableMultivaluedMap<String, String>(requestHeaders, eagerlyInitializeEntrySet);
        this.cookies = cookies == null ? new HashMap() : cookies;
    }

    public MultivaluedMap<String, String> getRequestHeaders() {
        return this.unmodifiableRequestHeaders;
    }

    public MultivaluedMap<String, String> getMutableHeaders() {
        return this.requestHeaders;
    }

    public void testParsing() {
        this.getAcceptableMediaTypes();
        this.getMediaType();
        this.getLanguage();
        this.getAcceptableLanguages();
    }

    public List<String> getRequestHeader(String name) {
        List vals = (List)this.unmodifiableRequestHeaders.get((Object)name);
        return vals == null ? Collections.emptyList() : vals;
    }

    public Map<String, Cookie> getCookies() {
        this.mergeCookies();
        return Collections.unmodifiableMap(this.cookies);
    }

    public Map<String, Cookie> getMutableCookies() {
        this.mergeCookies();
        return this.cookies;
    }

    public void setCookies(Map<String, Cookie> cookies) {
        this.cookies = cookies;
    }

    public Date getDate() {
        String date = (String)this.requestHeaders.getFirst((Object)"Date");
        if (date == null) {
            return null;
        }
        return DateUtil.parseDate(date);
    }

    public String getHeaderString(String name) {
        List vals = (List)this.requestHeaders.get((Object)name);
        if (vals == null) {
            return null;
        }
        StringBuilder builder = new StringBuilder();
        boolean first = true;
        for (String val : vals) {
            if (first) {
                first = false;
            } else {
                builder.append(",");
            }
            builder.append(val);
        }
        return builder.toString();
    }

    public Locale getLanguage() {
        String obj = (String)this.requestHeaders.getFirst((Object)"Content-Language");
        if (obj == null) {
            return null;
        }
        return LocaleHelper.extractLocale(obj);
    }

    public int getLength() {
        String obj = (String)this.requestHeaders.getFirst((Object)"Content-Length");
        if (obj == null) {
            return -1;
        }
        return Integer.parseInt(obj);
    }

    public MediaType getMediaType() {
        String obj = (String)this.requestHeaders.getFirst((Object)"Content-Type");
        if (obj == null) {
            return null;
        }
        if (obj == this.cachedMediaTypeString) {
            return this.cachedMediaType;
        }
        this.cachedMediaTypeString = obj;
        this.cachedMediaType = MediaType.valueOf((String)obj);
        return this.cachedMediaType;
    }

    public List<MediaType> getAcceptableMediaTypes() {
        List vals = (List)this.requestHeaders.get((Object)"Accept");
        if (vals == null || vals.isEmpty()) {
            return MEDIA_WILDCARD;
        }
        if (vals.size() == 1) {
            String type = ((String)vals.get(0)).trim();
            if ("*/*".equals(type)) {
                return MEDIA_WILDCARD;
            }
            List<MediaType> standard = mediaTypeCache.get(type);
            if (standard != null) {
                return standard;
            }
        }
        ArrayList<MediaType> list = new ArrayList<MediaType>();
        for (String v : vals) {
            StringTokenizer tokenizer = new StringTokenizer(v, ",");
            while (tokenizer.hasMoreElements()) {
                String item = tokenizer.nextToken().trim();
                list.add(MediaType.valueOf((String)item));
            }
        }
        MediaTypeHelper.sortByWeight(list);
        return Collections.unmodifiableList(list);
    }

    public List<Locale> getAcceptableLanguages() {
        List vals = (List)this.requestHeaders.get((Object)"Accept-Language");
        if (vals == null || vals.isEmpty()) {
            return LANGUAGE_WILDCARD;
        }
        if (vals.size() == 1) {
            String type = (String)vals.get(0);
            if (type.isBlank()) {
                return LANGUAGE_WILDCARD;
            }
            List<Locale> standard = languageCache.get(type);
            if (standard != null) {
                return standard;
            }
        }
        ArrayList<WeightedLanguage> languages = new ArrayList<WeightedLanguage>();
        for (String v : vals) {
            StringTokenizer tokenizer = new StringTokenizer(v, ",");
            while (tokenizer.hasMoreElements()) {
                String item = tokenizer.nextToken().trim();
                languages.add(WeightedLanguage.parse(item));
            }
        }
        Collections.sort(languages);
        ArrayList<Locale> list = new ArrayList<Locale>(languages.size());
        for (WeightedLanguage language : languages) {
            list.add(language.getLocale());
        }
        return Collections.unmodifiableList(list);
    }

    private void mergeCookies() {
        List cookieHeader = (List)this.requestHeaders.get((Object)"Cookie");
        if (cookieHeader != null && !cookieHeader.isEmpty()) {
            for (String s : cookieHeader) {
                List<Cookie> list = CookieParser.parseCookies(s);
                for (Cookie cookie : list) {
                    this.cookies.put(cookie.getName(), cookie);
                }
            }
        }
    }
}

