/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.extension.undertow;

import io.undertow.connector.ByteBufferPool;
import io.undertow.server.handlers.DisallowedMethodsHandler;
import io.undertow.server.handlers.PeerNameResolvingHandler;
import io.undertow.servlet.handlers.MarkSecureHandler;
import io.undertow.util.HttpString;
import java.util.HashSet;
import java.util.List;
import java.util.function.Consumer;
import org.jboss.as.controller.AbstractAddStepHandler;
import org.jboss.as.controller.CapabilityServiceBuilder;
import org.jboss.as.controller.ExpressionResolver;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.PathAddress;
import org.jboss.as.controller.capability.RuntimeCapability;
import org.jboss.as.controller.registry.Resource;
import org.jboss.as.network.SocketBinding;
import org.jboss.dmr.ModelNode;
import org.wildfly.extension.io.OptionList;
import org.wildfly.extension.undertow.ListenerResourceDefinition;
import org.wildfly.extension.undertow.ListenerService;
import org.wildfly.extension.undertow.Server;
import org.wildfly.extension.undertow.ServerDefinition;
import org.xnio.OptionMap;
import org.xnio.XnioWorker;

abstract class ListenerAdd<S extends ListenerService>
extends AbstractAddStepHandler {
    ListenerAdd() {
    }

    protected void recordCapabilitiesAndRequirements(OperationContext context, ModelNode operation, Resource resource) throws OperationFailedException {
        super.recordCapabilitiesAndRequirements(context, operation, resource);
        String ourCap = ListenerResourceDefinition.LISTENER_CAPABILITY.getDynamicName(context.getCurrentAddress());
        String serverCap = ServerDefinition.SERVER_CAPABILITY.getDynamicName(context.getCurrentAddress().getParent());
        context.registerAdditionalCapabilityRequirement(serverCap, ourCap, null);
    }

    protected void performRuntime(OperationContext context, ModelNode operation, ModelNode model) throws OperationFailedException {
        List disallowedMethods;
        PathAddress address = context.getCurrentAddress();
        PathAddress parent = address.getParent();
        String name = context.getCurrentAddressValue();
        String bindingRef = ListenerResourceDefinition.SOCKET_BINDING.resolveModelAttribute(context, model).asString();
        String workerName = ListenerResourceDefinition.WORKER.resolveModelAttribute(context, model).asString();
        String bufferPoolName = ListenerResourceDefinition.BUFFER_POOL.resolveModelAttribute(context, model).asString();
        boolean enabled = ListenerResourceDefinition.ENABLED.resolveModelAttribute(context, model).asBoolean();
        boolean peerHostLookup = ListenerResourceDefinition.RESOLVE_PEER_ADDRESS.resolveModelAttribute(context, model).asBoolean();
        boolean secure = ListenerResourceDefinition.SECURE.resolveModelAttribute(context, model).asBoolean();
        OptionMap listenerOptions = OptionList.resolveOptions((ExpressionResolver)context, (ModelNode)model, ListenerResourceDefinition.LISTENER_OPTIONS);
        OptionMap socketOptions = OptionList.resolveOptions((ExpressionResolver)context, (ModelNode)model, ListenerResourceDefinition.SOCKET_OPTIONS);
        String serverName = parent.getLastElement().getValue();
        CapabilityServiceBuilder sb = context.getCapabilityServiceTarget().addCapability(ListenerResourceDefinition.LISTENER_CAPABILITY);
        Consumer serviceConsumer = sb.provides(new RuntimeCapability[]{ListenerResourceDefinition.LISTENER_CAPABILITY, ListenerResourceDefinition.SERVER_LISTENER_CAPABILITY});
        S service = this.createService(serviceConsumer, name, serverName, context, model, listenerOptions, socketOptions);
        if (peerHostLookup) {
            ((ListenerService)service).addWrapperHandler(PeerNameResolvingHandler::new);
        }
        ((ListenerService)service).setEnabled(enabled);
        if (secure) {
            ((ListenerService)service).addWrapperHandler(MarkSecureHandler.WRAPPER);
        }
        if (!(disallowedMethods = ListenerResourceDefinition.DISALLOWED_METHODS.unwrap((ExpressionResolver)context, model)).isEmpty()) {
            HashSet<HttpString> methodSet = new HashSet<HttpString>();
            for (String i : disallowedMethods) {
                HttpString httpString = new HttpString(i.trim());
                methodSet.add(httpString);
            }
            ((ListenerService)service).addWrapperHandler(handler -> new DisallowedMethodsHandler(handler, methodSet));
        }
        sb.setInstance(service);
        ((ListenerService)service).getWorker().set(sb.requiresCapability("org.wildfly.io.worker", XnioWorker.class, new String[]{workerName}));
        ((ListenerService)service).getBinding().set(sb.requires(SocketBinding.SERVICE_DESCRIPTOR, bindingRef));
        ((ListenerService)service).getBufferPool().set(sb.requiresCapability("org.wildfly.undertow.byte-buffer-pool", ByteBufferPool.class, new String[]{bufferPoolName}));
        ((ListenerService)service).getServerService().set(sb.requires(Server.SERVICE_DESCRIPTOR, serverName));
        this.configureAdditionalDependencies(context, sb, model, service);
        sb.install();
    }

    abstract S createService(Consumer<ListenerService> var1, String var2, String var3, OperationContext var4, ModelNode var5, OptionMap var6, OptionMap var7) throws OperationFailedException;

    abstract void configureAdditionalDependencies(OperationContext var1, CapabilityServiceBuilder<?> var2, ModelNode var3, S var4) throws OperationFailedException;
}

