/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.faulttolerance.config;

import io.smallrye.faulttolerance.api.CustomBackoff;
import io.smallrye.faulttolerance.api.CustomBackoffStrategy;
import io.smallrye.faulttolerance.autoconfig.FaultToleranceMethod;
import io.smallrye.faulttolerance.autoconfig.MethodDescriptor;
import io.smallrye.faulttolerance.basicconfig.ConfigUtil;
import io.smallrye.faulttolerance.config.CustomBackoffConfig;
import java.lang.annotation.Annotation;
import java.util.Optional;
import org.eclipse.microprofile.config.Config;
import org.eclipse.microprofile.config.ConfigProvider;
import org.eclipse.microprofile.faulttolerance.exceptions.FaultToleranceDefinitionException;

public final class CustomBackoffConfigImpl
implements CustomBackoffConfig {
    private final Class<?> beanClass;
    private final MethodDescriptor method;
    private final boolean onMethod;
    private final String description;
    private final String configKey;
    private final CustomBackoff instance;
    private Class<? extends CustomBackoffStrategy> _value;

    private CustomBackoffConfigImpl(FaultToleranceMethod method) {
        this.beanClass = method.beanClass;
        this.method = method.method;
        this.onMethod = method.annotationsPresentDirectly.contains(CustomBackoff.class);
        this.description = method.method.toString();
        this.configKey = this.onMethod ? method.method.declaringClass.getName() + "/" + method.method.name : method.method.declaringClass.getName();
        this.instance = method.customBackoff;
    }

    public static CustomBackoffConfigImpl create(FaultToleranceMethod method) {
        if (method.customBackoff == null) {
            return null;
        }
        if (!ConfigUtil.isEnabled((String)"custom-backoff.enabled", (String)"CustomBackoff/enabled", (MethodDescriptor)method.method)) {
            return null;
        }
        return new CustomBackoffConfigImpl(method);
    }

    public boolean isOnMethod() {
        return this.onMethod;
    }

    public Class<?> beanClass() {
        return this.beanClass;
    }

    public MethodDescriptor method() {
        return this.method;
    }

    public Class<? extends Annotation> annotationType() {
        return CustomBackoff.class;
    }

    public Class<? extends CustomBackoffStrategy> value() {
        if (this._value == null) {
            Config config = ConfigProvider.getConfig();
            Object newKey = "smallrye.faulttolerance.\"" + this.configKey + "\".custom-backoff.value";
            Object oldKey = this.configKey + "/CustomBackoff/value";
            this._value = config.getOptionalValue((String)newKey, Class.class).or(() -> CustomBackoffConfigImpl.lambda$value$0(config, (String)oldKey)).orElse(null);
            if (this._value == null) {
                newKey = "smallrye.faulttolerance.global.custom-backoff.value";
                oldKey = "CustomBackoff/value";
                this._value = config.getOptionalValue((String)newKey, Class.class).or(() -> CustomBackoffConfigImpl.lambda$value$1(config, (String)oldKey)).orElse(null);
            }
            if (this._value == null) {
                this._value = this.instance.value();
            }
        }
        return this._value;
    }

    public void materialize() {
        this.value();
    }

    public FaultToleranceDefinitionException fail(String reason) {
        return new FaultToleranceDefinitionException("Invalid @CustomBackoff on " + this.description + ": " + reason);
    }

    public FaultToleranceDefinitionException fail(String member, String reason) {
        return new FaultToleranceDefinitionException("Invalid @CustomBackoff." + member + " on " + this.description + ": " + reason);
    }

    private static /* synthetic */ Optional lambda$value$1(Config config, String oldKey) {
        return config.getOptionalValue(oldKey, Class.class);
    }

    private static /* synthetic */ Optional lambda$value$0(Config config, String oldKey) {
        return config.getOptionalValue(oldKey, Class.class);
    }
}

