/*
 * Decompiled with CFR 0.152.
 */
package com.arjuna.webservices.base.processors;

import com.arjuna.webservices.base.processors.Callback;
import com.arjuna.webservices.logging.WSCLogger;
import java.util.HashMap;
import java.util.Map;

public abstract class BaseProcessor {
    private final Map callbackMap = new HashMap();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void register(String messageID, Callback callback) {
        Map map = this.callbackMap;
        synchronized (map) {
            this.callbackMap.put(messageID, callback);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeCallback(String messageID) {
        Map map = this.callbackMap;
        synchronized (map) {
            this.callbackMap.remove(messageID);
        }
    }

    protected void handleCallbacks(CallbackExecutor executor, String[] ids) {
        Callback[] callbacks = this.getCallbacks(ids);
        if (callbacks != null) {
            boolean executed = false;
            for (Callback callback : callbacks) {
                if (callback == null) continue;
                executed = true;
                try {
                    executor.execute(callback);
                    callback.setTriggered();
                }
                catch (Throwable th) {
                    if (WSCLogger.logger.isTraceEnabled()) {
                        WSCLogger.logger.tracev("Unexpected throwable while executing callback:", (Object)th);
                    }
                    callback.setFailed();
                }
            }
            if (!executed && WSCLogger.logger.isTraceEnabled()) {
                executor.executeUnknownIds(ids);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Callback[] getCallbacks(String[] ids) {
        if (ids == null) {
            return null;
        }
        int numIDs = ids.length;
        Callback[] callbacks = new Callback[numIDs];
        Map map = this.callbackMap;
        synchronized (map) {
            for (int count = 0; count < numIDs; ++count) {
                callbacks[count] = (Callback)this.callbackMap.get(ids[count]);
            }
        }
        return callbacks;
    }

    protected static interface CallbackExecutor {
        public void execute(Callback var1);

        public void executeUnknownIds(String[] var1);
    }

    protected static abstract class CallbackExecutorAdapter
    implements CallbackExecutor {
        protected CallbackExecutorAdapter() {
        }

        @Override
        public void executeUnknownIds(String[] ids) {
            WSCLogger.logger.tracev("Received a response for non existent message IDs {0}", new Object[]{this.toString(ids)});
        }

        private String toString(String[] ids) {
            int numIDs;
            int n = numIDs = ids == null ? 0 : ids.length;
            if (numIDs == 0) {
                return "";
            }
            if (numIDs == 1) {
                return ids[0];
            }
            StringBuffer buffer = new StringBuffer(ids[0]);
            for (int count = 1; count < numIDs; ++count) {
                buffer.append(", ");
                buffer.append(ids[count]);
            }
            return buffer.toString();
        }
    }
}

