/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.index;

import java.io.IOException;
import org.apache.lucene.index.FieldInfo;
import org.apache.lucene.index.LeafReader;
import org.apache.lucene.index.VectorEncoding;
import org.apache.lucene.search.DocIdSetIterator;
import org.apache.lucene.search.VectorScorer;

public abstract class ByteVectorValues
extends DocIdSetIterator {
    protected ByteVectorValues() {
    }

    public abstract int dimension();

    public abstract int size();

    @Override
    public final long cost() {
        return this.size();
    }

    public abstract byte[] vectorValue() throws IOException;

    public static void checkField(LeafReader in, String field) {
        FieldInfo fi = in.getFieldInfos().fieldInfo(field);
        if (fi != null && fi.hasVectorValues() && fi.getVectorEncoding() != VectorEncoding.BYTE) {
            throw new IllegalStateException("Unexpected vector encoding (" + fi.getVectorEncoding() + ") for field " + field + "(expected=" + VectorEncoding.BYTE + ")");
        }
    }

    public abstract VectorScorer scorer(byte[] var1) throws IOException;
}

