/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.clustering.infinispan.cache;

import java.lang.annotation.Annotation;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.TimeUnit;
import org.infinispan.AdvancedCache;
import org.infinispan.Cache;
import org.infinispan.CacheCollection;
import org.infinispan.CacheSet;
import org.infinispan.configuration.cache.Configuration;
import org.infinispan.lifecycle.ComponentStatus;
import org.infinispan.manager.EmbeddedCacheManager;
import org.infinispan.notifications.cachelistener.filter.CacheEventConverter;
import org.infinispan.notifications.cachelistener.filter.CacheEventFilter;
import org.jboss.as.clustering.infinispan.cache.LazyBasicCache;

public class LazyCache<K, V>
extends LazyBasicCache<K, V, Cache<K, V>>
implements Cache<K, V> {
    private final EmbeddedCacheManager container;
    private final String name;

    public LazyCache(EmbeddedCacheManager container, String name) {
        super(name);
        this.container = container;
        this.name = name;
    }

    @Override
    public Cache<K, V> run() {
        return this.container.getCache(this.name);
    }

    public EmbeddedCacheManager getCacheManager() {
        return this.container;
    }

    public AdvancedCache<K, V> getAdvancedCache() {
        return ((Cache)this.get()).getAdvancedCache();
    }

    public Configuration getCacheConfiguration() {
        return ((Cache)this.get()).getCacheConfiguration();
    }

    public ComponentStatus getStatus() {
        return ((Cache)this.get()).getStatus();
    }

    public boolean startBatch() {
        return ((Cache)this.get()).startBatch();
    }

    public void endBatch(boolean successful) {
        ((Cache)this.get()).endBatch(successful);
    }

    @Override
    public CacheSet<Map.Entry<K, V>> entrySet() {
        return ((Cache)this.get()).entrySet();
    }

    @Override
    public CacheSet<K> keySet() {
        return ((Cache)this.get()).keySet();
    }

    @Override
    public CacheCollection<V> values() {
        return ((Cache)this.get()).values();
    }

    public void evict(K key) {
        ((Cache)this.get()).evict(key);
    }

    public void putForExternalRead(K key, V value) {
        ((Cache)this.get()).putForExternalRead(key, value);
    }

    public void putForExternalRead(K key, V value, long lifespan, TimeUnit lifespanUnit) {
        ((Cache)this.get()).putForExternalRead(key, value, lifespan, lifespanUnit);
    }

    public void putForExternalRead(K key, V value, long lifespan, TimeUnit lifespanUnit, long maxIdle, TimeUnit maxIdleUnit) {
        ((Cache)this.get()).putForExternalRead(key, value, lifespan, lifespanUnit, maxIdle, maxIdleUnit);
    }

    public CompletionStage<Void> addListenerAsync(Object listener) {
        return ((Cache)this.get()).addListenerAsync(listener);
    }

    public <C> CompletionStage<Void> addListenerAsync(Object listener, CacheEventFilter<? super K, ? super V> filter, CacheEventConverter<? super K, ? super V, C> converter) {
        return ((Cache)this.get()).addListenerAsync(listener, filter, converter);
    }

    public <C> CompletionStage<Void> addFilteredListenerAsync(Object listener, CacheEventFilter<? super K, ? super V> filter, CacheEventConverter<? super K, ? super V, C> converter, Set<Class<? extends Annotation>> filterAnnotations) {
        return ((Cache)this.get()).addFilteredListenerAsync(listener, filter, converter, filterAnnotations);
    }

    public <C> CompletionStage<Void> addStorageFormatFilteredListenerAsync(Object listener, CacheEventFilter<? super K, ? super V> filter, CacheEventConverter<? super K, ? super V, C> converter, Set<Class<? extends Annotation>> filterAnnotations) {
        return ((Cache)this.get()).addStorageFormatFilteredListenerAsync(listener, filter, converter, filterAnnotations);
    }

    public CompletionStage<Void> removeListenerAsync(Object listener) {
        return ((Cache)this.get()).removeListenerAsync(listener);
    }
}

