/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.clustering.infinispan.subsystem;

import java.util.Map;
import java.util.function.Consumer;
import java.util.function.Supplier;
import java.util.function.UnaryOperator;
import java.util.stream.Stream;
import org.jboss.as.clustering.controller.ResourceDescriptor;
import org.jboss.as.clustering.controller.SimpleResourceDescriptorConfigurator;
import org.jboss.as.clustering.infinispan.persistence.hotrod.HotRodStoreConfiguration;
import org.jboss.as.clustering.infinispan.persistence.hotrod.HotRodStoreConfigurationBuilder;
import org.jboss.as.clustering.infinispan.subsystem.InfinispanExtension;
import org.jboss.as.clustering.infinispan.subsystem.StoreResourceDefinition;
import org.jboss.as.controller.AttributeDefinition;
import org.jboss.as.controller.CapabilityReferenceRecorder;
import org.jboss.as.controller.ExpressionResolver;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.PathElement;
import org.jboss.as.controller.RequirementServiceBuilder;
import org.jboss.as.controller.SimpleAttributeDefinitionBuilder;
import org.jboss.as.controller.descriptions.ResourceDescriptionResolver;
import org.jboss.as.controller.registry.AttributeAccess;
import org.jboss.dmr.ModelNode;
import org.jboss.dmr.ModelType;
import org.wildfly.clustering.infinispan.client.RemoteCacheContainer;
import org.wildfly.clustering.infinispan.client.service.HotRodServiceDescriptor;
import org.wildfly.clustering.server.util.MapEntry;
import org.wildfly.service.descriptor.UnaryServiceDescriptor;
import org.wildfly.subsystem.resource.capability.CapabilityReference;
import org.wildfly.subsystem.service.ServiceDependency;

public class HotRodStoreResourceDefinition
extends StoreResourceDefinition<HotRodStoreConfiguration, HotRodStoreConfigurationBuilder> {
    static final PathElement PATH = HotRodStoreResourceDefinition.pathElement("hotrod");

    HotRodStoreResourceDefinition() {
        super(PATH, (ResourceDescriptionResolver)InfinispanExtension.SUBSYSTEM_RESOLVER.createChildResolver(PATH, WILDCARD_PATH), (UnaryOperator<ResourceDescriptor>)new SimpleResourceDescriptorConfigurator(Attribute.class), HotRodStoreConfigurationBuilder.class);
    }

    @Override
    public Map.Entry<Map.Entry<Supplier<HotRodStoreConfigurationBuilder>, Consumer<HotRodStoreConfigurationBuilder>>, Stream<Consumer<RequirementServiceBuilder<?>>>> resolve(OperationContext context, ModelNode model) throws OperationFailedException {
        final String cacheConfiguration = Attribute.CACHE_CONFIGURATION.resolveModelAttribute((ExpressionResolver)context, model).asStringOrNull();
        String containerName = Attribute.REMOTE_CACHE_CONTAINER.resolveModelAttribute((ExpressionResolver)context, model).asString();
        final ServiceDependency container = ServiceDependency.on((UnaryServiceDescriptor)HotRodServiceDescriptor.REMOTE_CACHE_CONTAINER, (String)containerName);
        Object entry = super.resolve(context, model);
        Supplier builderFactory = (Supplier)((Map.Entry)entry.getKey()).getKey();
        Consumer<HotRodStoreConfigurationBuilder> configurator = ((Consumer)((Map.Entry)entry.getKey()).getValue()).andThen(new Consumer<HotRodStoreConfigurationBuilder>(){

            @Override
            public void accept(HotRodStoreConfigurationBuilder builder) {
                ((HotRodStoreConfigurationBuilder)builder.segmented(false)).cacheConfiguration(cacheConfiguration).remoteCacheContainer((RemoteCacheContainer)container.get());
            }
        });
        Stream dependencies = (Stream)entry.getValue();
        return MapEntry.of((Object)MapEntry.of((Object)builderFactory, configurator), Stream.concat(dependencies, Stream.of(container)));
    }

    static enum Attribute implements org.jboss.as.clustering.controller.Attribute
    {
        CACHE_CONFIGURATION("cache-configuration", ModelType.STRING, null),
        REMOTE_CACHE_CONTAINER("remote-cache-container", ModelType.STRING, (CapabilityReferenceRecorder)CapabilityReference.builder(StoreResourceDefinition.CAPABILITY, (UnaryServiceDescriptor)HotRodServiceDescriptor.REMOTE_CACHE_CONTAINER).build());

        private final AttributeDefinition definition;

        private Attribute(String attributeName, ModelType type, CapabilityReferenceRecorder capabilityReference) {
            this.definition = ((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)new SimpleAttributeDefinitionBuilder(attributeName, type).setAllowExpression(capabilityReference == null)).setRequired(capabilityReference != null)).setCapabilityReference(capabilityReference)).setFlags(new AttributeAccess.Flag[]{AttributeAccess.Flag.RESTART_RESOURCE_SERVICES})).build();
        }

        public AttributeDefinition getDefinition() {
            return this.definition;
        }
    }
}

