/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.mail.smime;

import jakarta.activation.CommandMap;
import jakarta.activation.MailcapCommandMap;
import jakarta.mail.MessagingException;
import jakarta.mail.Part;
import jakarta.mail.Session;
import jakarta.mail.internet.MimeBodyPart;
import jakarta.mail.internet.MimeMessage;
import jakarta.mail.internet.MimeMultipart;
import jakarta.mail.internet.MimePart;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.security.AccessController;
import java.security.PrivilegedAction;
import org.bouncycastle.cms.CMSException;
import org.bouncycastle.cms.CMSProcessable;
import org.bouncycastle.cms.CMSSignedData;
import org.bouncycastle.cms.CMSTypedData;
import org.bouncycastle.mail.smime.CMSProcessableBodyPartInbound;
import org.bouncycastle.mail.smime.SMIMEException;
import org.bouncycastle.mail.smime.SMIMEUtil;

public class SMIMESigned
extends CMSSignedData {
    Object message;
    MimeBodyPart content;

    public SMIMESigned(MimeMultipart mimeMultipart) throws MessagingException, CMSException {
        super((CMSProcessable)new CMSProcessableBodyPartInbound(mimeMultipart.getBodyPart(0)), SMIMEUtil.getInputStreamNoMultipartSigned((Part)mimeMultipart.getBodyPart(1)));
        this.message = mimeMultipart;
        this.content = (MimeBodyPart)mimeMultipart.getBodyPart(0);
    }

    public SMIMESigned(MimeMultipart mimeMultipart, String string) throws MessagingException, CMSException {
        super((CMSProcessable)new CMSProcessableBodyPartInbound(mimeMultipart.getBodyPart(0), string), SMIMEUtil.getInputStreamNoMultipartSigned((Part)mimeMultipart.getBodyPart(1)));
        this.message = mimeMultipart;
        this.content = (MimeBodyPart)mimeMultipart.getBodyPart(0);
    }

    public SMIMESigned(Part part) throws MessagingException, CMSException, SMIMEException {
        super(SMIMEUtil.getInputStreamNoMultipartSigned(part));
        this.message = part;
        CMSTypedData cMSTypedData = this.getSignedContent();
        if (cMSTypedData != null) {
            byte[] byArray = (byte[])cMSTypedData.getContent();
            this.content = SMIMEUtil.toMimeBodyPart(byArray);
        }
    }

    public MimeBodyPart getContent() {
        return this.content;
    }

    public MimeMessage getContentAsMimeMessage(Session session) throws MessagingException, IOException {
        Object object;
        Object object2 = this.getSignedContent().getContent();
        byte[] byArray = null;
        if (object2 instanceof byte[]) {
            byArray = (byte[])object2;
        } else if (object2 instanceof MimePart) {
            object = (MimePart)object2;
            ByteArrayOutputStream byteArrayOutputStream = object.getSize() > 0 ? new ByteArrayOutputStream(object.getSize()) : new ByteArrayOutputStream();
            object.writeTo((OutputStream)byteArrayOutputStream);
            byArray = byteArrayOutputStream.toByteArray();
        } else {
            String string = "<null>";
            if (object2 != null) {
                string = object2.getClass().getName();
            }
            throw new MessagingException("Could not transfrom content of type " + string + " into MimeMessage.");
        }
        if (byArray != null) {
            object = new ByteArrayInputStream(byArray);
            return new MimeMessage(session, (InputStream)object);
        }
        return null;
    }

    public Object getContentWithSignature() {
        return this.message;
    }

    static {
        final MailcapCommandMap mailcapCommandMap = (MailcapCommandMap)CommandMap.getDefaultCommandMap();
        mailcapCommandMap.addMailcap("application/pkcs7-signature;; x-java-content-handler=org.bouncycastle.mail.smime.handlers.pkcs7_signature");
        mailcapCommandMap.addMailcap("application/pkcs7-mime;; x-java-content-handler=org.bouncycastle.mail.smime.handlers.pkcs7_mime");
        mailcapCommandMap.addMailcap("application/x-pkcs7-signature;; x-java-content-handler=org.bouncycastle.mail.smime.handlers.x_pkcs7_signature");
        mailcapCommandMap.addMailcap("application/x-pkcs7-mime;; x-java-content-handler=org.bouncycastle.mail.smime.handlers.x_pkcs7_mime");
        mailcapCommandMap.addMailcap("multipart/signed;; x-java-content-handler=org.bouncycastle.mail.smime.handlers.multipart_signed");
        AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                CommandMap.setDefaultCommandMap((CommandMap)mailcapCommandMap);
                return null;
            }
        });
    }
}

