/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.domain.http.server;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.concurrent.atomic.AtomicStampedReference;
import java.util.function.Consumer;
import java.util.function.Supplier;
import org.jboss.as.controller.ControlledProcessState;
import org.jboss.as.controller.ControlledProcessStateService;
import org.jboss.as.controller.ProcessStateNotifier;
import org.jboss.as.domain.http.server.ConsoleAvailability;
import org.jboss.msc.Service;
import org.jboss.msc.service.ServiceBuilder;
import org.jboss.msc.service.ServiceName;
import org.jboss.msc.service.ServiceTarget;
import org.jboss.msc.service.StartContext;
import org.jboss.msc.service.StartException;
import org.jboss.msc.service.StopContext;

public final class ConsoleAvailabilityService
implements Service,
ConsoleAvailability,
PropertyChangeListener {
    private final Supplier<ProcessStateNotifier> notifier;
    private final Consumer<ConsoleAvailability> serviceConsumer;
    private final LogAdminConsole logAdminConsole;
    private final AtomicStampedReference<Boolean> available = new AtomicStampedReference<Boolean>(Boolean.FALSE, 0);

    public ConsoleAvailabilityService(Consumer<ConsoleAvailability> serviceConsumer, Supplier<ProcessStateNotifier> notifier, LogAdminConsole logMessageAction) {
        this.notifier = notifier;
        this.serviceConsumer = serviceConsumer;
        this.logAdminConsole = logMessageAction;
    }

    public static void addService(ServiceTarget serviceTarget, LogAdminConsole logMessageAction) {
        ServiceName serviceName = CONSOLE_AVAILABILITY_CAPABILITY.getCapabilityServiceName();
        ServiceBuilder sb = serviceTarget.addService(serviceName);
        Consumer caConsumer = sb.provides(new ServiceName[]{serviceName});
        Supplier psnSupplier = sb.requires(ControlledProcessStateService.INTERNAL_SERVICE_NAME);
        ConsoleAvailabilityService consoleAvailabilityService = new ConsoleAvailabilityService(caConsumer, psnSupplier, logMessageAction);
        sb.setInstance((Service)consoleAvailabilityService);
        sb.install();
    }

    public void start(StartContext context) throws StartException {
        this.notifier.get().addPropertyChangeListener((PropertyChangeListener)this);
        this.serviceConsumer.accept(this);
    }

    public void stop(StopContext context) {
        this.notifier.get().removePropertyChangeListener((PropertyChangeListener)this);
    }

    @Override
    public boolean isAvailable() {
        return this.available.getReference();
    }

    @Override
    public void setAvailable() {
        if (this.available.compareAndSet(Boolean.FALSE, Boolean.TRUE, 0, 1)) {
            this.logAdminConsole.logAdminConsole();
        }
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        if (ControlledProcessState.State.RUNNING == evt.getNewValue() || ControlledProcessState.State.RELOAD_REQUIRED == evt.getNewValue() || ControlledProcessState.State.RESTART_REQUIRED == evt.getNewValue()) {
            if (this.available.compareAndSet(Boolean.FALSE, Boolean.TRUE, 0, 1)) {
                this.logAdminConsole.logAdminConsole();
            }
        } else if (ControlledProcessState.State.STOPPING == evt.getNewValue()) {
            this.available.set(Boolean.FALSE, 1);
        } else if (ControlledProcessState.State.STARTING == evt.getNewValue()) {
            this.available.set(Boolean.FALSE, 0);
        } else if (ControlledProcessState.State.STOPPED == evt.getNewValue()) {
            this.available.set(Boolean.FALSE, 0);
        }
    }

    @FunctionalInterface
    public static interface LogAdminConsole {
        public void logAdminConsole();
    }
}

