/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.commons.marshall;

import java.io.IOException;
import java.io.InputStream;
import java.time.Instant;
import java.util.Date;
import org.infinispan.commons.dataconversion.MediaType;
import org.infinispan.commons.io.ByteBuffer;
import org.infinispan.commons.io.ByteBufferImpl;
import org.infinispan.commons.marshall.AbstractMarshaller;
import org.infinispan.protostream.ImmutableSerializationContext;
import org.infinispan.protostream.ProtobufUtil;

public class ImmutableProtoStreamMarshaller
extends AbstractMarshaller {
    protected final ImmutableSerializationContext serializationContext;

    public ImmutableProtoStreamMarshaller(ImmutableSerializationContext serializationContext) {
        this.serializationContext = serializationContext;
    }

    public ImmutableSerializationContext getSerializationContext() {
        return this.serializationContext;
    }

    @Override
    public Object objectFromByteBuffer(byte[] buf, int offset, int length) throws IOException, ClassNotFoundException {
        return ProtobufUtil.fromWrappedByteArray((ImmutableSerializationContext)this.getSerializationContext(), (byte[])buf, (int)offset, (int)length);
    }

    @Override
    public Object objectFromInputStream(InputStream inputStream) throws IOException {
        return ProtobufUtil.fromWrappedStream((ImmutableSerializationContext)this.getSerializationContext(), (InputStream)inputStream);
    }

    @Override
    public boolean isMarshallable(Object o) {
        return o instanceof String || o instanceof Long || o instanceof Integer || o instanceof Double || o instanceof Float || o instanceof Boolean || o instanceof byte[] || o instanceof Byte || o instanceof Short || o instanceof Character || o instanceof Date || o instanceof Instant || this.getSerializationContext().canMarshall(o.getClass());
    }

    @Override
    protected ByteBuffer objectToBuffer(Object o, int estimatedSize) throws IOException {
        java.nio.ByteBuffer nioBuffer = ProtobufUtil.toWrappedByteBuffer((ImmutableSerializationContext)this.getSerializationContext(), (Object)o);
        return ByteBufferImpl.create(nioBuffer.array(), nioBuffer.arrayOffset(), nioBuffer.remaining());
    }

    @Override
    public MediaType mediaType() {
        return MediaType.APPLICATION_PROTOSTREAM;
    }
}

