/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.jdbc.store.file;

import java.io.File;
import java.lang.invoke.MethodHandles;
import java.nio.ByteBuffer;
import java.sql.SQLException;
import java.util.List;
import java.util.concurrent.Executor;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.atomic.AtomicIntegerFieldUpdater;
import org.apache.activemq.artemis.core.io.IOCriticalErrorListener;
import org.apache.activemq.artemis.core.io.SequentialFile;
import org.apache.activemq.artemis.core.io.SequentialFileFactory;
import org.apache.activemq.artemis.core.io.nio.NIOSequentialFileFactory;
import org.apache.activemq.artemis.core.server.ActiveMQComponent;
import org.apache.activemq.artemis.jdbc.store.drivers.JDBCConnectionProvider;
import org.apache.activemq.artemis.jdbc.store.file.JDBCFileUtils;
import org.apache.activemq.artemis.jdbc.store.file.JDBCSequentialFile;
import org.apache.activemq.artemis.jdbc.store.file.JDBCSequentialFileFactoryDriver;
import org.apache.activemq.artemis.jdbc.store.sql.SQLProvider;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JDBCSequentialFileFactory
implements SequentialFileFactory,
ActiveMQComponent {
    private static final Logger logger = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    private boolean started;
    private final Executor executor;
    private JDBCSequentialFileFactoryDriver dbDriver;
    private volatile int countOpen = 0;
    private static final AtomicIntegerFieldUpdater<JDBCSequentialFileFactory> countOpenUpdater = AtomicIntegerFieldUpdater.newUpdater(JDBCSequentialFileFactory.class, "countOpen");
    private final IOCriticalErrorListener criticalErrorListener;
    private final long syncDelay;
    private final ScheduledExecutorService scheduledExecutorService;

    public JDBCSequentialFileFactory(JDBCConnectionProvider connectionProvider, SQLProvider sqlProvider, Executor executor, ScheduledExecutorService scheduledExecutorService, long syncDelay, IOCriticalErrorListener criticalErrorListener) throws Exception {
        this.executor = executor;
        this.criticalErrorListener = criticalErrorListener;
        this.scheduledExecutorService = scheduledExecutorService;
        this.syncDelay = syncDelay;
        try {
            this.dbDriver = JDBCFileUtils.getDBFileDriver(connectionProvider, sqlProvider);
        }
        catch (SQLException e) {
            logger.warn(e.getMessage(), (Throwable)e);
            if (criticalErrorListener != null) {
                criticalErrorListener.onIOException((Throwable)e, "Failed to start JDBC Driver", null);
            }
            throw new RuntimeException(e.getMessage(), e);
        }
    }

    public boolean supportsIndividualContext() {
        return true;
    }

    public JDBCSequentialFileFactoryDriver getDbDriver() {
        return this.dbDriver;
    }

    public SequentialFileFactory setDatasync(boolean enabled) {
        return this;
    }

    public boolean isDatasync() {
        return false;
    }

    public long getBufferSize() {
        return this.dbDriver.getMaxSize();
    }

    public synchronized void start() {
        try {
            if (!this.started) {
                this.dbDriver.start();
                this.started = true;
            }
        }
        catch (Exception e) {
            this.criticalErrorListener.onIOException((Throwable)e, "Unable to start database driver", null);
            this.started = false;
        }
    }

    public synchronized void stop() {
        try {
            this.dbDriver.stop();
        }
        catch (SQLException e) {
            logger.error("Error stopping file factory, unable to close db connection");
        }
        this.started = false;
    }

    public SequentialFile createSequentialFile(String fileName) {
        try {
            JDBCSequentialFile file = new JDBCSequentialFile(this, fileName, this.executor, this.scheduledExecutorService, this.syncDelay, this.dbDriver);
            countOpenUpdater.incrementAndGet(this);
            return file;
        }
        catch (Exception e) {
            this.criticalErrorListener.onIOException((Throwable)e, "Error whilst creating JDBC file", null);
            return null;
        }
    }

    public void sequentialFileClosed(SequentialFile file) {
        countOpenUpdater.decrementAndGet(this);
    }

    public int getNumberOfOpenFiles() {
        return countOpenUpdater.get(this);
    }

    public int getMaxIO() {
        return 1;
    }

    public List<String> listFiles(String extension) throws Exception {
        return this.dbDriver.listFiles(extension);
    }

    public boolean isSupportsCallbacks() {
        return true;
    }

    public void onIOError(Throwable exception, String message, String file) {
        this.criticalErrorListener.onIOException(exception, message, file);
    }

    public ByteBuffer allocateDirectBuffer(int size) {
        return NIOSequentialFileFactory.allocateDirectByteBuffer((int)size);
    }

    public void releaseDirectBuffer(ByteBuffer buffer) {
    }

    public ByteBuffer newBuffer(int size) {
        return ByteBuffer.allocate(size);
    }

    public void clearBuffer(ByteBuffer buffer) {
        int limit = buffer.limit();
        buffer.rewind();
        for (int i = 0; i < limit; ++i) {
            buffer.put((byte)0);
        }
        buffer.rewind();
    }

    public ByteBuffer wrapBuffer(byte[] bytes) {
        return ByteBuffer.wrap(bytes);
    }

    public int getAlignment() {
        return 1;
    }

    public JDBCSequentialFileFactory setAlignment(int alignment) {
        return this;
    }

    public int calculateBlockSize(int bytes) {
        return bytes;
    }

    public void deactivateBuffer() {
    }

    public void releaseBuffer(ByteBuffer buffer) {
    }

    public void activateBuffer(SequentialFile file) {
    }

    public File getDirectory() {
        return null;
    }

    public String getDirectoryName() {
        return this.dbDriver.getSqlProvider().getTableName();
    }

    public boolean isStarted() {
        return this.started;
    }

    public void createDirs() throws Exception {
    }

    public void flush() {
    }

    public synchronized void destroy() throws SQLException {
        try {
            this.dbDriver.destroy();
        }
        catch (SQLException e) {
            logger.error("Error destroying file factory", (Throwable)e);
        }
    }
}

