/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.backend.elasticsearch.multitenancy.impl;

import com.google.gson.JsonObject;
import java.lang.invoke.MethodHandles;
import java.util.Collections;
import java.util.Optional;
import java.util.Set;
import org.hibernate.search.backend.elasticsearch.common.impl.DocumentIdHelper;
import org.hibernate.search.backend.elasticsearch.document.impl.DocumentMetadataContributor;
import org.hibernate.search.backend.elasticsearch.document.model.dsl.impl.IndexSchemaRootContributor;
import org.hibernate.search.backend.elasticsearch.gson.impl.JsonAccessor;
import org.hibernate.search.backend.elasticsearch.logging.impl.Log;
import org.hibernate.search.backend.elasticsearch.multitenancy.impl.MultiTenancyStrategy;
import org.hibernate.search.backend.elasticsearch.search.projection.impl.ProjectionExtractContext;
import org.hibernate.search.backend.elasticsearch.search.projection.impl.ProjectionExtractionHelper;
import org.hibernate.search.backend.elasticsearch.search.projection.impl.ProjectionRequestContext;
import org.hibernate.search.util.common.logging.impl.LoggerFactory;
import org.hibernate.search.util.common.reporting.EventContext;

public class NoMultiTenancyStrategy
implements MultiTenancyStrategy {
    private static final Log log = (Log)LoggerFactory.make(Log.class, (MethodHandles.Lookup)MethodHandles.lookup());
    private final NoMultiTenancyElasticsearchDocumentIdHelper documentIdHelper = new NoMultiTenancyElasticsearchDocumentIdHelper();
    private final NoMultiTenancyIdProjectionExtractionHelper idProjectionExtractionHelper = new NoMultiTenancyIdProjectionExtractionHelper();

    @Override
    public Optional<IndexSchemaRootContributor> indexSchemaRootContributor() {
        return Optional.empty();
    }

    @Override
    public DocumentIdHelper documentIdHelper() {
        return this.documentIdHelper;
    }

    @Override
    public Optional<DocumentMetadataContributor> documentMetadataContributor() {
        return Optional.empty();
    }

    @Override
    public JsonObject filterOrNull(String tenantId) {
        return null;
    }

    @Override
    public JsonObject filterOrNull(Set<String> tenantIds) {
        return null;
    }

    public NoMultiTenancyIdProjectionExtractionHelper idProjectionExtractionHelper() {
        return this.idProjectionExtractionHelper;
    }

    private static final class NoMultiTenancyElasticsearchDocumentIdHelper
    implements DocumentIdHelper {
        private NoMultiTenancyElasticsearchDocumentIdHelper() {
        }

        @Override
        public void checkTenantId(String tenantId, EventContext backendContext) {
            if (tenantId != null) {
                throw log.tenantIdProvidedButMultiTenancyDisabled(Collections.singleton(tenantId), backendContext);
            }
        }

        @Override
        public void checkTenantId(Set<String> tenantIds, EventContext context) {
            if (tenantIds != null && !tenantIds.isEmpty()) {
                throw log.tenantIdProvidedButMultiTenancyDisabled(tenantIds, context);
            }
        }

        @Override
        public String toElasticsearchId(String tenantId, String id) {
            return id;
        }
    }

    private static final class NoMultiTenancyIdProjectionExtractionHelper
    implements ProjectionExtractionHelper<String> {
        private static final JsonAccessor<String> HIT_ID_ACCESSOR = JsonAccessor.root().property("_id").asString();

        private NoMultiTenancyIdProjectionExtractionHelper() {
        }

        @Override
        public void request(JsonObject requestBody, ProjectionRequestContext context) {
        }

        @Override
        public String extract(JsonObject hit, ProjectionExtractContext context) {
            return HIT_ID_ACCESSOR.get(hit).orElseThrow(log::elasticsearchResponseMissingData);
        }
    }
}

