/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.backend.elasticsearch.search.predicate.impl;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.Set;
import org.hibernate.search.backend.elasticsearch.gson.impl.JsonAccessor;
import org.hibernate.search.backend.elasticsearch.search.common.impl.ElasticsearchSearchIndexScope;
import org.hibernate.search.backend.elasticsearch.search.predicate.impl.ElasticsearchSearchPredicate;
import org.hibernate.search.backend.elasticsearch.search.predicate.impl.PredicateRequestContext;
import org.hibernate.search.engine.search.predicate.spi.SearchPredicateBuilder;

public abstract class AbstractElasticsearchPredicate
implements ElasticsearchSearchPredicate {
    private static final JsonAccessor<Float> BOOST_ACCESSOR = JsonAccessor.root().property("boost").asFloat();
    private final Set<String> indexNames;
    private final Float boost;
    private final boolean withConstantScore;

    protected AbstractElasticsearchPredicate(AbstractBuilder builder) {
        this.indexNames = builder.scope.hibernateSearchIndexNames();
        this.boost = builder.boost;
        this.withConstantScore = builder.withConstantScore;
    }

    @Override
    public Set<String> indexNames() {
        return this.indexNames;
    }

    @Override
    public JsonObject toJsonQuery(PredicateRequestContext context) {
        JsonObject outerObject = new JsonObject();
        JsonObject innerObject = new JsonObject();
        if (this.boost != null && !this.withConstantScore) {
            BOOST_ACCESSOR.set(innerObject, this.boost);
        }
        JsonObject result = this.doToJsonQuery(context, outerObject, innerObject);
        return this.withConstantScore && result != null ? this.applyConstantScore(result) : result;
    }

    protected abstract JsonObject doToJsonQuery(PredicateRequestContext var1, JsonObject var2, JsonObject var3);

    protected boolean hasNoModifiers() {
        return !this.withConstantScore && this.boost == null;
    }

    private JsonObject applyConstantScore(JsonObject filter) {
        JsonObject constantScore = new JsonObject();
        constantScore.add("filter", (JsonElement)filter);
        if (this.boost != null) {
            BOOST_ACCESSOR.set(constantScore, this.boost);
        }
        JsonObject result = new JsonObject();
        result.add("constant_score", (JsonElement)constantScore);
        return result;
    }

    protected static abstract class AbstractBuilder
    implements SearchPredicateBuilder {
        protected final ElasticsearchSearchIndexScope<?> scope;
        private Float boost;
        private boolean withConstantScore = false;

        AbstractBuilder(ElasticsearchSearchIndexScope<?> scope) {
            this.scope = scope;
        }

        public void boost(float boost) {
            this.boost = Float.valueOf(boost);
        }

        public void constantScore() {
            this.withConstantScore = true;
        }

        protected boolean hasNoModifiers() {
            return !this.withConstantScore && this.boost == null;
        }
    }
}

