/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.backend.elasticsearch.search.projection.impl;

import com.google.gson.JsonObject;
import org.hibernate.search.backend.elasticsearch.gson.impl.JsonAccessor;
import org.hibernate.search.backend.elasticsearch.gson.impl.JsonObjectAccessor;
import org.hibernate.search.backend.elasticsearch.reporting.impl.ElasticsearchSearchHints;
import org.hibernate.search.backend.elasticsearch.search.common.impl.ElasticsearchSearchIndexScope;
import org.hibernate.search.backend.elasticsearch.search.projection.impl.AbstractElasticsearchProjection;
import org.hibernate.search.backend.elasticsearch.search.projection.impl.ElasticsearchProjectionTypeKeys;
import org.hibernate.search.backend.elasticsearch.search.projection.impl.ElasticsearchSearchProjection;
import org.hibernate.search.backend.elasticsearch.search.projection.impl.ProjectionExtractContext;
import org.hibernate.search.backend.elasticsearch.search.projection.impl.ProjectionRequestContext;
import org.hibernate.search.backend.elasticsearch.search.projection.impl.ProjectionTransformContext;
import org.hibernate.search.engine.search.loading.spi.LoadingResult;
import org.hibernate.search.engine.search.loading.spi.ProjectionHitMapper;

class ElasticsearchExplanationProjection
extends AbstractElasticsearchProjection<JsonObject>
implements ElasticsearchSearchProjection.Extractor<JsonObject, JsonObject> {
    private static final JsonAccessor<Boolean> REQUEST_EXPLAIN_ACCESSOR = JsonAccessor.root().property("explain").asBoolean();
    private static final JsonObjectAccessor HIT_EXPLANATION_ACCESSOR = JsonAccessor.root().property("_explanation").asObject();

    ElasticsearchExplanationProjection(ElasticsearchSearchIndexScope<?> scope) {
        super(scope);
    }

    public String toString() {
        return this.getClass().getSimpleName();
    }

    @Override
    public ElasticsearchSearchProjection.Extractor<?, JsonObject> request(JsonObject requestBody, ProjectionRequestContext context) {
        context.checkNotNested(ElasticsearchProjectionTypeKeys.EXPLANATION, ElasticsearchSearchHints.INSTANCE.explanationProjectionNestingNotSupportedHint());
        REQUEST_EXPLAIN_ACCESSOR.set(requestBody, true);
        return this;
    }

    @Override
    public JsonObject extract(ProjectionHitMapper<?> projectionHitMapper, JsonObject hit, JsonObject source, ProjectionExtractContext context) {
        return (JsonObject)HIT_EXPLANATION_ACCESSOR.get(hit).get();
    }

    @Override
    public JsonObject transform(LoadingResult<?> loadingResult, JsonObject extractedData, ProjectionTransformContext context) {
        return extractedData;
    }
}

