/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.backend.elasticsearch.work.impl;

import com.google.gson.Gson;
import com.google.gson.JsonObject;
import java.util.Map;
import org.hibernate.search.backend.elasticsearch.client.impl.ElasticsearchClientUtils;
import org.hibernate.search.backend.elasticsearch.client.spi.ElasticsearchRequest;
import org.hibernate.search.backend.elasticsearch.client.spi.ElasticsearchResponse;
import org.hibernate.search.backend.elasticsearch.gson.spi.GsonProvider;
import org.hibernate.search.backend.elasticsearch.lowlevel.index.aliases.impl.IndexAliasDefinition;
import org.hibernate.search.backend.elasticsearch.lowlevel.index.mapping.impl.RootTypeMapping;
import org.hibernate.search.backend.elasticsearch.lowlevel.index.settings.impl.IndexSettings;
import org.hibernate.search.backend.elasticsearch.util.spi.URLEncodedString;
import org.hibernate.search.backend.elasticsearch.work.impl.AbstractNonBulkableWork;
import org.hibernate.search.backend.elasticsearch.work.impl.ElasticsearchRequestSuccessAssessor;
import org.hibernate.search.backend.elasticsearch.work.impl.ElasticsearchWorkExecutionContext;
import org.hibernate.search.backend.elasticsearch.work.result.impl.CreateIndexResult;

public class CreateIndexWork
extends AbstractNonBulkableWork<CreateIndexResult> {
    private static final String MAPPINGS_PROPERTY = "mappings";

    protected CreateIndexWork(Builder builder) {
        super(builder);
    }

    @Override
    protected CreateIndexResult generateResult(ElasticsearchWorkExecutionContext context, ElasticsearchResponse response) {
        int statusCode = response.statusCode();
        if (ElasticsearchClientUtils.isSuccessCode(statusCode)) {
            return CreateIndexResult.CREATED;
        }
        return CreateIndexResult.ALREADY_EXISTS;
    }

    public static class Builder
    extends AbstractNonBulkableWork.AbstractBuilder<Builder> {
        private final GsonProvider gsonProvider;
        private final URLEncodedString indexName;
        private final JsonObject payload = new JsonObject();

        public static Builder create(GsonProvider gsonProvider, URLEncodedString indexName) {
            return new Builder(gsonProvider, indexName);
        }

        private Builder(GsonProvider gsonProvider, URLEncodedString indexName) {
            super(ElasticsearchRequestSuccessAssessor.DEFAULT_INSTANCE);
            this.gsonProvider = gsonProvider;
            this.indexName = indexName;
        }

        public Builder aliases(Map<String, IndexAliasDefinition> aliases) {
            Gson gson = this.gsonProvider.getGsonNoSerializeNulls();
            this.payload.add("aliases", gson.toJsonTree(aliases));
            return this;
        }

        public Builder settings(IndexSettings settings) {
            Gson gson = this.gsonProvider.getGsonNoSerializeNulls();
            this.payload.add("settings", gson.toJsonTree((Object)settings));
            return this;
        }

        public Builder mapping(RootTypeMapping mapping) {
            Gson gson = this.gsonProvider.getGsonNoSerializeNulls();
            this.payload.add(CreateIndexWork.MAPPINGS_PROPERTY, gson.toJsonTree((Object)mapping));
            return this;
        }

        public Builder ignoreExisting() {
            this.resultAssessor = ElasticsearchRequestSuccessAssessor.builder().ignoreErrorTypes("index_already_exists_exception").build();
            return this;
        }

        @Override
        protected ElasticsearchRequest buildRequest() {
            ElasticsearchRequest.Builder builder = ElasticsearchRequest.put().pathComponent(this.indexName);
            if (this.payload.size() > 0) {
                builder.body(this.payload);
            }
            return builder.build();
        }

        public CreateIndexWork build() {
            return new CreateIndexWork(this);
        }
    }
}

