/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.yasson.internal.serializer;

import jakarta.json.bind.JsonbException;
import jakarta.json.stream.JsonGenerator;
import java.util.Base64;
import java.util.Map;
import java.util.function.Function;
import org.eclipse.yasson.internal.JsonbContext;
import org.eclipse.yasson.internal.SerializationContextImpl;
import org.eclipse.yasson.internal.properties.MessageKeys;
import org.eclipse.yasson.internal.properties.Messages;
import org.eclipse.yasson.internal.serializer.ModelSerializer;

abstract class ArraySerializer
implements ModelSerializer {
    private static final Map<Class<?>, Function<ModelSerializer, ArraySerializer>> ARRAY_SERIALIZERS = Map.of(boolean[].class, BooleanArraySerializer::new, byte[].class, ByteArraySerializer::new, char[].class, CharacterArraySerializer::new, double[].class, DoubleArraySerializer::new, float[].class, FloatArraySerializer::new, int[].class, IntegerArraySerializer::new, long[].class, LongArraySerializer::new, short[].class, ShortArraySerializer::new);
    private final ModelSerializer valueSerializer;

    protected ArraySerializer(ModelSerializer valueSerializer) {
        this.valueSerializer = valueSerializer;
    }

    public static ModelSerializer create(Class<?> arrayType, JsonbContext jsonbContext, ModelSerializer modelSerializer) {
        String binaryDataStrategy = jsonbContext.getConfigProperties().getBinaryDataStrategy();
        if (byte[].class.equals(arrayType) && !binaryDataStrategy.equals("BYTE")) {
            return new Base64ByteArraySerializer(binaryDataStrategy);
        }
        if (ARRAY_SERIALIZERS.containsKey(arrayType)) {
            return ARRAY_SERIALIZERS.get(arrayType).apply(modelSerializer);
        }
        return new ObjectArraySerializer(modelSerializer);
    }

    @Override
    public void serialize(Object value, JsonGenerator generator, SerializationContextImpl context) {
        generator.writeStartArray();
        this.serializeArray(value, generator, context);
        generator.writeEnd();
    }

    abstract void serializeArray(Object var1, JsonGenerator var2, SerializationContextImpl var3);

    protected ModelSerializer getValueSerializer() {
        return this.valueSerializer;
    }

    private static final class Base64ByteArraySerializer
    implements ModelSerializer {
        private final Base64.Encoder encoder;

        Base64ByteArraySerializer(String strategy) {
            this.encoder = this.getEncoder(strategy);
        }

        @Override
        public void serialize(Object value, JsonGenerator generator, SerializationContextImpl context) {
            byte[] array = (byte[])value;
            generator.write(this.encoder.encodeToString(array));
        }

        private Base64.Encoder getEncoder(String strategy) {
            switch (strategy) {
                case "BASE_64": {
                    return Base64.getEncoder();
                }
                case "BASE_64_URL": {
                    return Base64.getUrlEncoder();
                }
            }
            throw new JsonbException(Messages.getMessage(MessageKeys.INTERNAL_ERROR, "Invalid strategy: " + strategy));
        }
    }

    private static final class ObjectArraySerializer
    extends ArraySerializer {
        ObjectArraySerializer(ModelSerializer valueSerializer) {
            super(valueSerializer);
        }

        @Override
        public void serializeArray(Object value, JsonGenerator generator, SerializationContextImpl context) {
            Object[] array;
            for (Object o : array = (Object[])value) {
                this.getValueSerializer().serialize(o, generator, context);
            }
        }
    }

    private static final class CharacterArraySerializer
    extends ArraySerializer {
        CharacterArraySerializer(ModelSerializer valueSerializer) {
            super(valueSerializer);
        }

        @Override
        public void serializeArray(Object value, JsonGenerator generator, SerializationContextImpl context) {
            char[] array;
            for (char c : array = (char[])value) {
                this.getValueSerializer().serialize(Character.valueOf(c), generator, context);
            }
        }
    }

    private static final class BooleanArraySerializer
    extends ArraySerializer {
        BooleanArraySerializer(ModelSerializer valueSerializer) {
            super(valueSerializer);
        }

        @Override
        public void serializeArray(Object value, JsonGenerator generator, SerializationContextImpl context) {
            boolean[] array;
            for (boolean b : array = (boolean[])value) {
                this.getValueSerializer().serialize(b, generator, context);
            }
        }
    }

    private static final class DoubleArraySerializer
    extends ArraySerializer {
        DoubleArraySerializer(ModelSerializer valueSerializer) {
            super(valueSerializer);
        }

        @Override
        public void serializeArray(Object value, JsonGenerator generator, SerializationContextImpl context) {
            double[] array;
            for (double d : array = (double[])value) {
                this.getValueSerializer().serialize(d, generator, context);
            }
        }
    }

    private static final class FloatArraySerializer
    extends ArraySerializer {
        FloatArraySerializer(ModelSerializer valueSerializer) {
            super(valueSerializer);
        }

        @Override
        public void serializeArray(Object value, JsonGenerator generator, SerializationContextImpl context) {
            float[] array;
            for (float f : array = (float[])value) {
                this.getValueSerializer().serialize(Float.valueOf(f), generator, context);
            }
        }
    }

    private static final class LongArraySerializer
    extends ArraySerializer {
        LongArraySerializer(ModelSerializer valueSerializer) {
            super(valueSerializer);
        }

        @Override
        public void serializeArray(Object value, JsonGenerator generator, SerializationContextImpl context) {
            long[] array;
            for (long l : array = (long[])value) {
                this.getValueSerializer().serialize(l, generator, context);
            }
        }
    }

    private static final class IntegerArraySerializer
    extends ArraySerializer {
        IntegerArraySerializer(ModelSerializer valueSerializer) {
            super(valueSerializer);
        }

        @Override
        public void serializeArray(Object value, JsonGenerator generator, SerializationContextImpl context) {
            int[] array;
            for (int i : array = (int[])value) {
                this.getValueSerializer().serialize(i, generator, context);
            }
        }
    }

    private static final class ShortArraySerializer
    extends ArraySerializer {
        ShortArraySerializer(ModelSerializer valueSerializer) {
            super(valueSerializer);
        }

        @Override
        public void serializeArray(Object value, JsonGenerator generator, SerializationContextImpl context) {
            short[] array;
            for (short s : array = (short[])value) {
                this.getValueSerializer().serialize(s, generator, context);
            }
        }
    }

    private static final class ByteArraySerializer
    extends ArraySerializer {
        ByteArraySerializer(ModelSerializer valueSerializer) {
            super(valueSerializer);
        }

        @Override
        public void serializeArray(Object value, JsonGenerator generator, SerializationContextImpl context) {
            byte[] array;
            for (byte b : array = (byte[])value) {
                this.getValueSerializer().serialize(b, generator, context);
            }
        }
    }
}

