/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.ee.concurrent;

import jakarta.enterprise.concurrent.ContextService;
import java.util.Map;
import org.glassfish.enterprise.concurrent.spi.ContextHandle;
import org.glassfish.enterprise.concurrent.spi.ContextSetupProvider;
import org.jboss.as.ee.concurrent.ConcurrentContext;
import org.jboss.as.ee.concurrent.handle.NullContextHandle;
import org.jboss.as.ee.concurrent.handle.ResetContextHandle;
import org.jboss.as.ee.concurrent.handle.SetupContextHandle;
import org.jboss.as.ee.logging.EeLogger;

public class DefaultContextSetupProviderImpl
implements ContextSetupProvider {
    public ContextHandle saveContext(ContextService contextService) {
        return this.saveContext(contextService, null);
    }

    public ContextHandle saveContext(ContextService contextService, Map<String, String> contextObjectProperties) {
        ConcurrentContext concurrentContext = ConcurrentContext.current();
        if (concurrentContext != null) {
            return new SetupContextHandleWrapper(concurrentContext.saveContext(contextService, contextObjectProperties));
        }
        EeLogger.ROOT_LOGGER.debug((Object)"ee concurrency context not found in invocation context");
        return new SetupContextHandleWrapper((SetupContextHandle)new NullContextHandle());
    }

    public ContextHandle setup(ContextHandle contextHandle) throws IllegalStateException {
        return ((SetupContextHandleWrapper)contextHandle).setup();
    }

    public void reset(ContextHandle contextHandle) {
        ((ResetContextHandle)contextHandle).reset();
    }

    static class SetupContextHandleWrapper
    implements SetupContextHandle,
    ContextHandle {
        private final SetupContextHandle contextHandle;

        public SetupContextHandleWrapper(SetupContextHandle contextHandle) {
            this.contextHandle = contextHandle;
        }

        public ResetContextHandleWrapper setup() throws IllegalStateException {
            return new ResetContextHandleWrapper(this.contextHandle.setup());
        }

        public String getFactoryName() {
            return this.contextHandle.getFactoryName();
        }
    }

    static class ResetContextHandleWrapper
    implements ResetContextHandle,
    ContextHandle {
        private final ResetContextHandle contextHandle;

        public ResetContextHandleWrapper(ResetContextHandle contextHandle) {
            this.contextHandle = contextHandle;
        }

        public void reset() {
            this.contextHandle.reset();
        }

        public String getFactoryName() {
            return this.contextHandle.getFactoryName();
        }
    }
}

