/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.extension.io;

import java.net.InetSocketAddress;
import java.util.List;
import java.util.concurrent.Executor;
import java.util.concurrent.RejectedExecutionException;
import java.util.function.Consumer;
import java.util.function.Supplier;
import org.jboss.msc.service.Service;
import org.jboss.msc.service.StartContext;
import org.jboss.msc.service.StopContext;
import org.wildfly.common.net.CidrAddressTable;
import org.wildfly.extension.io.logging.IOLogger;
import org.xnio.XnioWorker;

public final class WorkerService
implements Service<XnioWorker> {
    private final XnioWorker.Builder builder;
    private final Consumer<XnioWorker> workerConsumer;
    private final Supplier<Executor> executorSupplier;
    private final Object stopLock = new Object();
    private XnioWorker worker;
    private volatile StopContext stopContext;

    public WorkerService(Consumer<XnioWorker> workerConsumer, Supplier<Executor> executorSupplier, XnioWorker.Builder builder) {
        this.workerConsumer = workerConsumer;
        this.executorSupplier = executorSupplier;
        this.builder = builder;
    }

    public void start(StartContext startContext) {
        this.builder.setTerminationTask(this::stopDone);
        this.worker = this.builder.build();
        this.workerConsumer.accept(this.worker);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stop(StopContext context) {
        this.stopContext = context;
        Executor executor = this.executorSupplier.get();
        Runnable asyncStop = () -> {
            XnioWorker localWorker = this.worker;
            this.workerConsumer.accept(null);
            this.worker = null;
            localWorker.shutdown();
            boolean interrupted = false;
            try {
                Object object = this.stopLock;
                synchronized (object) {
                    if (this.stopContext != null) {
                        try {
                            this.stopLock.wait(100L);
                        }
                        catch (InterruptedException e) {
                            interrupted = true;
                        }
                    }
                }
                if (this.stopContext != null) {
                    List tasks = localWorker.shutdownNow();
                    for (Runnable task : tasks) {
                        IOLogger.ROOT_LOGGER.debugf("Worker was shut down forcibly. Submitting task %s to the management executor", task);
                        executor.execute(task);
                    }
                }
            }
            finally {
                this.stopDone();
                if (interrupted) {
                    Thread.currentThread().interrupt();
                }
            }
        };
        try {
            try {
                executor.execute(asyncStop);
            }
            catch (RejectedExecutionException e) {
                asyncStop.run();
            }
        }
        finally {
            context.asynchronous();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void stopDone() {
        Object object = this.stopLock;
        synchronized (object) {
            StopContext stopContext = this.stopContext;
            this.stopContext = null;
            if (stopContext != null) {
                stopContext.complete();
            }
            this.stopLock.notifyAll();
        }
    }

    CidrAddressTable<InetSocketAddress> getBindingsTable() {
        return this.builder.getBindAddressConfigurations();
    }

    public XnioWorker getValue() throws IllegalStateException, IllegalArgumentException {
        return this.worker;
    }
}

